/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.buffer;

import io.aeron.driver.buffer.LogFactory;
import io.aeron.driver.buffer.MappedRawLog;
import io.aeron.driver.buffer.RawLog;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.StorageSpaceException;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.LangUtil;

public class FileStoreLogFactory
implements LogFactory {
    private static final String PUBLICATIONS = "publications";
    private static final String IMAGES = "images";
    private final long lowStorageWarningThreshold;
    private final int filePageSize;
    private final boolean checkStorage;
    private final ErrorHandler errorHandler;
    private final File publicationsDir;
    private final File imagesDir;
    private final FileStore fileStore;

    public FileStoreLogFactory(String string, int n2, boolean bl2, long l2, ErrorHandler errorHandler) {
        this.filePageSize = n2;
        this.lowStorageWarningThreshold = l2;
        this.checkStorage = bl2;
        this.errorHandler = errorHandler;
        File file = new File(string);
        this.publicationsDir = new File(file, PUBLICATIONS);
        this.imagesDir = new File(file, IMAGES);
        IoUtil.ensureDirectoryExists(this.publicationsDir, PUBLICATIONS);
        IoUtil.ensureDirectoryExists(this.imagesDir, IMAGES);
        try {
            this.fileStore = bl2 ? Files.getFileStore(file.toPath()) : null;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public RawLog newPublication(long l2, int n2, boolean bl2) {
        return this.newInstance(this.publicationsDir, l2, n2, bl2);
    }

    @Override
    public RawLog newImage(long l2, int n2, boolean bl2) {
        return this.newInstance(this.imagesDir, l2, n2, bl2);
    }

    private RawLog newInstance(File file, long l2, int n2, boolean bl2) {
        long l3 = LogBufferDescriptor.computeLogLength(n2, this.filePageSize);
        this.checkStorage(l3);
        File file2 = FileStoreLogFactory.streamLocation(file, l2);
        return new MappedRawLog(file2, bl2, l3, n2, this.filePageSize, this.errorHandler);
    }

    private void checkStorage(long l2) {
        if (this.checkStorage) {
            long l3 = this.getUsableSpace();
            if (l3 < l2) {
                throw new StorageSpaceException("insufficient usable storage for new log of length=" + l2 + " in " + this.fileStore);
            }
            if (l3 <= this.lowStorageWarningThreshold) {
                String string = "space is running low: threshold=" + this.lowStorageWarningThreshold + " usable=" + l3 + " in " + this.fileStore;
                this.errorHandler.onError(new AeronException(string, AeronException.Category.WARN));
            }
        }
    }

    private long getUsableSpace() {
        long l2 = 0L;
        try {
            l2 = this.fileStore.getUsableSpace();
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
        return l2;
    }

    private static File streamLocation(File file, long l2) {
        String string = l2 + ".logbuffer";
        return new File(file, string);
    }
}

