/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.CommonContext;
import io.aeron.driver.AeronClient;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.IpcPublication;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.Subscribable;
import io.aeron.driver.SubscriptionParams;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import java.util.IdentityHashMap;
import java.util.Map;
import org.agrona.concurrent.status.ReadablePosition;

public abstract class SubscriptionLink
implements DriverManagedResource {
    final long registrationId;
    final int streamId;
    final int sessionId;
    final boolean hasSessionId;
    final boolean isSparse;
    final boolean isTether;
    boolean reachedEndOfLife = false;
    final CommonContext.InferableBoolean group;
    final String channel;
    final AeronClient aeronClient;
    final IdentityHashMap<Subscribable, ReadablePosition> positionBySubscribableMap;

    SubscriptionLink(long l2, int n2, String string, AeronClient aeronClient, SubscriptionParams subscriptionParams) {
        this.registrationId = l2;
        this.streamId = n2;
        this.channel = string;
        this.aeronClient = aeronClient;
        this.hasSessionId = subscriptionParams.hasSessionId;
        this.sessionId = subscriptionParams.sessionId;
        this.isSparse = subscriptionParams.isSparse;
        this.isTether = subscriptionParams.isTether;
        this.group = subscriptionParams.group;
        this.positionBySubscribableMap = new IdentityHashMap(this.hasSessionId ? 1 : 8);
    }

    public final String channel() {
        return this.channel;
    }

    public final int streamId() {
        return this.streamId;
    }

    public final long registrationId() {
        return this.registrationId;
    }

    AeronClient aeronClient() {
        return this.aeronClient;
    }

    final int sessionId() {
        return this.sessionId;
    }

    ReceiveChannelEndpoint channelEndpoint() {
        return null;
    }

    boolean isReliable() {
        return true;
    }

    boolean isRejoin() {
        return true;
    }

    boolean isTether() {
        return this.isTether;
    }

    boolean isSparse() {
        return this.isSparse;
    }

    CommonContext.InferableBoolean group() {
        return this.group;
    }

    boolean hasSessionId() {
        return this.hasSessionId;
    }

    boolean matches(NetworkPublication networkPublication) {
        return false;
    }

    boolean matches(PublicationImage publicationImage) {
        return false;
    }

    boolean matches(IpcPublication ipcPublication) {
        return false;
    }

    boolean matches(ReceiveChannelEndpoint receiveChannelEndpoint, int n2, SubscriptionParams subscriptionParams) {
        return false;
    }

    boolean matches(ReceiveChannelEndpoint receiveChannelEndpoint, int n2, int n3) {
        return false;
    }

    boolean isLinked(Subscribable subscribable) {
        return this.positionBySubscribableMap.containsKey(subscribable);
    }

    void link(Subscribable subscribable, ReadablePosition readablePosition) {
        this.positionBySubscribableMap.put(subscribable, readablePosition);
    }

    void unlink(Subscribable subscribable) {
        this.positionBySubscribableMap.remove(subscribable);
    }

    boolean isWildcardOrSessionIdMatch(int n2) {
        return !this.hasSessionId || this.sessionId == n2;
    }

    boolean supportsMds() {
        return false;
    }

    void notifyUnavailableImages(DriverConductor driverConductor) {
        for (Map.Entry<Subscribable, ReadablePosition> entry : this.positionBySubscribableMap.entrySet()) {
            Subscribable subscribable = entry.getKey();
            driverConductor.notifyUnavailableImageLink(subscribable.subscribableRegistrationId(), this);
        }
    }

    @Override
    public void close() {
        for (Map.Entry<Subscribable, ReadablePosition> entry : this.positionBySubscribableMap.entrySet()) {
            Subscribable subscribable = entry.getKey();
            ReadablePosition readablePosition = entry.getValue();
            subscribable.removeSubscriber(this, readablePosition);
        }
    }

    @Override
    public void onTimeEvent(long l2, long l3, DriverConductor driverConductor) {
        if (this.aeronClient.hasTimedOut()) {
            this.reachedEndOfLife = true;
            driverConductor.cleanupSubscriptionLink(this);
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public String toString() {
        return this.getClass().getName() + "{registrationId=" + this.registrationId + ", streamId=" + this.streamId + ", sessionId=" + this.sessionId + ", hasSessionId=" + this.hasSessionId + ", isReliable=" + this.isReliable() + ", isSparse=" + this.isSparse() + ", isTether=" + this.isTether() + ", isRejoin=" + this.isRejoin() + ", reachedEndOfLife=" + this.reachedEndOfLife + ", group=" + (Object)((Object)this.group) + ", channel='" + this.channel + '\'' + ", aeronClient=" + this.aeronClient + ", positionBySubscribableMap=" + this.positionBySubscribableMap + '}';
    }
}

