/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.Sender;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.media.SendChannelEndpoint;
import java.net.InetSocketAddress;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.QueuedPipe;
import org.agrona.concurrent.status.AtomicCounter;

final class SenderProxy {
    private final ThreadingMode threadingMode;
    private final QueuedPipe<Runnable> commandQueue;
    private final AtomicCounter failCount;
    private Sender sender;

    SenderProxy(ThreadingMode threadingMode, QueuedPipe<Runnable> queuedPipe, AtomicCounter atomicCounter) {
        this.threadingMode = threadingMode;
        this.commandQueue = queuedPipe;
        this.failCount = atomicCounter;
    }

    public String toString() {
        return "SenderProxy{threadingMode=" + (Object)((Object)this.threadingMode) + ", failCount=" + this.failCount + '}';
    }

    boolean isApplyingBackpressure() {
        return this.commandQueue.remainingCapacity() < 1;
    }

    void sender(Sender sender) {
        this.sender = sender;
    }

    void registerSendChannelEndpoint(SendChannelEndpoint sendChannelEndpoint) {
        if (this.notConcurrent()) {
            this.sender.onRegisterSendChannelEndpoint(sendChannelEndpoint);
        } else {
            this.offer(() -> this.sender.onRegisterSendChannelEndpoint(sendChannelEndpoint));
        }
    }

    void closeSendChannelEndpoint(SendChannelEndpoint sendChannelEndpoint) {
        if (this.notConcurrent()) {
            this.sender.onCloseSendChannelEndpoint(sendChannelEndpoint);
        } else {
            this.offer(() -> this.sender.onCloseSendChannelEndpoint(sendChannelEndpoint));
        }
    }

    void removeNetworkPublication(NetworkPublication networkPublication) {
        if (this.notConcurrent()) {
            this.sender.onRemoveNetworkPublication(networkPublication);
        } else {
            this.offer(() -> this.sender.onRemoveNetworkPublication(networkPublication));
        }
    }

    void newNetworkPublication(NetworkPublication networkPublication) {
        if (this.notConcurrent()) {
            this.sender.onNewNetworkPublication(networkPublication);
        } else {
            this.offer(() -> this.sender.onNewNetworkPublication(networkPublication));
        }
    }

    void addDestination(SendChannelEndpoint sendChannelEndpoint, ChannelUri channelUri, InetSocketAddress inetSocketAddress) {
        if (this.notConcurrent()) {
            this.sender.onAddDestination(sendChannelEndpoint, channelUri, inetSocketAddress);
        } else {
            this.offer(() -> this.sender.onAddDestination(sendChannelEndpoint, channelUri, inetSocketAddress));
        }
    }

    void removeDestination(SendChannelEndpoint sendChannelEndpoint, ChannelUri channelUri, InetSocketAddress inetSocketAddress) {
        if (this.notConcurrent()) {
            this.sender.onRemoveDestination(sendChannelEndpoint, channelUri, inetSocketAddress);
        } else {
            this.offer(() -> this.sender.onRemoveDestination(sendChannelEndpoint, channelUri, inetSocketAddress));
        }
    }

    void onResolutionChange(SendChannelEndpoint sendChannelEndpoint, String string, InetSocketAddress inetSocketAddress) {
        if (this.notConcurrent()) {
            this.sender.onResolutionChange(sendChannelEndpoint, string, inetSocketAddress);
        } else {
            this.offer(() -> this.sender.onResolutionChange(sendChannelEndpoint, string, inetSocketAddress));
        }
    }

    private boolean notConcurrent() {
        return this.threadingMode == ThreadingMode.SHARED || this.threadingMode == ThreadingMode.INVOKER;
    }

    private void offer(Runnable runnable) {
        while (!this.commandQueue.offer(runnable)) {
            if (!this.failCount.isClosed()) {
                this.failCount.increment();
            }
            Thread.yield();
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new AgentTerminationException("interrupted");
        }
    }
}

