/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.DutyCycleTracker;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.PendingSetupMessageFromSource;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.media.DataTransportPoller;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.status.DutyCycleStallTracker;
import io.aeron.driver.status.SystemCounterDescriptor;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;

public final class Receiver
implements Agent {
    private static final PublicationImage[] EMPTY_IMAGES = new PublicationImage[0];
    private final long reResolutionCheckIntervalNs;
    private long reResolutionDeadlineNs;
    private final DataTransportPoller dataTransportPoller;
    private final OneToOneConcurrentArrayQueue<Runnable> commandQueue;
    private final AtomicCounter totalBytesReceived;
    private final AtomicCounter resolutionChanges;
    private final NanoClock nanoClock;
    private final CachedNanoClock cachedNanoClock;
    private PublicationImage[] publicationImages = EMPTY_IMAGES;
    private final ArrayList<PendingSetupMessageFromSource> pendingSetupMessages = new ArrayList();
    private final DriverConductorProxy conductorProxy;
    private final DutyCycleTracker dutyCycleTracker;

    Receiver(MediaDriver.Context context) {
        this.dataTransportPoller = context.dataTransportPoller();
        this.commandQueue = context.receiverCommandQueue();
        this.totalBytesReceived = context.systemCounters().get(SystemCounterDescriptor.BYTES_RECEIVED);
        this.resolutionChanges = context.systemCounters().get(SystemCounterDescriptor.RESOLUTION_CHANGES);
        this.nanoClock = context.nanoClock();
        this.cachedNanoClock = context.receiverCachedNanoClock();
        this.conductorProxy = context.driverConductorProxy();
        this.reResolutionCheckIntervalNs = context.reResolutionCheckIntervalNs();
        this.dutyCycleTracker = context.receiverDutyCycleTracker();
    }

    @Override
    public void onStart() {
        long l2 = this.nanoClock.nanoTime();
        this.cachedNanoClock.update(l2);
        this.dutyCycleTracker.update(l2);
        this.reResolutionDeadlineNs = l2 + this.reResolutionCheckIntervalNs;
        if (this.dutyCycleTracker instanceof DutyCycleStallTracker) {
            DutyCycleStallTracker dutyCycleStallTracker = (DutyCycleStallTracker)this.dutyCycleTracker;
            dutyCycleStallTracker.maxCycleTime().appendToLabel(": " + this.conductorProxy.threadingMode().name());
            dutyCycleStallTracker.cycleTimeThresholdExceededCount().appendToLabel(": threshold=" + dutyCycleStallTracker.cycleTimeThresholdNs() + "ns " + this.conductorProxy.threadingMode().name());
        }
    }

    @Override
    public void onClose() {
        this.dataTransportPoller.close();
    }

    @Override
    public String roleName() {
        return "receiver";
    }

    @Override
    public int doWork() {
        int n2;
        long l2 = this.nanoClock.nanoTime();
        this.cachedNanoClock.update(l2);
        this.dutyCycleTracker.measureAndUpdate(l2);
        int n3 = this.commandQueue.drain(Runnable::run, 2);
        int n4 = this.dataTransportPoller.pollTransports();
        this.totalBytesReceived.getAndAddOrdered(n4);
        PublicationImage[] publicationImageArray = this.publicationImages;
        for (int i2 = n2 = publicationImageArray.length - 1; i2 >= 0; --i2) {
            PublicationImage publicationImage = publicationImageArray[i2];
            if (publicationImage.isConnected(l2)) {
                publicationImage.checkEosForDrainTransition(l2);
                n3 += publicationImage.sendPendingStatusMessage(l2);
                n3 += publicationImage.processPendingLoss();
                n3 += publicationImage.initiateAnyRttMeasurements(l2);
                continue;
            }
            this.publicationImages = 1 == this.publicationImages.length ? EMPTY_IMAGES : ArrayUtil.remove(this.publicationImages, i2);
            publicationImage.removeFromDispatcher();
            publicationImage.receiverRelease();
        }
        this.checkPendingSetupMessages(l2);
        if (this.reResolutionCheckIntervalNs > 0L && this.reResolutionDeadlineNs - l2 < 0L) {
            this.reResolutionDeadlineNs = l2 + this.reResolutionCheckIntervalNs;
            this.dataTransportPoller.checkForReResolutions(l2, this.conductorProxy);
        }
        return n3 + n4;
    }

    void addPendingSetupMessage(int n2, int n3, int n4, ReceiveChannelEndpoint receiveChannelEndpoint, boolean bl2, InetSocketAddress inetSocketAddress) {
        PendingSetupMessageFromSource pendingSetupMessageFromSource = new PendingSetupMessageFromSource(n2, n3, n4, receiveChannelEndpoint, bl2, inetSocketAddress);
        pendingSetupMessageFromSource.timeOfStatusMessageNs(this.cachedNanoClock.nanoTime());
        this.pendingSetupMessages.add(pendingSetupMessageFromSource);
    }

    void onAddSubscription(ReceiveChannelEndpoint receiveChannelEndpoint, int n2) {
        receiveChannelEndpoint.dispatcher().addSubscription(n2);
    }

    void onAddSubscription(ReceiveChannelEndpoint receiveChannelEndpoint, int n2, int n3) {
        receiveChannelEndpoint.dispatcher().addSubscription(n2, n3);
    }

    void onRemoveSubscription(ReceiveChannelEndpoint receiveChannelEndpoint, int n2) {
        receiveChannelEndpoint.dispatcher().removeSubscription(n2);
    }

    void onRemoveSubscription(ReceiveChannelEndpoint receiveChannelEndpoint, int n2, int n3) {
        receiveChannelEndpoint.dispatcher().removeSubscription(n2, n3);
    }

    void onNewPublicationImage(ReceiveChannelEndpoint receiveChannelEndpoint, PublicationImage publicationImage) {
        this.publicationImages = ArrayUtil.add(this.publicationImages, publicationImage);
        receiveChannelEndpoint.dispatcher().addPublicationImage(publicationImage);
    }

    void onRegisterReceiveChannelEndpoint(ReceiveChannelEndpoint receiveChannelEndpoint) {
        if (!receiveChannelEndpoint.hasDestinationControl()) {
            receiveChannelEndpoint.openChannel(this.conductorProxy);
            receiveChannelEndpoint.registerForRead(this.dataTransportPoller);
            receiveChannelEndpoint.indicateActive();
            if (receiveChannelEndpoint.hasExplicitControl()) {
                this.addPendingSetupMessage(0, 0, 0, receiveChannelEndpoint, true, receiveChannelEndpoint.explicitControlAddress());
                receiveChannelEndpoint.sendSetupElicitingStatusMessage(0, receiveChannelEndpoint.explicitControlAddress(), 0, 0);
            }
        } else {
            receiveChannelEndpoint.indicateActive();
        }
    }

    void onCloseReceiveChannelEndpoint(ReceiveChannelEndpoint receiveChannelEndpoint) {
        int n2;
        ArrayList<PendingSetupMessageFromSource> arrayList = this.pendingSetupMessages;
        for (int i2 = n2 = arrayList.size() - 1; i2 >= 0; --i2) {
            PendingSetupMessageFromSource pendingSetupMessageFromSource = arrayList.get(i2);
            if (pendingSetupMessageFromSource.channelEndpoint() != receiveChannelEndpoint) continue;
            ArrayListUtil.fastUnorderedRemove(arrayList, i2, n2--);
            pendingSetupMessageFromSource.removeFromDataPacketDispatcher();
        }
        receiveChannelEndpoint.closeMultiRcvDestinationTransports(this.dataTransportPoller);
        receiveChannelEndpoint.close();
        receiveChannelEndpoint.closeMultiRcvDestinationIndicators(this.conductorProxy);
    }

    void onRemoveCoolDown(ReceiveChannelEndpoint receiveChannelEndpoint, int n2, int n3) {
        receiveChannelEndpoint.dispatcher().removeCoolDown(n2, n3);
    }

    void onAddDestination(ReceiveChannelEndpoint receiveChannelEndpoint, ReceiveDestinationTransport receiveDestinationTransport) {
        receiveDestinationTransport.openChannel(this.conductorProxy, receiveChannelEndpoint.statusIndicatorCounter());
        int n2 = receiveChannelEndpoint.addDestination(receiveDestinationTransport);
        SelectionKey selectionKey = this.dataTransportPoller.registerForRead(receiveChannelEndpoint, receiveDestinationTransport, n2);
        receiveDestinationTransport.selectionKey(selectionKey);
        if (receiveDestinationTransport.hasExplicitControl()) {
            this.addPendingSetupMessage(0, 0, n2, receiveChannelEndpoint, true, receiveDestinationTransport.explicitControlAddress());
            receiveChannelEndpoint.sendSetupElicitingStatusMessage(n2, receiveDestinationTransport.explicitControlAddress(), 0, 0);
        }
        for (PublicationImage publicationImage : this.publicationImages) {
            if (receiveChannelEndpoint != publicationImage.channelEndpoint()) continue;
            publicationImage.addDestination(n2, receiveDestinationTransport);
        }
    }

    void onRemoveDestination(ReceiveChannelEndpoint receiveChannelEndpoint, UdpChannel udpChannel) {
        int n2 = receiveChannelEndpoint.destination(udpChannel);
        if (-1 != n2) {
            ReceiveDestinationTransport receiveDestinationTransport = receiveChannelEndpoint.destination(n2);
            this.dataTransportPoller.cancelRead(receiveChannelEndpoint, receiveDestinationTransport);
            receiveChannelEndpoint.removeDestination(n2);
            receiveDestinationTransport.closeTransport();
            this.dataTransportPoller.selectNowWithoutProcessing();
            for (PublicationImage publicationImage : this.publicationImages) {
                if (receiveChannelEndpoint != publicationImage.channelEndpoint()) continue;
                publicationImage.removeDestination(n2);
            }
            this.conductorProxy.closeReceiveDestinationIndicators(receiveDestinationTransport);
        }
    }

    void onResolutionChange(ReceiveChannelEndpoint receiveChannelEndpoint, UdpChannel udpChannel, InetSocketAddress inetSocketAddress) {
        int n2 = receiveChannelEndpoint.hasDestinationControl() ? receiveChannelEndpoint.destination(udpChannel) : 0;
        int n3 = this.pendingSetupMessages.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            PendingSetupMessageFromSource pendingSetupMessageFromSource = this.pendingSetupMessages.get(i2);
            if (pendingSetupMessageFromSource.channelEndpoint() != receiveChannelEndpoint || !pendingSetupMessageFromSource.isPeriodic() || pendingSetupMessageFromSource.transportIndex() != n2) continue;
            pendingSetupMessageFromSource.controlAddress(inetSocketAddress);
            this.resolutionChanges.getAndAddOrdered(1L);
        }
        receiveChannelEndpoint.updateControlAddress(n2, inetSocketAddress);
    }

    private void checkPendingSetupMessages(long l2) {
        int n2;
        for (int i2 = n2 = this.pendingSetupMessages.size() - 1; i2 >= 0; --i2) {
            PendingSetupMessageFromSource pendingSetupMessageFromSource = this.pendingSetupMessages.get(i2);
            if (pendingSetupMessageFromSource.timeOfStatusMessageNs() + Configuration.PENDING_SETUPS_TIMEOUT_NS - l2 >= 0L) continue;
            if (!pendingSetupMessageFromSource.isPeriodic()) {
                ArrayListUtil.fastUnorderedRemove(this.pendingSetupMessages, i2, n2--);
                pendingSetupMessageFromSource.removeFromDataPacketDispatcher();
                continue;
            }
            if (!pendingSetupMessageFromSource.shouldElicitSetupMessage()) continue;
            pendingSetupMessageFromSource.timeOfStatusMessageNs(l2);
            pendingSetupMessageFromSource.channelEndpoint().sendSetupElicitingStatusMessage(pendingSetupMessageFromSource.transportIndex(), pendingSetupMessageFromSource.controlAddress(), pendingSetupMessageFromSource.sessionId(), pendingSetupMessageFromSource.streamId());
        }
    }
}

