/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.IpcPublication;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.buffer.RawLog;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import org.agrona.SystemUtil;

final class PublicationParams {
    long lingerTimeoutNs;
    long entityTag = -1L;
    int termLength;
    int mtuLength;
    int initialTermId = 0;
    int termId = 0;
    int termOffset = 0;
    int sessionId = 0;
    boolean hasPosition = false;
    boolean hasSessionId = false;
    boolean isSessionIdTagged = false;
    boolean signalEos = true;
    boolean isSparse;
    boolean spiesSimulateConnection;

    PublicationParams() {
    }

    static PublicationParams getPublicationParams(ChannelUri channelUri, MediaDriver.Context context, DriverConductor driverConductor, boolean bl2) {
        PublicationParams publicationParams = new PublicationParams(context, bl2);
        publicationParams.getEntityTag(channelUri, driverConductor);
        publicationParams.getSessionId(channelUri, driverConductor);
        publicationParams.getTermBufferLength(channelUri);
        publicationParams.getMtuLength(channelUri);
        publicationParams.getLingerTimeoutNs(channelUri);
        publicationParams.getEos(channelUri);
        publicationParams.getSparse(channelUri, context);
        publicationParams.getSpiesSimulateConnection(channelUri, context);
        int n2 = 0;
        String string = channelUri.get("init-term-id");
        n2 = string != null ? n2 + 1 : n2;
        String string2 = channelUri.get("term-id");
        n2 = string2 != null ? n2 + 1 : n2;
        String string3 = channelUri.get("term-offset");
        int n3 = n2 = string3 != null ? n2 + 1 : n2;
        if (n2 > 0) {
            if (n2 < 3) {
                throw new IllegalArgumentException("params must be used as a complete set: init-term-id term-id term-offset channel=" + channelUri);
            }
            publicationParams.initialTermId = Integer.parseInt(string);
            publicationParams.termId = Integer.parseInt(string2);
            publicationParams.termOffset = Integer.parseInt(string3);
            if (publicationParams.termOffset > publicationParams.termLength) {
                throw new IllegalArgumentException("term-offset=" + publicationParams.termOffset + " > " + "term-length" + "=" + publicationParams.termLength + ": channel=" + channelUri);
            }
            if (publicationParams.termOffset < 0 || publicationParams.termOffset > 0x40000000) {
                throw new IllegalArgumentException("term-offset=" + publicationParams.termOffset + " out of range: channel=" + channelUri);
            }
            if ((publicationParams.termOffset & 0x1F) != 0) {
                throw new IllegalArgumentException("term-offset=" + publicationParams.termOffset + " must be a multiple of FRAME_ALIGNMENT: channel=" + channelUri);
            }
            if (publicationParams.termId - publicationParams.initialTermId < 0) {
                throw new IllegalStateException("difference greater than 2^31 - 1: init-term-id=" + publicationParams.initialTermId + " when " + "term-id" + "=" + publicationParams.termId + " channel=" + channelUri);
            }
            publicationParams.hasPosition = true;
        }
        return publicationParams;
    }

    private PublicationParams(MediaDriver.Context context, boolean bl2) {
        this.termLength = bl2 ? context.ipcTermBufferLength() : context.publicationTermBufferLength();
        this.mtuLength = bl2 ? context.ipcMtuLength() : context.mtuLength();
        this.lingerTimeoutNs = context.publicationLingerTimeoutNs();
        this.isSparse = context.termBufferSparseFile();
    }

    private void getEntityTag(ChannelUri channelUri, DriverConductor driverConductor) {
        String string = channelUri.entityTag();
        if (null != string) {
            this.entityTag = PublicationParams.parseEntityTag(string, driverConductor, channelUri);
        }
    }

    private void getTermBufferLength(ChannelUri channelUri) {
        String string = channelUri.get("term-length");
        if (null != string) {
            int n2 = (int)SystemUtil.parseSize("term-length", string);
            LogBufferDescriptor.checkTermLength(n2);
            PublicationParams.validateTermLength(this, n2, channelUri);
            this.termLength = n2;
        }
    }

    private void getMtuLength(ChannelUri channelUri) {
        String string = channelUri.get("mtu");
        if (null != string) {
            int n2 = (int)SystemUtil.parseSize("mtu", string);
            Configuration.validateMtuLength(n2);
            PublicationParams.validateMtuLength(this, n2, channelUri);
            this.mtuLength = n2;
        }
    }

    static void validateMtuForMaxMessage(PublicationParams publicationParams, String string) {
        int n2 = publicationParams.termLength;
        int n3 = FrameDescriptor.computeMaxMessageLength(n2);
        if (publicationParams.mtuLength > n3) {
            throw new IllegalStateException("MTU greater than max message length for term length: mtu=" + publicationParams.mtuLength + " maxMessageLength=" + n3 + " termLength=" + n2 + " channel=" + string);
        }
    }

    static void validateTermLength(PublicationParams publicationParams, int n2, ChannelUri channelUri) {
        if (publicationParams.isSessionIdTagged && n2 != publicationParams.termLength) {
            throw new IllegalArgumentException("term-length=" + n2 + " does not match session-id tag value: channel=" + channelUri);
        }
    }

    static void validateMtuLength(PublicationParams publicationParams, int n2, ChannelUri channelUri) {
        if (publicationParams.isSessionIdTagged && n2 != publicationParams.mtuLength) {
            throw new IllegalArgumentException("mtu=" + n2 + " does not match session-id tag value: channel=" + channelUri);
        }
    }

    private static String formatMatchError(String string, String string2, String string3, String string4, String string5) {
        return "existing publication has different '" + string + "': existing=" + string2 + " requested=" + string3 + " existingChannel=" + string4 + " channel=" + string5;
    }

    static void confirmMatch(ChannelUri channelUri, PublicationParams publicationParams, RawLog rawLog, int n2, String string, int n3, int n4, int n5) {
        int n6 = LogBufferDescriptor.mtuLength(rawLog.metaData());
        if (channelUri.containsKey("mtu") && n6 != publicationParams.mtuLength) {
            throw new IllegalStateException(PublicationParams.formatMatchError("mtu", String.valueOf(n6), String.valueOf(publicationParams.mtuLength), string, channelUri.toString()));
        }
        if (channelUri.containsKey("term-length") && rawLog.termLength() != publicationParams.termLength) {
            throw new IllegalStateException(PublicationParams.formatMatchError("term-length", String.valueOf(rawLog.termLength()), String.valueOf(publicationParams.termLength), string, channelUri.toString()));
        }
        if (channelUri.containsKey("session-id") && publicationParams.sessionId != n2) {
            throw new IllegalStateException(PublicationParams.formatMatchError("session-id", String.valueOf(n2), String.valueOf(publicationParams.sessionId), string, channelUri.toString()));
        }
        if (channelUri.containsKey("init-term-id") && publicationParams.initialTermId != n3) {
            throw new IllegalStateException(PublicationParams.formatMatchError("init-term-id", String.valueOf(n3), String.valueOf(publicationParams.initialTermId), string, channelUri.toString()));
        }
        if (channelUri.containsKey("term-id") && publicationParams.termId != n4) {
            throw new IllegalStateException(PublicationParams.formatMatchError("term-id", String.valueOf(n4), String.valueOf(publicationParams.termId), string, channelUri.toString()));
        }
        if (channelUri.containsKey("term-offset") && publicationParams.termOffset != n5) {
            throw new IllegalStateException(PublicationParams.formatMatchError("term-offset", String.valueOf(n5), String.valueOf(publicationParams.termOffset), string, channelUri.toString()));
        }
    }

    static void validateSpiesSimulateConnection(PublicationParams publicationParams, boolean bl2, String string, String string2) {
        if (publicationParams.spiesSimulateConnection != bl2) {
            throw new IllegalStateException("existing publication has different spiesSimulateConnection: existing=" + bl2 + " requested=" + publicationParams.spiesSimulateConnection + " existingChannel=" + string2 + " channel=" + string);
        }
    }

    static void validateMtuForSndbuf(PublicationParams publicationParams, int n2, MediaDriver.Context context, String string, String string2) {
        if (0 != n2 && publicationParams.mtuLength > n2) {
            throw new IllegalStateException("MTU greater than SO_SNDBUF for channel: mtu=" + publicationParams.mtuLength + " so-sndbuf=" + n2 + (null == string2 ? "" : " existingChannel=" + string2) + " channel=" + string);
        }
        if (0 == n2 && publicationParams.mtuLength > context.osDefaultSocketSndbufLength()) {
            throw new IllegalStateException("MTU greater than SO_SNDBUF for channel: mtu=" + publicationParams.mtuLength + " so-sndbuf=" + context.osDefaultSocketSndbufLength() + " (OS default)" + (null == string2 ? "" : " existingChannel=" + string2) + " channel=" + string);
        }
    }

    private void getLingerTimeoutNs(ChannelUri channelUri) {
        String string = channelUri.get("linger");
        if (null != string) {
            this.lingerTimeoutNs = SystemUtil.parseDuration("linger", string);
        }
    }

    private void getSessionId(ChannelUri channelUri, DriverConductor driverConductor) {
        String string = channelUri.get("session-id");
        if (null != string) {
            this.isSessionIdTagged = ChannelUri.isTagged(string);
            if (this.isSessionIdTagged) {
                NetworkPublication networkPublication = driverConductor.findNetworkPublicationByTag(ChannelUri.getTag(string));
                if (null == networkPublication) {
                    throw new IllegalArgumentException("session-id=" + string + " must reference a network publication: channel=" + channelUri);
                }
                this.sessionId = networkPublication.sessionId();
                this.mtuLength = networkPublication.mtuLength();
                this.termLength = networkPublication.termBufferLength();
            } else {
                this.sessionId = Integer.parseInt(string);
            }
            this.hasSessionId = true;
        }
    }

    private void getEos(ChannelUri channelUri) {
        String string = channelUri.get("eos");
        if (null != string) {
            this.signalEos = "true".equals(string);
        }
    }

    private void getSparse(ChannelUri channelUri, MediaDriver.Context context) {
        String string = channelUri.get("sparse");
        this.isSparse = null != string ? "true".equals(string) : context.termBufferSparseFile();
    }

    private void getSpiesSimulateConnection(ChannelUri channelUri, MediaDriver.Context context) {
        String string = channelUri.get("ssc");
        this.spiesSimulateConnection = null != string ? "true".equals(string) : context.spiesSimulateConnection();
    }

    private static long parseEntityTag(String string, DriverConductor driverConductor, ChannelUri channelUri) {
        long l2;
        try {
            l2 = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("invalid entity tag, must be a number", numberFormatException);
        }
        if (-1L == l2) {
            throw new IllegalArgumentException("-1 tag is reserved: channel=" + channelUri);
        }
        NetworkPublication networkPublication = driverConductor.findNetworkPublicationByTag(l2);
        if (null != networkPublication) {
            throw new IllegalArgumentException(l2 + " entityTag already in use: existingChannel=" + networkPublication.channel() + " channel=" + channelUri);
        }
        IpcPublication ipcPublication = driverConductor.findIpcPublicationByTag(l2);
        if (null != ipcPublication) {
            throw new IllegalArgumentException(l2 + " entityTag already in use: existingChannel=" + ipcPublication.channel() + " channel=" + channelUri);
        }
        return l2;
    }

    public String toString() {
        return "PublicationParams{lingerTimeoutNs=" + this.lingerTimeoutNs + ", entityTag=" + this.entityTag + ", termLength=" + this.termLength + ", mtuLength=" + this.mtuLength + ", initialTermId=" + this.initialTermId + ", termId=" + this.termId + ", termOffset=" + this.termOffset + ", sessionId=" + this.sessionId + ", hasPosition=" + this.hasPosition + ", hasSessionId=" + this.hasSessionId + ", isSessionIdTagged=" + this.isSessionIdTagged + ", isSparse=" + this.isSparse + ", signalEos=" + this.signalEos + ", spiesSimulateConnection=" + this.spiesSimulateConnection + '}';
    }
}

