/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.FlowControl;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublicationPadding3;
import io.aeron.driver.NetworkPublicationThreadLocals;
import io.aeron.driver.PublicationParams;
import io.aeron.driver.RetransmitHandler;
import io.aeron.driver.RetransmitSender;
import io.aeron.driver.Subscribable;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.UntetheredSubscription;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.LogBufferUnblocker;
import io.aeron.logbuffer.TermScanner;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;

public final class NetworkPublication
extends NetworkPublicationPadding3
implements RetransmitSender,
DriverManagedResource,
Subscribable {
    private final long registrationId;
    private final long unblockTimeoutNs;
    private final long connectionTimeoutNs;
    private final long lingerTimeoutNs;
    private final long untetheredWindowLimitTimeoutNs;
    private final long untetheredRestingTimeoutNs;
    private final long tag;
    private final int positionBitsToShift;
    private final int initialTermId;
    private final int startingTermId;
    private final int startingTermOffset;
    private final int termBufferLength;
    private final int termLengthMask;
    private final int mtuLength;
    private final int termWindowLength;
    private final int sessionId;
    private final int streamId;
    private final boolean isExclusive;
    private final boolean spiesSimulateConnection;
    private final boolean signalEos;
    private volatile boolean hasReceivers;
    private volatile boolean hasSpies;
    private volatile boolean isConnected;
    private volatile boolean isEndOfStream;
    private volatile boolean hasSenderReleased;
    private volatile boolean hasReceivedSmEos;
    private State state = State.ACTIVE;
    private final UnsafeBuffer[] termBuffers;
    private final ByteBuffer[] sendBuffers;
    private final ErrorHandler errorHandler;
    private final Position publisherPos;
    private final Position publisherLimit;
    private final Position senderPosition;
    private final Position senderLimit;
    private final SendChannelEndpoint channelEndpoint;
    private final ByteBuffer heartbeatBuffer;
    private final DataHeaderFlyweight heartbeatDataHeader;
    private final ByteBuffer setupBuffer;
    private final SetupFlyweight setupHeader;
    private final ByteBuffer rttMeasurementBuffer;
    private final RttMeasurementFlyweight rttMeasurementHeader;
    private final FlowControl flowControl;
    private final CachedNanoClock cachedNanoClock;
    private final RetransmitHandler retransmitHandler;
    private final UnsafeBuffer metaDataBuffer;
    private final RawLog rawLog;
    private final AtomicCounter heartbeatsSent;
    private final AtomicCounter retransmitsSent;
    private final AtomicCounter senderFlowControlLimits;
    private final AtomicCounter senderBpe;
    private final AtomicCounter shortSends;
    private final AtomicCounter unblockedPublications;

    NetworkPublication(long l2, MediaDriver.Context context, PublicationParams publicationParams, SendChannelEndpoint sendChannelEndpoint, RawLog rawLog, int n2, Position position, Position position2, Position position3, Position position4, AtomicCounter atomicCounter, int n3, int n4, int n5, FlowControl flowControl, RetransmitHandler retransmitHandler, NetworkPublicationThreadLocals networkPublicationThreadLocals, boolean bl2) {
        int n6;
        this.registrationId = l2;
        this.unblockTimeoutNs = context.publicationUnblockTimeoutNs();
        this.connectionTimeoutNs = context.publicationConnectionTimeoutNs();
        this.lingerTimeoutNs = publicationParams.lingerTimeoutNs;
        this.untetheredWindowLimitTimeoutNs = context.untetheredWindowLimitTimeoutNs();
        this.untetheredRestingTimeoutNs = context.untetheredRestingTimeoutNs();
        this.tag = publicationParams.entityTag;
        this.channelEndpoint = sendChannelEndpoint;
        this.rawLog = rawLog;
        this.cachedNanoClock = context.senderCachedNanoClock();
        this.senderPosition = position3;
        this.senderLimit = position4;
        this.flowControl = flowControl;
        this.retransmitHandler = retransmitHandler;
        this.publisherPos = position;
        this.publisherLimit = position2;
        this.mtuLength = publicationParams.mtuLength;
        this.initialTermId = n5;
        this.sessionId = n3;
        this.streamId = n4;
        this.spiesSimulateConnection = publicationParams.spiesSimulateConnection;
        this.signalEos = publicationParams.signalEos;
        this.isExclusive = bl2;
        this.startingTermId = publicationParams.hasPosition ? publicationParams.termId : n5;
        this.startingTermOffset = publicationParams.hasPosition ? publicationParams.termOffset : 0;
        this.metaDataBuffer = rawLog.metaData();
        this.setupBuffer = networkPublicationThreadLocals.setupBuffer();
        this.setupHeader = networkPublicationThreadLocals.setupHeader();
        this.heartbeatBuffer = networkPublicationThreadLocals.heartbeatBuffer();
        this.heartbeatDataHeader = networkPublicationThreadLocals.heartbeatDataHeader();
        this.rttMeasurementBuffer = networkPublicationThreadLocals.rttMeasurementBuffer();
        this.rttMeasurementHeader = networkPublicationThreadLocals.rttMeasurementHeader();
        SystemCounters systemCounters = context.systemCounters();
        this.heartbeatsSent = systemCounters.get(SystemCounterDescriptor.HEARTBEATS_SENT);
        this.shortSends = systemCounters.get(SystemCounterDescriptor.SHORT_SENDS);
        this.retransmitsSent = systemCounters.get(SystemCounterDescriptor.RETRANSMITS_SENT);
        this.senderFlowControlLimits = systemCounters.get(SystemCounterDescriptor.SENDER_FLOW_CONTROL_LIMITS);
        this.unblockedPublications = systemCounters.get(SystemCounterDescriptor.UNBLOCKED_PUBLICATIONS);
        this.senderBpe = atomicCounter;
        for (UnsafeBuffer unsafeBuffer : this.termBuffers = rawLog.termBuffers()) {
            unsafeBuffer.verifyAlignment();
        }
        this.sendBuffers = rawLog.sliceTerms();
        this.errorHandler = context.errorHandler();
        this.termBufferLength = n6 = rawLog.termLength();
        this.termLengthMask = n6 - 1;
        long l3 = this.cachedNanoClock.nanoTime();
        this.timeOfLastDataOrHeartbeatNs = l3 - Configuration.PUBLICATION_HEARTBEAT_TIMEOUT_NS - 1L;
        this.timeOfLastSetupNs = l3 - Configuration.PUBLICATION_SETUP_TIMEOUT_NS - 1L;
        this.timeOfLastStatusMessageNs = l3;
        this.positionBitsToShift = LogBufferDescriptor.positionBitsToShift(n6);
        this.termWindowLength = n2;
        this.cleanPosition = this.lastSenderPosition = position3.get();
        this.timeOfLastActivityNs = l3;
    }

    @Override
    public boolean free() {
        return this.rawLog.free();
    }

    @Override
    public void close() {
        CloseHelper.close(this.errorHandler, this.publisherPos);
        CloseHelper.close(this.errorHandler, this.publisherLimit);
        CloseHelper.close(this.errorHandler, this.senderPosition);
        CloseHelper.close(this.errorHandler, this.senderLimit);
        CloseHelper.close(this.errorHandler, this.senderBpe);
        CloseHelper.closeAll(this.errorHandler, (AutoCloseable[])this.spyPositions);
        int n2 = this.untetheredSubscriptions.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            UntetheredSubscription untetheredSubscription = (UntetheredSubscription)this.untetheredSubscriptions.get(i2);
            if (UntetheredSubscription.State.RESTING != untetheredSubscription.state) continue;
            CloseHelper.close(this.errorHandler, untetheredSubscription.position);
        }
        CloseHelper.close(this.flowControl);
    }

    public long timeOfLastStatusMessageNs() {
        return this.timeOfLastStatusMessageNs;
    }

    public String channel() {
        return this.channelEndpoint.originalUriString();
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    public void triggerSendSetupFrame() {
        if (!this.isEndOfStream) {
            this.timeOfLastStatusMessageNs = this.cachedNanoClock.nanoTime();
            this.isSetupElicited = true;
        }
    }

    @Override
    public long subscribableRegistrationId() {
        return this.registrationId;
    }

    @Override
    public void addSubscriber(SubscriptionLink subscriptionLink, ReadablePosition readablePosition, long l2) {
        this.spyPositions = ArrayUtil.add(this.spyPositions, readablePosition);
        this.hasSpies = true;
        if (!subscriptionLink.isTether()) {
            this.untetheredSubscriptions.add(new UntetheredSubscription(subscriptionLink, readablePosition, l2));
        }
        if (this.spiesSimulateConnection) {
            LogBufferDescriptor.isConnected(this.metaDataBuffer, true);
            this.isConnected = true;
        }
    }

    @Override
    public void removeSubscriber(SubscriptionLink subscriptionLink, ReadablePosition readablePosition) {
        this.spyPositions = ArrayUtil.remove(this.spyPositions, readablePosition);
        this.hasSpies = this.spyPositions.length > 0;
        readablePosition.close();
        if (!subscriptionLink.isTether()) {
            int n2;
            for (int i2 = n2 = this.untetheredSubscriptions.size() - 1; i2 >= 0; --i2) {
                if (((UntetheredSubscription)this.untetheredSubscriptions.get((int)i2)).subscriptionLink != subscriptionLink) continue;
                ArrayListUtil.fastUnorderedRemove(this.untetheredSubscriptions, i2, n2);
                break;
            }
        }
    }

    public void onNak(int n2, int n3, int n4) {
        this.retransmitHandler.onNak(n2, n3, n4, this.termBufferLength, this);
    }

    public void onStatusMessage(StatusMessageFlyweight statusMessageFlyweight, InetSocketAddress inetSocketAddress) {
        long l2;
        if (!this.hasReceivers) {
            this.hasReceivers = true;
        }
        if (!this.hasInitialConnection) {
            this.hasInitialConnection = true;
        }
        if (!this.channelEndpoint.udpChannel().isMulticast() && !this.channelEndpoint.udpChannel().isMultiDestination() && 64 == (statusMessageFlyweight.flags() & 0x40)) {
            this.hasReceivedSmEos = true;
        }
        this.timeOfLastStatusMessageNs = l2 = this.cachedNanoClock.nanoTime();
        this.senderLimit.setOrdered(this.flowControl.onStatusMessage(statusMessageFlyweight, inetSocketAddress, this.senderLimit.get(), this.initialTermId, this.positionBitsToShift, l2));
        if (!this.isConnected && this.flowControl.hasRequiredReceivers()) {
            LogBufferDescriptor.isConnected(this.metaDataBuffer, true);
            this.isConnected = true;
        }
    }

    public void onRttMeasurement(RttMeasurementFlyweight rttMeasurementFlyweight, InetSocketAddress inetSocketAddress) {
        if (128 == (rttMeasurementFlyweight.flags() & 0x80)) {
            this.rttMeasurementBuffer.clear();
            this.rttMeasurementHeader.receiverId(rttMeasurementFlyweight.receiverId()).echoTimestampNs(rttMeasurementFlyweight.echoTimestampNs()).receptionDelta(0L).sessionId(this.sessionId).streamId(this.streamId).flags((short)0);
            int n2 = this.channelEndpoint.send(this.rttMeasurementBuffer);
            if (40 != n2) {
                this.shortSends.increment();
            }
        }
    }

    @Override
    public void resend(int n2, int n3, int n4) {
        long l2 = this.senderPosition.get();
        long l3 = LogBufferDescriptor.computePosition(n2, n3, this.positionBitsToShift, this.initialTermId);
        long l4 = l2 - (long)(this.termBufferLength >> 1) - (long)FrameDescriptor.computeMaxMessageLength(this.termBufferLength);
        if (l4 <= l3 && l3 < l2) {
            long l5;
            int n5;
            int n6 = LogBufferDescriptor.indexByPosition(l3, this.positionBitsToShift);
            UnsafeBuffer unsafeBuffer = this.termBuffers[n6];
            ByteBuffer byteBuffer = this.sendBuffers[n6];
            int n7 = n4;
            int n8 = 0;
            int n9 = n3;
            while ((n5 = TermScanner.available(l5 = TermScanner.scanForAvailability(unsafeBuffer, n9 += n8, Math.min(this.mtuLength, n7)))) > 0) {
                byteBuffer.limit(n9 + n5).position(n9);
                if (n5 != this.channelEndpoint.send(byteBuffer)) {
                    this.shortSends.increment();
                    break;
                }
                n8 = n5 + TermScanner.padding(l5);
                if ((n7 -= n8) > 0) continue;
            }
            this.retransmitsSent.incrementOrdered();
        }
    }

    int send(long l2) {
        int n2;
        long l3 = this.senderPosition.get();
        int n3 = LogBufferDescriptor.computeTermIdFromPosition(l3, this.positionBitsToShift, this.initialTermId);
        int n4 = (int)l3 & this.termLengthMask;
        if (!this.hasInitialConnection || this.isSetupElicited) {
            this.setupMessageCheck(l2, n3, n4);
        }
        if (0 == (n2 = this.sendData(l2, l3, n4))) {
            n2 = this.heartbeatMessageCheck(l2, n3, n4, this.signalEos && this.isEndOfStream);
            if (this.spiesSimulateConnection && this.hasSpies && !this.hasReceivers) {
                long l4 = this.maxSpyPosition(l3);
                this.senderPosition.setOrdered(l4);
                this.senderLimit.setOrdered(this.flowControl.onIdle(l2, l4, l4, this.isEndOfStream));
            } else {
                this.senderLimit.setOrdered(this.flowControl.onIdle(l2, this.senderLimit.get(), l3, this.isEndOfStream));
            }
        }
        this.updateHasReceivers(l2);
        this.retransmitHandler.processTimeouts(l2, this);
        return n2;
    }

    SendChannelEndpoint channelEndpoint() {
        return this.channelEndpoint;
    }

    RawLog rawLog() {
        return this.rawLog;
    }

    int publisherLimitId() {
        return this.publisherLimit.id();
    }

    long tag() {
        return this.tag;
    }

    int termBufferLength() {
        return this.termBufferLength;
    }

    int mtuLength() {
        return this.mtuLength;
    }

    long registrationId() {
        return this.registrationId;
    }

    boolean isExclusive() {
        return this.isExclusive;
    }

    boolean spiesSimulateConnection() {
        return this.spiesSimulateConnection;
    }

    int initialTermId() {
        return this.initialTermId;
    }

    int startingTermId() {
        return this.startingTermId;
    }

    int startingTermOffset() {
        return this.startingTermOffset;
    }

    boolean isAcceptingSubscriptions() {
        return State.ACTIVE == this.state || State.DRAINING == this.state && this.spyPositions.length > 0 && this.producerPosition() > this.senderPosition.getVolatile();
    }

    int updatePublisherLimit() {
        int n2 = 0;
        if (State.ACTIVE == this.state) {
            long l2 = this.senderPosition.getVolatile();
            if (this.hasRequiredReceivers() || this.spiesSimulateConnection && this.spyPositions.length > 0) {
                long l3 = l2;
                for (ReadablePosition readablePosition : this.spyPositions) {
                    l3 = Math.min(l3, readablePosition.getVolatile());
                }
                long l4 = l3 + (long)this.termWindowLength;
                long l5 = this.publisherLimit.get();
                if (l4 > l5) {
                    this.cleanBufferTo(l3 - (long)this.termBufferLength);
                    this.publisherLimit.setOrdered(l4);
                    n2 = 1;
                }
            } else if (this.publisherLimit.get() > l2) {
                this.publisherLimit.setOrdered(l2);
                this.cleanBufferTo(l2 - (long)this.termBufferLength);
                n2 = 1;
            }
        }
        return n2;
    }

    boolean hasSpies() {
        return this.hasSpies;
    }

    void updateHasReceivers(long l2) {
        if (this.timeOfLastStatusMessageNs + this.connectionTimeoutNs - l2 < 0L && this.hasReceivers) {
            this.hasReceivers = false;
        }
    }

    private int sendData(long l2, long l3, int n2) {
        int n3 = 0;
        int n4 = (int)(this.senderLimit.get() - l3);
        if (n4 > 0) {
            int n5 = Math.min(n4, this.mtuLength);
            int n6 = LogBufferDescriptor.indexByPosition(l3, this.positionBitsToShift);
            long l4 = TermScanner.scanForAvailability(this.termBuffers[n6], n2, n5);
            int n7 = TermScanner.available(l4);
            if (n7 > 0) {
                ByteBuffer byteBuffer = this.sendBuffers[n6];
                byteBuffer.limit(n2 + n7).position(n2);
                if (n7 == this.channelEndpoint.send(byteBuffer)) {
                    this.timeOfLastDataOrHeartbeatNs = l2;
                    this.trackSenderLimits = true;
                    n3 = n7;
                    this.senderPosition.setOrdered(l3 + (long)n3 + (long)TermScanner.padding(l4));
                } else {
                    this.shortSends.increment();
                }
            }
        } else if (this.trackSenderLimits) {
            this.trackSenderLimits = false;
            this.senderBpe.incrementOrdered();
            this.senderFlowControlLimits.incrementOrdered();
        }
        return n3;
    }

    private void setupMessageCheck(long l2, int n2, int n3) {
        if (this.timeOfLastSetupNs + Configuration.PUBLICATION_SETUP_TIMEOUT_NS - l2 < 0L) {
            this.timeOfLastSetupNs = l2;
            this.setupBuffer.clear();
            this.setupHeader.activeTermId(n2).termOffset(n3).sessionId(this.sessionId).streamId(this.streamId).initialTermId(this.initialTermId).termLength(this.termBufferLength).mtuLength(this.mtuLength).ttl(this.channelEndpoint.multicastTtl());
            if (this.isSetupElicited) {
                this.flowControl.onSetup(this.setupHeader, this.senderLimit.get(), this.senderPosition.get(), this.positionBitsToShift, l2);
            }
            if (40 != this.channelEndpoint.send(this.setupBuffer)) {
                this.shortSends.increment();
            }
            if (this.isSetupElicited && this.hasReceivers) {
                this.isSetupElicited = false;
            }
        }
    }

    private int heartbeatMessageCheck(long l2, int n2, int n3, boolean bl2) {
        int n4 = 0;
        if (this.hasInitialConnection && this.timeOfLastDataOrHeartbeatNs + Configuration.PUBLICATION_HEARTBEAT_TIMEOUT_NS - l2 < 0L) {
            this.heartbeatBuffer.clear();
            this.heartbeatDataHeader.sessionId(this.sessionId).streamId(this.streamId).termId(n2).termOffset(n3).flags((byte)(bl2 ? 224 : 192));
            n4 = this.channelEndpoint.send(this.heartbeatBuffer);
            if (32 != n4) {
                this.shortSends.increment();
            }
            this.timeOfLastDataOrHeartbeatNs = l2;
            this.heartbeatsSent.incrementOrdered();
        }
        return n4;
    }

    private void cleanBufferTo(long l2) {
        long l3 = this.cleanPosition;
        if (l2 > l3) {
            UnsafeBuffer unsafeBuffer = this.termBuffers[LogBufferDescriptor.indexByPosition(l3, this.positionBitsToShift)];
            int n2 = (int)(l2 - l3);
            int n3 = (int)l3 & this.termLengthMask;
            int n4 = Math.min(n2, this.termBufferLength - n3);
            unsafeBuffer.setMemory(n3 + 8, n4 - 8, (byte)0);
            unsafeBuffer.putLongOrdered(n3, 0L);
            this.cleanPosition = l3 + (long)n4;
        }
    }

    private void checkForBlockedPublisher(long l2, long l3, long l4) {
        if (l3 == this.lastSenderPosition && this.isPossiblyBlocked(l2, l3)) {
            if (this.timeOfLastActivityNs + this.unblockTimeoutNs - l4 < 0L && LogBufferUnblocker.unblock(this.termBuffers, this.metaDataBuffer, l3, this.termBufferLength)) {
                this.unblockedPublications.incrementOrdered();
            }
        } else {
            this.timeOfLastActivityNs = l4;
            this.lastSenderPosition = l3;
        }
    }

    private boolean isPossiblyBlocked(long l2, long l3) {
        int n2;
        int n3 = LogBufferDescriptor.activeTermCount(this.metaDataBuffer);
        if (n3 != (n2 = (int)(l3 >> this.positionBitsToShift))) {
            return true;
        }
        return l2 > l3;
    }

    private boolean spiesFinishedConsuming(DriverConductor driverConductor, long l2) {
        if (this.spyPositions.length > 0) {
            for (ReadablePosition readablePosition : this.spyPositions) {
                if (readablePosition.getVolatile() >= l2) continue;
                return false;
            }
            this.hasSpies = false;
            driverConductor.cleanupSpies(this);
        }
        return true;
    }

    private long maxSpyPosition(long l2) {
        long l3 = l2;
        for (ReadablePosition readablePosition : this.spyPositions) {
            l3 = Math.max(l3, readablePosition.getVolatile());
        }
        return l3;
    }

    private void updateConnectedStatus() {
        boolean bl2;
        boolean bl3 = bl2 = this.hasRequiredReceivers() || this.spiesSimulateConnection && this.spyPositions.length > 0;
        if (bl2 != this.isConnected) {
            LogBufferDescriptor.isConnected(this.metaDataBuffer, bl2);
            this.isConnected = bl2;
        }
    }

    private boolean hasRequiredReceivers() {
        return this.hasReceivers && this.flowControl.hasRequiredReceivers();
    }

    private void checkUntetheredSubscriptions(long l2, DriverConductor driverConductor) {
        ArrayList arrayList = this.untetheredSubscriptions;
        int n2 = arrayList.size();
        if (n2 > 0) {
            int n3;
            long l3 = this.senderPosition.getVolatile();
            long l4 = l3 - (long)this.termWindowLength + (long)(this.termWindowLength >> 2);
            for (int i2 = n3 = n2 - 1; i2 >= 0; --i2) {
                UntetheredSubscription untetheredSubscription = (UntetheredSubscription)arrayList.get(i2);
                if (UntetheredSubscription.State.ACTIVE == untetheredSubscription.state) {
                    if (untetheredSubscription.position.getVolatile() > l4) {
                        untetheredSubscription.timeOfLastUpdateNs = l2;
                        continue;
                    }
                    if (untetheredSubscription.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - l2 > 0L) continue;
                    driverConductor.notifyUnavailableImageLink(this.registrationId, untetheredSubscription.subscriptionLink);
                    untetheredSubscription.state(UntetheredSubscription.State.LINGER, l2, this.streamId, this.sessionId);
                    continue;
                }
                if (UntetheredSubscription.State.LINGER == untetheredSubscription.state) {
                    if (untetheredSubscription.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - l2 > 0L) continue;
                    this.spyPositions = ArrayUtil.remove(this.spyPositions, untetheredSubscription.position);
                    untetheredSubscription.state(UntetheredSubscription.State.RESTING, l2, this.streamId, this.sessionId);
                    continue;
                }
                if (UntetheredSubscription.State.RESTING != untetheredSubscription.state || untetheredSubscription.timeOfLastUpdateNs + this.untetheredRestingTimeoutNs - l2 > 0L) continue;
                this.spyPositions = ArrayUtil.add(this.spyPositions, untetheredSubscription.position);
                driverConductor.notifyAvailableImageLink(this.registrationId, this.sessionId, untetheredSubscription.subscriptionLink, untetheredSubscription.position.id(), l3, this.rawLog.fileName(), "aeron:ipc");
                untetheredSubscription.state(UntetheredSubscription.State.ACTIVE, l2, this.streamId, this.sessionId);
                LogBufferDescriptor.isConnected(this.metaDataBuffer, true);
            }
        }
    }

    @Override
    public void onTimeEvent(long l2, long l3, DriverConductor driverConductor) {
        switch (this.state) {
            case ACTIVE: {
                this.updateConnectedStatus();
                long l4 = this.producerPosition();
                this.publisherPos.setOrdered(l4);
                if (!this.isExclusive) {
                    this.checkForBlockedPublisher(l4, this.senderPosition.getVolatile(), l2);
                }
                this.checkUntetheredSubscriptions(l2, driverConductor);
                break;
            }
            case DRAINING: {
                long l5 = this.producerPosition();
                this.publisherPos.setOrdered(l5);
                long l6 = this.senderPosition.getVolatile();
                if (l5 > l6) {
                    if (LogBufferUnblocker.unblock(this.termBuffers, this.metaDataBuffer, l6, this.termBufferLength)) {
                        this.unblockedPublications.incrementOrdered();
                        break;
                    }
                    if (this.hasReceivers) {
                        break;
                    }
                } else {
                    this.isEndOfStream = true;
                }
                if (!this.spiesFinishedConsuming(driverConductor, l5)) break;
                this.timeOfLastActivityNs = l2;
                this.state = State.LINGER;
                break;
            }
            case LINGER: {
                if (!this.hasReceivedSmEos && this.timeOfLastActivityNs + this.lingerTimeoutNs - l2 >= 0L) break;
                this.channelEndpoint.decRef();
                driverConductor.cleanupPublication(this);
                this.timeOfLastActivityNs = l2;
                this.state = State.DONE;
                break;
            }
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.hasSenderReleased;
    }

    void decRef() {
        if (0 == --this.refCount) {
            long l2 = this.producerPosition();
            this.publisherLimit.setOrdered(l2);
            LogBufferDescriptor.endOfStreamPosition(this.metaDataBuffer, l2);
            if (this.senderPosition.getVolatile() >= l2) {
                this.isEndOfStream = true;
            }
            this.state = State.DRAINING;
        }
    }

    void incRef() {
        ++this.refCount;
    }

    State state() {
        return this.state;
    }

    void senderRelease() {
        this.hasSenderReleased = true;
    }

    long producerPosition() {
        long l2 = LogBufferDescriptor.rawTailVolatile(this.metaDataBuffer);
        int n2 = LogBufferDescriptor.termOffset(l2, this.termBufferLength);
        return LogBufferDescriptor.computePosition(LogBufferDescriptor.termId(l2), n2, this.positionBitsToShift, this.initialTermId);
    }

    long consumerPosition() {
        return this.senderPosition.getVolatile();
    }

    static enum State {
        ACTIVE,
        DRAINING,
        LINGER,
        DONE;

    }
}

