/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.driver.ClientProxy;
import io.aeron.driver.Configuration;
import io.aeron.driver.CongestionControlSupplier;
import io.aeron.driver.DefaultNameResolver;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.DutyCycleTracker;
import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.FlowControlSupplier;
import io.aeron.driver.NameResolver;
import io.aeron.driver.OptimalMulticastDelayGenerator;
import io.aeron.driver.ReceiveChannelEndpointSupplier;
import io.aeron.driver.Receiver;
import io.aeron.driver.ReceiverProxy;
import io.aeron.driver.SendChannelEndpointSupplier;
import io.aeron.driver.Sender;
import io.aeron.driver.SenderProxy;
import io.aeron.driver.StaticDelayGenerator;
import io.aeron.driver.TerminationValidator;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.buffer.FileStoreLogFactory;
import io.aeron.driver.buffer.LogFactory;
import io.aeron.driver.exceptions.ActiveDriverException;
import io.aeron.driver.media.ControlTransportPoller;
import io.aeron.driver.media.DataTransportPoller;
import io.aeron.driver.media.ReceiveChannelEndpointThreadLocals;
import io.aeron.driver.reports.LossReport;
import io.aeron.driver.reports.LossReportUtil;
import io.aeron.driver.status.DutyCycleStallTracker;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.agrona.BitUtil;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.CachedEpochClock;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.CompositeAgent;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.HighResolutionTimer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.ShutdownSignalBarrier;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.SystemEpochNanoClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.broadcast.BroadcastTransmitter;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.ConcurrentCountersManager;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.UnsafeBufferStatusIndicator;

public final class MediaDriver
implements AutoCloseable {
    private boolean wasHighResTimerEnabled;
    private final AgentRunner sharedRunner;
    private final AgentRunner sharedNetworkRunner;
    private final AgentRunner conductorRunner;
    private final AgentRunner receiverRunner;
    private final AgentRunner senderRunner;
    private final AgentInvoker sharedInvoker;
    private final Context ctx;

    public static void main(String[] stringArray) {
        SystemUtil.loadPropertiesFiles(stringArray);
        ShutdownSignalBarrier shutdownSignalBarrier = new ShutdownSignalBarrier();
        Context context = new Context().terminationHook(shutdownSignalBarrier::signal);
        try (MediaDriver mediaDriver = MediaDriver.launch(context);){
            shutdownSignalBarrier.await();
            System.out.println("Shutdown Driver...");
        }
    }

    private MediaDriver(Context context) {
        context.concludeAeronDirectory();
        MediaDriver.ensureDirectoryIsRecreated(context);
        Configuration.validateSocketBufferLengths(context);
        try {
            context.conclude();
            this.ctx = context;
            DriverConductor driverConductor = new DriverConductor(context);
            Receiver receiver = new Receiver(context);
            Sender sender = new Sender(context);
            context.receiverProxy().receiver(receiver);
            context.senderProxy().sender(sender);
            context.driverConductorProxy().driverConductor(driverConductor);
            AtomicCounter atomicCounter = context.systemCounters().get(SystemCounterDescriptor.ERRORS);
            ErrorHandler errorHandler = context.errorHandler();
            switch (context.threadingMode()) {
                case INVOKER: {
                    this.sharedInvoker = new AgentInvoker(errorHandler, atomicCounter, new CompositeAgent(sender, receiver, driverConductor));
                    this.sharedRunner = null;
                    this.sharedNetworkRunner = null;
                    this.conductorRunner = null;
                    this.receiverRunner = null;
                    this.senderRunner = null;
                    break;
                }
                case SHARED: {
                    this.sharedRunner = new AgentRunner(context.sharedIdleStrategy(), errorHandler, atomicCounter, new CompositeAgent(sender, receiver, driverConductor));
                    this.sharedNetworkRunner = null;
                    this.conductorRunner = null;
                    this.receiverRunner = null;
                    this.senderRunner = null;
                    this.sharedInvoker = null;
                    break;
                }
                case SHARED_NETWORK: {
                    this.sharedNetworkRunner = new AgentRunner(context.sharedNetworkIdleStrategy(), errorHandler, atomicCounter, new CompositeAgent(sender, receiver));
                    this.conductorRunner = new AgentRunner(context.conductorIdleStrategy(), errorHandler, atomicCounter, driverConductor);
                    this.sharedRunner = null;
                    this.receiverRunner = null;
                    this.senderRunner = null;
                    this.sharedInvoker = null;
                    break;
                }
                default: {
                    this.senderRunner = new AgentRunner(context.senderIdleStrategy(), errorHandler, atomicCounter, sender);
                    this.receiverRunner = new AgentRunner(context.receiverIdleStrategy(), errorHandler, atomicCounter, receiver);
                    this.conductorRunner = new AgentRunner(context.conductorIdleStrategy(), errorHandler, atomicCounter, driverConductor);
                    this.sharedNetworkRunner = null;
                    this.sharedRunner = null;
                    this.sharedInvoker = null;
                    break;
                }
            }
        }
        catch (ConcurrentConcludeException concurrentConcludeException) {
            throw concurrentConcludeException;
        }
        catch (Exception exception) {
            CloseHelper.quietClose(context::close);
            throw exception;
        }
    }

    public static MediaDriver launchEmbedded() {
        return MediaDriver.launchEmbedded(new Context());
    }

    public static MediaDriver launchEmbedded(Context context) {
        if (CommonContext.AERON_DIR_PROP_DEFAULT.equals(context.aeronDirectoryName())) {
            context.aeronDirectoryName(CommonContext.generateRandomDirName());
        }
        return MediaDriver.launch(context);
    }

    public static MediaDriver launch() {
        return MediaDriver.launch(new Context());
    }

    public static MediaDriver launch(Context context) {
        MediaDriver mediaDriver = new MediaDriver(context);
        if (context.useWindowsHighResTimer() && SystemUtil.isWindows()) {
            mediaDriver.wasHighResTimerEnabled = HighResolutionTimer.isEnabled();
            if (!mediaDriver.wasHighResTimerEnabled) {
                HighResolutionTimer.enable();
            }
        }
        if (null != mediaDriver.conductorRunner) {
            AgentRunner.startOnThread(mediaDriver.conductorRunner, context.conductorThreadFactory());
        }
        if (null != mediaDriver.senderRunner) {
            AgentRunner.startOnThread(mediaDriver.senderRunner, context.senderThreadFactory());
        }
        if (null != mediaDriver.receiverRunner) {
            AgentRunner.startOnThread(mediaDriver.receiverRunner, context.receiverThreadFactory());
        }
        if (null != mediaDriver.sharedNetworkRunner) {
            AgentRunner.startOnThread(mediaDriver.sharedNetworkRunner, context.sharedNetworkThreadFactory());
        }
        if (null != mediaDriver.sharedRunner) {
            AgentRunner.startOnThread(mediaDriver.sharedRunner, context.sharedThreadFactory());
        }
        if (null != mediaDriver.sharedInvoker) {
            mediaDriver.sharedInvoker.start();
        }
        return mediaDriver;
    }

    public Context context() {
        return this.ctx;
    }

    public AgentInvoker sharedAgentInvoker() {
        return this.sharedInvoker;
    }

    @Override
    public void close() {
        try {
            CloseHelper.closeAll(this.sharedRunner, this.sharedNetworkRunner, this.receiverRunner, this.senderRunner, this.conductorRunner, this.sharedInvoker);
        }
        finally {
            if (this.ctx.useWindowsHighResTimer() && SystemUtil.isWindows() && !this.wasHighResTimerEnabled) {
                HighResolutionTimer.disable();
            }
        }
    }

    public String aeronDirectoryName() {
        return this.ctx.aeronDirectoryName();
    }

    private static void ensureDirectoryIsRecreated(Context context) {
        if (context.aeronDirectory().isDirectory()) {
            if (context.warnIfDirectoryExists()) {
                System.err.println("WARNING: " + context.aeronDirectory() + " exists");
            }
            if (!context.dirDeleteOnStart()) {
                Consumer<String> consumer = context.warnIfDirectoryExists() ? System.err::println : string -> {};
                MappedByteBuffer mappedByteBuffer = context.mapExistingCncFile(consumer);
                try {
                    if (CommonContext.isDriverActive(context.driverTimeoutMs(), consumer, mappedByteBuffer)) {
                        throw new ActiveDriverException("active driver detected");
                    }
                    MediaDriver.reportExistingErrors(context, mappedByteBuffer);
                }
                finally {
                    BufferUtil.free(mappedByteBuffer);
                }
            }
            context.deleteDirectory();
        }
        IoUtil.ensureDirectoryExists(context.aeronDirectory(), "aeron");
    }

    private static void reportExistingErrors(Context context, MappedByteBuffer mappedByteBuffer) {
        block14: {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n2 = context.saveErrorLog(new PrintStream((OutputStream)byteArrayOutputStream, false, "US-ASCII"), mappedByteBuffer);
                if (n2 <= 0) break block14;
                StringBuilder stringBuilder = new StringBuilder(context.aeronDirectoryName());
                IoUtil.removeTrailingSlashes(stringBuilder);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("-yyyy-MM-dd-HH-mm-ss-SSSZ");
                stringBuilder.append(simpleDateFormat.format(new Date())).append("-error.log");
                String string = stringBuilder.toString();
                System.err.println("WARNING: Existing errors saved to: " + string);
                try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
                    byteArrayOutputStream.writeTo(fileOutputStream);
                }
            }
            catch (Exception exception) {
                LangUtil.rethrowUnchecked(exception);
            }
        }
    }

    public static final class Context
    extends CommonContext {
        private static final AtomicIntegerFieldUpdater<Context> IS_CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Context.class, "isClosed");
        private volatile int isClosed;
        private boolean printConfigurationOnStart = Configuration.printConfigurationOnStart();
        private boolean useWindowsHighResTimer = Configuration.useWindowsHighResTimer();
        private boolean warnIfDirectoryExists = Configuration.warnIfDirExists();
        private boolean dirDeleteOnStart = Configuration.dirDeleteOnStart();
        private boolean dirDeleteOnShutdown = Configuration.dirDeleteOnShutdown();
        private boolean termBufferSparseFile = Configuration.termBufferSparseFile();
        private boolean performStorageChecks = Configuration.performStorageChecks();
        private boolean spiesSimulateConnection = Configuration.spiesSimulateConnection();
        private boolean reliableStream = Configuration.reliableStream();
        private boolean tetherSubscriptions = Configuration.tetherSubscriptions();
        private boolean rejoinStream = Configuration.rejoinStream();
        private long lowStorageWarningThreshold = Configuration.lowStorageWarningThreshold();
        private long timerIntervalNs = Configuration.timerIntervalNs();
        private long clientLivenessTimeoutNs = Configuration.clientLivenessTimeoutNs();
        private long imageLivenessTimeoutNs = Configuration.imageLivenessTimeoutNs();
        private long publicationUnblockTimeoutNs = Configuration.publicationUnblockTimeoutNs();
        private long publicationConnectionTimeoutNs = Configuration.publicationConnectionTimeoutNs();
        private long publicationLingerTimeoutNs = Configuration.publicationLingerTimeoutNs();
        private long untetheredWindowLimitTimeoutNs = Configuration.untetheredWindowLimitTimeoutNs();
        private long untetheredRestingTimeoutNs = Configuration.untetheredRestingTimeoutNs();
        private long statusMessageTimeoutNs = Configuration.statusMessageTimeoutNs();
        private long counterFreeToReuseTimeoutNs = Configuration.counterFreeToReuseTimeoutNs();
        private long retransmitUnicastDelayNs = Configuration.retransmitUnicastDelayNs();
        private long retransmitUnicastLingerNs = Configuration.retransmitUnicastLingerNs();
        private long nakUnicastDelayNs = Configuration.nakUnicastDelayNs();
        private long nakMulticastMaxBackoffNs = Configuration.nakMulticastMaxBackoffNs();
        private long flowControlReceiverTimeoutNs = Configuration.flowControlReceiverTimeoutNs();
        private long reResolutionCheckIntervalNs = Configuration.reResolutionCheckIntervalNs();
        private long conductorCycleThresholdNs = Configuration.conductorCycleThresholdNs();
        private long senderCycleThresholdNs = Configuration.senderCycleThresholdNs();
        private long receiverCycleThresholdNs = Configuration.receiverCycleThresholdNs();
        private int conductorBufferLength = Configuration.conductorBufferLength();
        private int toClientsBufferLength = Configuration.toClientsBufferLength();
        private int counterValuesBufferLength = Configuration.counterValuesBufferLength();
        private int errorBufferLength = Configuration.errorBufferLength();
        private int nakMulticastGroupSize = Configuration.nakMulticastGroupSize();
        private int publicationTermBufferLength = Configuration.termBufferLength();
        private int ipcTermBufferLength = Configuration.ipcTermBufferLength();
        private int publicationTermWindowLength = Configuration.publicationTermWindowLength();
        private int ipcPublicationTermWindowLength = Configuration.ipcPublicationTermWindowLength();
        private int initialWindowLength = Configuration.initialWindowLength();
        private int socketSndbufLength = Configuration.socketSndbufLength();
        private int socketRcvbufLength = Configuration.socketRcvbufLength();
        private int socketMulticastTtl = Configuration.socketMulticastTtl();
        private int mtuLength = Configuration.mtuLength();
        private int ipcMtuLength = Configuration.ipcMtuLength();
        private int filePageSize = Configuration.filePageSize();
        private int publicationReservedSessionIdLow = Configuration.publicationReservedSessionIdLow();
        private int publicationReservedSessionIdHigh = Configuration.publicationReservedSessionIdHigh();
        private int lossReportBufferLength = Configuration.lossReportBufferLength();
        private int sendToStatusMessagePollRatio = Configuration.sendToStatusMessagePollRatio();
        private int resourceFreeLimit = Configuration.resourceFreeLimit();
        private Long receiverGroupTag = Configuration.groupTag();
        private long flowControlGroupTag = Configuration.flowControlGroupTag();
        private int flowControlGroupMinSize = Configuration.flowControlGroupMinSize();
        private CommonContext.InferableBoolean receiverGroupConsideration = Configuration.receiverGroupConsideration();
        private String resolverName = Configuration.resolverName();
        private String resolverInterface = Configuration.resolverInterface();
        private String resolverBootstrapNeighbor = Configuration.resolverBootstrapNeighbor();
        private EpochClock epochClock;
        private NanoClock nanoClock;
        private CachedEpochClock cachedEpochClock;
        private CachedNanoClock cachedNanoClock;
        private CachedNanoClock senderCachedNanoClock;
        private CachedNanoClock receiverCachedNanoClock;
        private ThreadingMode threadingMode;
        private ThreadFactory conductorThreadFactory;
        private ThreadFactory senderThreadFactory;
        private ThreadFactory receiverThreadFactory;
        private ThreadFactory sharedThreadFactory;
        private ThreadFactory sharedNetworkThreadFactory;
        private IdleStrategy conductorIdleStrategy;
        private IdleStrategy senderIdleStrategy;
        private IdleStrategy receiverIdleStrategy;
        private IdleStrategy sharedNetworkIdleStrategy;
        private IdleStrategy sharedIdleStrategy;
        private SendChannelEndpointSupplier sendChannelEndpointSupplier;
        private ReceiveChannelEndpointSupplier receiveChannelEndpointSupplier;
        private ReceiveChannelEndpointThreadLocals receiveChannelEndpointThreadLocals;
        private MutableDirectBuffer tempBuffer;
        private FlowControlSupplier unicastFlowControlSupplier;
        private FlowControlSupplier multicastFlowControlSupplier;
        private byte[] applicationSpecificFeedback;
        private CongestionControlSupplier congestionControlSupplier;
        private FeedbackDelayGenerator unicastFeedbackDelayGenerator;
        private FeedbackDelayGenerator multicastFeedbackDelayGenerator;
        private FeedbackDelayGenerator retransmitUnicastDelayGenerator;
        private FeedbackDelayGenerator retransmitUnicastLingerGenerator;
        private TerminationValidator terminationValidator;
        private Runnable terminationHook;
        private NameResolver nameResolver;
        private DistinctErrorLog errorLog;
        private ErrorHandler errorHandler;
        private boolean useConcurrentCountersManager;
        private CountersManager countersManager;
        private SystemCounters systemCounters;
        private LossReport lossReport;
        private LogFactory logFactory;
        private DataTransportPoller dataTransportPoller;
        private ControlTransportPoller controlTransportPoller;
        private ManyToOneConcurrentArrayQueue<Runnable> driverCommandQueue;
        private OneToOneConcurrentArrayQueue<Runnable> receiverCommandQueue;
        private OneToOneConcurrentArrayQueue<Runnable> senderCommandQueue;
        private ReceiverProxy receiverProxy;
        private SenderProxy senderProxy;
        private DriverConductorProxy driverConductorProxy;
        private ClientProxy clientProxy;
        private RingBuffer toDriverCommands;
        private MappedByteBuffer lossReportBuffer;
        private MappedByteBuffer cncByteBuffer;
        private UnsafeBuffer cncMetaDataBuffer;
        private int osDefaultSocketRcvbufLength = -1;
        private int osMaxSocketRcvbufLength = -1;
        private int osDefaultSocketSndbufLength = -1;
        private int osMaxSocketSndbufLength = -1;
        private EpochNanoClock channelReceiveTimestampClock;
        private EpochNanoClock channelSendTimestampClock;
        private DutyCycleTracker conductorDutyCycleTracker;
        private DutyCycleTracker senderDutyCycleTracker;
        private DutyCycleTracker receiverDutyCycleTracker;

        @Override
        public Context clone() {
            return (Context)super.clone();
        }

        @Override
        public void close() {
            if (IS_CLOSED_UPDATER.compareAndSet(this, 0, 1)) {
                CloseHelper.close(this.errorHandler, this.logFactory);
                if (null != this.systemCounters) {
                    AtomicCounter atomicCounter = this.systemCounters.get(SystemCounterDescriptor.ERRORS);
                    atomicCounter.disconnectCountersManager();
                    atomicCounter.close();
                }
                if (this.errorHandler instanceof AutoCloseable) {
                    CloseHelper.quietClose((AutoCloseable)((Object)this.errorHandler));
                }
                BufferUtil.free(this.lossReportBuffer);
                this.lossReportBuffer = null;
                BufferUtil.free(this.cncByteBuffer);
                this.cncByteBuffer = null;
                if (this.dirDeleteOnShutdown) {
                    this.deleteDirectory();
                }
                super.close();
            }
        }

        @Override
        public Context conclude() {
            super.conclude();
            try {
                this.concludeNullProperties();
                this.resolveOsSocketBufLengths();
                Configuration.validateMtuLength(this.mtuLength);
                Configuration.validateMtuLength(this.ipcMtuLength);
                Configuration.validatePageSize(this.filePageSize);
                Configuration.validateValueRange(this.conductorBufferLength, Configuration.CONDUCTOR_BUFFER_LENGTH_DEFAULT, Integer.MAX_VALUE, "conductorBufferLength");
                Configuration.validateValueRange(this.toClientsBufferLength, Configuration.TO_CLIENTS_BUFFER_LENGTH_DEFAULT, Integer.MAX_VALUE, "toClientsBufferLength");
                Configuration.validateValueRange(this.counterValuesBufferLength, 0x100000L, 524288000L, "counterValuesBufferLength");
                Configuration.validateValueRange(this.errorBufferLength, 0x100000L, Integer.MAX_VALUE, "errorBufferLength");
                Configuration.validateValueRange(this.publicationTermWindowLength, 0L, 0x40000000L, "publicationTermWindowLength");
                Configuration.validateValueRange(this.ipcPublicationTermWindowLength, 0L, 0x40000000L, "ipcPublicationTermWindowLength");
                Configuration.validateSessionIdRange(this.publicationReservedSessionIdLow, this.publicationReservedSessionIdHigh);
                LogBufferDescriptor.checkTermLength(this.publicationTermBufferLength);
                LogBufferDescriptor.checkTermLength(this.ipcTermBufferLength);
                Configuration.validateInitialWindowLength(this.initialWindowLength, this.mtuLength);
                Configuration.validateUnblockTimeout(this.publicationUnblockTimeoutNs, this.clientLivenessTimeoutNs, this.timerIntervalNs);
                Configuration.validateUntetheredTimeouts(this.untetheredWindowLimitTimeoutNs, this.untetheredRestingTimeoutNs, this.timerIntervalNs);
                long l2 = BitUtil.align((long)CncFileDescriptor.END_OF_METADATA_OFFSET + (long)this.conductorBufferLength + (long)this.toClientsBufferLength + (long)Configuration.countersMetadataBufferLength(this.counterValuesBufferLength) + (long)this.counterValuesBufferLength + (long)this.errorBufferLength, (long)this.filePageSize);
                Configuration.validateValueRange(l2, 0L, Integer.MAX_VALUE, "CnC file length");
                this.cncByteBuffer = IoUtil.mapNewFile(this.cncFile(), l2);
                this.cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(this.cncByteBuffer);
                CncFileDescriptor.fillMetaData(this.cncMetaDataBuffer, this.conductorBufferLength, this.toClientsBufferLength, Configuration.countersMetadataBufferLength(this.counterValuesBufferLength), this.counterValuesBufferLength, this.clientLivenessTimeoutNs, this.errorBufferLength, this.epochClock.time(), SystemUtil.getPid());
                this.concludeCounters();
                this.concludeDependantProperties();
                this.concludeIdleStrategies();
                this.toDriverCommands.nextCorrelationId();
                this.toDriverCommands.consumerHeartbeatTime(this.epochClock.time());
                CncFileDescriptor.signalCncReady(this.cncMetaDataBuffer);
            }
            catch (Exception exception) {
                LangUtil.rethrowUnchecked(exception);
            }
            if (this.printConfigurationOnStart) {
                System.out.println(this);
            }
            return this;
        }

        public void deleteDirectory() {
            if (null != this.aeronDirectory()) {
                super.deleteAeronDirectory();
            }
        }

        @Override
        public Context aeronDirectoryName(String string) {
            super.aeronDirectoryName(string);
            return this;
        }

        @Override
        public Context driverTimeoutMs(long l2) {
            super.driverTimeoutMs(l2);
            return this;
        }

        @Override
        public Context countersMetaDataBuffer(UnsafeBuffer unsafeBuffer) {
            super.countersMetaDataBuffer(unsafeBuffer);
            return this;
        }

        @Override
        public Context countersValuesBuffer(UnsafeBuffer unsafeBuffer) {
            super.countersValuesBuffer(unsafeBuffer);
            return this;
        }

        public boolean printConfigurationOnStart() {
            return this.printConfigurationOnStart;
        }

        public Context printConfigurationOnStart(boolean bl2) {
            this.printConfigurationOnStart = bl2;
            return this;
        }

        public Context useWindowsHighResTimer(boolean bl2) {
            this.useWindowsHighResTimer = bl2;
            return this;
        }

        public boolean useWindowsHighResTimer() {
            return this.useWindowsHighResTimer;
        }

        public boolean warnIfDirectoryExists() {
            return this.warnIfDirectoryExists;
        }

        public Context warnIfDirectoryExists(boolean bl2) {
            this.warnIfDirectoryExists = bl2;
            return this;
        }

        public boolean dirDeleteOnStart() {
            return this.dirDeleteOnStart;
        }

        public Context dirDeleteOnStart(boolean bl2) {
            this.dirDeleteOnStart = bl2;
            return this;
        }

        public boolean dirDeleteOnShutdown() {
            return this.dirDeleteOnShutdown;
        }

        public Context dirDeleteOnShutdown(boolean bl2) {
            this.dirDeleteOnShutdown = bl2;
            return this;
        }

        public boolean termBufferSparseFile() {
            return this.termBufferSparseFile;
        }

        public Context termBufferSparseFile(boolean bl2) {
            this.termBufferSparseFile = bl2;
            return this;
        }

        public int conductorBufferLength() {
            return this.conductorBufferLength;
        }

        public Context conductorBufferLength(int n2) {
            this.conductorBufferLength = n2;
            return this;
        }

        public int toClientsBufferLength() {
            return this.toClientsBufferLength;
        }

        public Context toClientsBufferLength(int n2) {
            this.toClientsBufferLength = n2;
            return this;
        }

        public int counterValuesBufferLength() {
            return this.counterValuesBufferLength;
        }

        public Context counterValuesBufferLength(int n2) {
            this.counterValuesBufferLength = n2;
            return this;
        }

        public int errorBufferLength() {
            return this.errorBufferLength;
        }

        public Context errorBufferLength(int n2) {
            this.errorBufferLength = n2;
            return this;
        }

        public boolean performStorageChecks() {
            return this.performStorageChecks;
        }

        public Context performStorageChecks(boolean bl2) {
            this.performStorageChecks = bl2;
            return this;
        }

        public long lowStorageWarningThreshold() {
            return this.lowStorageWarningThreshold;
        }

        public Context lowStorageWarningThreshold(long l2) {
            this.lowStorageWarningThreshold = l2;
            return this;
        }

        public int lossReportBufferLength() {
            return this.lossReportBufferLength;
        }

        public Context lossReportBufferLength(int n2) {
            this.lossReportBufferLength = n2;
            return this;
        }

        public int filePageSize() {
            return this.filePageSize;
        }

        public Context filePageSize(int n2) {
            this.filePageSize = n2;
            return this;
        }

        public long timerIntervalNs() {
            return this.timerIntervalNs;
        }

        public Context timerIntervalNs(long l2) {
            this.timerIntervalNs = l2;
            return this;
        }

        public long imageLivenessTimeoutNs() {
            return this.imageLivenessTimeoutNs;
        }

        public Context imageLivenessTimeoutNs(long l2) {
            this.imageLivenessTimeoutNs = l2;
            return this;
        }

        public long publicationLingerTimeoutNs() {
            return this.publicationLingerTimeoutNs;
        }

        public Context publicationLingerTimeoutNs(long l2) {
            this.publicationLingerTimeoutNs = l2;
            return this;
        }

        public long untetheredWindowLimitTimeoutNs() {
            return this.untetheredWindowLimitTimeoutNs;
        }

        public Context untetheredWindowLimitTimeoutNs(long l2) {
            this.untetheredWindowLimitTimeoutNs = l2;
            return this;
        }

        public long untetheredRestingTimeoutNs() {
            return this.untetheredRestingTimeoutNs;
        }

        public Context untetheredRestingTimeoutNs(long l2) {
            this.untetheredRestingTimeoutNs = l2;
            return this;
        }

        public long retransmitUnicastDelayNs() {
            return this.retransmitUnicastDelayNs;
        }

        public Context retransmitUnicastDelayNs(long l2) {
            this.retransmitUnicastDelayNs = l2;
            return this;
        }

        public long retransmitUnicastLingerNs() {
            return this.retransmitUnicastLingerNs;
        }

        public Context retransmitUnicastLingerNs(long l2) {
            this.retransmitUnicastLingerNs = l2;
            return this;
        }

        public long nakUnicastDelayNs() {
            return this.nakUnicastDelayNs;
        }

        public Context nakUnicastDelayNs(long l2) {
            this.nakUnicastDelayNs = l2;
            return this;
        }

        public long nakMulticastMaxBackoffNs() {
            return this.nakMulticastMaxBackoffNs;
        }

        public Context nakMulticastMaxBackoffNs(long l2) {
            this.nakMulticastMaxBackoffNs = l2;
            return this;
        }

        public int nakMulticastGroupSize() {
            return this.nakMulticastGroupSize;
        }

        public Context nakMulticastGroupSize(int n2) {
            this.nakMulticastGroupSize = n2;
            return this;
        }

        public long clientLivenessTimeoutNs() {
            return CommonContext.checkDebugTimeout(this.clientLivenessTimeoutNs, TimeUnit.NANOSECONDS);
        }

        public Context clientLivenessTimeoutNs(long l2) {
            this.clientLivenessTimeoutNs = l2;
            return this;
        }

        public long statusMessageTimeoutNs() {
            return this.statusMessageTimeoutNs;
        }

        public Context statusMessageTimeoutNs(long l2) {
            this.statusMessageTimeoutNs = l2;
            return this;
        }

        public long counterFreeToReuseTimeoutNs() {
            return this.counterFreeToReuseTimeoutNs;
        }

        public Context counterFreeToReuseTimeoutNs(long l2) {
            this.counterFreeToReuseTimeoutNs = l2;
            return this;
        }

        public long publicationUnblockTimeoutNs() {
            return this.publicationUnblockTimeoutNs;
        }

        public Context publicationUnblockTimeoutNs(long l2) {
            this.publicationUnblockTimeoutNs = l2;
            return this;
        }

        public long publicationConnectionTimeoutNs() {
            return this.publicationConnectionTimeoutNs;
        }

        public Context publicationConnectionTimeoutNs(long l2) {
            this.publicationConnectionTimeoutNs = l2;
            return this;
        }

        public boolean spiesSimulateConnection() {
            return this.spiesSimulateConnection;
        }

        public Context spiesSimulateConnection(boolean bl2) {
            this.spiesSimulateConnection = bl2;
            return this;
        }

        public boolean reliableStream() {
            return this.reliableStream;
        }

        public Context reliableStream(boolean bl2) {
            this.reliableStream = bl2;
            return this;
        }

        public boolean tetherSubscriptions() {
            return this.tetherSubscriptions;
        }

        public Context tetherSubscriptions(boolean bl2) {
            this.tetherSubscriptions = bl2;
            return this;
        }

        public CommonContext.InferableBoolean receiverGroupConsideration() {
            return this.receiverGroupConsideration;
        }

        public Context receiverGroupConsideration(CommonContext.InferableBoolean inferableBoolean) {
            this.receiverGroupConsideration = inferableBoolean;
            return this;
        }

        public boolean rejoinStream() {
            return this.rejoinStream;
        }

        public Context rejoinStream(boolean bl2) {
            this.rejoinStream = bl2;
            return this;
        }

        public int publicationTermBufferLength() {
            return this.publicationTermBufferLength;
        }

        public Context publicationTermBufferLength(int n2) {
            this.publicationTermBufferLength = n2;
            return this;
        }

        public int ipcTermBufferLength() {
            return this.ipcTermBufferLength;
        }

        public Context ipcTermBufferLength(int n2) {
            this.ipcTermBufferLength = n2;
            return this;
        }

        public int publicationTermWindowLength() {
            return this.publicationTermWindowLength;
        }

        public Context publicationTermWindowLength(int n2) {
            this.publicationTermWindowLength = n2;
            return this;
        }

        public int ipcPublicationTermWindowLength() {
            return this.ipcPublicationTermWindowLength;
        }

        public Context ipcPublicationTermWindowLength(int n2) {
            this.ipcPublicationTermWindowLength = n2;
            return this;
        }

        public int initialWindowLength() {
            return this.initialWindowLength;
        }

        public Context initialWindowLength(int n2) {
            this.initialWindowLength = n2;
            return this;
        }

        public int socketSndbufLength() {
            return this.socketSndbufLength;
        }

        public Context socketSndbufLength(int n2) {
            this.socketSndbufLength = n2;
            return this;
        }

        public int socketRcvbufLength() {
            return this.socketRcvbufLength;
        }

        public Context socketRcvbufLength(int n2) {
            this.socketRcvbufLength = n2;
            return this;
        }

        public int socketMulticastTtl() {
            return this.socketMulticastTtl;
        }

        public Context socketMulticastTtl(int n2) {
            this.socketMulticastTtl = n2;
            return this;
        }

        public int mtuLength() {
            return this.mtuLength;
        }

        public Context mtuLength(int n2) {
            this.mtuLength = n2;
            return this;
        }

        public int ipcMtuLength() {
            return this.ipcMtuLength;
        }

        public Context ipcMtuLength(int n2) {
            this.ipcMtuLength = n2;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public Context epochClock(EpochClock epochClock) {
            this.epochClock = epochClock;
            return this;
        }

        public NanoClock nanoClock() {
            return this.nanoClock;
        }

        public Context nanoClock(NanoClock nanoClock) {
            this.nanoClock = nanoClock;
            return this;
        }

        public CachedEpochClock cachedEpochClock() {
            return this.cachedEpochClock;
        }

        public Context cachedEpochClock(CachedEpochClock cachedEpochClock) {
            this.cachedEpochClock = cachedEpochClock;
            return this;
        }

        public CachedNanoClock cachedNanoClock() {
            return this.cachedNanoClock;
        }

        public Context cachedNanoClock(CachedNanoClock cachedNanoClock) {
            this.cachedNanoClock = cachedNanoClock;
            return this;
        }

        public CachedNanoClock senderCachedNanoClock() {
            return this.senderCachedNanoClock;
        }

        public Context senderCachedNanoClock(CachedNanoClock cachedNanoClock) {
            this.senderCachedNanoClock = cachedNanoClock;
            return this;
        }

        public CachedNanoClock receiverCachedNanoClock() {
            return this.receiverCachedNanoClock;
        }

        public Context receiverCachedNanoClock(CachedNanoClock cachedNanoClock) {
            this.receiverCachedNanoClock = cachedNanoClock;
            return this;
        }

        public ThreadingMode threadingMode() {
            return this.threadingMode;
        }

        public Context threadingMode(ThreadingMode threadingMode) {
            this.threadingMode = threadingMode;
            return this;
        }

        public ThreadFactory senderThreadFactory() {
            return this.senderThreadFactory;
        }

        public Context senderThreadFactory(ThreadFactory threadFactory) {
            this.senderThreadFactory = threadFactory;
            return this;
        }

        public ThreadFactory receiverThreadFactory() {
            return this.receiverThreadFactory;
        }

        public Context receiverThreadFactory(ThreadFactory threadFactory) {
            this.receiverThreadFactory = threadFactory;
            return this;
        }

        public ThreadFactory conductorThreadFactory() {
            return this.conductorThreadFactory;
        }

        public Context conductorThreadFactory(ThreadFactory threadFactory) {
            this.conductorThreadFactory = threadFactory;
            return this;
        }

        public ThreadFactory sharedThreadFactory() {
            return this.sharedThreadFactory;
        }

        public Context sharedThreadFactory(ThreadFactory threadFactory) {
            this.sharedThreadFactory = threadFactory;
            return this;
        }

        public ThreadFactory sharedNetworkThreadFactory() {
            return this.sharedNetworkThreadFactory;
        }

        public Context sharedNetworkThreadFactory(ThreadFactory threadFactory) {
            this.sharedNetworkThreadFactory = threadFactory;
            return this;
        }

        public IdleStrategy senderIdleStrategy() {
            return this.senderIdleStrategy;
        }

        public Context senderIdleStrategy(IdleStrategy idleStrategy) {
            this.senderIdleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy receiverIdleStrategy() {
            return this.receiverIdleStrategy;
        }

        public Context receiverIdleStrategy(IdleStrategy idleStrategy) {
            this.receiverIdleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy conductorIdleStrategy() {
            return this.conductorIdleStrategy;
        }

        public Context conductorIdleStrategy(IdleStrategy idleStrategy) {
            this.conductorIdleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy sharedNetworkIdleStrategy() {
            return this.sharedNetworkIdleStrategy;
        }

        public Context sharedNetworkIdleStrategy(IdleStrategy idleStrategy) {
            this.sharedNetworkIdleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy sharedIdleStrategy() {
            return this.sharedIdleStrategy;
        }

        public Context sharedIdleStrategy(IdleStrategy idleStrategy) {
            this.sharedIdleStrategy = idleStrategy;
            return this;
        }

        public SendChannelEndpointSupplier sendChannelEndpointSupplier() {
            return this.sendChannelEndpointSupplier;
        }

        public Context sendChannelEndpointSupplier(SendChannelEndpointSupplier sendChannelEndpointSupplier) {
            this.sendChannelEndpointSupplier = sendChannelEndpointSupplier;
            return this;
        }

        public ReceiveChannelEndpointSupplier receiveChannelEndpointSupplier() {
            return this.receiveChannelEndpointSupplier;
        }

        public Context receiveChannelEndpointSupplier(ReceiveChannelEndpointSupplier receiveChannelEndpointSupplier) {
            this.receiveChannelEndpointSupplier = receiveChannelEndpointSupplier;
            return this;
        }

        public ReceiveChannelEndpointThreadLocals receiveChannelEndpointThreadLocals() {
            return this.receiveChannelEndpointThreadLocals;
        }

        public Context receiveChannelEndpointThreadLocals(ReceiveChannelEndpointThreadLocals receiveChannelEndpointThreadLocals) {
            this.receiveChannelEndpointThreadLocals = receiveChannelEndpointThreadLocals;
            return this;
        }

        public MutableDirectBuffer tempBuffer() {
            return this.tempBuffer;
        }

        public Context tempBuffer(MutableDirectBuffer mutableDirectBuffer) {
            this.tempBuffer = mutableDirectBuffer;
            return this;
        }

        public FlowControlSupplier unicastFlowControlSupplier() {
            return this.unicastFlowControlSupplier;
        }

        public Context unicastFlowControlSupplier(FlowControlSupplier flowControlSupplier) {
            this.unicastFlowControlSupplier = flowControlSupplier;
            return this;
        }

        public FlowControlSupplier multicastFlowControlSupplier() {
            return this.multicastFlowControlSupplier;
        }

        public Context multicastFlowControlSupplier(FlowControlSupplier flowControlSupplier) {
            this.multicastFlowControlSupplier = flowControlSupplier;
            return this;
        }

        public long flowControlReceiverTimeoutNs() {
            return this.flowControlReceiverTimeoutNs;
        }

        public Context flowControlReceiverTimeoutNs(long l2) {
            this.flowControlReceiverTimeoutNs = l2;
            return this;
        }

        @Deprecated
        public byte[] applicationSpecificFeedback() {
            return this.applicationSpecificFeedback;
        }

        @Deprecated
        public Context applicationSpecificFeedback(byte[] byArray) {
            this.applicationSpecificFeedback = byArray;
            return this;
        }

        public CongestionControlSupplier congestionControlSupplier() {
            return this.congestionControlSupplier;
        }

        public Context congestControlSupplier(CongestionControlSupplier congestionControlSupplier) {
            this.congestionControlSupplier = congestionControlSupplier;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public DistinctErrorLog errorLog() {
            return this.errorLog;
        }

        public Context errorLog(DistinctErrorLog distinctErrorLog) {
            this.errorLog = distinctErrorLog;
            return this;
        }

        public boolean useConcurrentCountersManager() {
            return this.useConcurrentCountersManager;
        }

        public Context useConcurrentCountersManager(boolean bl2) {
            this.useConcurrentCountersManager = bl2;
            return this;
        }

        public CountersManager countersManager() {
            return this.countersManager;
        }

        public Context countersManager(CountersManager countersManager) {
            this.countersManager = countersManager;
            return this;
        }

        public SystemCounters systemCounters() {
            return this.systemCounters;
        }

        public Context systemCounters(SystemCounters systemCounters) {
            this.systemCounters = systemCounters;
            return this;
        }

        LossReport lossReport() {
            return this.lossReport;
        }

        Context lossReport(LossReport lossReport) {
            this.lossReport = lossReport;
            return this;
        }

        public int publicationReservedSessionIdLow() {
            return this.publicationReservedSessionIdLow;
        }

        public Context publicationReservedSessionIdLow(int n2) {
            this.publicationReservedSessionIdLow = n2;
            return this;
        }

        public int publicationReservedSessionIdHigh() {
            return this.publicationReservedSessionIdHigh;
        }

        public Context publicationReservedSessionIdHigh(int n2) {
            this.publicationReservedSessionIdHigh = n2;
            return this;
        }

        public FeedbackDelayGenerator retransmitUnicastDelayGenerator() {
            return this.retransmitUnicastDelayGenerator;
        }

        public Context retransmitUnicastDelayGenerator(FeedbackDelayGenerator feedbackDelayGenerator) {
            this.retransmitUnicastDelayGenerator = feedbackDelayGenerator;
            return this;
        }

        public FeedbackDelayGenerator retransmitUnicastLingerGenerator() {
            return this.retransmitUnicastLingerGenerator;
        }

        public Context retransmitUnicastLingerGenerator(FeedbackDelayGenerator feedbackDelayGenerator) {
            this.retransmitUnicastLingerGenerator = feedbackDelayGenerator;
            return this;
        }

        public FeedbackDelayGenerator unicastFeedbackDelayGenerator() {
            return this.unicastFeedbackDelayGenerator;
        }

        public Context unicastFeedbackDelayGenerator(FeedbackDelayGenerator feedbackDelayGenerator) {
            this.unicastFeedbackDelayGenerator = feedbackDelayGenerator;
            return this;
        }

        public FeedbackDelayGenerator multicastFeedbackDelayGenerator() {
            return this.multicastFeedbackDelayGenerator;
        }

        public Context multicastFeedbackDelayGenerator(FeedbackDelayGenerator feedbackDelayGenerator) {
            this.multicastFeedbackDelayGenerator = feedbackDelayGenerator;
            return this;
        }

        public Context terminationHook(Runnable runnable) {
            this.terminationHook = runnable;
            return this;
        }

        public Runnable terminationHook() {
            return this.terminationHook;
        }

        public Context terminationValidator(TerminationValidator terminationValidator) {
            this.terminationValidator = terminationValidator;
            return this;
        }

        public TerminationValidator terminationValidator() {
            return this.terminationValidator;
        }

        public int sendToStatusMessagePollRatio() {
            return this.sendToStatusMessagePollRatio;
        }

        public Context sendToStatusMessagePollRatio(int n2) {
            this.sendToStatusMessagePollRatio = n2;
            return this;
        }

        public Long receiverGroupTag() {
            return this.receiverGroupTag;
        }

        public Context receiverGroupTag(Long l2) {
            this.receiverGroupTag = l2;
            return this;
        }

        public long flowControlGroupTag() {
            return this.flowControlGroupTag;
        }

        public Context flowControlGroupTag(long l2) {
            this.flowControlGroupTag = l2;
            return this;
        }

        public int flowControlGroupMinSize() {
            return this.flowControlGroupMinSize;
        }

        public Context flowControlGroupMinSize(int n2) {
            this.flowControlGroupMinSize = n2;
            return this;
        }

        public NameResolver nameResolver() {
            return this.nameResolver;
        }

        public Context nameResolver(NameResolver nameResolver) {
            this.nameResolver = nameResolver;
            return this;
        }

        public String resolverName() {
            return this.resolverName;
        }

        public Context resolverName(String string) {
            this.resolverName = string;
            return this;
        }

        public String resolverInterface() {
            return this.resolverInterface;
        }

        public Context resolverInterface(String string) {
            this.resolverInterface = string;
            return this;
        }

        public String resolverBootstrapNeighbor() {
            return this.resolverBootstrapNeighbor;
        }

        public Context resolverBootstrapNeighbor(String string) {
            this.resolverBootstrapNeighbor = string;
            return this;
        }

        public long reResolutionCheckIntervalNs() {
            return this.reResolutionCheckIntervalNs;
        }

        public Context reResolutionCheckIntervalNs(long l2) {
            this.reResolutionCheckIntervalNs = l2;
            return this;
        }

        public Context conductorCycleThresholdNs(long l2) {
            this.conductorCycleThresholdNs = l2;
            return this;
        }

        public long conductorCycleThresholdNs() {
            return this.conductorCycleThresholdNs;
        }

        public Context channelReceiveTimestampClock(EpochNanoClock epochNanoClock) {
            this.channelReceiveTimestampClock = epochNanoClock;
            return this;
        }

        public Context senderCycleThresholdNs(long l2) {
            this.senderCycleThresholdNs = l2;
            return this;
        }

        public long senderCycleThresholdNs() {
            return this.senderCycleThresholdNs;
        }

        public Context receiverCycleThresholdNs(long l2) {
            this.receiverCycleThresholdNs = l2;
            return this;
        }

        public long receiverCycleThresholdNs() {
            return this.receiverCycleThresholdNs;
        }

        public Context resourceFreeLimit(int n2) {
            this.resourceFreeLimit = n2;
            return this;
        }

        public int resourceFreeLimit() {
            return this.resourceFreeLimit;
        }

        public EpochNanoClock channelReceiveTimestampClock() {
            return this.channelReceiveTimestampClock;
        }

        public Context channelSendTimestampClock(EpochNanoClock epochNanoClock) {
            this.channelSendTimestampClock = epochNanoClock;
            return this;
        }

        public DutyCycleTracker conductorDutyCycleTracker() {
            return this.conductorDutyCycleTracker;
        }

        public Context conductorDutyCycleTracker(DutyCycleTracker dutyCycleTracker) {
            this.conductorDutyCycleTracker = dutyCycleTracker;
            return this;
        }

        public DutyCycleTracker senderDutyCycleTracker() {
            return this.senderDutyCycleTracker;
        }

        public Context senderDutyCycleTracker(DutyCycleTracker dutyCycleTracker) {
            this.senderDutyCycleTracker = dutyCycleTracker;
            return this;
        }

        public DutyCycleTracker receiverDutyCycleTracker() {
            return this.receiverDutyCycleTracker;
        }

        public Context receiverDutyCycleTracker(DutyCycleTracker dutyCycleTracker) {
            this.receiverDutyCycleTracker = dutyCycleTracker;
            return this;
        }

        public EpochNanoClock channelSendTimestampClock() {
            return this.channelSendTimestampClock;
        }

        OneToOneConcurrentArrayQueue<Runnable> receiverCommandQueue() {
            return this.receiverCommandQueue;
        }

        Context receiverCommandQueue(OneToOneConcurrentArrayQueue<Runnable> oneToOneConcurrentArrayQueue) {
            this.receiverCommandQueue = oneToOneConcurrentArrayQueue;
            return this;
        }

        OneToOneConcurrentArrayQueue<Runnable> senderCommandQueue() {
            return this.senderCommandQueue;
        }

        Context senderCommandQueue(OneToOneConcurrentArrayQueue<Runnable> oneToOneConcurrentArrayQueue) {
            this.senderCommandQueue = oneToOneConcurrentArrayQueue;
            return this;
        }

        ManyToOneConcurrentArrayQueue<Runnable> driverCommandQueue() {
            return this.driverCommandQueue;
        }

        Context driverCommandQueue(ManyToOneConcurrentArrayQueue<Runnable> manyToOneConcurrentArrayQueue) {
            this.driverCommandQueue = manyToOneConcurrentArrayQueue;
            return this;
        }

        ClientProxy clientProxy() {
            return this.clientProxy;
        }

        Context clientProxy(ClientProxy clientProxy) {
            this.clientProxy = clientProxy;
            return this;
        }

        RingBuffer toDriverCommands() {
            return this.toDriverCommands;
        }

        Context toDriverCommands(RingBuffer ringBuffer) {
            this.toDriverCommands = ringBuffer;
            return this;
        }

        LogFactory logFactory() {
            return this.logFactory;
        }

        Context logFactory(LogFactory logFactory) {
            this.logFactory = logFactory;
            return this;
        }

        DataTransportPoller dataTransportPoller() {
            return this.dataTransportPoller;
        }

        Context dataTransportPoller(DataTransportPoller dataTransportPoller) {
            this.dataTransportPoller = dataTransportPoller;
            return this;
        }

        ControlTransportPoller controlTransportPoller() {
            return this.controlTransportPoller;
        }

        Context controlTransportPoller(ControlTransportPoller controlTransportPoller) {
            this.controlTransportPoller = controlTransportPoller;
            return this;
        }

        ReceiverProxy receiverProxy() {
            return this.receiverProxy;
        }

        Context receiverProxy(ReceiverProxy receiverProxy) {
            this.receiverProxy = receiverProxy;
            return this;
        }

        SenderProxy senderProxy() {
            return this.senderProxy;
        }

        Context senderProxy(SenderProxy senderProxy) {
            this.senderProxy = senderProxy;
            return this;
        }

        DriverConductorProxy driverConductorProxy() {
            return this.driverConductorProxy;
        }

        Context driverConductorProxy(DriverConductorProxy driverConductorProxy) {
            this.driverConductorProxy = driverConductorProxy;
            return this;
        }

        int osDefaultSocketRcvbufLength() {
            this.resolveOsSocketBufLengths();
            return this.osDefaultSocketRcvbufLength;
        }

        int osMaxSocketRcvbufLength() {
            this.resolveOsSocketBufLengths();
            return this.osMaxSocketRcvbufLength;
        }

        int osDefaultSocketSndbufLength() {
            this.resolveOsSocketBufLengths();
            return this.osDefaultSocketSndbufLength;
        }

        int osMaxSocketSndbufLength() {
            this.resolveOsSocketBufLengths();
            return this.osMaxSocketSndbufLength;
        }

        void resolveOsSocketBufLengths() {
            if (-1 != this.osMaxSocketRcvbufLength) {
                return;
            }
            try (DatagramChannel datagramChannel = DatagramChannel.open();){
                this.osDefaultSocketSndbufLength = datagramChannel.getOption(StandardSocketOptions.SO_SNDBUF);
                datagramChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)Integer.MAX_VALUE);
                this.osMaxSocketSndbufLength = datagramChannel.getOption(StandardSocketOptions.SO_SNDBUF);
                this.osDefaultSocketRcvbufLength = datagramChannel.getOption(StandardSocketOptions.SO_RCVBUF);
                datagramChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)Integer.MAX_VALUE);
                this.osMaxSocketRcvbufLength = datagramChannel.getOption(StandardSocketOptions.SO_RCVBUF);
            }
            catch (IOException iOException) {
                throw new AeronException("probe socket: " + iOException, iOException);
            }
        }

        void concludeNullProperties() {
            if (null == this.tempBuffer) {
                this.tempBuffer = new UnsafeBuffer(new byte[512]);
            }
            if (null == this.epochClock) {
                this.epochClock = SystemEpochClock.INSTANCE;
            }
            if (null == this.nanoClock) {
                this.nanoClock = SystemNanoClock.INSTANCE;
            }
            if (null == this.cachedEpochClock) {
                this.cachedEpochClock = new CachedEpochClock();
            }
            if (null == this.cachedNanoClock) {
                this.cachedNanoClock = new CachedNanoClock();
            }
            if (null == this.senderCachedNanoClock) {
                this.senderCachedNanoClock = new CachedNanoClock();
            }
            if (null == this.receiverCachedNanoClock) {
                this.receiverCachedNanoClock = new CachedNanoClock();
            }
            if (null == this.unicastFlowControlSupplier) {
                this.unicastFlowControlSupplier = Configuration.unicastFlowControlSupplier();
            }
            if (null == this.multicastFlowControlSupplier) {
                this.multicastFlowControlSupplier = Configuration.multicastFlowControlSupplier();
            }
            if (null == this.sendChannelEndpointSupplier) {
                this.sendChannelEndpointSupplier = Configuration.sendChannelEndpointSupplier();
            }
            if (null == this.receiveChannelEndpointSupplier) {
                this.receiveChannelEndpointSupplier = Configuration.receiveChannelEndpointSupplier();
            }
            if (null == this.dataTransportPoller) {
                this.dataTransportPoller = new DataTransportPoller(this.errorHandler);
            }
            if (null == this.controlTransportPoller) {
                this.controlTransportPoller = new ControlTransportPoller(this.errorHandler);
            }
            if (null == this.applicationSpecificFeedback) {
                this.applicationSpecificFeedback = Configuration.applicationSpecificFeedback();
            }
            if (null == this.receiverGroupTag && this.applicationSpecificFeedback.length > 0) {
                if (this.applicationSpecificFeedback.length != 8) {
                    throw new IllegalArgumentException("applicationSpecificFeedback length must be equal to 8 bytes: length=" + this.applicationSpecificFeedback.length);
                }
                UnsafeBuffer unsafeBuffer = new UnsafeBuffer(this.applicationSpecificFeedback);
                this.receiverGroupTag = unsafeBuffer.getLong(0, ByteOrder.LITTLE_ENDIAN);
            }
            if (null == this.receiveChannelEndpointThreadLocals) {
                this.receiveChannelEndpointThreadLocals = new ReceiveChannelEndpointThreadLocals();
            }
            if (null == this.congestionControlSupplier) {
                this.congestionControlSupplier = Configuration.congestionControlSupplier();
            }
            if (null == this.driverCommandQueue) {
                this.driverCommandQueue = new ManyToOneConcurrentArrayQueue(128);
            }
            if (null == this.receiverCommandQueue) {
                this.receiverCommandQueue = new OneToOneConcurrentArrayQueue(128);
            }
            if (null == this.senderCommandQueue) {
                this.senderCommandQueue = new OneToOneConcurrentArrayQueue(128);
            }
            if (null == this.retransmitUnicastDelayGenerator) {
                this.retransmitUnicastDelayGenerator = new StaticDelayGenerator(this.retransmitUnicastDelayNs, false);
            }
            if (null == this.retransmitUnicastLingerGenerator) {
                this.retransmitUnicastLingerGenerator = new StaticDelayGenerator(this.retransmitUnicastLingerNs, false);
            }
            if (null == this.unicastFeedbackDelayGenerator) {
                this.unicastFeedbackDelayGenerator = new StaticDelayGenerator(this.nakUnicastDelayNs, true);
            }
            if (null == this.multicastFeedbackDelayGenerator) {
                this.multicastFeedbackDelayGenerator = new OptimalMulticastDelayGenerator(this.nakMulticastMaxBackoffNs, this.nakMulticastGroupSize);
            }
            if (null == this.threadingMode) {
                this.threadingMode = Configuration.threadingMode();
            }
            if (null == this.terminationValidator) {
                this.terminationValidator = Configuration.terminationValidator();
            }
            if (null == this.nameResolver) {
                this.nameResolver = DefaultNameResolver.INSTANCE;
            }
            if (null == this.channelReceiveTimestampClock) {
                this.channelReceiveTimestampClock = new SystemEpochNanoClock();
            }
            if (null == this.channelSendTimestampClock) {
                this.channelSendTimestampClock = new SystemEpochNanoClock();
            }
        }

        private void concludeDependantProperties() {
            this.clientProxy = new ClientProxy(new BroadcastTransmitter(CncFileDescriptor.createToClientsBuffer(this.cncByteBuffer, this.cncMetaDataBuffer)));
            this.toDriverCommands = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
            if (null == this.errorLog) {
                this.errorLog = new DistinctErrorLog(CncFileDescriptor.createErrorLogBuffer(this.cncByteBuffer, this.cncMetaDataBuffer), this.epochClock, StandardCharsets.US_ASCII);
            }
            this.errorHandler = CommonContext.setupErrorHandler(this.errorHandler, this.errorLog);
            this.receiverProxy = new ReceiverProxy(this.threadingMode, this.receiverCommandQueue, this.systemCounters.get(SystemCounterDescriptor.RECEIVER_PROXY_FAILS));
            this.senderProxy = new SenderProxy(this.threadingMode, this.senderCommandQueue, this.systemCounters.get(SystemCounterDescriptor.SENDER_PROXY_FAILS));
            this.driverConductorProxy = new DriverConductorProxy(this.threadingMode, this.driverCommandQueue, this.systemCounters.get(SystemCounterDescriptor.CONDUCTOR_PROXY_FAILS));
            if (null == this.logFactory) {
                this.logFactory = new FileStoreLogFactory(this.aeronDirectoryName(), this.filePageSize, this.performStorageChecks, this.lowStorageWarningThreshold, this.errorHandler);
            }
            if (null == this.lossReport) {
                long l2 = BitUtil.align(this.lossReportBufferLength, this.filePageSize);
                Configuration.validateValueRange(l2, 0x100000L, Integer.MAX_VALUE, "lossReportBufferLength");
                this.lossReportBuffer = LossReportUtil.mapLossReport(this.aeronDirectoryName(), (int)l2);
                this.lossReport = new LossReport(new UnsafeBuffer(this.lossReportBuffer));
            }
            if (null == this.conductorDutyCycleTracker) {
                this.conductorDutyCycleTracker = new DutyCycleStallTracker(this.systemCounters.get(SystemCounterDescriptor.CONDUCTOR_MAX_CYCLE_TIME), this.systemCounters.get(SystemCounterDescriptor.CONDUCTOR_CYCLE_TIME_THRESHOLD_EXCEEDED), this.conductorCycleThresholdNs);
            }
            if (null == this.senderDutyCycleTracker) {
                this.senderDutyCycleTracker = new DutyCycleStallTracker(this.systemCounters.get(SystemCounterDescriptor.SENDER_MAX_CYCLE_TIME), this.systemCounters.get(SystemCounterDescriptor.SENDER_CYCLE_TIME_THRESHOLD_EXCEEDED), this.senderCycleThresholdNs);
            }
            if (null == this.receiverDutyCycleTracker) {
                this.receiverDutyCycleTracker = new DutyCycleStallTracker(this.systemCounters.get(SystemCounterDescriptor.RECEIVER_MAX_CYCLE_TIME), this.systemCounters.get(SystemCounterDescriptor.RECEIVER_CYCLE_TIME_THRESHOLD_EXCEEDED), this.receiverCycleThresholdNs);
            }
        }

        private void concludeCounters() {
            if (null == this.countersManager) {
                if (this.countersMetaDataBuffer() == null) {
                    this.countersMetaDataBuffer(CncFileDescriptor.createCountersMetaDataBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
                }
                if (this.countersValuesBuffer() == null) {
                    this.countersValuesBuffer(CncFileDescriptor.createCountersValuesBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
                }
                long l2 = this.counterFreeToReuseTimeoutNs > 0L ? Math.max(TimeUnit.NANOSECONDS.toMillis(this.counterFreeToReuseTimeoutNs), 1L) : 0L;
                CountersManager countersManager = this.countersManager = this.useConcurrentCountersManager ? new ConcurrentCountersManager(this.countersMetaDataBuffer(), this.countersValuesBuffer(), StandardCharsets.US_ASCII, this.cachedEpochClock, l2) : new CountersManager(this.countersMetaDataBuffer(), this.countersValuesBuffer(), StandardCharsets.US_ASCII, this.cachedEpochClock, l2);
            }
            if (null == this.systemCounters) {
                this.systemCounters = new SystemCounters(this.countersManager);
            }
        }

        private void concludeIdleStrategies() {
            UnsafeBufferStatusIndicator unsafeBufferStatusIndicator = new UnsafeBufferStatusIndicator(this.countersManager.valuesBuffer(), SystemCounterDescriptor.CONTROLLABLE_IDLE_STRATEGY.id());
            switch (this.threadingMode) {
                case INVOKER: {
                    break;
                }
                case SHARED: {
                    if (null == this.sharedThreadFactory) {
                        this.sharedThreadFactory = Thread::new;
                    }
                    if (null != this.sharedIdleStrategy) break;
                    this.sharedIdleStrategy = Configuration.sharedIdleStrategy(unsafeBufferStatusIndicator);
                    break;
                }
                case SHARED_NETWORK: {
                    if (null == this.conductorThreadFactory) {
                        this.conductorThreadFactory = Thread::new;
                    }
                    if (null == this.conductorIdleStrategy) {
                        this.conductorIdleStrategy = Configuration.conductorIdleStrategy(unsafeBufferStatusIndicator);
                    }
                    if (null == this.sharedNetworkThreadFactory) {
                        this.sharedNetworkThreadFactory = Thread::new;
                    }
                    if (null != this.sharedNetworkIdleStrategy) break;
                    this.sharedNetworkIdleStrategy = Configuration.sharedNetworkIdleStrategy(unsafeBufferStatusIndicator);
                    break;
                }
                case DEDICATED: {
                    if (null == this.conductorThreadFactory) {
                        this.conductorThreadFactory = Thread::new;
                    }
                    if (null == this.senderThreadFactory) {
                        this.senderThreadFactory = Thread::new;
                    }
                    if (null == this.receiverThreadFactory) {
                        this.receiverThreadFactory = Thread::new;
                    }
                    if (null == this.conductorIdleStrategy) {
                        this.conductorIdleStrategy = Configuration.conductorIdleStrategy(unsafeBufferStatusIndicator);
                    }
                    if (null == this.senderIdleStrategy) {
                        this.senderIdleStrategy = Configuration.senderIdleStrategy(unsafeBufferStatusIndicator);
                    }
                    if (null != this.receiverIdleStrategy) break;
                    this.receiverIdleStrategy = Configuration.receiverIdleStrategy(unsafeBufferStatusIndicator);
                }
            }
        }

        public String toString() {
            return "MediaDriver.Context\n{\n    isConcluded=" + this.isConcluded() + "\n    isClosed=" + (1 == this.isClosed) + "\n    cncVersion=" + SemanticVersion.toString(CncFileDescriptor.CNC_VERSION) + "\n    aeronDirectory=" + this.aeronDirectory() + "\n    aeronDirectoryName='" + this.aeronDirectoryName() + '\'' + "\n    cncFile=" + this.cncFile() + "\n    countersMetaDataBuffer=" + this.countersMetaDataBuffer() + "\n    countersValuesBuffer=" + this.countersValuesBuffer() + "\n    driverTimeoutMs=" + this.driverTimeoutMs() + "\n    printConfigurationOnStart=" + this.printConfigurationOnStart + "\n    useWindowsHighResTimer=" + this.useWindowsHighResTimer + "\n    warnIfDirectoryExists=" + this.warnIfDirectoryExists + "\n    dirDeleteOnStart=" + this.dirDeleteOnStart + "\n    dirDeleteOnShutdown=" + this.dirDeleteOnShutdown + "\n    termBufferSparseFile=" + this.termBufferSparseFile + "\n    performStorageChecks=" + this.performStorageChecks + "\n    spiesSimulateConnection=" + this.spiesSimulateConnection + "\n    reliableStream=" + this.reliableStream + "\n    tetherSubscriptions=" + this.tetherSubscriptions + "\n    rejoinStream=" + this.rejoinStream + "\n    receiverGroupConsideration=" + (Object)((Object)this.receiverGroupConsideration) + "\n    conductorBufferLength=" + this.conductorBufferLength + "\n    toClientsBufferLength=" + this.toClientsBufferLength + "\n    counterValuesBufferLength=" + this.counterValuesBufferLength + "\n    errorBufferLength=" + this.errorBufferLength + "\n    lowStorageWarningThreshold=" + this.lowStorageWarningThreshold + "\n    timerIntervalNs=" + this.timerIntervalNs + "\n    clientLivenessTimeoutNs=" + this.clientLivenessTimeoutNs + "\n    imageLivenessTimeoutNs=" + this.imageLivenessTimeoutNs + "\n    publicationUnblockTimeoutNs=" + this.publicationUnblockTimeoutNs + "\n    publicationConnectionTimeoutNs=" + this.publicationConnectionTimeoutNs + "\n    publicationLingerTimeoutNs=" + this.publicationLingerTimeoutNs + "\n    untetheredWindowLimitTimeoutNs=" + this.untetheredWindowLimitTimeoutNs + "\n    untetheredRestingTimeoutNs=" + this.untetheredRestingTimeoutNs + "\n    retransmitUnicastDelayNs=" + this.retransmitUnicastDelayNs + "\n    retransmitUnicastLingerNs=" + this.retransmitUnicastLingerNs + "\n    nakUnicastDelayNs=" + this.nakUnicastDelayNs + "\n    nakMulticastMaxBackoffNs=" + this.nakMulticastMaxBackoffNs + "\n    nakMulticastGroupSize=" + this.nakMulticastGroupSize + "\n    statusMessageTimeoutNs=" + this.statusMessageTimeoutNs + "\n    counterFreeToReuseTimeoutNs=" + this.counterFreeToReuseTimeoutNs + "\n    conductorCycleThresholdNs=" + this.conductorCycleThresholdNs + "\n    senderCycleThresholdNs=" + this.senderCycleThresholdNs + "\n    receiverCycleThresholdNs=" + this.receiverCycleThresholdNs + "\n    publicationTermBufferLength=" + this.publicationTermBufferLength + "\n    ipcTermBufferLength=" + this.ipcTermBufferLength + "\n    publicationTermWindowLength=" + this.publicationTermWindowLength + "\n    ipcPublicationTermWindowLength=" + this.ipcPublicationTermWindowLength + "\n    initialWindowLength=" + this.initialWindowLength + "\n    socketSndbufLength=" + this.socketSndbufLength + "\n    socketRcvbufLength=" + this.socketRcvbufLength + "\n    socketMulticastTtl=" + this.socketMulticastTtl + "\n    mtuLength=" + this.mtuLength + "\n    ipcMtuLength=" + this.ipcMtuLength + "\n    filePageSize=" + this.filePageSize + "\n    publicationReservedSessionIdLow=" + this.publicationReservedSessionIdLow + "\n    publicationReservedSessionIdHigh=" + this.publicationReservedSessionIdHigh + "\n    lossReportBufferLength=" + this.lossReportBufferLength + "\n    epochClock=" + this.epochClock + "\n    nanoClock=" + this.nanoClock + "\n    cachedEpochClock=" + this.cachedEpochClock + "\n    cachedNanoClock=" + this.cachedNanoClock + "\n    threadingMode=" + (Object)((Object)this.threadingMode) + "\n    conductorThreadFactory=" + this.conductorThreadFactory + "\n    senderThreadFactory=" + this.senderThreadFactory + "\n    receiverThreadFactory=" + this.receiverThreadFactory + "\n    sharedThreadFactory=" + this.sharedThreadFactory + "\n    sharedNetworkThreadFactory=" + this.sharedNetworkThreadFactory + "\n    conductorIdleStrategy=" + this.conductorIdleStrategy + "\n    senderIdleStrategy=" + this.senderIdleStrategy + "\n    receiverIdleStrategy=" + this.receiverIdleStrategy + "\n    sharedNetworkIdleStrategy=" + this.sharedNetworkIdleStrategy + "\n    sharedIdleStrategy=" + this.sharedIdleStrategy + "\n    sendChannelEndpointSupplier=" + this.sendChannelEndpointSupplier + "\n    receiveChannelEndpointSupplier=" + this.receiveChannelEndpointSupplier + "\n    receiveChannelEndpointThreadLocals=" + this.receiveChannelEndpointThreadLocals + "\n    tempBuffer=" + this.tempBuffer + "\n    unicastFlowControlSupplier=" + this.unicastFlowControlSupplier + "\n    multicastFlowControlSupplier=" + this.multicastFlowControlSupplier + "\n    applicationSpecificFeedback=" + Arrays.toString(this.applicationSpecificFeedback) + "\n    receiverGroupTag=" + this.receiverGroupTag + "\n    flowControlGroupTag=" + this.flowControlGroupTag + "\n    flowControlGroupMinSize=" + this.flowControlGroupMinSize + "\n    flowControlReceiverTimeoutNs=" + this.flowControlReceiverTimeoutNs + "\n    reResolutionCheckIntervalNs=" + this.reResolutionCheckIntervalNs + "\n    receiverGroupConsideration=" + (Object)((Object)this.receiverGroupConsideration) + "\n    congestionControlSupplier=" + this.congestionControlSupplier + "\n    terminationValidator=" + this.terminationValidator + "\n    terminationHook=" + this.terminationHook + "\n    nameResolver=" + this.nameResolver + "\n    resolverName='" + this.resolverName + '\'' + "\n    resolverInterface='" + this.resolverInterface + '\'' + "\n    resolverBootstrapNeighbor='" + this.resolverBootstrapNeighbor + '\'' + "\n    sendToStatusMessagePollRatio=" + this.sendToStatusMessagePollRatio + "\n    unicastFeedbackDelayGenerator=" + this.unicastFeedbackDelayGenerator + "\n    multicastFeedbackDelayGenerator=" + this.multicastFeedbackDelayGenerator + "\n    retransmitUnicastDelayGenerator=" + this.retransmitUnicastDelayGenerator + "\n    retransmitUnicastLingerGenerator=" + this.retransmitUnicastLingerGenerator + "\n    errorLog=" + this.errorLog + "\n    errorHandler=" + this.errorHandler + "\n    useConcurrentCountersManager=" + this.useConcurrentCountersManager + "\n    countersManager=" + this.countersManager + "\n    systemCounters=" + this.systemCounters + "\n    lossReport=" + this.lossReport + "\n    logFactory=" + this.logFactory + "\n    dataTransportPoller=" + this.dataTransportPoller + "\n    controlTransportPoller=" + this.controlTransportPoller + "\n    driverCommandQueue=" + this.driverCommandQueue + "\n    receiverCommandQueue=" + this.receiverCommandQueue + "\n    senderCommandQueue=" + this.senderCommandQueue + "\n    receiverProxy=" + this.receiverProxy + "\n    senderProxy=" + this.senderProxy + "\n    driverConductorProxy=" + this.driverConductorProxy + "\n    clientProxy=" + this.clientProxy + "\n    toDriverCommands=" + this.toDriverCommands + "\n    lossReportBuffer=" + this.lossReportBuffer + "\n    cncByteBuffer=" + this.cncByteBuffer + "\n    cncMetaDataBuffer=" + this.cncMetaDataBuffer + "\n    channelSendTimestampClock=" + this.channelSendTimestampClock + "\n    channelReceiveTimestampClock=" + this.channelReceiveTimestampClock + "\n    conductorDutyCycleTracker=" + this.conductorDutyCycleTracker + "\n    senderDutyCycleTracker=" + this.senderDutyCycleTracker + "\n    receiverDutyCycleTracker=" + this.receiverDutyCycleTracker + "\n    resourceFreeLimit=" + this.resourceFreeLimit + "\n}";
        }
    }
}

