/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.ErrorCode;
import io.aeron.driver.AeronClient;
import io.aeron.driver.ClientCommandAdapter;
import io.aeron.driver.ClientProxy;
import io.aeron.driver.Configuration;
import io.aeron.driver.CongestionControl;
import io.aeron.driver.CounterLink;
import io.aeron.driver.DataPacketDispatcher;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.DriverNameResolver;
import io.aeron.driver.DutyCycleTracker;
import io.aeron.driver.FlowControl;
import io.aeron.driver.IpcPublication;
import io.aeron.driver.IpcSubscriptionLink;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NameResolver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.NetworkPublicationThreadLocals;
import io.aeron.driver.NetworkSubscriptionLink;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.PublicationLink;
import io.aeron.driver.PublicationParams;
import io.aeron.driver.ReceiverProxy;
import io.aeron.driver.RetransmitHandler;
import io.aeron.driver.SenderProxy;
import io.aeron.driver.SessionKey;
import io.aeron.driver.SpySubscriptionLink;
import io.aeron.driver.SubscriberPosition;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.SubscriptionParams;
import io.aeron.driver.buffer.LogFactory;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.exceptions.InvalidChannelException;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.status.ClientHeartbeatTimestamp;
import io.aeron.driver.status.PublisherLimit;
import io.aeron.driver.status.PublisherPos;
import io.aeron.driver.status.ReceiveChannelStatus;
import io.aeron.driver.status.ReceiveLocalSocketAddress;
import io.aeron.driver.status.ReceiverHwm;
import io.aeron.driver.status.ReceiverPos;
import io.aeron.driver.status.SendChannelStatus;
import io.aeron.driver.status.SendLocalSocketAddress;
import io.aeron.driver.status.SenderBpe;
import io.aeron.driver.status.SenderLimit;
import io.aeron.driver.status.SenderPos;
import io.aeron.driver.status.SubscriberPos;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.exceptions.AeronEvent;
import io.aeron.exceptions.ControlProtocolException;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.Object2ObjectHashMap;
import org.agrona.collections.ObjectHashSet;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.CachedEpochClock;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;
import org.agrona.concurrent.status.UnsafeBufferPosition;

public final class DriverConductor
implements Agent {
    private static final long CLOCK_UPDATE_INTERNAL_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final String[] INVALID_DESTINATION_KEYS = new String[]{"mtu", "rcv-wnd", "so-rcvbuf", "so-sndbuf"};
    private int nextSessionId = BitUtil.generateRandomisedId();
    private final long timerIntervalNs;
    private final long clientLivenessTimeoutNs;
    private long timeOfLastToDriverPositionChangeNs;
    private long lastCommandConsumerPosition;
    private long timerCheckDeadlineNs;
    private long clockUpdateDeadlineNs;
    private final MediaDriver.Context ctx;
    private final LogFactory logFactory;
    private final ReceiverProxy receiverProxy;
    private final SenderProxy senderProxy;
    private final ClientProxy clientProxy;
    private final RingBuffer toDriverCommands;
    private final ClientCommandAdapter clientCommandAdapter;
    private final ManyToOneConcurrentArrayQueue<Runnable> driverCmdQueue;
    private final Object2ObjectHashMap<String, SendChannelEndpoint> sendChannelEndpointByChannelMap = new Object2ObjectHashMap();
    private final Object2ObjectHashMap<String, ReceiveChannelEndpoint> receiveChannelEndpointByChannelMap = new Object2ObjectHashMap();
    private final ArrayList<NetworkPublication> networkPublications = new ArrayList();
    private final ArrayList<IpcPublication> ipcPublications = new ArrayList();
    private final ArrayList<PublicationImage> publicationImages = new ArrayList();
    private final ArrayList<PublicationLink> publicationLinks = new ArrayList();
    private final ArrayList<SubscriptionLink> subscriptionLinks = new ArrayList();
    private final ArrayList<CounterLink> counterLinks = new ArrayList();
    private final ArrayList<AeronClient> clients = new ArrayList();
    private final ArrayDeque<DriverManagedResource> endOfLiveResources = new ArrayDeque();
    private final ObjectHashSet<SessionKey> activeSessionSet = new ObjectHashSet();
    private final EpochClock epochClock;
    private final NanoClock nanoClock;
    private final CachedEpochClock cachedEpochClock;
    private final CachedNanoClock cachedNanoClock;
    private final CountersManager countersManager;
    private final NetworkPublicationThreadLocals networkPublicationThreadLocals = new NetworkPublicationThreadLocals();
    private final MutableDirectBuffer tempBuffer;
    private final DataHeaderFlyweight defaultDataHeader = new DataHeaderFlyweight(DataHeaderFlyweight.createDefaultHeader(0, 0, 0));
    private NameResolver nameResolver;
    private DriverNameResolver driverNameResolver;
    private final AtomicCounter errorCounter;
    private final DutyCycleTracker dutyCycleTracker;

    DriverConductor(MediaDriver.Context context) {
        this.ctx = context;
        this.timerIntervalNs = context.timerIntervalNs();
        this.clientLivenessTimeoutNs = context.clientLivenessTimeoutNs();
        this.driverCmdQueue = context.driverCommandQueue();
        this.receiverProxy = context.receiverProxy();
        this.senderProxy = context.senderProxy();
        this.logFactory = context.logFactory();
        this.epochClock = context.epochClock();
        this.nanoClock = context.nanoClock();
        this.cachedEpochClock = context.cachedEpochClock();
        this.cachedNanoClock = context.cachedNanoClock();
        this.toDriverCommands = context.toDriverCommands();
        this.clientProxy = context.clientProxy();
        this.tempBuffer = context.tempBuffer();
        this.errorCounter = context.systemCounters().get(SystemCounterDescriptor.ERRORS);
        this.dutyCycleTracker = context.conductorDutyCycleTracker();
        this.countersManager = context.countersManager();
        this.clientCommandAdapter = new ClientCommandAdapter(this.errorCounter, context.errorHandler(), this.toDriverCommands, this.clientProxy, this);
        this.lastCommandConsumerPosition = this.toDriverCommands.consumerPosition();
    }

    @Override
    public void onStart() {
        if (null == this.ctx.resolverInterface()) {
            this.driverNameResolver = null;
            this.nameResolver = this.ctx.nameResolver();
        } else {
            this.driverNameResolver = new DriverNameResolver(this.ctx);
            this.nameResolver = this.driverNameResolver;
        }
        this.ctx.systemCounters().get(SystemCounterDescriptor.RESOLUTION_CHANGES).appendToLabel(": driverName=" + this.ctx.resolverName() + " hostname=" + DriverNameResolver.getCanonicalName("<unresolved>"));
        this.ctx.systemCounters().get(SystemCounterDescriptor.CONDUCTOR_MAX_CYCLE_TIME).appendToLabel(": " + this.ctx.threadingMode().name());
        this.ctx.systemCounters().get(SystemCounterDescriptor.CONDUCTOR_CYCLE_TIME_THRESHOLD_EXCEEDED).appendToLabel(": threshold=" + this.ctx.conductorCycleThresholdNs() + "ns " + this.ctx.threadingMode().name());
        this.nameResolver.init(this.ctx);
        long l2 = this.nanoClock.nanoTime();
        this.cachedNanoClock.update(l2);
        this.cachedEpochClock.update(this.epochClock.time());
        this.dutyCycleTracker.update(l2);
        this.timerCheckDeadlineNs = l2 + this.timerIntervalNs;
        this.clockUpdateDeadlineNs = l2 + CLOCK_UPDATE_INTERNAL_NS;
        this.timeOfLastToDriverPositionChangeNs = l2;
    }

    @Override
    public void onClose() {
        CloseHelper.close(this.ctx.errorHandler(), this.driverNameResolver);
        this.publicationImages.forEach(PublicationImage::free);
        this.networkPublications.forEach(NetworkPublication::free);
        this.ipcPublications.forEach(IpcPublication::free);
        this.freeEndOfLifeResources(Integer.MAX_VALUE);
        this.toDriverCommands.consumerHeartbeatTime(-1L);
        this.ctx.close();
    }

    @Override
    public String roleName() {
        return "driver-conductor";
    }

    @Override
    public int doWork() {
        long l2 = this.nanoClock.nanoTime();
        this.trackTime(l2);
        int n2 = 0;
        n2 += this.processTimers(l2);
        n2 += this.driverCmdQueue.drain(Runnable::run, 2);
        n2 += this.clientCommandAdapter.receive();
        n2 += this.trackStreamPositions(n2, l2);
        n2 += this.nameResolver.doWork(this.cachedEpochClock.time());
        return n2 += this.freeEndOfLifeResources(this.ctx.resourceFreeLimit());
    }

    boolean notAcceptingClientCommands() {
        return this.senderProxy.isApplyingBackpressure() || this.receiverProxy.isApplyingBackpressure();
    }

    void onCreatePublicationImage(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, ReceiveChannelEndpoint receiveChannelEndpoint) {
        Configuration.validateMtuLength(n8);
        UdpChannel udpChannel = receiveChannelEndpoint.subscriptionUdpChannel();
        Configuration.validateInitialWindowLength(udpChannel.receiverWindowLengthOrDefault(this.ctx.initialWindowLength()), n8);
        long l2 = LogBufferDescriptor.computePosition(n5, n6, LogBufferDescriptor.positionBitsToShift(n7), n4);
        ArrayList<SubscriberPosition> arrayList = this.createSubscriberPositions(n2, n3, receiveChannelEndpoint, l2);
        if (arrayList.size() > 0) {
            RawLog rawLog = null;
            CongestionControl congestionControl = null;
            UnsafeBufferPosition unsafeBufferPosition = null;
            UnsafeBufferPosition unsafeBufferPosition2 = null;
            try {
                long l3 = this.toDriverCommands.nextCorrelationId();
                rawLog = this.newPublicationImageLog(n2, n3, n4, n7, DriverConductor.isOldestSubscriptionSparse(arrayList), n8, l3);
                congestionControl = this.ctx.congestionControlSupplier().newInstance(l3, udpChannel, n3, n2, n7, n8, inetSocketAddress, inetSocketAddress2, this.ctx.receiverCachedNanoClock(), this.ctx, this.countersManager);
                SubscriptionLink subscriptionLink = arrayList.get(0).subscription();
                String string = subscriptionLink.channel();
                unsafeBufferPosition = ReceiverHwm.allocate(this.tempBuffer, this.countersManager, l3, n2, n3, string);
                unsafeBufferPosition2 = ReceiverPos.allocate(this.tempBuffer, this.countersManager, l3, n2, n3, string);
                boolean bl2 = subscriptionLink.group() == CommonContext.InferableBoolean.INFER ? receiveChannelEndpoint.udpChannel(n9).isMulticast() : subscriptionLink.group() == CommonContext.InferableBoolean.FORCE_TRUE;
                String string2 = Configuration.sourceIdentity(inetSocketAddress2);
                PublicationImage publicationImage = new PublicationImage(l3, this.ctx, receiveChannelEndpoint, n9, inetSocketAddress, n2, n3, n4, n5, n6, rawLog, bl2 ? this.ctx.multicastFeedbackDelayGenerator() : this.ctx.unicastFeedbackDelayGenerator(), arrayList, unsafeBufferPosition, unsafeBufferPosition2, inetSocketAddress2, string2, congestionControl);
                receiveChannelEndpoint.incRefImages();
                this.publicationImages.add(publicationImage);
                this.receiverProxy.newPublicationImage(receiveChannelEndpoint, publicationImage);
                int n10 = arrayList.size();
                for (int i2 = 0; i2 < n10; ++i2) {
                    SubscriberPosition subscriberPosition2 = arrayList.get(i2);
                    subscriberPosition2.addLink(publicationImage);
                    this.clientProxy.onAvailableImage(l3, n3, n2, subscriberPosition2.subscription().registrationId(), subscriberPosition2.positionCounterId(), rawLog.fileName(), string2);
                }
            }
            catch (Exception exception) {
                arrayList.forEach(subscriberPosition -> subscriberPosition.position().close());
                CloseHelper.quietCloseAll(rawLog, congestionControl, unsafeBufferPosition, unsafeBufferPosition2);
                throw exception;
            }
        }
    }

    void onChannelEndpointError(long l2, Exception exception) {
        String string = exception.getClass().getName() + " : " + exception.getMessage();
        this.clientProxy.onError(l2, ErrorCode.CHANNEL_ENDPOINT_ERROR, string);
    }

    void onReResolveEndpoint(String string, SendChannelEndpoint sendChannelEndpoint, InetSocketAddress inetSocketAddress) {
        try {
            InetSocketAddress inetSocketAddress2 = UdpChannel.resolve(string, "endpoint", true, this.nameResolver);
            if (inetSocketAddress2.isUnresolved()) {
                this.ctx.errorHandler().onError(new AeronEvent("could not re-resolve: endpoint=" + string));
                this.errorCounter.increment();
            } else if (!inetSocketAddress.equals(inetSocketAddress2)) {
                this.senderProxy.onResolutionChange(sendChannelEndpoint, string, inetSocketAddress2);
            }
        }
        catch (Exception exception) {
            this.ctx.errorHandler().onError(exception);
            this.errorCounter.increment();
        }
    }

    void onReResolveControl(String string, UdpChannel udpChannel, ReceiveChannelEndpoint receiveChannelEndpoint, InetSocketAddress inetSocketAddress) {
        try {
            InetSocketAddress inetSocketAddress2 = UdpChannel.resolve(string, "control", true, this.nameResolver);
            if (inetSocketAddress2.isUnresolved()) {
                this.ctx.errorHandler().onError(new AeronEvent("could not re-resolve: control=" + string));
                this.errorCounter.increment();
            } else if (!inetSocketAddress.equals(inetSocketAddress2)) {
                this.receiverProxy.onResolutionChange(receiveChannelEndpoint, udpChannel, inetSocketAddress2);
            }
        }
        catch (Exception exception) {
            this.ctx.errorHandler().onError(exception);
            this.errorCounter.increment();
        }
    }

    IpcPublication getSharedIpcPublication(long l2) {
        return DriverConductor.findSharedIpcPublication(this.ipcPublications, l2);
    }

    IpcPublication getIpcPublication(long l2) {
        int n2 = this.ipcPublications.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IpcPublication ipcPublication = this.ipcPublications.get(i2);
            if (ipcPublication.registrationId() != l2) continue;
            return ipcPublication;
        }
        return null;
    }

    NetworkPublication findNetworkPublicationByTag(long l2) {
        int n2 = this.networkPublications.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            NetworkPublication networkPublication = this.networkPublications.get(i2);
            long l3 = networkPublication.tag();
            if (l3 != l2 || l3 == -1L) continue;
            return networkPublication;
        }
        return null;
    }

    IpcPublication findIpcPublicationByTag(long l2) {
        int n2 = this.ipcPublications.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IpcPublication ipcPublication = this.ipcPublications.get(i2);
            long l3 = ipcPublication.tag();
            if (l3 != l2 || l3 == -1L) continue;
            return ipcPublication;
        }
        return null;
    }

    void onAddNetworkPublication(String string, int n2, long l2, long l3, boolean bl2) {
        UdpChannel udpChannel = UdpChannel.parse(string, this.nameResolver);
        ChannelUri channelUri = udpChannel.channelUri();
        PublicationParams publicationParams = PublicationParams.getPublicationParams(channelUri, this.ctx, this, false);
        DriverConductor.validateEndpointForPublication(udpChannel);
        PublicationParams.validateMtuForMaxMessage(publicationParams, string);
        SendChannelEndpoint sendChannelEndpoint = this.getOrCreateSendChannelEndpoint(publicationParams, udpChannel, l2);
        NetworkPublication networkPublication = null;
        if (!bl2) {
            networkPublication = DriverConductor.findPublication(this.networkPublications, n2, sendChannelEndpoint);
        }
        boolean bl3 = false;
        if (null == networkPublication) {
            if (publicationParams.hasSessionId) {
                this.checkForSessionClash(publicationParams.sessionId, n2, udpChannel.canonicalForm(), string);
            }
            networkPublication = this.newNetworkPublication(l2, l3, n2, string, udpChannel, sendChannelEndpoint, publicationParams, bl2);
            bl3 = true;
        } else {
            PublicationParams.confirmMatch(channelUri, publicationParams, networkPublication.rawLog(), networkPublication.sessionId(), networkPublication.channel(), networkPublication.initialTermId(), networkPublication.startingTermId(), networkPublication.startingTermOffset());
            PublicationParams.validateSpiesSimulateConnection(publicationParams, networkPublication.spiesSimulateConnection(), string, networkPublication.channel());
        }
        this.publicationLinks.add(new PublicationLink(l2, this.getOrAddClient(l3), networkPublication));
        this.clientProxy.onPublicationReady(l2, networkPublication.registrationId(), n2, networkPublication.sessionId(), networkPublication.rawLog().fileName(), networkPublication.publisherLimitId(), sendChannelEndpoint.statusIndicatorCounterId(), bl2);
        if (bl3) {
            this.linkSpies(this.subscriptionLinks, networkPublication);
        }
    }

    void cleanupSpies(NetworkPublication networkPublication) {
        int n2 = this.subscriptionLinks.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SubscriptionLink subscriptionLink = this.subscriptionLinks.get(i2);
            if (!subscriptionLink.isLinked(networkPublication)) continue;
            this.notifyUnavailableImageLink(networkPublication.registrationId(), subscriptionLink);
            subscriptionLink.unlink(networkPublication);
        }
    }

    void notifyUnavailableImageLink(long l2, SubscriptionLink subscriptionLink) {
        this.clientProxy.onUnavailableImage(l2, subscriptionLink.registrationId(), subscriptionLink.streamId(), subscriptionLink.channel());
    }

    void notifyAvailableImageLink(long l2, int n2, SubscriptionLink subscriptionLink, int n3, long l3, String string, String string2) {
        this.countersManager.setCounterValue(n3, l3);
        int n4 = subscriptionLink.streamId();
        this.clientProxy.onAvailableImage(l2, n4, n2, subscriptionLink.registrationId(), n3, string, string2);
    }

    void cleanupPublication(NetworkPublication networkPublication) {
        this.senderProxy.removeNetworkPublication(networkPublication);
        SendChannelEndpoint sendChannelEndpoint = networkPublication.channelEndpoint();
        if (sendChannelEndpoint.shouldBeClosed()) {
            this.senderProxy.closeSendChannelEndpoint(sendChannelEndpoint);
            this.sendChannelEndpointByChannelMap.remove(sendChannelEndpoint.udpChannel().canonicalForm());
            sendChannelEndpoint.closeIndicators();
        }
        String string = sendChannelEndpoint.udpChannel().canonicalForm();
        this.activeSessionSet.remove(new SessionKey(networkPublication.sessionId(), networkPublication.streamId(), string));
    }

    void cleanupSubscriptionLink(SubscriptionLink subscriptionLink) {
        ReceiveChannelEndpoint receiveChannelEndpoint = subscriptionLink.channelEndpoint();
        if (null != receiveChannelEndpoint) {
            if (subscriptionLink.hasSessionId()) {
                if (0L == receiveChannelEndpoint.decRefToStreamAndSession(subscriptionLink.streamId(), subscriptionLink.sessionId())) {
                    this.receiverProxy.removeSubscription(receiveChannelEndpoint, subscriptionLink.streamId(), subscriptionLink.sessionId());
                }
            } else if (0 == receiveChannelEndpoint.decRefToStream(subscriptionLink.streamId())) {
                this.receiverProxy.removeSubscription(receiveChannelEndpoint, subscriptionLink.streamId());
            }
            this.tryCloseReceiveChannelEndpoint(receiveChannelEndpoint);
        }
    }

    void transitionToLinger(PublicationImage publicationImage) {
        boolean bl2 = true;
        int n2 = this.subscriptionLinks.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SubscriptionLink subscriptionLink = this.subscriptionLinks.get(i2);
            if (!subscriptionLink.isLinked(publicationImage)) continue;
            bl2 = subscriptionLink.isRejoin();
            this.notifyUnavailableImageLink(publicationImage.correlationId(), subscriptionLink);
        }
        if (bl2) {
            this.receiverProxy.removeCoolDown(publicationImage.channelEndpoint(), publicationImage.sessionId(), publicationImage.streamId());
        }
    }

    void transitionToLinger(IpcPublication ipcPublication) {
        this.activeSessionSet.remove(new SessionKey(ipcPublication.sessionId(), ipcPublication.streamId(), "ipc"));
        int n2 = this.subscriptionLinks.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SubscriptionLink subscriptionLink = this.subscriptionLinks.get(i2);
            if (!subscriptionLink.isLinked(ipcPublication)) continue;
            this.notifyUnavailableImageLink(ipcPublication.registrationId(), subscriptionLink);
        }
    }

    void cleanupImage(PublicationImage publicationImage) {
        int n2 = this.subscriptionLinks.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.subscriptionLinks.get(i2).unlink(publicationImage);
        }
    }

    void cleanupIpcPublication(IpcPublication ipcPublication) {
        int n2 = this.subscriptionLinks.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.subscriptionLinks.get(i2).unlink(ipcPublication);
        }
    }

    void tryCloseReceiveChannelEndpoint(ReceiveChannelEndpoint receiveChannelEndpoint) {
        if (receiveChannelEndpoint.shouldBeClosed()) {
            this.receiverProxy.closeReceiveChannelEndpoint(receiveChannelEndpoint);
            this.receiveChannelEndpointByChannelMap.remove(receiveChannelEndpoint.subscriptionUdpChannel().canonicalForm());
            receiveChannelEndpoint.closeIndicators();
        }
    }

    void clientTimeout(long l2) {
        this.clientProxy.onClientTimeout(l2);
    }

    void unavailableCounter(long l2, int n2) {
        this.clientProxy.onUnavailableCounter(l2, n2);
    }

    void onAddIpcPublication(String string, int n2, long l2, long l3, boolean bl2) {
        IpcPublication ipcPublication = null;
        ChannelUri channelUri = ChannelUri.parse(string);
        PublicationParams publicationParams = PublicationParams.getPublicationParams(channelUri, this.ctx, this, true);
        if (!bl2) {
            ipcPublication = DriverConductor.findSharedIpcPublication(this.ipcPublications, n2);
        }
        boolean bl3 = false;
        if (null == ipcPublication) {
            if (publicationParams.hasSessionId) {
                this.checkForSessionClash(publicationParams.sessionId, n2, "ipc", string);
            }
            PublicationParams.validateMtuForMaxMessage(publicationParams, string);
            ipcPublication = this.addIpcPublication(l2, l3, n2, string, bl2, publicationParams);
            bl3 = true;
        } else {
            PublicationParams.confirmMatch(channelUri, publicationParams, ipcPublication.rawLog(), ipcPublication.sessionId(), ipcPublication.channel(), ipcPublication.initialTermId(), ipcPublication.startingTermId(), ipcPublication.startingTermOffset());
        }
        this.publicationLinks.add(new PublicationLink(l2, this.getOrAddClient(l3), ipcPublication));
        this.clientProxy.onPublicationReady(l2, ipcPublication.registrationId(), n2, ipcPublication.sessionId(), ipcPublication.rawLog().fileName(), ipcPublication.publisherLimitId(), -1, bl2);
        if (bl3) {
            this.linkIpcSubscriptions(ipcPublication);
        }
    }

    void onRemovePublication(long l2, long l3) {
        PublicationLink publicationLink = null;
        ArrayList<PublicationLink> arrayList = this.publicationLinks;
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            PublicationLink publicationLink2 = arrayList.get(i2);
            if (l2 != publicationLink2.registrationId()) continue;
            publicationLink = publicationLink2;
            ArrayListUtil.fastUnorderedRemove(arrayList, i2);
            break;
        }
        if (null == publicationLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "unknown publication: " + l2);
        }
        publicationLink.close();
        this.clientProxy.operationSucceeded(l3);
    }

    void onAddSendDestination(long l2, String string, long l3) {
        ChannelUri channelUri = ChannelUri.parse(string);
        DriverConductor.validateDestinationUri(channelUri, string);
        DriverConductor.validateSendDestinationUri(channelUri, string);
        SendChannelEndpoint sendChannelEndpoint = null;
        int n2 = this.networkPublications.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            NetworkPublication networkPublication = this.networkPublications.get(i2);
            if (l2 != networkPublication.registrationId()) continue;
            sendChannelEndpoint = networkPublication.channelEndpoint();
            break;
        }
        if (null == sendChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "unknown publication: " + l2);
        }
        sendChannelEndpoint.validateAllowsManualControl();
        InetSocketAddress inetSocketAddress = UdpChannel.destinationAddress(channelUri, this.nameResolver);
        this.senderProxy.addDestination(sendChannelEndpoint, channelUri, inetSocketAddress);
        this.clientProxy.operationSucceeded(l3);
    }

    void onRemoveSendDestination(long l2, String string, long l3) {
        SendChannelEndpoint sendChannelEndpoint = null;
        int n2 = this.networkPublications.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            NetworkPublication networkPublication = this.networkPublications.get(i2);
            if (l2 != networkPublication.registrationId()) continue;
            sendChannelEndpoint = networkPublication.channelEndpoint();
            break;
        }
        if (null == sendChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "unknown publication: " + l2);
        }
        sendChannelEndpoint.validateAllowsManualControl();
        ChannelUri channelUri = ChannelUri.parse(string);
        InetSocketAddress inetSocketAddress = UdpChannel.destinationAddress(channelUri, this.nameResolver);
        this.senderProxy.removeDestination(sendChannelEndpoint, channelUri, inetSocketAddress);
        this.clientProxy.operationSucceeded(l3);
    }

    void onAddNetworkSubscription(String string, int n2, long l2, long l3) {
        UdpChannel udpChannel = UdpChannel.parse(string, this.nameResolver);
        DriverConductor.validateControlForSubscription(udpChannel);
        DriverConductor.validateTimestampConfiguration(udpChannel);
        SubscriptionParams subscriptionParams = SubscriptionParams.getSubscriptionParams(udpChannel.channelUri(), this.ctx);
        this.checkForClashingSubscription(subscriptionParams, udpChannel, n2);
        ReceiveChannelEndpoint receiveChannelEndpoint = this.getOrCreateReceiveChannelEndpoint(subscriptionParams, udpChannel, l2);
        NetworkSubscriptionLink networkSubscriptionLink = new NetworkSubscriptionLink(l2, receiveChannelEndpoint, n2, string, this.getOrAddClient(l3), subscriptionParams);
        this.subscriptionLinks.add(networkSubscriptionLink);
        if (subscriptionParams.hasSessionId) {
            if (1L == receiveChannelEndpoint.incRefToStreamAndSession(n2, subscriptionParams.sessionId)) {
                this.receiverProxy.addSubscription(receiveChannelEndpoint, n2, subscriptionParams.sessionId);
            }
        } else if (1 == receiveChannelEndpoint.incRefToStream(n2)) {
            this.receiverProxy.addSubscription(receiveChannelEndpoint, n2);
        }
        this.clientProxy.onSubscriptionReady(l2, receiveChannelEndpoint.statusIndicatorCounter().id());
        this.linkMatchingImages(networkSubscriptionLink);
    }

    void onAddIpcSubscription(String string, int n2, long l2, long l3) {
        SubscriptionParams subscriptionParams = SubscriptionParams.getSubscriptionParams(ChannelUri.parse(string), this.ctx);
        IpcSubscriptionLink ipcSubscriptionLink = new IpcSubscriptionLink(l2, n2, string, this.getOrAddClient(l3), subscriptionParams);
        this.subscriptionLinks.add(ipcSubscriptionLink);
        this.clientProxy.onSubscriptionReady(l2, -1);
        int n3 = this.ipcPublications.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            IpcPublication ipcPublication = this.ipcPublications.get(i2);
            if (!ipcSubscriptionLink.matches(ipcPublication) || !ipcPublication.isAcceptingSubscriptions()) continue;
            this.clientProxy.onAvailableImage(ipcPublication.registrationId(), n2, ipcPublication.sessionId(), l2, this.linkIpcSubscription(ipcPublication, ipcSubscriptionLink).id(), ipcPublication.rawLog().fileName(), "aeron:ipc");
        }
    }

    void onAddSpySubscription(String string, int n2, long l2, long l3) {
        UdpChannel udpChannel = UdpChannel.parse(string, this.nameResolver);
        SubscriptionParams subscriptionParams = SubscriptionParams.getSubscriptionParams(udpChannel.channelUri(), this.ctx);
        SpySubscriptionLink spySubscriptionLink = new SpySubscriptionLink(l2, udpChannel, n2, this.getOrAddClient(l3), subscriptionParams);
        this.subscriptionLinks.add(spySubscriptionLink);
        this.clientProxy.onSubscriptionReady(l2, -1);
        int n3 = this.networkPublications.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            NetworkPublication networkPublication = this.networkPublications.get(i2);
            if (!spySubscriptionLink.matches(networkPublication) || !networkPublication.isAcceptingSubscriptions()) continue;
            this.clientProxy.onAvailableImage(networkPublication.registrationId(), n2, networkPublication.sessionId(), l2, this.linkSpy(networkPublication, spySubscriptionLink).id(), networkPublication.rawLog().fileName(), "aeron:ipc");
        }
    }

    void onRemoveSubscription(long l2, long l3) {
        int n2;
        boolean bl2 = false;
        for (int i2 = n2 = this.subscriptionLinks.size() - 1; i2 >= 0; --i2) {
            SubscriptionLink subscriptionLink = this.subscriptionLinks.get(i2);
            if (subscriptionLink.registrationId() != l2) continue;
            ArrayListUtil.fastUnorderedRemove(this.subscriptionLinks, i2, n2--);
            subscriptionLink.close();
            this.cleanupSubscriptionLink(subscriptionLink);
            bl2 = true;
        }
        if (!bl2) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown subscription: " + l2);
        }
        this.clientProxy.operationSucceeded(l3);
    }

    void onClientKeepalive(long l2) {
        AeronClient aeronClient = DriverConductor.findClient(this.clients, l2);
        if (null != aeronClient) {
            aeronClient.timeOfLastKeepaliveMs(this.cachedEpochClock.time());
        }
    }

    void onAddCounter(int n2, DirectBuffer directBuffer, int n3, int n4, DirectBuffer directBuffer2, int n5, int n6, long l2, long l3) {
        AeronClient aeronClient = this.getOrAddClient(l3);
        AtomicCounter atomicCounter = this.countersManager.newCounter(n2, directBuffer, n3, n4, directBuffer2, n5, n6);
        this.countersManager.setCounterOwnerId(atomicCounter.id(), l3);
        this.countersManager.setCounterRegistrationId(atomicCounter.id(), l2);
        this.counterLinks.add(new CounterLink(atomicCounter, l2, aeronClient));
        this.clientProxy.onCounterReady(l2, atomicCounter.id());
    }

    void onRemoveCounter(long l2, long l3) {
        CounterLink counterLink = null;
        ArrayList<CounterLink> arrayList = this.counterLinks;
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CounterLink counterLink2 = arrayList.get(i2);
            if (l2 != counterLink2.registrationId()) continue;
            counterLink = counterLink2;
            ArrayListUtil.fastUnorderedRemove(arrayList, i2);
            break;
        }
        if (null == counterLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_COUNTER, "unknown counter: " + l2);
        }
        this.clientProxy.operationSucceeded(l3);
        this.clientProxy.onUnavailableCounter(l2, counterLink.counterId());
        counterLink.close();
    }

    void onClientClose(long l2) {
        AeronClient aeronClient = DriverConductor.findClient(this.clients, l2);
        if (null != aeronClient) {
            aeronClient.onClosedByCommand();
        }
    }

    void onAddRcvDestination(long l2, String string, long l3) {
        if (string.startsWith("aeron:ipc")) {
            this.onAddRcvIpcDestination(l2, string, l3);
        } else if (string.startsWith("aeron-spy")) {
            this.onAddRcvSpyDestination(l2, string, l3);
        } else {
            this.onAddRcvNetworkDestination(l2, string, l3);
        }
    }

    void onAddRcvIpcDestination(long l2, String string, long l3) {
        SubscriptionParams subscriptionParams = SubscriptionParams.getSubscriptionParams(ChannelUri.parse(string), this.ctx);
        SubscriptionLink subscriptionLink = DriverConductor.findMdsSubscriptionLink(this.subscriptionLinks, l2);
        if (null == subscriptionLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown MDS subscription: " + l2);
        }
        IpcSubscriptionLink ipcSubscriptionLink = new IpcSubscriptionLink(l2, subscriptionLink.streamId(), string, subscriptionLink.aeronClient(), subscriptionParams);
        this.subscriptionLinks.add(ipcSubscriptionLink);
        this.clientProxy.operationSucceeded(l3);
        int n2 = this.ipcPublications.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IpcPublication ipcPublication = this.ipcPublications.get(i2);
            if (!ipcSubscriptionLink.matches(ipcPublication) || !ipcPublication.isAcceptingSubscriptions()) continue;
            this.clientProxy.onAvailableImage(ipcPublication.registrationId(), subscriptionLink.streamId(), ipcPublication.sessionId(), l2, this.linkIpcSubscription(ipcPublication, ipcSubscriptionLink).id(), ipcPublication.rawLog().fileName(), "aeron:ipc");
        }
    }

    void onAddRcvSpyDestination(long l2, String string, long l3) {
        UdpChannel udpChannel = UdpChannel.parse(string, this.nameResolver);
        SubscriptionParams subscriptionParams = SubscriptionParams.getSubscriptionParams(udpChannel.channelUri(), this.ctx);
        SubscriptionLink subscriptionLink = DriverConductor.findMdsSubscriptionLink(this.subscriptionLinks, l2);
        if (null == subscriptionLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown MDS subscription: " + l2);
        }
        SpySubscriptionLink spySubscriptionLink = new SpySubscriptionLink(l2, udpChannel, subscriptionLink.streamId(), subscriptionLink.aeronClient(), subscriptionParams);
        this.subscriptionLinks.add(spySubscriptionLink);
        this.clientProxy.operationSucceeded(l3);
        int n2 = this.networkPublications.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            NetworkPublication networkPublication = this.networkPublications.get(i2);
            if (!spySubscriptionLink.matches(networkPublication) || !networkPublication.isAcceptingSubscriptions()) continue;
            this.clientProxy.onAvailableImage(networkPublication.registrationId(), subscriptionLink.streamId(), networkPublication.sessionId(), l2, this.linkSpy(networkPublication, spySubscriptionLink).id(), networkPublication.rawLog().fileName(), "aeron:ipc");
        }
    }

    void onAddRcvNetworkDestination(long l2, String string, long l3) {
        UdpChannel udpChannel = UdpChannel.parse(string, this.nameResolver, true);
        DriverConductor.validateDestinationUri(udpChannel.channelUri(), string);
        SubscriptionLink subscriptionLink = DriverConductor.findMdsSubscriptionLink(this.subscriptionLinks, l2);
        if (null == subscriptionLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown MDS subscription: " + l2);
        }
        ReceiveChannelEndpoint receiveChannelEndpoint = subscriptionLink.channelEndpoint();
        AtomicCounter atomicCounter = ReceiveLocalSocketAddress.allocate(this.tempBuffer, this.countersManager, l2, receiveChannelEndpoint.statusIndicatorCounter().id());
        ReceiveDestinationTransport receiveDestinationTransport = new ReceiveDestinationTransport(udpChannel, this.ctx, atomicCounter, receiveChannelEndpoint);
        this.receiverProxy.addDestination(receiveChannelEndpoint, receiveDestinationTransport);
        this.clientProxy.operationSucceeded(l3);
    }

    void onRemoveRcvDestination(long l2, String string, long l3) {
        if (string.startsWith("aeron:ipc") || string.startsWith("aeron-spy")) {
            this.onRemoveRcvIpcOrSpyDestination(l2, string, l3);
        } else {
            this.onRemoveRcvNetworkDestination(l2, string, l3);
        }
    }

    void onRemoveRcvIpcOrSpyDestination(long l2, String string, long l3) {
        SubscriptionLink subscriptionLink = DriverConductor.removeSubscriptionLink(this.subscriptionLinks, l2, string);
        if (null == subscriptionLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown subscription: " + l2);
        }
        subscriptionLink.close();
        this.cleanupSubscriptionLink(subscriptionLink);
        this.clientProxy.operationSucceeded(l3);
        subscriptionLink.notifyUnavailableImages(this);
    }

    void onRemoveRcvNetworkDestination(long l2, String string, long l3) {
        ReceiveChannelEndpoint receiveChannelEndpoint = null;
        int n2 = this.subscriptionLinks.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SubscriptionLink subscriptionLink = this.subscriptionLinks.get(i2);
            if (l2 != subscriptionLink.registrationId()) continue;
            receiveChannelEndpoint = subscriptionLink.channelEndpoint();
            break;
        }
        if (null == receiveChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown subscription: " + l2);
        }
        receiveChannelEndpoint.validateAllowsDestinationControl();
        this.receiverProxy.removeDestination(receiveChannelEndpoint, UdpChannel.parse(string, this.nameResolver, true));
        this.clientProxy.operationSucceeded(l3);
    }

    void closeReceiveDestinationIndicators(ReceiveDestinationTransport receiveDestinationTransport) {
        receiveDestinationTransport.closeIndicators();
    }

    void onTerminateDriver(DirectBuffer directBuffer, int n2, int n3) {
        if (this.ctx.terminationValidator().allowTermination(this.ctx.aeronDirectory(), directBuffer, n2, n3)) {
            this.ctx.terminationHook().run();
        }
    }

    private void heartbeatAndCheckTimers(long l2) {
        long l3 = this.cachedEpochClock.time();
        this.toDriverCommands.consumerHeartbeatTime(l3);
        this.checkManagedResources(this.clients, l2, l3);
        this.checkManagedResources(this.publicationLinks, l2, l3);
        this.checkManagedResources(this.networkPublications, l2, l3);
        this.checkManagedResources(this.subscriptionLinks, l2, l3);
        this.checkManagedResources(this.publicationImages, l2, l3);
        this.checkManagedResources(this.ipcPublications, l2, l3);
        this.checkManagedResources(this.counterLinks, l2, l3);
    }

    private void checkForBlockedToDriverCommands(long l2) {
        long l3 = this.toDriverCommands.consumerPosition();
        if (l3 == this.lastCommandConsumerPosition && this.toDriverCommands.producerPosition() > l3) {
            if (this.timeOfLastToDriverPositionChangeNs + this.clientLivenessTimeoutNs - l2 < 0L && this.toDriverCommands.unblock()) {
                this.ctx.systemCounters().get(SystemCounterDescriptor.UNBLOCKED_COMMANDS).incrementOrdered();
            }
        } else {
            this.timeOfLastToDriverPositionChangeNs = l2;
            this.lastCommandConsumerPosition = l3;
        }
    }

    private ArrayList<SubscriberPosition> createSubscriberPositions(int n2, int n3, ReceiveChannelEndpoint receiveChannelEndpoint, long l2) {
        ArrayList<SubscriberPosition> arrayList = new ArrayList<SubscriberPosition>();
        int n4 = this.subscriptionLinks.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            SubscriptionLink subscriptionLink = this.subscriptionLinks.get(i2);
            if (!subscriptionLink.matches(receiveChannelEndpoint, n3, n2)) continue;
            UnsafeBufferPosition unsafeBufferPosition = SubscriberPos.allocate(this.tempBuffer, this.countersManager, subscriptionLink.aeronClient().clientId(), subscriptionLink.registrationId(), n2, n3, subscriptionLink.channel(), l2);
            ((Position)unsafeBufferPosition).setOrdered(l2);
            arrayList.add(new SubscriberPosition(subscriptionLink, null, unsafeBufferPosition));
        }
        return arrayList;
    }

    private static NetworkPublication findPublication(ArrayList<NetworkPublication> arrayList, int n2, SendChannelEndpoint sendChannelEndpoint) {
        int n3 = arrayList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            NetworkPublication networkPublication = arrayList.get(i2);
            if (n2 != networkPublication.streamId() || sendChannelEndpoint != networkPublication.channelEndpoint() || NetworkPublication.State.ACTIVE != networkPublication.state() || networkPublication.isExclusive()) continue;
            return networkPublication;
        }
        return null;
    }

    private NetworkPublication newNetworkPublication(long l2, long l3, int n2, String string, UdpChannel udpChannel, SendChannelEndpoint sendChannelEndpoint, PublicationParams publicationParams, boolean bl2) {
        String string2 = udpChannel.canonicalForm();
        int n3 = publicationParams.hasSessionId ? publicationParams.sessionId : this.nextAvailableSessionId(n2, string2);
        int n4 = publicationParams.hasPosition ? publicationParams.initialTermId : BitUtil.generateRandomisedId();
        FlowControl flowControl = udpChannel.isMulticast() || udpChannel.isMultiDestination() ? this.ctx.multicastFlowControlSupplier().newInstance(udpChannel, n2, l2) : this.ctx.unicastFlowControlSupplier().newInstance(udpChannel, n2, l2);
        flowControl.initialize(this.ctx, this.countersManager, udpChannel, n2, n3, l2, n4, publicationParams.termLength);
        RawLog rawLog = this.newNetworkPublicationLog(n3, n2, n4, l2, publicationParams);
        UnsafeBufferPosition unsafeBufferPosition = null;
        UnsafeBufferPosition unsafeBufferPosition2 = null;
        UnsafeBufferPosition unsafeBufferPosition3 = null;
        UnsafeBufferPosition unsafeBufferPosition4 = null;
        AtomicCounter atomicCounter = null;
        try {
            unsafeBufferPosition = PublisherPos.allocate(this.tempBuffer, this.countersManager, l2, n3, n2, string);
            unsafeBufferPosition2 = PublisherLimit.allocate(this.tempBuffer, this.countersManager, l2, n3, n2, string);
            unsafeBufferPosition3 = SenderPos.allocate(this.tempBuffer, this.countersManager, l2, n3, n2, string);
            unsafeBufferPosition4 = SenderLimit.allocate(this.tempBuffer, this.countersManager, l2, n3, n2, string);
            atomicCounter = SenderBpe.allocate(this.tempBuffer, this.countersManager, l2, n3, n2, string);
            this.countersManager.setCounterOwnerId(unsafeBufferPosition2.id(), l3);
            if (publicationParams.hasPosition) {
                int n5 = LogBufferDescriptor.positionBitsToShift(publicationParams.termLength);
                long l4 = LogBufferDescriptor.computePosition(publicationParams.termId, publicationParams.termOffset, n5, n4);
                unsafeBufferPosition.setOrdered(l4);
                unsafeBufferPosition2.setOrdered(l4);
                unsafeBufferPosition3.setOrdered(l4);
                unsafeBufferPosition4.setOrdered(l4);
            }
            RetransmitHandler retransmitHandler = new RetransmitHandler(this.ctx.senderCachedNanoClock(), this.ctx.systemCounters().get(SystemCounterDescriptor.INVALID_PACKETS), this.ctx.retransmitUnicastDelayGenerator(), this.ctx.retransmitUnicastLingerGenerator());
            NetworkPublication networkPublication = new NetworkPublication(l2, this.ctx, publicationParams, sendChannelEndpoint, rawLog, Configuration.producerWindowLength(publicationParams.termLength, this.ctx.publicationTermWindowLength()), unsafeBufferPosition, unsafeBufferPosition2, unsafeBufferPosition3, unsafeBufferPosition4, atomicCounter, n3, n2, n4, flowControl, retransmitHandler, this.networkPublicationThreadLocals, bl2);
            sendChannelEndpoint.incRef();
            this.networkPublications.add(networkPublication);
            this.senderProxy.newNetworkPublication(networkPublication);
            this.activeSessionSet.add(new SessionKey(n3, n2, string2));
            return networkPublication;
        }
        catch (Exception exception) {
            CloseHelper.quietCloseAll(rawLog, unsafeBufferPosition, unsafeBufferPosition2, unsafeBufferPosition3, unsafeBufferPosition4, atomicCounter);
            throw exception;
        }
    }

    private RawLog newNetworkPublicationLog(int n2, int n3, int n4, long l2, PublicationParams publicationParams) {
        RawLog rawLog = this.logFactory.newPublication(l2, publicationParams.termLength, publicationParams.isSparse);
        this.initLogMetadata(n2, n3, n4, publicationParams.mtuLength, l2, rawLog);
        DriverConductor.initialisePositionCounters(n4, publicationParams, rawLog.metaData());
        return rawLog;
    }

    private RawLog newIpcPublicationLog(int n2, int n3, int n4, long l2, PublicationParams publicationParams) {
        RawLog rawLog = this.logFactory.newPublication(l2, publicationParams.termLength, publicationParams.isSparse);
        this.initLogMetadata(n2, n3, n4, publicationParams.mtuLength, l2, rawLog);
        DriverConductor.initialisePositionCounters(n4, publicationParams, rawLog.metaData());
        return rawLog;
    }

    private void initLogMetadata(int n2, int n3, int n4, int n5, long l2, RawLog rawLog) {
        UnsafeBuffer unsafeBuffer = rawLog.metaData();
        this.defaultDataHeader.sessionId(n2).streamId(n3).termId(n4);
        LogBufferDescriptor.storeDefaultFrameHeader(unsafeBuffer, this.defaultDataHeader);
        LogBufferDescriptor.initialTermId(unsafeBuffer, n4);
        LogBufferDescriptor.mtuLength(unsafeBuffer, n5);
        LogBufferDescriptor.termLength(unsafeBuffer, rawLog.termLength());
        LogBufferDescriptor.pageSize(unsafeBuffer, this.ctx.filePageSize());
        LogBufferDescriptor.correlationId(unsafeBuffer, l2);
        LogBufferDescriptor.endOfStreamPosition(unsafeBuffer, Long.MAX_VALUE);
    }

    private static void initialisePositionCounters(int n2, PublicationParams publicationParams, UnsafeBuffer unsafeBuffer) {
        if (publicationParams.hasPosition) {
            int n3 = publicationParams.termId;
            int n4 = n3 - n2;
            int n5 = LogBufferDescriptor.indexByTerm(n2, n3);
            LogBufferDescriptor.rawTail(unsafeBuffer, n5, LogBufferDescriptor.packTail(n3, publicationParams.termOffset));
            for (int i2 = 1; i2 < 3; ++i2) {
                int n6 = n3 + i2 - 3;
                n5 = LogBufferDescriptor.nextPartitionIndex(n5);
                LogBufferDescriptor.initialiseTailWithTermId(unsafeBuffer, n5, n6);
            }
            LogBufferDescriptor.activeTermCount(unsafeBuffer, n4);
        } else {
            LogBufferDescriptor.initialiseTailWithTermId(unsafeBuffer, 0, n2);
            for (int i3 = 1; i3 < 3; ++i3) {
                int n7 = n2 + i3 - 3;
                LogBufferDescriptor.initialiseTailWithTermId(unsafeBuffer, i3, n7);
            }
        }
    }

    private RawLog newPublicationImageLog(int n2, int n3, int n4, int n5, boolean bl2, int n6, long l2) {
        RawLog rawLog = this.logFactory.newImage(l2, n5, bl2);
        this.initLogMetadata(n2, n3, n4, n6, l2, rawLog);
        return rawLog;
    }

    private SendChannelEndpoint getOrCreateSendChannelEndpoint(PublicationParams publicationParams, UdpChannel udpChannel, long l2) {
        SendChannelEndpoint sendChannelEndpoint = this.findExistingSendChannelEndpoint(udpChannel);
        if (null == sendChannelEndpoint) {
            AtomicCounter atomicCounter = null;
            AtomicCounter atomicCounter2 = null;
            try {
                atomicCounter = SendChannelStatus.allocate(this.tempBuffer, this.countersManager, l2, udpChannel.originalUriString());
                sendChannelEndpoint = this.ctx.sendChannelEndpointSupplier().newInstance(udpChannel, atomicCounter, this.ctx);
                atomicCounter2 = SendLocalSocketAddress.allocate(this.tempBuffer, this.countersManager, l2, sendChannelEndpoint.statusIndicatorCounterId());
                sendChannelEndpoint.localSocketAddressIndicator(atomicCounter2);
                sendChannelEndpoint.allocateDestinationsCounterForMdc(this.tempBuffer, this.countersManager, l2, udpChannel.originalUriString());
                PublicationParams.validateMtuForSndbuf(publicationParams, sendChannelEndpoint.socketSndbufLength(), this.ctx, udpChannel.originalUriString(), null);
                this.sendChannelEndpointByChannelMap.put(udpChannel.canonicalForm(), sendChannelEndpoint);
                this.senderProxy.registerSendChannelEndpoint(sendChannelEndpoint);
            }
            catch (Exception exception) {
                CloseHelper.closeAll(atomicCounter, atomicCounter2, sendChannelEndpoint);
                throw exception;
            }
        } else {
            this.validateChannelSendTimestampOffset(udpChannel, sendChannelEndpoint);
            PublicationParams.validateMtuForSndbuf(publicationParams, sendChannelEndpoint.socketSndbufLength(), this.ctx, udpChannel.originalUriString(), sendChannelEndpoint.originalUriString());
            DriverConductor.validateChannelBufferLength("so-rcvbuf", udpChannel.socketRcvbufLength(), sendChannelEndpoint.socketRcvbufLength(), udpChannel.originalUriString(), sendChannelEndpoint.originalUriString());
            DriverConductor.validateChannelBufferLength("so-sndbuf", udpChannel.socketSndbufLength(), sendChannelEndpoint.socketSndbufLength(), udpChannel.originalUriString(), sendChannelEndpoint.originalUriString());
        }
        return sendChannelEndpoint;
    }

    private void validateChannelSendTimestampOffset(UdpChannel udpChannel, SendChannelEndpoint sendChannelEndpoint) {
        if (udpChannel.channelSendTimestampOffset() != sendChannelEndpoint.udpChannel().channelSendTimestampOffset()) {
            throw new InvalidChannelException("option conflicts with existing subscription: channel-snd-ts-offset=" + udpChannel.channelSendTimestampOffset() + " existingChannel=" + sendChannelEndpoint.originalUriString() + " channel=" + udpChannel.originalUriString());
        }
    }

    private void validateReceiveTimestampOffset(UdpChannel udpChannel, ReceiveChannelEndpoint receiveChannelEndpoint) {
        if (udpChannel.channelReceiveTimestampOffset() != receiveChannelEndpoint.subscriptionUdpChannel().channelReceiveTimestampOffset()) {
            throw new InvalidChannelException("option conflicts with existing subscription: channel-rcv-ts-offset=" + udpChannel.channelReceiveTimestampOffset() + " existingChannel=" + receiveChannelEndpoint.originalUriString() + " channel=" + udpChannel.originalUriString());
        }
    }

    private SendChannelEndpoint findExistingSendChannelEndpoint(UdpChannel udpChannel) {
        Object object;
        if (udpChannel.hasTag()) {
            object = this.sendChannelEndpointByChannelMap.values().iterator();
            while (object.hasNext()) {
                SendChannelEndpoint sendChannelEndpoint = (SendChannelEndpoint)object.next();
                UdpChannel udpChannel2 = sendChannelEndpoint.udpChannel();
                if (!udpChannel2.matchesTag(udpChannel)) continue;
                return sendChannelEndpoint;
            }
            if (!(udpChannel.hasExplicitControl() || udpChannel.isManualControlMode() || udpChannel.channelUri().containsKey("endpoint"))) {
                throw new InvalidChannelException("URI must have explicit control, endpoint, or be manual control-mode when original: channel=" + udpChannel.originalUriString());
            }
        }
        if (null != (object = this.sendChannelEndpointByChannelMap.get(udpChannel.canonicalForm())) && ((UdpChannelTransport)object).udpChannel().hasTag() && udpChannel.hasTag() && ((UdpChannelTransport)object).udpChannel().tag() != udpChannel.tag()) {
            object = null;
        }
        return object;
    }

    private void checkForClashingSubscription(SubscriptionParams subscriptionParams, UdpChannel udpChannel, int n2) {
        ReceiveChannelEndpoint receiveChannelEndpoint = this.findExistingReceiveChannelEndpoint(udpChannel);
        if (null != receiveChannelEndpoint) {
            this.validateReceiveTimestampOffset(udpChannel, receiveChannelEndpoint);
            int n3 = this.subscriptionLinks.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                boolean bl2;
                SubscriptionLink subscriptionLink = this.subscriptionLinks.get(i2);
                boolean bl3 = bl2 = !udpChannel.hasTag() || receiveChannelEndpoint.matchesTag(udpChannel);
                if (!bl2 || !subscriptionLink.matches(receiveChannelEndpoint, n2, subscriptionParams)) continue;
                if (subscriptionParams.isReliable != subscriptionLink.isReliable()) {
                    throw new InvalidChannelException("option conflicts with existing subscription: reliable=" + subscriptionParams.isReliable + " existingChannel=" + subscriptionLink.channel() + " channel=" + udpChannel.originalUriString());
                }
                if (subscriptionParams.isRejoin == subscriptionLink.isRejoin()) continue;
                throw new InvalidChannelException("option conflicts with existing subscription: rejoin=" + subscriptionParams.isRejoin + " existingChannel=" + subscriptionLink.channel() + " channel=" + udpChannel.originalUriString());
            }
        }
    }

    private void linkMatchingImages(SubscriptionLink subscriptionLink) {
        int n2 = this.publicationImages.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            PublicationImage publicationImage = this.publicationImages.get(i2);
            if (!subscriptionLink.matches(publicationImage) || !publicationImage.isAcceptingSubscriptions()) continue;
            long l2 = subscriptionLink.registrationId();
            long l3 = publicationImage.joinPosition();
            int n3 = publicationImage.sessionId();
            int n4 = subscriptionLink.streamId();
            UnsafeBufferPosition unsafeBufferPosition = SubscriberPos.allocate(this.tempBuffer, this.countersManager, subscriptionLink.aeronClient().clientId(), l2, n3, n4, subscriptionLink.channel(), l3);
            ((Position)unsafeBufferPosition).setOrdered(l3);
            subscriptionLink.link(publicationImage, unsafeBufferPosition);
            publicationImage.addSubscriber(subscriptionLink, unsafeBufferPosition, this.cachedNanoClock.nanoTime());
            this.clientProxy.onAvailableImage(publicationImage.correlationId(), n4, n3, l2, ((ReadablePosition)unsafeBufferPosition).id(), publicationImage.rawLog().fileName(), publicationImage.sourceIdentity());
        }
    }

    private void linkIpcSubscriptions(IpcPublication ipcPublication) {
        int n2 = this.subscriptionLinks.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SubscriptionLink subscriptionLink = this.subscriptionLinks.get(i2);
            if (!subscriptionLink.matches(ipcPublication) || subscriptionLink.isLinked(ipcPublication)) continue;
            this.clientProxy.onAvailableImage(ipcPublication.registrationId(), ipcPublication.streamId(), ipcPublication.sessionId(), subscriptionLink.registrationId, this.linkIpcSubscription(ipcPublication, subscriptionLink).id(), ipcPublication.rawLog().fileName(), "aeron:ipc");
        }
    }

    private Position linkIpcSubscription(IpcPublication ipcPublication, SubscriptionLink subscriptionLink) {
        long l2 = ipcPublication.joinPosition();
        long l3 = subscriptionLink.registrationId();
        long l4 = subscriptionLink.aeronClient().clientId();
        int n2 = ipcPublication.sessionId();
        int n3 = subscriptionLink.streamId();
        String string = subscriptionLink.channel();
        UnsafeBufferPosition unsafeBufferPosition = SubscriberPos.allocate(this.tempBuffer, this.countersManager, l4, l3, n2, n3, string, l2);
        ((Position)unsafeBufferPosition).setOrdered(l2);
        subscriptionLink.link(ipcPublication, unsafeBufferPosition);
        ipcPublication.addSubscriber(subscriptionLink, unsafeBufferPosition, this.cachedNanoClock.nanoTime());
        return unsafeBufferPosition;
    }

    private Position linkSpy(NetworkPublication networkPublication, SubscriptionLink subscriptionLink) {
        long l2 = networkPublication.consumerPosition();
        long l3 = subscriptionLink.registrationId();
        long l4 = subscriptionLink.aeronClient().clientId();
        int n2 = networkPublication.streamId();
        int n3 = networkPublication.sessionId();
        String string = subscriptionLink.channel();
        UnsafeBufferPosition unsafeBufferPosition = SubscriberPos.allocate(this.tempBuffer, this.countersManager, l4, l3, n3, n2, string, l2);
        ((Position)unsafeBufferPosition).setOrdered(l2);
        subscriptionLink.link(networkPublication, unsafeBufferPosition);
        networkPublication.addSubscriber(subscriptionLink, unsafeBufferPosition, this.cachedNanoClock.nanoTime());
        return unsafeBufferPosition;
    }

    private ReceiveChannelEndpoint getOrCreateReceiveChannelEndpoint(SubscriptionParams subscriptionParams, UdpChannel udpChannel, long l2) {
        ReceiveChannelEndpoint receiveChannelEndpoint = this.findExistingReceiveChannelEndpoint(udpChannel);
        if (null == receiveChannelEndpoint) {
            AtomicCounter atomicCounter = null;
            AtomicCounter atomicCounter2 = null;
            try {
                String string = udpChannel.originalUriString();
                atomicCounter = ReceiveChannelStatus.allocate(this.tempBuffer, this.countersManager, l2, string);
                DataPacketDispatcher dataPacketDispatcher = new DataPacketDispatcher(this.ctx.driverConductorProxy(), this.receiverProxy.receiver());
                receiveChannelEndpoint = this.ctx.receiveChannelEndpointSupplier().newInstance(udpChannel, dataPacketDispatcher, atomicCounter, this.ctx);
                if (!udpChannel.isManualControlMode()) {
                    atomicCounter2 = ReceiveLocalSocketAddress.allocate(this.tempBuffer, this.countersManager, l2, receiveChannelEndpoint.statusIndicatorCounter().id());
                    receiveChannelEndpoint.localSocketAddressIndicator(atomicCounter2);
                }
                SubscriptionParams.validateInitialWindowForRcvBuf(subscriptionParams, string, receiveChannelEndpoint.socketRcvbufLength(), this.ctx, null);
                this.receiveChannelEndpointByChannelMap.put(udpChannel.canonicalForm(), receiveChannelEndpoint);
                this.receiverProxy.registerReceiveChannelEndpoint(receiveChannelEndpoint);
            }
            catch (Exception exception) {
                CloseHelper.closeAll(atomicCounter, atomicCounter2, receiveChannelEndpoint);
                throw exception;
            }
        } else {
            SubscriptionParams.validateInitialWindowForRcvBuf(subscriptionParams, udpChannel.originalUriString(), receiveChannelEndpoint.socketRcvbufLength(), this.ctx, receiveChannelEndpoint.originalUriString());
            DriverConductor.validateChannelBufferLength("so-rcvbuf", udpChannel.socketRcvbufLength(), receiveChannelEndpoint.socketRcvbufLength(), udpChannel.originalUriString(), receiveChannelEndpoint.originalUriString());
            DriverConductor.validateChannelBufferLength("so-sndbuf", udpChannel.socketSndbufLength(), receiveChannelEndpoint.socketSndbufLength(), udpChannel.originalUriString(), receiveChannelEndpoint.originalUriString());
        }
        return receiveChannelEndpoint;
    }

    private ReceiveChannelEndpoint findExistingReceiveChannelEndpoint(UdpChannel udpChannel) {
        Object object;
        if (udpChannel.hasTag()) {
            object = this.receiveChannelEndpointByChannelMap.values().iterator();
            while (object.hasNext()) {
                ReceiveChannelEndpoint receiveChannelEndpoint = (ReceiveChannelEndpoint)object.next();
                if (!receiveChannelEndpoint.matchesTag(udpChannel)) continue;
                return receiveChannelEndpoint;
            }
        }
        if (null != (object = this.receiveChannelEndpointByChannelMap.get(udpChannel.canonicalForm())) && ((ReceiveChannelEndpoint)object).hasTag() && udpChannel.hasTag() && ((ReceiveChannelEndpoint)object).tag() != udpChannel.tag()) {
            object = null;
        }
        return object;
    }

    private AeronClient getOrAddClient(long l2) {
        AeronClient aeronClient = DriverConductor.findClient(this.clients, l2);
        if (null == aeronClient) {
            AtomicCounter atomicCounter = ClientHeartbeatTimestamp.allocate(this.tempBuffer, this.countersManager, l2);
            int n2 = atomicCounter.id();
            atomicCounter.setOrdered(this.cachedEpochClock.time());
            this.countersManager.setCounterOwnerId(n2, l2);
            this.countersManager.setCounterRegistrationId(n2, l2);
            aeronClient = new AeronClient(l2, this.clientLivenessTimeoutNs, this.ctx.systemCounters().get(SystemCounterDescriptor.CLIENT_TIMEOUTS), atomicCounter);
            this.clients.add(aeronClient);
            this.clientProxy.onCounterReady(l2, n2);
        }
        return aeronClient;
    }

    private IpcPublication addIpcPublication(long l2, long l3, int n2, String string, boolean bl2, PublicationParams publicationParams) {
        int n3 = publicationParams.hasSessionId ? publicationParams.sessionId : this.nextAvailableSessionId(n2, "ipc");
        int n4 = publicationParams.hasPosition ? publicationParams.initialTermId : BitUtil.generateRandomisedId();
        RawLog rawLog = this.newIpcPublicationLog(n3, n2, n4, l2, publicationParams);
        UnsafeBufferPosition unsafeBufferPosition = null;
        UnsafeBufferPosition unsafeBufferPosition2 = null;
        try {
            unsafeBufferPosition = PublisherPos.allocate(this.tempBuffer, this.countersManager, l2, n3, n2, string);
            unsafeBufferPosition2 = PublisherLimit.allocate(this.tempBuffer, this.countersManager, l2, n3, n2, string);
            this.countersManager.setCounterOwnerId(unsafeBufferPosition2.id(), l3);
            if (publicationParams.hasPosition) {
                int n5 = LogBufferDescriptor.positionBitsToShift(publicationParams.termLength);
                long l4 = LogBufferDescriptor.computePosition(publicationParams.termId, publicationParams.termOffset, n5, n4);
                unsafeBufferPosition.setOrdered(l4);
                unsafeBufferPosition2.setOrdered(l4);
            }
            IpcPublication ipcPublication = new IpcPublication(l2, string, this.ctx, publicationParams.entityTag, n3, n2, unsafeBufferPosition, unsafeBufferPosition2, rawLog, Configuration.producerWindowLength(publicationParams.termLength, this.ctx.ipcPublicationTermWindowLength()), bl2, publicationParams);
            this.ipcPublications.add(ipcPublication);
            this.activeSessionSet.add(new SessionKey(n3, n2, "ipc"));
            return ipcPublication;
        }
        catch (Exception exception) {
            CloseHelper.quietCloseAll(rawLog, unsafeBufferPosition, unsafeBufferPosition2);
            throw exception;
        }
    }

    private static AeronClient findClient(ArrayList<AeronClient> arrayList, long l2) {
        AeronClient aeronClient = null;
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            AeronClient aeronClient2 = arrayList.get(i2);
            if (aeronClient2.clientId() != l2) continue;
            aeronClient = aeronClient2;
            break;
        }
        return aeronClient;
    }

    private static SubscriptionLink findMdsSubscriptionLink(ArrayList<SubscriptionLink> arrayList, long l2) {
        SubscriptionLink subscriptionLink = null;
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SubscriptionLink subscriptionLink2 = arrayList.get(i2);
            if (subscriptionLink2.registrationId() != l2 || !subscriptionLink2.supportsMds()) continue;
            subscriptionLink = subscriptionLink2;
            break;
        }
        return subscriptionLink;
    }

    private static SubscriptionLink removeSubscriptionLink(ArrayList<SubscriptionLink> arrayList, long l2, String string) {
        SubscriptionLink subscriptionLink = null;
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SubscriptionLink subscriptionLink2 = arrayList.get(i2);
            if (subscriptionLink2.registrationId() != l2 || !subscriptionLink2.channel().equals(string)) continue;
            subscriptionLink = subscriptionLink2;
            ArrayListUtil.fastUnorderedRemove(arrayList, i2);
            break;
        }
        return subscriptionLink;
    }

    private static IpcPublication findSharedIpcPublication(ArrayList<IpcPublication> arrayList, long l2) {
        IpcPublication ipcPublication = null;
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            IpcPublication ipcPublication2 = arrayList.get(i2);
            if ((long)ipcPublication2.streamId() != l2 || ipcPublication2.isExclusive() || IpcPublication.State.ACTIVE != ipcPublication2.state()) continue;
            ipcPublication = ipcPublication2;
            break;
        }
        return ipcPublication;
    }

    private void checkForSessionClash(int n2, int n3, String string, String string2) {
        if (this.activeSessionSet.contains(new SessionKey(n2, n3, string))) {
            throw new InvalidChannelException("existing publication has clashing sessionId=" + n2 + " for streamId=" + n3 + " channel=" + string2);
        }
    }

    private int nextAvailableSessionId(int n2, String string) {
        int n3;
        SessionKey sessionKey = new SessionKey(n2, string);
        do {
            ++this.nextSessionId;
            if (this.ctx.publicationReservedSessionIdLow() <= n3 && n3 <= this.ctx.publicationReservedSessionIdHigh()) {
                this.nextSessionId = this.ctx.publicationReservedSessionIdHigh() + 1;
                n3 = this.nextSessionId++;
            }
            sessionKey.sessionId = n3;
        } while (this.activeSessionSet.contains(sessionKey));
        return n3;
    }

    private <T extends DriverManagedResource> void checkManagedResources(ArrayList<T> arrayList, long l2, long l3) {
        int n2;
        for (int i2 = n2 = arrayList.size() - 1; i2 >= 0; --i2) {
            DriverManagedResource driverManagedResource = (DriverManagedResource)arrayList.get(i2);
            driverManagedResource.onTimeEvent(l2, l3, this);
            if (!driverManagedResource.hasReachedEndOfLife()) continue;
            CloseHelper.close(this.ctx.errorHandler(), driverManagedResource::close);
            this.endOfLiveResources.add(driverManagedResource);
            ArrayListUtil.fastUnorderedRemove(arrayList, i2, n2--);
        }
    }

    private int freeEndOfLifeResources(int n2) {
        DriverManagedResource driverManagedResource;
        int n3 = 0;
        for (int i2 = 0; i2 < n2 && null != (driverManagedResource = this.endOfLiveResources.pollFirst()); ++i2) {
            if (driverManagedResource.free()) {
                ++n3;
                continue;
            }
            this.ctx.systemCounters().get(SystemCounterDescriptor.FREE_FAILS).incrementOrdered();
            this.endOfLiveResources.addLast(driverManagedResource);
        }
        return n3;
    }

    private void linkSpies(ArrayList<SubscriptionLink> arrayList, NetworkPublication networkPublication) {
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SubscriptionLink subscriptionLink = arrayList.get(i2);
            if (!subscriptionLink.matches(networkPublication) || subscriptionLink.isLinked(networkPublication)) continue;
            this.clientProxy.onAvailableImage(networkPublication.registrationId(), networkPublication.streamId(), networkPublication.sessionId(), subscriptionLink.registrationId(), this.linkSpy(networkPublication, subscriptionLink).id(), networkPublication.rawLog().fileName(), "aeron:ipc");
        }
    }

    private void trackTime(long l2) {
        this.cachedNanoClock.update(l2);
        this.dutyCycleTracker.measureAndUpdate(l2);
        if (this.clockUpdateDeadlineNs - l2 < 0L) {
            this.clockUpdateDeadlineNs = l2 + CLOCK_UPDATE_INTERNAL_NS;
            this.cachedEpochClock.update(this.epochClock.time());
        }
    }

    private int processTimers(long l2) {
        int n2 = 0;
        if (this.timerCheckDeadlineNs - l2 < 0L) {
            this.timerCheckDeadlineNs = l2 + this.timerIntervalNs;
            this.heartbeatAndCheckTimers(l2);
            this.checkForBlockedToDriverCommands(l2);
            n2 = 1;
        }
        return n2;
    }

    private static boolean isOldestSubscriptionSparse(ArrayList<SubscriberPosition> arrayList) {
        SubscriberPosition subscriberPosition = arrayList.get(0);
        long l2 = subscriberPosition.subscription().registrationId();
        boolean bl2 = subscriberPosition.subscription().isSparse();
        int n2 = arrayList.size();
        for (int i2 = 1; i2 < n2; ++i2) {
            SubscriptionLink subscriptionLink = arrayList.get(i2).subscription();
            if (subscriptionLink.registrationId() >= l2) continue;
            bl2 = subscriptionLink.isSparse();
            l2 = subscriptionLink.registrationId();
        }
        return bl2;
    }

    private int trackStreamPositions(int n2, long l2) {
        int n3 = n2;
        ArrayList<PublicationImage> arrayList = this.publicationImages;
        int n4 = arrayList.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            n3 += arrayList.get(i2).trackRebuild(l2);
        }
        ArrayList<NetworkPublication> arrayList2 = this.networkPublications;
        int n5 = arrayList2.size();
        for (n4 = 0; n4 < n5; ++n4) {
            n3 += arrayList2.get(n4).updatePublisherLimit();
        }
        ArrayList<IpcPublication> arrayList3 = this.ipcPublications;
        int n6 = arrayList3.size();
        for (n5 = 0; n5 < n6; ++n5) {
            n3 += arrayList3.get(n5).updatePublisherLimit();
        }
        return n3;
    }

    private static void validateChannelBufferLength(String string, int n2, int n3, String string2, String string3) {
        if (0 != n2 && n2 != n3) {
            Object object = 0 == n3 ? "OS default" : Integer.valueOf(n3);
            throw new InvalidChannelException(string + "=" + n2 + " does not match existing value of " + object + ": existingChannel=" + string3 + " channel=" + string2);
        }
    }

    private static void validateEndpointForPublication(UdpChannel udpChannel) {
        if (!udpChannel.isManualControlMode() && !udpChannel.isDynamicControlMode() && udpChannel.hasExplicitEndpoint() && 0 == udpChannel.remoteData().getPort()) {
            throw new IllegalArgumentException("endpoint has port=0 for publication: channel=" + udpChannel.originalUriString());
        }
    }

    private static void validateControlForSubscription(UdpChannel udpChannel) {
        if (udpChannel.hasExplicitControl() && 0 == udpChannel.localControl().getPort()) {
            throw new IllegalArgumentException("control has port=0 for subscription: channel=" + udpChannel.originalUriString());
        }
    }

    private static void validateTimestampConfiguration(UdpChannel udpChannel) {
        if (null != udpChannel.channelUri().get("media-rcv-ts-offset")) {
            throw new InvalidChannelException("Media timestamps 'media-rcv-ts-offset' are not supported in the Java driver: channel=" + udpChannel.originalUriString());
        }
    }

    private static void validateDestinationUri(ChannelUri channelUri, String string) {
        if ("aeron-spy".equals(channelUri.prefix())) {
            throw new InvalidChannelException("Aeron spies are invalid as send destinations: channel=" + string);
        }
        for (String string2 : INVALID_DESTINATION_KEYS) {
            if (!channelUri.containsKey(string2)) continue;
            throw new InvalidChannelException("destinations must not contain the key: " + string2 + " channel=" + string);
        }
    }

    private static void validateSendDestinationUri(ChannelUri channelUri, String string) {
        String string2 = channelUri.get("endpoint");
        if (null != string2 && string2.endsWith(":0")) {
            throw new InvalidChannelException("endpoint has port=0 for send destination: channel=" + string);
        }
    }
}

