/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import org.agrona.MutableDirectBuffer;

public class ImageMessageFlyweight {
    private static final int CORRELATION_ID_OFFSET = 0;
    private static final int SUBSCRIPTION_REGISTRATION_ID_OFFSET = 8;
    private static final int STREAM_ID_FIELD_OFFSET = 16;
    private static final int CHANNEL_OFFSET = 20;
    private MutableDirectBuffer buffer;
    private int offset;
    private int lengthOfChannel;

    public final ImageMessageFlyweight wrap(MutableDirectBuffer mutableDirectBuffer, int n2) {
        this.buffer = mutableDirectBuffer;
        this.offset = n2;
        return this;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 0);
    }

    public ImageMessageFlyweight correlationId(long l2) {
        this.buffer.putLong(this.offset + 0, l2);
        return this;
    }

    public long subscriptionRegistrationId() {
        return this.buffer.getLong(this.offset + 8);
    }

    public ImageMessageFlyweight subscriptionRegistrationId(long l2) {
        this.buffer.putLong(this.offset + 8, l2);
        return this;
    }

    public int streamId() {
        return this.buffer.getInt(this.offset + 16);
    }

    public ImageMessageFlyweight streamId(int n2) {
        this.buffer.putInt(this.offset + 16, n2);
        return this;
    }

    public String channel() {
        int n2 = this.buffer.getInt(this.offset + 20);
        this.lengthOfChannel = 4 + n2;
        return this.buffer.getStringAscii(this.offset + 20, n2);
    }

    public void appendChannel(Appendable appendable) {
        int n2 = this.buffer.getInt(this.offset + 20);
        this.lengthOfChannel = 4 + n2;
        this.buffer.getStringAscii(this.offset + 20, appendable);
    }

    public ImageMessageFlyweight channel(String string) {
        this.lengthOfChannel = this.buffer.putStringAscii(this.offset + 20, string);
        return this;
    }

    public int length() {
        return 20 + this.lengthOfChannel;
    }
}

