/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import io.aeron.ErrorCode;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.exceptions.ControlProtocolException;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class CounterMessageFlyweight
extends CorrelatedMessageFlyweight {
    private static final int COUNTER_TYPE_ID_FIELD_OFFSET = 16;
    private static final int KEY_LENGTH_OFFSET = 20;
    static final int KEY_BUFFER_OFFSET = 24;
    private static final int MINIMUM_LENGTH = 28;

    @Override
    public CounterMessageFlyweight wrap(MutableDirectBuffer mutableDirectBuffer, int n2) {
        super.wrap(mutableDirectBuffer, n2);
        return this;
    }

    public int typeId() {
        return this.buffer.getInt(this.offset + 16);
    }

    public CounterMessageFlyweight typeId(int n2) {
        this.buffer.putInt(this.offset + 16, n2);
        return this;
    }

    public int keyBufferOffset() {
        return 24;
    }

    public int keyBufferLength() {
        return this.buffer.getInt(this.offset + 20);
    }

    public CounterMessageFlyweight keyBuffer(DirectBuffer directBuffer, int n2, int n3) {
        this.buffer.putInt(this.offset + 20, n3);
        if (null != directBuffer && n3 > 0) {
            this.buffer.putBytes(this.offset + 24, directBuffer, n2, n3);
        }
        return this;
    }

    public int labelBufferOffset() {
        return this.labelLengthOffset() + 4;
    }

    public int labelBufferLength() {
        return this.buffer.getInt(this.offset + this.labelLengthOffset());
    }

    public CounterMessageFlyweight labelBuffer(DirectBuffer directBuffer, int n2, int n3) {
        int n4 = this.labelLengthOffset();
        this.buffer.putInt(this.offset + n4, n3);
        if (null != directBuffer && n3 > 0) {
            this.buffer.putBytes(this.offset + n4 + 4, directBuffer, n2, n3);
        }
        return this;
    }

    public CounterMessageFlyweight label(String string) {
        this.buffer.putStringAscii(this.offset + this.labelLengthOffset(), string);
        return this;
    }

    public int length() {
        int n2 = this.labelLengthOffset();
        return n2 + 4 + this.labelBufferLength();
    }

    @Override
    public void validateLength(int n2, int n3) {
        if (n3 < 28) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + n2 + " too short: length=" + n3);
        }
        int n4 = this.labelLengthOffset();
        if (n3 - n4 < 4) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + n2 + " too short for key: length=" + n3);
        }
        int n5 = this.length();
        if (n3 < n5) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + n2 + " too short for label: length=" + n3 + " encodedLength=" + n5);
        }
    }

    public static int computeLength(int n2, int n3) {
        return 28 + BitUtil.align(n2, 4) + 4 + n3;
    }

    public String toString() {
        return "CounterMessageFlyweight{clientId=" + this.clientId() + ", correlationId=" + this.correlationId() + ", typeId=" + this.typeId() + ", keyBufferOffset=" + this.keyBufferOffset() + ", keyBufferLength=" + this.keyBufferLength() + ", labelLengthOffset=" + this.labelLengthOffset() + ", labelBufferOffset=" + this.labelBufferOffset() + ", labelBufferLength=" + this.labelBufferLength() + ", length=" + this.length() + "}";
    }

    private int labelLengthOffset() {
        return 24 + BitUtil.align(this.keyBufferLength(), 4);
    }
}

