/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;

public final class LogBuffers
implements AutoCloseable {
    private static final EnumSet<StandardOpenOption> FILE_OPTIONS = EnumSet.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SPARSE);
    private long lingerDeadlineNs = Long.MAX_VALUE;
    private int refCount;
    private final int termLength;
    private final FileChannel fileChannel;
    private final ByteBuffer[] termBuffers = new ByteBuffer[3];
    private final UnsafeBuffer logMetaDataBuffer;
    private final MappedByteBuffer[] mappedByteBuffers;

    public LogBuffers(String string) {
        int n2 = 0;
        FileChannel fileChannel = null;
        UnsafeBuffer unsafeBuffer = null;
        MappedByteBuffer[] mappedByteBufferArray = null;
        try {
            fileChannel = FileChannel.open(Paths.get(string, new String[0]), FILE_OPTIONS, new FileAttribute[0]);
            long l2 = fileChannel.size();
            if (l2 < Integer.MAX_VALUE) {
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, l2);
                mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                mappedByteBufferArray = new MappedByteBuffer[]{mappedByteBuffer};
                unsafeBuffer = new UnsafeBuffer(mappedByteBuffer, (int)(l2 - (long)LogBufferDescriptor.LOG_META_DATA_LENGTH), LogBufferDescriptor.LOG_META_DATA_LENGTH);
                n2 = LogBufferDescriptor.termLength(unsafeBuffer);
                int n3 = LogBufferDescriptor.pageSize(unsafeBuffer);
                LogBufferDescriptor.checkTermLength(n2);
                LogBufferDescriptor.checkPageSize(n3);
                for (int i2 = 0; i2 < 3; ++i2) {
                    int n4 = i2 * n2;
                    mappedByteBuffer.limit(n4 + n2).position(n4);
                    this.termBuffers[i2] = mappedByteBuffer.slice();
                }
            } else {
                mappedByteBufferArray = new MappedByteBuffer[4];
                int n5 = 0x40000000;
                long l3 = 0xC0000000L;
                long l4 = l2 - 0xC0000000L;
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0xC0000000L, l4);
                mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                mappedByteBufferArray[3] = mappedByteBuffer;
                unsafeBuffer = new UnsafeBuffer(mappedByteBuffer, (int)l4 - LogBufferDescriptor.LOG_META_DATA_LENGTH, LogBufferDescriptor.LOG_META_DATA_LENGTH);
                int n6 = LogBufferDescriptor.termLength(unsafeBuffer);
                int n7 = LogBufferDescriptor.pageSize(unsafeBuffer);
                LogBufferDescriptor.checkPageSize(n7);
                if (n6 != 0x40000000) {
                    throw new IllegalStateException("assumed term length 1073741824 does not match metadata: termLength=" + n6);
                }
                n2 = 0x40000000;
                for (int i3 = 0; i3 < 3; ++i3) {
                    long l5 = 0x40000000L * (long)i3;
                    MappedByteBuffer mappedByteBuffer2 = fileChannel.map(FileChannel.MapMode.READ_WRITE, l5, 0x40000000L);
                    mappedByteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
                    mappedByteBufferArray[i3] = mappedByteBuffer2;
                    this.termBuffers[i3] = mappedByteBuffer2;
                }
            }
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
        catch (IllegalStateException illegalStateException) {
            this.close();
            throw illegalStateException;
        }
        this.termLength = n2;
        this.fileChannel = fileChannel;
        this.logMetaDataBuffer = unsafeBuffer;
        this.mappedByteBuffers = mappedByteBufferArray;
    }

    public UnsafeBuffer[] duplicateTermBuffers() {
        UnsafeBuffer[] unsafeBufferArray = new UnsafeBuffer[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            unsafeBufferArray[i2] = new UnsafeBuffer(this.termBuffers[i2].duplicate().order(ByteOrder.LITTLE_ENDIAN));
        }
        return unsafeBufferArray;
    }

    public UnsafeBuffer metaDataBuffer() {
        return this.logMetaDataBuffer;
    }

    public FileChannel fileChannel() {
        return this.fileChannel;
    }

    public void preTouch() {
        boolean bl2 = false;
        int n2 = LogBufferDescriptor.pageSize(this.logMetaDataBuffer);
        UnsafeBuffer unsafeBuffer = new UnsafeBuffer();
        for (MappedByteBuffer mappedByteBuffer : this.mappedByteBuffers) {
            unsafeBuffer.wrap(mappedByteBuffer);
            int n3 = unsafeBuffer.capacity();
            for (int i2 = 0; i2 < n3; i2 += n2) {
                unsafeBuffer.compareAndSetInt(i2, 0, 0);
            }
        }
    }

    @Override
    public void close() {
        Exception exception = null;
        try {
            CloseHelper.close(this.fileChannel);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        for (MappedByteBuffer mappedByteBuffer : this.mappedByteBuffers) {
            this.mappedByteBuffers[var2_3] = null;
            BufferUtil.free(mappedByteBuffer);
        }
        this.logMetaDataBuffer.wrap(0L, 0);
        if (exception != null) {
            LangUtil.rethrowUnchecked(exception);
        }
    }

    public int termLength() {
        return this.termLength;
    }

    public int incRef() {
        return ++this.refCount;
    }

    public int decRef() {
        return --this.refCount;
    }

    public void lingerDeadlineNs(long l2) {
        this.lingerDeadlineNs = l2;
    }

    public long lingerDeadlineNs() {
        return this.lingerDeadlineNs;
    }
}

