/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.exceptions.AeronException;

public enum ErrorCode {
    UNUSED(0),
    INVALID_CHANNEL(1),
    UNKNOWN_SUBSCRIPTION(2),
    UNKNOWN_PUBLICATION(3),
    CHANNEL_ENDPOINT_ERROR(4),
    UNKNOWN_COUNTER(5),
    UNKNOWN_COMMAND_TYPE_ID(6),
    MALFORMED_COMMAND(7),
    NOT_SUPPORTED(8),
    UNKNOWN_HOST(9),
    RESOURCE_TEMPORARILY_UNAVAILABLE(10),
    GENERIC_ERROR(11),
    STORAGE_SPACE(12),
    UNKNOWN_CODE_VALUE(-1);

    static final ErrorCode[] ERROR_CODES;
    private final int value;

    private ErrorCode(int n3) {
        this.value = n3;
    }

    public int value() {
        return this.value;
    }

    public static ErrorCode get(int n2) {
        if (0 <= n2 && n2 <= ERROR_CODES.length - 2) {
            return ERROR_CODES[n2];
        }
        return UNKNOWN_CODE_VALUE;
    }

    static {
        ErrorCode[] errorCodeArray = ErrorCode.values();
        ERROR_CODES = new ErrorCode[errorCodeArray.length];
        for (ErrorCode errorCode : errorCodeArray) {
            int n2 = errorCode.value();
            if (n2 == UNKNOWN_CODE_VALUE.value()) continue;
            if (null != ERROR_CODES[n2]) {
                throw new AeronException("value already in use: " + n2);
            }
            ErrorCode.ERROR_CODES[n2] = errorCode;
        }
    }
}

