/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.CounterMessageFlyweight;
import io.aeron.command.DestinationMessageFlyweight;
import io.aeron.command.PublicationMessageFlyweight;
import io.aeron.command.RemoveMessageFlyweight;
import io.aeron.command.SubscriptionMessageFlyweight;
import io.aeron.command.TerminateDriverFlyweight;
import io.aeron.exceptions.AeronException;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;

public final class DriverProxy {
    private final long clientId;
    private final PublicationMessageFlyweight publicationMessage = new PublicationMessageFlyweight();
    private final SubscriptionMessageFlyweight subscriptionMessage = new SubscriptionMessageFlyweight();
    private final RemoveMessageFlyweight removeMessage = new RemoveMessageFlyweight();
    private final DestinationMessageFlyweight destinationMessage = new DestinationMessageFlyweight();
    private final CounterMessageFlyweight counterMessage = new CounterMessageFlyweight();
    private final RingBuffer toDriverCommandBuffer;

    public DriverProxy(RingBuffer ringBuffer, long l2) {
        this.toDriverCommandBuffer = ringBuffer;
        this.clientId = l2;
    }

    public long timeOfLastDriverKeepaliveMs() {
        return this.toDriverCommandBuffer.consumerHeartbeatTime();
    }

    public long addPublication(String string, int n2) {
        long l2 = this.toDriverCommandBuffer.nextCorrelationId();
        int n3 = PublicationMessageFlyweight.computeLength(string.length());
        int n4 = this.toDriverCommandBuffer.tryClaim(1, n3);
        if (n4 < 0) {
            throw new AeronException("could not write add publication command");
        }
        this.publicationMessage.wrap(this.toDriverCommandBuffer.buffer(), n4).streamId(n2).channel(string).clientId(this.clientId).correlationId(l2);
        this.toDriverCommandBuffer.commit(n4);
        return l2;
    }

    public long addExclusivePublication(String string, int n2) {
        long l2 = this.toDriverCommandBuffer.nextCorrelationId();
        int n3 = PublicationMessageFlyweight.computeLength(string.length());
        int n4 = this.toDriverCommandBuffer.tryClaim(3, n3);
        if (n4 < 0) {
            throw new AeronException("could not write add exclusive publication command");
        }
        this.publicationMessage.wrap(this.toDriverCommandBuffer.buffer(), n4).streamId(n2).channel(string).clientId(this.clientId).correlationId(l2);
        this.toDriverCommandBuffer.commit(n4);
        return l2;
    }

    public long removePublication(long l2) {
        long l3 = this.toDriverCommandBuffer.nextCorrelationId();
        int n2 = this.toDriverCommandBuffer.tryClaim(2, RemoveMessageFlyweight.length());
        if (n2 < 0) {
            throw new AeronException("could not write remove publication command");
        }
        this.removeMessage.wrap(this.toDriverCommandBuffer.buffer(), n2).registrationId(l2).clientId(this.clientId).correlationId(l3);
        this.toDriverCommandBuffer.commit(n2);
        return l3;
    }

    public long addSubscription(String string, int n2) {
        long l2 = -1L;
        long l3 = this.toDriverCommandBuffer.nextCorrelationId();
        int n3 = SubscriptionMessageFlyweight.computeLength(string.length());
        int n4 = this.toDriverCommandBuffer.tryClaim(4, n3);
        if (n4 < 0) {
            throw new AeronException("could not write add subscription command");
        }
        this.subscriptionMessage.wrap(this.toDriverCommandBuffer.buffer(), n4).registrationCorrelationId(-1L).streamId(n2).channel(string).clientId(this.clientId).correlationId(l3);
        this.toDriverCommandBuffer.commit(n4);
        return l3;
    }

    public long removeSubscription(long l2) {
        long l3 = this.toDriverCommandBuffer.nextCorrelationId();
        int n2 = this.toDriverCommandBuffer.tryClaim(5, RemoveMessageFlyweight.length());
        if (n2 < 0) {
            throw new AeronException("could not write remove subscription command");
        }
        this.removeMessage.wrap(this.toDriverCommandBuffer.buffer(), n2).registrationId(l2).clientId(this.clientId).correlationId(l3);
        this.toDriverCommandBuffer.commit(n2);
        return l3;
    }

    public long addDestination(long l2, String string) {
        long l3 = this.toDriverCommandBuffer.nextCorrelationId();
        int n2 = DestinationMessageFlyweight.computeLength(string.length());
        int n3 = this.toDriverCommandBuffer.tryClaim(7, n2);
        if (n3 < 0) {
            throw new AeronException("could not write add destination command");
        }
        this.destinationMessage.wrap(this.toDriverCommandBuffer.buffer(), n3).registrationCorrelationId(l2).channel(string).clientId(this.clientId).correlationId(l3);
        this.toDriverCommandBuffer.commit(n3);
        return l3;
    }

    public long removeDestination(long l2, String string) {
        long l3 = this.toDriverCommandBuffer.nextCorrelationId();
        int n2 = DestinationMessageFlyweight.computeLength(string.length());
        int n3 = this.toDriverCommandBuffer.tryClaim(8, n2);
        if (n3 < 0) {
            throw new AeronException("could not write remove destination command");
        }
        this.destinationMessage.wrap(this.toDriverCommandBuffer.buffer(), n3).registrationCorrelationId(l2).channel(string).clientId(this.clientId).correlationId(l3);
        this.toDriverCommandBuffer.commit(n3);
        return l3;
    }

    public long addRcvDestination(long l2, String string) {
        long l3 = this.toDriverCommandBuffer.nextCorrelationId();
        int n2 = DestinationMessageFlyweight.computeLength(string.length());
        int n3 = this.toDriverCommandBuffer.tryClaim(12, n2);
        if (n3 < 0) {
            throw new AeronException("could not write add rcv destination command");
        }
        this.destinationMessage.wrap(this.toDriverCommandBuffer.buffer(), n3).registrationCorrelationId(l2).channel(string).clientId(this.clientId).correlationId(l3);
        this.toDriverCommandBuffer.commit(n3);
        return l3;
    }

    public long removeRcvDestination(long l2, String string) {
        long l3 = this.toDriverCommandBuffer.nextCorrelationId();
        int n2 = DestinationMessageFlyweight.computeLength(string.length());
        int n3 = this.toDriverCommandBuffer.tryClaim(13, n2);
        if (n3 < 0) {
            throw new AeronException("could not write remove rcv destination command");
        }
        this.destinationMessage.wrap(this.toDriverCommandBuffer.buffer(), n3).registrationCorrelationId(l2).channel(string).clientId(this.clientId).correlationId(l3);
        this.toDriverCommandBuffer.commit(n3);
        return l3;
    }

    public long addCounter(int n2, DirectBuffer directBuffer, int n3, int n4, DirectBuffer directBuffer2, int n5, int n6) {
        long l2 = this.toDriverCommandBuffer.nextCorrelationId();
        int n7 = CounterMessageFlyweight.computeLength(n4, n6);
        int n8 = this.toDriverCommandBuffer.tryClaim(9, n7);
        if (n8 < 0) {
            throw new AeronException("could not write add counter command");
        }
        this.counterMessage.wrap(this.toDriverCommandBuffer.buffer(), n8).keyBuffer(directBuffer, n3, n4).labelBuffer(directBuffer2, n5, n6).typeId(n2).clientId(this.clientId).correlationId(l2);
        this.toDriverCommandBuffer.commit(n8);
        return l2;
    }

    public long addCounter(int n2, String string) {
        long l2 = this.toDriverCommandBuffer.nextCorrelationId();
        int n3 = CounterMessageFlyweight.computeLength(0, string.length());
        int n4 = this.toDriverCommandBuffer.tryClaim(9, n3);
        if (n4 < 0) {
            throw new AeronException("could not write add counter command");
        }
        this.counterMessage.wrap(this.toDriverCommandBuffer.buffer(), n4).keyBuffer(null, 0, 0).label(string).typeId(n2).clientId(this.clientId).correlationId(l2);
        this.toDriverCommandBuffer.commit(n4);
        return l2;
    }

    public long removeCounter(long l2) {
        long l3 = this.toDriverCommandBuffer.nextCorrelationId();
        int n2 = this.toDriverCommandBuffer.tryClaim(10, RemoveMessageFlyweight.length());
        if (n2 < 0) {
            throw new AeronException("could not write remove counter command");
        }
        this.removeMessage.wrap(this.toDriverCommandBuffer.buffer(), n2).registrationId(l2).clientId(this.clientId).correlationId(l3);
        this.toDriverCommandBuffer.commit(n2);
        return l3;
    }

    public void clientClose() {
        int n2 = this.toDriverCommandBuffer.tryClaim(11, 16);
        if (n2 > 0) {
            new CorrelatedMessageFlyweight().wrap(this.toDriverCommandBuffer.buffer(), n2).clientId(this.clientId).correlationId(-1L);
            this.toDriverCommandBuffer.commit(n2);
        }
    }

    public boolean terminateDriver(DirectBuffer directBuffer, int n2, int n3) {
        int n4 = TerminateDriverFlyweight.computeLength(n3);
        int n5 = this.toDriverCommandBuffer.tryClaim(14, n4);
        if (n5 > 0) {
            new TerminateDriverFlyweight().wrap(this.toDriverCommandBuffer.buffer(), n5).tokenBuffer(directBuffer, n2, n3).clientId(this.clientId).correlationId(-1L);
            this.toDriverCommandBuffer.commit(n5);
            return true;
        }
        return false;
    }

    public String toString() {
        return "DriverProxy{clientId=" + this.clientId + '}';
    }
}

