/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.BufferBuilder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;

public class ControlledFragmentAssembler
implements ControlledFragmentHandler {
    private final boolean isDirectByteBuffer;
    private final int initialBufferLength;
    private final ControlledFragmentHandler delegate;
    private final Int2ObjectHashMap<BufferBuilder> builderBySessionIdMap = new Int2ObjectHashMap();

    public ControlledFragmentAssembler(ControlledFragmentHandler controlledFragmentHandler) {
        this(controlledFragmentHandler, 0, false);
    }

    public ControlledFragmentAssembler(ControlledFragmentHandler controlledFragmentHandler, int n2) {
        this(controlledFragmentHandler, n2, false);
    }

    public ControlledFragmentAssembler(ControlledFragmentHandler controlledFragmentHandler, int n2, boolean bl2) {
        this.initialBufferLength = n2;
        this.delegate = controlledFragmentHandler;
        this.isDirectByteBuffer = bl2;
    }

    public ControlledFragmentHandler delegate() {
        return this.delegate;
    }

    public boolean isDirectByteBuffer() {
        return this.isDirectByteBuffer;
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer directBuffer, int n2, int n3, Header header) {
        byte by2 = header.flags();
        ControlledFragmentHandler.Action action = ControlledFragmentHandler.Action.CONTINUE;
        if ((by2 & 0xFFFFFFC0) == -64) {
            action = this.delegate.onFragment(directBuffer, n2, n3, header);
        } else if ((by2 & 0xFFFFFF80) == -128) {
            BufferBuilder bufferBuilder = this.getBufferBuilder(header.sessionId());
            bufferBuilder.reset().append(directBuffer, n2, n3).nextTermOffset(BitUtil.align(n2 + n3 + 32, 32));
        } else {
            BufferBuilder bufferBuilder = this.builderBySessionIdMap.get(header.sessionId());
            if (null != bufferBuilder) {
                if (n2 == bufferBuilder.nextTermOffset()) {
                    int n4 = bufferBuilder.limit();
                    bufferBuilder.append(directBuffer, n2, n3);
                    if ((by2 & 0x40) == 64) {
                        action = this.delegate.onFragment(bufferBuilder.buffer(), 0, bufferBuilder.limit(), header);
                        if (ControlledFragmentHandler.Action.ABORT == action) {
                            bufferBuilder.limit(n4);
                        } else {
                            bufferBuilder.reset();
                        }
                    } else {
                        bufferBuilder.nextTermOffset(BitUtil.align(n2 + n3 + 32, 32));
                    }
                } else {
                    bufferBuilder.reset();
                }
            }
        }
        return action;
    }

    public boolean freeSessionBuffer(int n2) {
        return null != this.builderBySessionIdMap.remove(n2);
    }

    public void clear() {
        this.builderBySessionIdMap.clear();
    }

    private BufferBuilder getBufferBuilder(int n2) {
        BufferBuilder bufferBuilder = this.builderBySessionIdMap.get(n2);
        if (null == bufferBuilder) {
            bufferBuilder = new BufferBuilder(this.initialBufferLength, this.isDirectByteBuffer);
            this.builderBySessionIdMap.put(n2, bufferBuilder);
        }
        return bufferBuilder;
    }
}

