/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class BufferBuilder {
    static final int MAX_CAPACITY = 0x7FFFFFF7;
    static final int INIT_MIN_CAPACITY = 4096;
    private final boolean isDirect;
    private int limit;
    private int nextTermOffset;
    private final UnsafeBuffer buffer;

    public BufferBuilder() {
        this(0, false);
    }

    public BufferBuilder(int n2) {
        this(n2, false);
    }

    public BufferBuilder(int n2, boolean bl2) {
        if (n2 < 0 || n2 > 0x7FFFFFF7) {
            throw new IllegalArgumentException("initialCapacity outside range 0 - 2147483639: initialCapacity=" + n2);
        }
        this.isDirect = bl2;
        if (bl2) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.buffer = new UnsafeBuffer(byteBuffer);
        } else {
            this.buffer = new UnsafeBuffer(new byte[n2]);
        }
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int n2) {
        if (n2 < 0 || n2 >= this.buffer.capacity()) {
            throw new IllegalArgumentException("limit outside range: capacity=" + this.buffer.capacity() + " limit=" + n2);
        }
        this.limit = n2;
    }

    public int nextTermOffset() {
        return this.nextTermOffset;
    }

    public void nextTermOffset(int n2) {
        this.nextTermOffset = n2;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public BufferBuilder reset() {
        this.limit = 0;
        this.nextTermOffset = 0;
        return this;
    }

    public BufferBuilder compact() {
        this.resize(Math.max(4096, this.limit));
        return this;
    }

    public BufferBuilder append(DirectBuffer directBuffer, int n2, int n3) {
        this.ensureCapacity(n3);
        this.buffer.putBytes(this.limit, directBuffer, n2, n3);
        this.limit += n3;
        return this;
    }

    private void ensureCapacity(int n2) {
        long l2 = (long)this.limit + (long)n2;
        int n3 = this.buffer.capacity();
        if (l2 > (long)n3) {
            if (l2 > 0x7FFFFFF7L) {
                throw new IllegalStateException("insufficient capacity: maxCapacity=2147483639 limit=" + this.limit + " additionalLength=" + n2);
            }
            this.resize(BufferBuilder.findSuitableCapacity(n3, l2));
        }
    }

    private void resize(int n2) {
        if (this.isDirect) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.buffer.getBytes(0, byteBuffer, 0, this.limit);
            this.buffer.wrap(byteBuffer);
        } else {
            this.buffer.wrap(Arrays.copyOf(this.buffer.byteArray(), n2));
        }
    }

    static int findSuitableCapacity(int n2, long l2) {
        long l3 = Math.max(n2, 4096);
        while (l3 < l2) {
            if ((l3 += l3 >> 1) <= 0x7FFFFFF7L) continue;
            l3 = 0x7FFFFFF7L;
        }
        return (int)l3;
    }
}

