/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.worldmap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableMap;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.ZoomEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import org.controlsfx.control.WorldMapView;

public class WorldMapViewSkin
extends SkinBase<WorldMapView> {
    private static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");
    private static final String DEFAULT_STYLE_LOCATION = "location";
    private static final String DEFAULT_STYLE_COUNTRY = "country";
    private static final double PREFERRED_WIDTH = 1009.0;
    private static final double PREFERRED_HEIGHT = 665.0;
    private static double MAP_OFFSET_X = -28.756500000000003;
    private static double MAP_OFFSET_Y = 129.675;
    private final Map<WorldMapView.Country, List<? extends String>> countryPathMap = new HashMap<WorldMapView.Country, List<? extends String>>();
    private final Map<WorldMapView.Country, List<? extends WorldMapView.CountryView>> countryViewMap = new HashMap<WorldMapView.Country, List<? extends WorldMapView.CountryView>>();
    private Pane countryPane;
    private Group group;
    private Group locationsGroup;
    protected ObservableMap<WorldMapView.Location, Node> locationMap;
    private double dragX;
    private double dragY;
    private final ListChangeListener<? super WorldMapView.Location> locationsListener = change -> {
        while (change.next()) {
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(location -> this.addLocation((WorldMapView.Location)location));
                continue;
            }
            if (!change.wasRemoved()) continue;
            change.getRemoved().forEach(location -> this.removeLocation((WorldMapView.Location)location));
        }
    };
    private final WeakListChangeListener weakLocationsListener = new WeakListChangeListener(this.locationsListener);
    private final ListChangeListener<? super WorldMapView.Country> countrySelectionListener = change -> {
        while (change.next()) {
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(country -> this.countryViewMap.get(country).forEach(countryView -> countryView.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, true)));
                continue;
            }
            if (!change.wasRemoved()) continue;
            change.getRemoved().forEach(country -> this.countryViewMap.get(country).forEach(countryView -> countryView.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, false)));
        }
    };
    private final WeakListChangeListener weakCountrySelectionListener = new WeakListChangeListener(this.countrySelectionListener);
    private final ListChangeListener<? super WorldMapView.Location> locationSelectionListener = change -> {
        while (change.next()) {
            if (change.wasAdded()) {
                change.getAddedSubList().forEach(location -> ((Node)this.locationMap.get(location)).pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, true));
                continue;
            }
            if (!change.wasRemoved()) continue;
            change.getRemoved().forEach(location -> ((Node)this.locationMap.get(location)).pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, false));
        }
    };
    private final WeakListChangeListener weakLocationSelectionListener = new WeakListChangeListener(this.locationSelectionListener);

    public WorldMapViewSkin(WorldMapView worldMapView) {
        super((Control)worldMapView);
        this.locationMap = FXCollections.observableHashMap();
        this.group = new Group();
        this.group.setManaged(false);
        this.group.setAutoSizeChildren(false);
        this.locationsGroup = new Group();
        this.locationsGroup.setManaged(false);
        this.locationsGroup.visibleProperty().bind((ObservableValue)worldMapView.showLocationsProperty());
        this.locationsGroup.setAutoSizeChildren(false);
        this.countryPane = new Pane();
        this.countryPane.getChildren().add((Object)this.group);
        worldMapView.getLocations().addListener(this.locationsListener);
        ListChangeListener listChangeListener = change -> this.buildView();
        worldMapView.getCountries().addListener(listChangeListener);
        this.locationMap.addListener(change -> {
            if (change.wasRemoved()) {
                this.locationsGroup.getChildren().remove(change.getValueRemoved());
            }
        });
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter((Node)this.countryPane);
        this.getChildren().add((Object)borderPane);
        worldMapView.zoomFactorProperty().addListener(observable -> worldMapView.requestLayout());
        Properties properties = this.loadData();
        for (WorldMapView.Country country : WorldMapView.Country.values()) {
            String string = (String)properties.get(country.name());
            if (string == null) {
                System.out.println("Missing SVG path for country " + country.getLocale().getDisplayCountry() + " (" + country + ")");
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            this.countryPathMap.put(country, arrayList);
        }
        this.buildView();
        worldMapView.getSelectedCountries().addListener((ListChangeListener)this.weakCountrySelectionListener);
        worldMapView.selectedCountriesProperty().addListener(observable -> worldMapView.getSelectedCountries().addListener((ListChangeListener)this.weakCountrySelectionListener));
        worldMapView.getSelectedLocations().addListener((ListChangeListener)this.weakLocationSelectionListener);
        worldMapView.selectedLocationsProperty().addListener(observable -> worldMapView.getSelectedLocations().addListener((ListChangeListener)this.weakLocationSelectionListener));
        worldMapView.getLocations().addListener((ListChangeListener)this.weakLocationsListener);
        worldMapView.locationsProperty().addListener(observable -> worldMapView.getLocations().addListener((ListChangeListener)this.weakLocationsListener));
        worldMapView.getLocations().forEach(location -> this.addLocation((WorldMapView.Location)location));
        worldMapView.addEventHandler(ScrollEvent.SCROLL, scrollEvent -> scrollEvent.consume());
        worldMapView.addEventHandler(ZoomEvent.ZOOM, zoomEvent -> {
            double d2 = zoomEvent.getZoomFactor();
            worldMapView.setZoomFactor(worldMapView.getZoomFactor() * d2);
            zoomEvent.consume();
        });
        worldMapView.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            this.dragX = mouseEvent.getX();
            this.dragY = mouseEvent.getY();
        });
        worldMapView.addEventHandler(MouseEvent.MOUSE_DRAGGED, mouseEvent -> {
            double d2 = mouseEvent.getX() - this.dragX;
            double d3 = mouseEvent.getY() - this.dragY;
            this.group.setTranslateX(this.group.getTranslateX() + d2);
            this.group.setTranslateY(this.group.getTranslateY() + d3);
            this.dragX = mouseEvent.getX();
            this.dragY = mouseEvent.getY();
        });
        worldMapView.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
            if (mouseEvent.getClickCount() == 2) {
                worldMapView.setZoomFactor(1.0);
                this.group.setTranslateX(0.0);
                this.group.setTranslateY(0.0);
            } else if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
                EventTarget eventTarget = mouseEvent.getTarget();
                if (eventTarget instanceof WorldMapView.CountryView) {
                    WorldMapView.CountryView countryView = (WorldMapView.CountryView)eventTarget;
                    WorldMapView.Country country = countryView.getCountry();
                    boolean bl2 = worldMapView.getSelectedCountries().contains((Object)country);
                    if (worldMapView.getCountrySelectionMode().equals((Object)WorldMapView.SelectionMode.SINGLE) || !mouseEvent.isShortcutDown() && !mouseEvent.isShiftDown()) {
                        worldMapView.getSelectedCountries().clear();
                    }
                    if (bl2) {
                        worldMapView.getSelectedCountries().remove((Object)country);
                    } else {
                        worldMapView.getSelectedCountries().add((Object)country);
                    }
                } else if (eventTarget.equals(this.countryPane)) {
                    worldMapView.getSelectedCountries().clear();
                } else {
                    for (WorldMapView.Location location : this.locationMap.keySet()) {
                        Node node = (Node)this.locationMap.get((Object)location);
                        if (!eventTarget.equals(node)) continue;
                        boolean bl3 = worldMapView.getSelectedLocations().contains((Object)location);
                        if (worldMapView.getLocationSelectionMode().equals((Object)WorldMapView.SelectionMode.SINGLE) || !mouseEvent.isShortcutDown() && !mouseEvent.isShiftDown()) {
                            worldMapView.getSelectedLocations().clear();
                        }
                        if (bl3) {
                            worldMapView.getSelectedLocations().remove((Object)location);
                            break;
                        }
                        worldMapView.getSelectedLocations().add((Object)location);
                        break;
                    }
                }
            }
        });
        Rectangle rectangle = new Rectangle();
        rectangle.widthProperty().bind((ObservableValue)worldMapView.widthProperty());
        rectangle.heightProperty().bind((ObservableValue)worldMapView.heightProperty());
        worldMapView.setClip((Node)rectangle);
        worldMapView.countryViewFactoryProperty().addListener(observable -> this.buildView());
        worldMapView.locationViewFactoryProperty().addListener(observable -> this.buildView());
    }

    private Point2D getLocationCoordinates(WorldMapView.Location location) {
        double d2 = (location.getLongitude() + 180.0) * 2.8027777777777776 + MAP_OFFSET_X;
        double d3 = 332.5 - 1009.0 * Math.log(Math.tan(0.7853981633974483 + Math.toRadians(location.getLatitude()) / 2.0)) / (Math.PI * 2) + MAP_OFFSET_Y;
        return new Point2D(d2, d3);
    }

    private void addLocation(WorldMapView.Location location) {
        Point2D point2D = this.getLocationCoordinates(location);
        Callback<WorldMapView.Location, Node> callback = ((WorldMapView)this.getSkinnable()).getLocationViewFactory();
        Node node = (Node)callback.call((Object)location);
        if (node == null) {
            throw new IllegalArgumentException("location view factory returned NULL");
        }
        node.getStyleClass().add((Object)DEFAULT_STYLE_LOCATION);
        node.setManaged(false);
        this.locationsGroup.getChildren().add((Object)node);
        node.applyCss();
        node.resizeRelocate(point2D.getX(), point2D.getY(), node.prefWidth(-1.0), node.prefHeight(-1.0));
        this.locationMap.put((Object)location, (Object)node);
    }

    private void removeLocation(WorldMapView.Location location) {
        this.locationMap.remove((Object)location);
    }

    private void buildView() {
        this.group.getChildren().clear();
        this.locationsGroup.getChildren().clear();
        if (Double.compare(((WorldMapView)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((WorldMapView)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((WorldMapView)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((WorldMapView)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((WorldMapView)this.getSkinnable()).getPrefWidth() > 0.0 && ((WorldMapView)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((WorldMapView)this.getSkinnable()).setPrefSize(((WorldMapView)this.getSkinnable()).getPrefWidth(), ((WorldMapView)this.getSkinnable()).getPrefHeight());
            } else {
                ((WorldMapView)this.getSkinnable()).setPrefSize(1009.0, 665.0);
            }
        }
        Callback<WorldMapView.Country, WorldMapView.CountryView> callback = ((WorldMapView)this.getSkinnable()).getCountryViewFactory();
        for (WorldMapView.Country country : WorldMapView.Country.values()) {
            if (!((WorldMapView)this.getSkinnable()).getCountries().isEmpty() && !((WorldMapView)this.getSkinnable()).getCountries().contains((Object)country)) continue;
            ArrayList<WorldMapView.CountryView> arrayList = new ArrayList<WorldMapView.CountryView>();
            for (String string : this.countryPathMap.get((Object)country)) {
                WorldMapView.CountryView countryView = (WorldMapView.CountryView)((Object)callback.call((Object)country));
                if (countryView == null) continue;
                countryView.setContent(string);
                countryView.getStyleClass().add(0, (Object)DEFAULT_STYLE_COUNTRY);
                this.group.getChildren().addAll((Object[])new Node[]{countryView});
                arrayList.add(countryView);
            }
            this.countryViewMap.put(country, arrayList);
        }
        for (WorldMapView.Location location : this.locationMap.keySet()) {
            Point2D point2D = this.getLocationCoordinates(location);
            if (!this.group.getLayoutBounds().contains(point2D)) continue;
            this.locationsGroup.getChildren().add((Object)((Node)this.locationMap.get((Object)location)));
        }
        this.group.getChildren().add((Object)this.locationsGroup);
        ((WorldMapView)this.getSkinnable()).requestLayout();
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        super.layoutChildren(d2, d3, d4, d5);
        double d6 = this.group.prefWidth(-1.0);
        double d7 = this.group.prefHeight(-1.0);
        double d8 = d4 / d6;
        double d9 = d5 / d7;
        double d10 = Math.min(d8, d9) * ((WorldMapView)this.getSkinnable()).getZoomFactor();
        this.group.setTranslateX(-this.group.getLayoutBounds().getMinX());
        this.group.setTranslateY(-this.group.getLayoutBounds().getMinY());
        this.group.setScaleX(d10);
        this.group.setScaleY(d10);
        this.group.setLayoutX((d4 - d6) / 2.0);
        this.group.setLayoutY((d5 - d7) / 2.0);
    }

    protected Properties loadData() {
        Properties properties = new Properties();
        try {
            properties.load(WorldMapView.class.getResourceAsStream("worldmap-small.properties"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return properties;
    }
}

