/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2;

import impl.org.controlsfx.tableview2.RowHeader;
import impl.org.controlsfx.tableview2.TableRow2Skin;
import impl.org.controlsfx.tableview2.TableView2Skin;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.WeakEventHandler;
import javafx.scene.control.Skin;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableRow;
import javafx.scene.input.MouseEvent;
import org.controlsfx.control.tableview2.TableView2;

public class TableRow2<S>
extends TableRow<S> {
    private final TableView2<S> tableView;
    private final TableView2Skin<S> skin;
    DoubleProperty verticalShift = new SimpleDoubleProperty();
    TableView2<S> parentTableView = null;
    private final InvalidationListener setPrefHeightListener = observable -> this.setRowHeight(this.computePrefHeight(-1.0));
    private final WeakInvalidationListener weakPrefHeightListener = new WeakInvalidationListener(this.setPrefHeightListener);
    private final EventHandler<MouseEvent> dragDetectedEventHandler = mouseEvent -> {
        if (mouseEvent.getTarget().getClass().equals(TableRow2.class) && mouseEvent.getPickResult().getIntersectedNode() != null && mouseEvent.getPickResult().getIntersectedNode().getClass().equals(TableCell.class)) {
            Event.fireEvent((EventTarget)mouseEvent.getPickResult().getIntersectedNode(), (Event)mouseEvent);
        }
    };
    private final WeakEventHandler<MouseEvent> weakDragHandler = new WeakEventHandler(this.dragDetectedEventHandler);

    public TableRow2(TableView2<S> tableView2) {
        this.tableView = tableView2;
        if (tableView2.getParent() != null && tableView2.getParent() instanceof RowHeader) {
            this.parentTableView = ((RowHeader)tableView2.getParent()).getParentTableView();
        }
        this.skin = (TableView2Skin)(this.parentTableView != null ? this.parentTableView : tableView2).getSkin();
        this.indexProperty().addListener((InvalidationListener)this.weakPrefHeightListener);
        this.visibleProperty().addListener((InvalidationListener)this.weakPrefHeightListener);
        this.skin.rowHeightMap.addListener(change -> {
            if (change.wasAdded() && ((Integer)change.getKey()).intValue() == this.getIndex()) {
                this.setRowHeight((Double)change.getValueAdded());
            } else if (change.wasRemoved() && ((Integer)change.getKey()).intValue() == this.getIndex()) {
                this.setRowHeight(this.computePrefHeight(-1.0));
            }
        });
        this.skin.rowHeightMap.addListener(observable -> {
            if (this.getIndex() > -1 && this.getIndex() < this.skin.rowHeightMap.size()) {
                this.setRowHeight((Double)this.skin.rowHeightMap.getOrDefault((Object)this.getIndex(), (Object)this.computePrefHeight(-1.0)));
            }
        });
        this.addEventHandler(MouseEvent.DRAG_DETECTED, (EventHandler)this.weakDragHandler);
    }

    void addCell(TableCell<S, ?> tableCell) {
        this.getChildren().add(tableCell);
    }

    void removeCell(TableCell<S, ?> tableCell) {
        this.getChildren().remove(tableCell);
    }

    protected double computePrefHeight(double d2) {
        return this.skin.getRowHeight(this.getIndex());
    }

    protected double computeMinHeight(double d2) {
        return this.skin.getRowHeight(this.getIndex());
    }

    protected Skin<?> createDefaultSkin() {
        return new TableRow2Skin<S>(this.tableView, this);
    }

    public void setRowHeight(double d2) {
        this.runOnFXThread(() -> this.setHeight(d2));
        this.setPrefHeight(d2);
    }

    private void runOnFXThread(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }
}

