/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2;

import impl.org.controlsfx.tableview2.NestedTableColumnHeader2;
import impl.org.controlsfx.tableview2.SouthTableColumnHeader;
import impl.org.controlsfx.tableview2.SouthTableHeaderRow;
import impl.org.controlsfx.tableview2.TableView2Skin;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.event.EventHandler;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.skin.NestedTableColumnHeader;
import javafx.scene.control.skin.TableColumnHeader;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.tableview2.TableView2;

public class TableHeaderRow2
extends TableHeaderRow {
    private static final String FIXED_STYLE = "fixed";
    private static final String SELECTED_STYLE = "selected";
    private static final String LEAF_STYLE = "leaf-header";
    final TableView2Skin<?> skin;
    final TableView2<?> control;
    private boolean working = true;
    protected BitSet selectedColumns = new BitSet();
    private final List<TableColumnHeader> visibleLeafHeaders;
    private double scrollX;
    private double tableWidth;
    private final NestedTableColumnHeader header;
    private NestedTableColumnHeader2 rootHeader2;
    private final Region filler;
    private final Pane cornerRegion;
    private final StackPane dragHeader;
    private TableColumnHeader reorderingRegion;
    private final SouthTableHeaderRow southHeaderRow;
    private final InvalidationListener rowHeaderListener = observable -> this.updateTableWidth();
    private final InvalidationListener columnFixingEnabledHeaderListener = observable -> this.updateFixedColumnsStyle();
    private final ListChangeListener<TableColumn> fixedColumnsListener = change -> {
        while (change.next()) {
            change.getRemoved().forEach(this::unfixColumnStyle);
            change.getAddedSubList().forEach(this::fixColumnStyle);
        }
        this.updateHighlightSelection();
    };
    private final InvalidationListener selectionListener = observable -> this.updateHighlightSelection();
    private final EventHandler<KeyEvent> cancelDrag = keyEvent -> {
        if (this.isReordering() && keyEvent.getCode() == KeyCode.ESCAPE) {
            this.setReordering(false);
            TableColumnHeader tableColumnHeader = this.getReorderingRegion();
            if (tableColumnHeader != null) {
                tableColumnHeader.getTableColumn().setReorderable(false);
            }
        }
    };

    public TableHeaderRow2(TableView2Skin<?> tableView2Skin) {
        super(tableView2Skin);
        this.skin = tableView2Skin;
        this.control = (TableView2)tableView2Skin.getSkinnable();
        this.visibleLeafHeaders = new ArrayList<TableColumnHeader>();
        this.buildVisibleLeafColumnHeaders((List<TableColumnHeader>)this.getRootHeader().getColumnHeaders(), this.visibleLeafHeaders);
        this.filler = (Region)this.getChildrenUnmodifiable().get(0);
        this.header = (NestedTableColumnHeader)this.getChildrenUnmodifiable().get(1);
        this.cornerRegion = (Pane)this.getChildrenUnmodifiable().get(2);
        this.dragHeader = (StackPane)this.getChildrenUnmodifiable().get(3);
        this.southHeaderRow = new SouthTableHeaderRow(tableView2Skin);
        this.getChildren().add(0, (Object)this.southHeaderRow);
    }

    public void init() {
        this.updateColumnHeaderVisibility(this.skin.isColumnHeaderVisible());
        this.control.rowHeaderVisibleProperty().addListener(this.rowHeaderListener);
        if (this.skin.rowHeader != null) {
            this.skin.rowHeader.rowHeaderWidthProperty().addListener(this.rowHeaderListener);
        }
        this.control.columnFixingEnabledProperty().addListener(this.columnFixingEnabledHeaderListener);
        this.control.itemsProperty().addListener(this.columnFixingEnabledHeaderListener);
        this.skin.getSelectedColumns().addListener(this.selectionListener);
        this.control.getFixedColumns().addListener(this.fixedColumnsListener);
        Platform.runLater(() -> {
            this.updateFixedColumnsStyle();
            this.requestLayout();
            this.updateVisibleLeafColumnHeaders();
            this.updateVisibleLeafStyle();
        });
        this.getRootHeader().getColumnHeaders().addListener(observable -> {
            this.updateFixedColumnsStyle();
            this.updateHighlightSelection();
            this.updateVisibleLeafStyle();
        });
        this.control.addEventHandler(KeyEvent.KEY_PRESSED, this.cancelDrag);
        this.southHeaderRow.heightProperty().addListener(observable -> this.updateVisibleLeafStyle());
        this.control.southHeaderBlendedProperty().addListener(observable -> this.updateVisibleLeafStyle());
    }

    public SouthTableHeaderRow getSouthHeaderRow() {
        return this.southHeaderRow;
    }

    protected void layoutChildren() {
        double d2 = this.scrollX;
        double d3 = this.snapSize(this.header.prefWidth(-1.0));
        double d4 = this.southHeaderRow.prefHeight(d3);
        this.southHeaderRow.resizeRelocate(d2, this.getHeight() - this.snappedBottomInset() - d4, d3, d4);
        double d5 = this.getHeight() - this.snappedTopInset() - this.snappedBottomInset();
        double d6 = this.snapSize(this.skin.getFlow().getVerticalBar().prefWidth(-1.0));
        this.header.resizeRelocate(d2, this.snappedTopInset(), d3, d5 - d4);
        if (this.control == null) {
            return;
        }
        double d7 = this.control.snappedLeftInset() + this.control.snappedRightInset();
        double d8 = this.tableWidth - d3 + this.filler.getInsets().getLeft() - d7;
        this.filler.setVisible((d8 -= this.control.tableMenuButtonVisibleProperty().get() ? d6 : 0.0) > 0.0);
        if (d8 > 0.0) {
            this.filler.resizeRelocate(d2 + d3, this.snappedTopInset(), d8, d5);
        }
        this.cornerRegion.resizeRelocate(this.tableWidth - d6, this.snappedTopInset(), d6, d5);
    }

    void clearSelectedColumns() {
        this.selectedColumns.clear();
    }

    protected void updateTableWidth() {
        super.updateTableWidth();
        double d2 = 0.0;
        if (this.working && this.skin != null && this.control != null && this.control.rowHeaderVisibleProperty().get() && this.skin.rowHeader != null) {
            d2 += this.skin.rowHeader.getRowHeaderWidth();
        }
        Rectangle rectangle = (Rectangle)this.getClip();
        this.tableWidth = rectangle.getWidth();
        rectangle.setWidth(rectangle.getWidth() == 0.0 ? 0.0 : rectangle.getWidth() - d2);
    }

    protected void updateScrollX() {
        this.scrollX = this.skin.getFlow().getHorizontalBar().isVisible() ? -this.skin.getFlow().getHorizontalBar().getValue() : 0.0;
        this.requestLayout();
        this.layout();
        if (this.working) {
            this.requestLayout();
            if (this.rootHeader2 == null) {
                this.createRootHeader();
            }
            this.rootHeader2.layoutFixedColumns();
        }
        this.skin.getSouthHeader().updateScrollX();
    }

    protected NestedTableColumnHeader createRootHeader() {
        this.rootHeader2 = new NestedTableColumnHeader2(null);
        return this.rootHeader2;
    }

    protected void updateVisibleLeafColumnHeaders() {
        this.visibleLeafHeaders.clear();
        this.buildVisibleLeafColumnHeaders((List<TableColumnHeader>)this.getRootHeader().getColumnHeaders(), this.visibleLeafHeaders);
        this.updateHighlightSelection();
    }

    public TableColumnHeader getReorderingRegion() {
        return this.reorderingRegion;
    }

    public void setReorderingRegion(final TableColumnHeader tableColumnHeader) {
        this.reorderingRegion = tableColumnHeader;
        if (tableColumnHeader != null) {
            this.dragHeader.resize(tableColumnHeader.getWidth(), tableColumnHeader.getHeight());
            this.reorderingProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    TableHeaderRow2.this.dragHeader.setLayoutX(-TableHeaderRow2.this.skin.rowHeader.getRowHeaderWidth());
                    TableHeaderRow2.this.dragHeader.setTranslateY(TableHeaderRow2.this.dragHeader.getTranslateY() - TableHeaderRow2.this.southHeaderRow.getHeight());
                    TableHeaderRow2.this.dragHeader.resize(tableColumnHeader.getWidth(), TableHeaderRow2.this.dragHeader.getHeight() + TableHeaderRow2.this.southHeaderRow.getHeight());
                    TableHeaderRow2.this.reorderingProperty().removeListener((InvalidationListener)this);
                }
            });
        }
    }

    private void fixColumnStyle(TableColumn tableColumn) {
        int n2 = this.skin.getViewColumn(this.control.getColumns().indexOf((Object)tableColumn));
        if (this.getRootHeader().getColumnHeaders().size() > n2) {
            if (this.control.isColumnFixingEnabled() && this.control.getItems() != null && tableColumn.isVisible()) {
                this.addStyleHeader((TableColumnHeader)this.getRootHeader().getColumnHeaders().get(n2), FIXED_STYLE);
                this.addStyleSouthHeader(tableColumn, FIXED_STYLE);
            } else {
                this.removeStyleHeader((TableColumnHeader)this.getRootHeader().getColumnHeaders().get(n2), FIXED_STYLE);
                this.removeStyleSouthHeader(tableColumn, FIXED_STYLE);
            }
        }
    }

    private void unfixColumnStyle(TableColumn tableColumn) {
        int n2 = this.skin.getViewColumn(this.control.getColumns().indexOf((Object)tableColumn));
        if (this.getRootHeader().getColumnHeaders().size() > n2) {
            this.removeStyleHeader((TableColumnHeader)this.getRootHeader().getColumnHeaders().get(n2), FIXED_STYLE);
        }
        this.removeStyleSouthHeader(tableColumn, FIXED_STYLE);
    }

    private void removeStyleHeader(TableColumnHeader tableColumnHeader2, String string) {
        if (tableColumnHeader2 instanceof NestedTableColumnHeader) {
            ((NestedTableColumnHeader)tableColumnHeader2).getChildrenUnmodifiable().stream().filter(TableColumnHeader.class::isInstance).map(TableColumnHeader.class::cast).forEach(tableColumnHeader -> this.removeStyleHeader((TableColumnHeader)tableColumnHeader, string));
        } else if (tableColumnHeader2.getStyleClass().contains((Object)string)) {
            tableColumnHeader2.getStyleClass().remove((Object)string);
        }
    }

    private void addStyleHeader(TableColumnHeader tableColumnHeader2, String string) {
        if (tableColumnHeader2 instanceof NestedTableColumnHeader) {
            ((NestedTableColumnHeader)tableColumnHeader2).getChildrenUnmodifiable().stream().filter(TableColumnHeader.class::isInstance).map(TableColumnHeader.class::cast).forEach(tableColumnHeader -> this.addStyleHeader((TableColumnHeader)tableColumnHeader, string));
        } else if (!tableColumnHeader2.getStyleClass().contains((Object)string)) {
            tableColumnHeader2.getStyleClass().add((Object)string);
        }
    }

    private void addStyleSouthHeader(TableColumn<?, ?> tableColumn2, String string) {
        SouthTableColumnHeader southTableColumnHeader = this.southHeaderRow.getSouthColumnHeaderFor((TableColumnBase<?, ?>)tableColumn2);
        if (southTableColumnHeader != null) {
            if (!southTableColumnHeader.getStyleClass().contains((Object)string)) {
                southTableColumnHeader.getStyleClass().add((Object)string);
            }
        } else {
            tableColumn2.getColumns().forEach(tableColumn -> this.addStyleSouthHeader((TableColumn<?, ?>)tableColumn, string));
        }
    }

    private void removeStyleSouthHeader(TableColumn<?, ?> tableColumn2, String string) {
        SouthTableColumnHeader southTableColumnHeader = this.southHeaderRow.getSouthColumnHeaderFor((TableColumnBase<?, ?>)tableColumn2);
        if (southTableColumnHeader != null) {
            if (southTableColumnHeader.getStyleClass().contains((Object)string)) {
                southTableColumnHeader.getStyleClass().remove((Object)string);
            }
        } else {
            tableColumn2.getColumns().forEach(tableColumn -> this.removeStyleSouthHeader((TableColumn<?, ?>)tableColumn, string));
        }
    }

    private void updateHighlightSelection() {
        this.removeStyleHeader((TableColumnHeader)this.getRootHeader(), SELECTED_STYLE);
        this.visibleLeafHeaders.forEach(tableColumnHeader -> this.removeStyleSouthHeader((TableColumn)tableColumnHeader.getTableColumn(), SELECTED_STYLE));
        this.skin.getSelectedColumns().forEach(n2 -> {
            if (this.visibleLeafHeaders.size() > n2 && !this.visibleLeafHeaders.get((int)n2).getStyleClass().contains((Object)SELECTED_STYLE)) {
                this.visibleLeafHeaders.get((int)n2).getStyleClass().add((Object)SELECTED_STYLE);
                this.addStyleSouthHeader((TableColumn)this.visibleLeafHeaders.get((int)n2).getTableColumn(), SELECTED_STYLE);
            }
        });
    }

    private void buildVisibleLeafColumnHeaders(List<TableColumnHeader> list, List<TableColumnHeader> list2) {
        list.stream().filter(Objects::nonNull).forEachOrdered(tableColumnHeader -> {
            if (tableColumnHeader instanceof NestedTableColumnHeader) {
                this.buildVisibleLeafColumnHeaders((List<TableColumnHeader>)((NestedTableColumnHeader)tableColumnHeader).getColumnHeaders(), list2);
            } else if (tableColumnHeader.isVisible()) {
                list2.add((TableColumnHeader)tableColumnHeader);
            }
        });
    }

    private void updateColumnHeaderVisibility(boolean bl2) {
        this.working = bl2;
        this.setManaged(this.working);
        if (!bl2) {
            this.getStyleClass().add((Object)"invisible");
        } else {
            this.getStyleClass().remove((Object)"invisible");
            this.requestLayout();
            if (this.rootHeader2 == null) {
                this.createRootHeader();
            }
            this.rootHeader2.layoutFixedColumns();
            this.updateHighlightSelection();
        }
    }

    private void updateFixedColumnsStyle() {
        Platform.runLater(() -> this.control.getFixedColumns().forEach(this::fixColumnStyle));
    }

    private void updateVisibleLeafStyle() {
        this.removeStyleHeader((TableColumnHeader)this.getRootHeader(), LEAF_STYLE);
        if (this.southHeaderRow.getHeight() > 0.0) {
            this.visibleLeafHeaders.forEach(tableColumnHeader -> tableColumnHeader.getStyleClass().add((Object)LEAF_STYLE));
        }
        this.removeStyleHeader((TableColumnHeader)this.getRootHeader(), "south");
        if (this.southHeaderRow.getHeight() > 0.0 && this.control.isSouthHeaderBlended()) {
            this.visibleLeafHeaders.forEach(tableColumnHeader -> tableColumnHeader.getStyleClass().add((Object)"south"));
        }
    }

    protected double computePrefHeight(double d2) {
        if (!this.skin.isColumnHeaderVisible()) {
            return 0.0;
        }
        double d3 = this.getRootHeader().prefHeight(d2);
        d3 = d3 == 0.0 ? 24.0 : d3;
        double d4 = this.southHeaderRow.prefHeight(d2);
        return this.snappedTopInset() + d3 + d4 + this.snappedBottomInset();
    }
}

