/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2;

import impl.org.controlsfx.tableview2.RowHeader;
import impl.org.controlsfx.tableview2.TableView2Skin;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.skin.NestedTableColumnHeader;
import javafx.scene.control.skin.TableColumnHeader;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.tableview2.TableView2;

public class NestedTableColumnHeader2
extends NestedTableColumnHeader {
    int lastColumnResized = -1;
    private TableView2Skin<?> skin;
    private TableView2<?> tableView;

    public NestedTableColumnHeader2(TableColumnBase<?, ?> tableColumnBase) {
        super(tableColumnBase);
    }

    private void init() {
        this.skin = (TableView2Skin)this.getTableSkin();
        this.tableView = (TableView2)this.skin.getSkinnable();
        this.widthProperty().addListener(observable -> this.skin.hBarValue.clear());
        this.getColumnHeaders().addListener(observable -> this.skin.getTableHeaderRow2().updateVisibleLeafColumnHeaders());
        this.tableView.getVisibleLeafColumns().addListener(observable -> this.skin.getTableHeaderRow2().updateVisibleLeafColumnHeaders());
    }

    protected TableColumnHeader createTableColumnHeader(TableColumnBase tableColumnBase) {
        if (tableColumnBase == null || tableColumnBase.getColumns().isEmpty() || tableColumnBase == this.getTableColumn()) {
            TableColumnHeader tableColumnHeader = new TableColumnHeader(tableColumnBase);
            this.addMousePressedListener(tableColumnHeader);
            this.addMouseReleasedListener(tableColumnHeader);
            return tableColumnHeader;
        }
        NestedTableColumnHeader2 nestedTableColumnHeader2 = new NestedTableColumnHeader2(tableColumnBase);
        final ObservableList observableList = nestedTableColumnHeader2.getChildren();
        observableList.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (observableList.size() > 0) {
                    TableColumnHeader tableColumnHeader = (TableColumnHeader)observableList.get(0);
                    NestedTableColumnHeader2.this.addMouseReleasedListener(tableColumnHeader);
                    observableList.removeListener((InvalidationListener)this);
                }
            }
        });
        this.addMousePressedListener((TableColumnHeader)nestedTableColumnHeader2);
        return nestedTableColumnHeader2;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.layoutFixedColumns();
        this.updateDragRectangles();
    }

    public void layoutFixedColumns() {
        if (this.skin == null && this.tableView == null) {
            this.init();
        }
        if (this.skin == null || this.getChildren().isEmpty()) {
            return;
        }
        double d2 = this.getHeight() - this.snappedTopInset() - this.snappedBottomInset();
        double d3 = this.skin.getHBar().getValue();
        int n2 = (int)((Node)this.getChildren().get(0)).prefHeight(-1.0);
        double d4 = 0.0;
        double d5 = this.snappedLeftInset();
        int n3 = this.getColumnHeaders().size();
        n3 = n3 > this.tableView.getVisibleLeafColumns().size() ? this.tableView.getVisibleLeafColumns().size() : n3;
        n3 = n3 > this.tableView.getColumns().size() ? this.tableView.getColumns().size() : n3;
        for (int i2 = 0; i2 < n3; ++i2) {
            boolean bl2;
            TableColumnHeader tableColumnHeader = (TableColumnHeader)this.getColumnHeaders().get(i2);
            if (!tableColumnHeader.isVisible()) continue;
            double d6 = this.snapSize(tableColumnHeader.prefWidth(-1.0));
            tableColumnHeader.resize(d6, this.snapSize(d2 - (double)n2));
            TableColumn tableColumn = (TableColumn)tableColumnHeader.getTableColumn();
            boolean bl3 = bl2 = tableColumn.getParentColumn() != null;
            while (tableColumn.getParentColumn() != null) {
                tableColumn = (TableColumn)tableColumn.getParentColumn();
            }
            if (this.tableView.isColumnFixingEnabled() && this.tableView.getFixedColumns().contains((Object)tableColumn)) {
                double d7 = 0.0;
                if (d3 + d4 > d5) {
                    d7 = Math.abs((bl2 ? 0.0 : d3) + d4 - d5);
                    tableColumnHeader.toFront();
                    d4 += d6;
                }
                tableColumnHeader.relocate(d5 + d7, (double)n2 + this.snappedTopInset());
            }
            d5 += d6;
        }
    }

    private void updateDragRectangles() {
        this.getChildren().removeIf(node -> node instanceof Rectangle && (node.getLayoutX() < 1.0 || this.tableView.getParent() instanceof RowHeader));
    }

    private void addMouseReleasedListener(TableColumnHeader tableColumnHeader) {
        tableColumnHeader.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            TableColumnHeader tableColumnHeader2 = this.skin.getTableHeaderRow2().getReorderingRegion();
            if (tableColumnHeader.equals(tableColumnHeader2)) {
                tableColumnHeader.getTableColumn().setReorderable(true);
            }
            if (mouseEvent.getButton() != MouseButton.PRIMARY) {
                mouseEvent.consume();
            }
        });
    }

    private void addMousePressedListener(TableColumnHeader tableColumnHeader) {
        tableColumnHeader.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            ContextMenu contextMenu = tableColumnHeader.getTableColumn().getContextMenu();
            if (contextMenu != null && contextMenu.isShowing()) {
                contextMenu.hide();
            }
        });
    }
}

