/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.collections.MappingChange;
import impl.org.controlsfx.collections.NonIterableChange;
import impl.org.controlsfx.collections.ReadOnlyUnbackedObservableList;
import impl.org.controlsfx.spreadsheet.FocusModelListener;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SelectedCellsMapTemp;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.VerticalHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import javafx.util.Pair;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class TableViewSpanSelectionModel
extends TableView.TableViewSelectionModel<ObservableList<SpreadsheetCell>> {
    private boolean shift = false;
    private boolean key = false;
    private boolean drag = false;
    private MouseEvent mouseEvent;
    private boolean makeAtomic;
    private SpreadsheetGridView cellsView;
    private SpreadsheetView spreadsheetView;
    private final SelectedCellsMapTemp<TablePosition<ObservableList<SpreadsheetCell>, ?>> selectedCellsMap;
    private final ReadOnlyUnbackedObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>> selectedCellsSeq;
    private TableColumn oldTableColumn = null;
    private int oldRow = -1;
    public Pair<Integer, Integer> direction;
    private int oldColSpan = -1;
    private int oldRowSpan = -1;
    private final Timeline timer;
    private final EventHandler<ActionEvent> timerEventHandler = actionEvent -> {
        GridViewSkin gridViewSkin = this.getCellsViewSkin();
        if (this.mouseEvent != null && !this.cellsView.contains(this.mouseEvent.getX(), this.mouseEvent.getY())) {
            double d2 = this.mouseEvent.getSceneX();
            double d3 = this.mouseEvent.getSceneY();
            double d4 = this.cellsView.getLocalToSceneTransform().getTx();
            double d5 = this.cellsView.getLocalToSceneTransform().getTy();
            double d6 = d4 + this.cellsView.getWidth();
            double d7 = d5 + this.cellsView.getHeight();
            if (d2 > d6) {
                gridViewSkin.getHBar().increment();
            } else if (d2 < d4) {
                gridViewSkin.getHBar().decrement();
            }
            if (d3 > d7) {
                gridViewSkin.getVBar().increment();
            } else if (d3 < d5) {
                gridViewSkin.getVBar().decrement();
            }
        }
    };
    private final EventHandler<MouseEvent> dragDoneHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            TableViewSpanSelectionModel.this.drag = false;
            TableViewSpanSelectionModel.this.timer.stop();
            TableViewSpanSelectionModel.this.spreadsheetView.removeEventHandler(MouseEvent.MOUSE_RELEASED, this);
        }
    };
    private final EventHandler<KeyEvent> keyPressedEventHandler = keyEvent -> {
        this.key = true;
        this.shift = keyEvent.isShiftDown();
    };
    private final EventHandler<MouseEvent> mousePressedEventHandler = mouseEvent -> {
        this.key = false;
        this.shift = mouseEvent.isShiftDown();
    };
    private final EventHandler<MouseEvent> onDragDetectedEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            TableViewSpanSelectionModel.this.cellsView.addEventHandler(MouseEvent.MOUSE_RELEASED, TableViewSpanSelectionModel.this.dragDoneHandler);
            TableViewSpanSelectionModel.this.drag = true;
            TableViewSpanSelectionModel.this.timer.setCycleCount(-1);
            TableViewSpanSelectionModel.this.timer.play();
        }
    };
    private final EventHandler<MouseEvent> onMouseDragEventHandler = mouseEvent -> {
        this.mouseEvent = mouseEvent;
    };
    private final ListChangeListener<TablePosition<ObservableList<SpreadsheetCell>, ?>> listChangeListener = this::handleSelectedCellsListChangeEvent;
    private TablePosition<ObservableList<SpreadsheetCell>, ?> old = null;

    public TableViewSpanSelectionModel(@NamedArg(value="spreadsheetView") SpreadsheetView spreadsheetView, @NamedArg(value="cellsView") SpreadsheetGridView spreadsheetGridView) {
        super((TableView)spreadsheetGridView);
        this.cellsView = spreadsheetGridView;
        this.spreadsheetView = spreadsheetView;
        this.timer = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), (EventHandler)new WeakEventHandler(this.timerEventHandler), new KeyValue[0])});
        spreadsheetGridView.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new WeakEventHandler(this.keyPressedEventHandler));
        spreadsheetGridView.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new WeakEventHandler(this.mousePressedEventHandler));
        spreadsheetGridView.setOnDragDetected((EventHandler)new WeakEventHandler(this.onDragDetectedEventHandler));
        spreadsheetGridView.setOnMouseDragged((EventHandler)new WeakEventHandler(this.onMouseDragEventHandler));
        this.selectedCellsMap = new SelectedCellsMapTemp(new WeakListChangeListener(this.listChangeListener));
        this.selectedCellsSeq = new ReadOnlyUnbackedObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>>(){

            @Override
            public TablePosition<ObservableList<SpreadsheetCell>, ?> get(int n2) {
                return TableViewSpanSelectionModel.this.selectedCellsMap.get(n2);
            }

            @Override
            public int size() {
                return TableViewSpanSelectionModel.this.selectedCellsMap.size();
            }
        };
    }

    private void handleSelectedCellsListChangeEvent(ListChangeListener.Change<? extends TablePosition<ObservableList<SpreadsheetCell>, ?>> change) {
        if (this.makeAtomic) {
            return;
        }
        this.selectedCellsSeq.callObservers(new MappingChange(change, MappingChange.NOOP_MAP, (ObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>>)this.selectedCellsSeq));
        change.reset();
    }

    public void select(int n2, TableColumn<ObservableList<SpreadsheetCell>, ?> tableColumn) {
        if (n2 < 0 || n2 >= this.getItemCount()) {
            return;
        }
        if (this.isCellSelectionEnabled() && tableColumn == null) {
            return;
        }
        TablePosition tablePosition = new TablePosition(this.getTableView(), n2, tableColumn);
        int n3 = this.cellsView.getColumns().indexOf((Object)tablePosition.getTableColumn());
        SpreadsheetView.SpanType spanType = this.spreadsheetView.getSpanType(n2, n3);
        switch (spanType) {
            case ROW_SPAN_INVISIBLE: {
                int n4;
                if (this.old != null && !this.shift && this.old.getColumn() == tablePosition.getColumn() && this.old.getRow() == tablePosition.getRow() - 1 && (n4 = FocusModelListener.getNextRowNumber(this.old, this.cellsView, this.spreadsheetView)) < this.getItemCount()) {
                    tablePosition = this.getVisibleCell(n4, this.oldColSpan > 1 ? this.oldTableColumn : this.old.getTableColumn());
                    break;
                }
                tablePosition = this.getVisibleCell(n2, this.oldColSpan > 1 ? this.oldTableColumn : tableColumn);
                break;
            }
            case BOTH_INVISIBLE: {
                tablePosition = this.getVisibleCell(n2, tableColumn);
                break;
            }
            case COLUMN_SPAN_INVISIBLE: {
                tablePosition = this.old != null && !this.shift && this.old.getColumn() == tablePosition.getColumn() - 1 && this.old.getRow() == tablePosition.getRow() ? this.getVisibleCell(this.oldRowSpan > 1 ? this.oldRow : this.old.getRow(), FocusModelListener.getTableColumnSpan(this.old, this.cellsView, this.spreadsheetView)) : this.getVisibleCell(n2, tableColumn);
            }
            default: {
                if (this.direction == null || !this.key) break;
                if ((Integer)this.direction.getKey() != 0 && this.oldColSpan > 1) {
                    tablePosition = this.getVisibleCell(tablePosition.getRow(), this.oldTableColumn);
                    break;
                }
                if ((Integer)this.direction.getValue() == 0 || this.oldRowSpan <= 1) break;
                tablePosition = this.getVisibleCell(this.oldRow, tablePosition.getTableColumn());
            }
        }
        this.old = tablePosition;
        if (tablePosition.getTableColumn() == null) {
            return;
        }
        if (!this.key) {
            this.oldRow = this.old.getRow();
            this.oldTableColumn = this.old.getTableColumn();
        } else if (this.direction != null && (Integer)this.direction.getKey() != 0) {
            this.oldRow = this.old.getRow();
        } else if (this.direction != null && (Integer)this.direction.getValue() != 0) {
            this.oldTableColumn = this.old.getTableColumn();
        }
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)this.old.getTableColumn().getCellData(this.old.getRow());
        this.oldRowSpan = this.spreadsheetView.getRowSpan(spreadsheetCell, this.old.getRow());
        this.oldColSpan = this.spreadsheetView.getColumnSpan(spreadsheetCell);
        for (int i2 = this.old.getRow(); i2 < this.oldRowSpan + this.old.getRow(); ++i2) {
            for (int i3 = this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()); i3 < this.oldColSpan + this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()); ++i3) {
                tablePosition = new TablePosition(this.getTableView(), i2, this.getTableView().getVisibleLeafColumn(i3));
                this.selectedCellsMap.add(tablePosition);
            }
        }
        this.updateScroll(this.old);
        this.addSelectedRowsAndColumns(this.old);
        this.setSelectedIndex(this.old.getRow());
        this.setSelectedItem((ObservableList)this.getModelItem(this.old.getRow()));
        if (this.getTableView().getFocusModel() == null) {
            return;
        }
        this.getTableView().getFocusModel().focus(this.old.getRow(), this.old.getTableColumn());
    }

    private void updateScroll(TablePosition<ObservableList<SpreadsheetCell>, ?> tablePosition) {
        if (!this.drag && this.key && this.getCellsViewSkin().getCellsSize() != 0 && !VerticalHeader.isFixedRowEmpty(this.spreadsheetView)) {
            int n2 = this.getCellsViewSkin().getRow(0).getIndex();
            double d2 = 0.0;
            for (int i2 = n2; i2 < tablePosition.getRow(); ++i2) {
                d2 += this.getSpreadsheetViewSkin().getRowHeight(i2);
            }
            if (this.getCellsViewSkin().getFixedRowHeight() > d2) {
                this.cellsView.scrollTo(tablePosition.getRow());
            }
        }
    }

    public void clearSelection(int n2, TableColumn<ObservableList<SpreadsheetCell>, ?> tableColumn) {
        TablePosition tablePosition = new TablePosition(this.getTableView(), n2, tableColumn);
        if (tablePosition.getRow() < 0 || tablePosition.getColumn() < 0) {
            return;
        }
        List<TablePosition<ObservableList<SpreadsheetCell>, ?>> list = this.isSelectedRange(n2, tableColumn, tablePosition.getColumn());
        if (list != null) {
            for (TablePosition<ObservableList<SpreadsheetCell>, ?> tablePosition2 : list) {
                this.selectedCellsMap.remove(tablePosition2);
                this.removeSelectedRowsAndColumns(tablePosition2);
                this.focus(tablePosition2.getRow());
            }
        } else {
            for (TablePosition tablePosition3 : this.getSelectedCells()) {
                if (!tablePosition3.equals((Object)tablePosition)) continue;
                this.selectedCellsMap.remove(tablePosition3);
                this.removeSelectedRowsAndColumns(tablePosition3);
                this.focus(n2);
                return;
            }
        }
    }

    public void verifySelectedCells(List<Pair<Integer, Integer>> list) {
        Object object2;
        HashSet<TablePosition> hashSet = new HashSet<TablePosition>();
        this.clearSelection();
        int n2 = this.getItemCount();
        int n3 = this.getTableView().getVisibleLeafColumns().size();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        HashSet<Integer> hashSet3 = new HashSet<Integer>();
        TablePosition tablePosition = null;
        for (Object object2 : list) {
            TableColumn tableColumn;
            SpreadsheetCell spreadsheetCell;
            if ((Integer)object2.getKey() < 0 || (Integer)object2.getKey() >= n2 || (Integer)object2.getValue() < 0 || (Integer)object2.getValue() >= n3 || (spreadsheetCell = (SpreadsheetCell)(tableColumn = this.getTableView().getVisibleLeafColumn(((Integer)object2.getValue()).intValue())).getCellData((tablePosition = this.getVisibleCell((Integer)object2.getKey(), tableColumn)).getRow())) == null) continue;
            int n4 = this.spreadsheetView.getRowSpan(spreadsheetCell, tablePosition.getRow());
            int n5 = tablePosition.getRow();
            for (int i2 = tablePosition.getRow(); i2 < n4 + n5; ++i2) {
                hashSet3.add(i2);
                for (int i3 = this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()); i3 < this.spreadsheetView.getColumnSpan(spreadsheetCell) + this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()); ++i3) {
                    hashSet2.add(i3);
                    tablePosition = new TablePosition(this.getTableView(), i2, this.getTableView().getVisibleLeafColumn(i3));
                    hashSet.add(tablePosition);
                }
            }
        }
        this.selectedCellsMap.setAll(hashSet);
        Iterator<Pair<Integer, Integer>> iterator = tablePosition;
        object2 = this.getSpreadsheetViewSkin();
        if (object2 == null) {
            this.cellsView.skinProperty().addListener(new InvalidationListener((TablePosition)iterator, hashSet2, hashSet3){
                final /* synthetic */ TablePosition val$finalPos;
                final /* synthetic */ HashSet val$selectedRows;
                final /* synthetic */ HashSet val$selectedColumns;
                {
                    this.val$finalPos = tablePosition;
                    this.val$selectedRows = hashSet;
                    this.val$selectedColumns = hashSet2;
                }

                public void invalidated(Observable observable) {
                    TableViewSpanSelectionModel.this.cellsView.skinProperty().removeListener((InvalidationListener)this);
                    GridViewSkin gridViewSkin = TableViewSpanSelectionModel.this.getSpreadsheetViewSkin();
                    if (gridViewSkin != null) {
                        TableViewSpanSelectionModel.this.updateSelectedVisuals(gridViewSkin, this.val$finalPos, this.val$selectedRows, this.val$selectedColumns);
                    }
                }
            });
        } else {
            this.updateSelectedVisuals((GridViewSkin)((Object)object2), tablePosition, hashSet2, hashSet3);
        }
    }

    private void updateSelectedVisuals(GridViewSkin gridViewSkin, TablePosition tablePosition, HashSet<Integer> hashSet, HashSet<Integer> hashSet2) {
        if (gridViewSkin != null) {
            gridViewSkin.getSelectedRows().addAll(hashSet2);
            gridViewSkin.getSelectedColumns().addAll(hashSet);
        }
        if (tablePosition != null) {
            this.getCellsViewSkin().lastRowLayout.set(true);
            this.getCellsViewSkin().lastRowLayout.addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    TableViewSpanSelectionModel.this.handleSelectedCellsListChangeEvent(new NonIterableChange.SimpleAddChange(0, TableViewSpanSelectionModel.this.selectedCellsMap.size(), (ObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>>)TableViewSpanSelectionModel.this.selectedCellsSeq));
                    TableViewSpanSelectionModel.this.getCellsViewSkin().lastRowLayout.removeListener((InvalidationListener)this);
                }
            });
        }
    }

    public void selectRange(int n2, TableColumnBase<ObservableList<SpreadsheetCell>, ?> tableColumnBase, int n3, TableColumnBase<ObservableList<SpreadsheetCell>, ?> tableColumnBase2) {
        int n4;
        int n5;
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
            this.select(n3, tableColumnBase2);
            return;
        }
        this.makeAtomic = true;
        int n6 = this.getItemCount();
        int n7 = this.getTableView().getVisibleLeafIndex((TableColumn)tableColumnBase);
        int n8 = this.getTableView().getVisibleLeafIndex((TableColumn)tableColumnBase2);
        int n9 = Math.min(n7, n8);
        int n10 = Math.max(n7, n8);
        int n11 = Math.min(n2, n3);
        int n12 = Math.max(n2, n3);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        for (n5 = n11; n5 <= n12; ++n5) {
            for (n4 = n9; n4 <= n10; ++n4) {
                int n13;
                TableColumn tableColumn;
                if (n5 < 0 || n5 >= n6 || (tableColumn = this.getTableView().getVisibleLeafColumn(n4)) == null) continue;
                TablePosition tablePosition = this.getVisibleCell(n5, tableColumn);
                SpreadsheetCell spreadsheetCell = (SpreadsheetCell)tableColumn.getCellData(tablePosition.getRow());
                int n14 = this.spreadsheetView.getRowSpan(spreadsheetCell, tablePosition.getRow());
                for (int i2 = n13 = tablePosition.getRow(); i2 < n14 + n13; ++i2) {
                    hashSet.add(i2);
                    for (int i3 = this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()); i3 < this.spreadsheetView.getColumnSpan(spreadsheetCell) + this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()); ++i3) {
                        hashSet2.add(i3);
                        tablePosition = new TablePosition(this.getTableView(), i2, this.getTableView().getVisibleLeafColumn(i3));
                        this.selectedCellsMap.add(tablePosition);
                    }
                }
            }
        }
        this.makeAtomic = false;
        this.getSpreadsheetViewSkin().getSelectedRows().addAll(hashSet);
        this.getSpreadsheetViewSkin().getSelectedColumns().addAll(hashSet2);
        this.setSelectedIndex(n3);
        this.setSelectedItem((ObservableList)this.getModelItem(n3));
        if (this.getTableView().getFocusModel() == null) {
            return;
        }
        this.getTableView().getFocusModel().focus(n3, (TableColumn)tableColumnBase2);
        n5 = this.selectedCellsMap.indexOf(new TablePosition(this.getTableView(), n2, (TableColumn)tableColumnBase));
        n4 = this.selectedCellsMap.getSelectedCells().size() - 1;
        if (n5 > -1 && n4 > -1) {
            int n15 = Math.min(n5, n4);
            int n16 = Math.max(n5, n4);
            this.handleSelectedCellsListChangeEvent(new NonIterableChange.SimpleAddChange(n15, n16 + 1, (ObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>>)this.selectedCellsSeq));
        }
    }

    public void selectAll() {
        int n2;
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        this.quietClearSelection();
        ArrayList<TablePosition> arrayList = new ArrayList<TablePosition>();
        TablePosition tablePosition = null;
        for (int i2 = 0; i2 < this.getTableView().getVisibleLeafColumns().size(); ++i2) {
            TableColumn tableColumn = (TableColumn)this.getTableView().getVisibleLeafColumns().get(i2);
            for (n2 = 0; n2 < this.getItemCount(); ++n2) {
                tablePosition = new TablePosition(this.getTableView(), n2, tableColumn);
                arrayList.add(tablePosition);
            }
        }
        this.selectedCellsMap.setAll(arrayList);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n2 = 0; n2 < this.spreadsheetView.getGrid().getColumnCount(); ++n2) {
            arrayList2.add(n2);
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i3 = 0; i3 < this.getItemCount(); ++i3) {
            arrayList3.add(i3);
        }
        this.getSpreadsheetViewSkin().getSelectedRows().addAll(arrayList3);
        this.getSpreadsheetViewSkin().getSelectedColumns().addAll(arrayList2);
        if (tablePosition != null) {
            this.select(tablePosition.getRow(), tablePosition.getTableColumn());
            this.getTableView().getFocusModel().focus(0, (TableColumn)this.getTableView().getColumns().get(0));
        }
    }

    public boolean isSelected(int n2, TableColumn<ObservableList<SpreadsheetCell>, ?> tableColumn) {
        if (tableColumn == null || n2 < 0) {
            return false;
        }
        int n3 = this.getTableView().getVisibleLeafIndex(tableColumn);
        if (this.getCellsViewSkin().getCellsSize() != 0) {
            TablePosition<ObservableList<SpreadsheetCell>, ?> tablePosition = this.getVisibleCell(n2, tableColumn);
            return this.selectedCellsMap.isSelected(tablePosition.getRow(), tablePosition.getColumn());
        }
        return this.selectedCellsMap.isSelected(n2, n3);
    }

    public List<TablePosition<ObservableList<SpreadsheetCell>, ?>> isSelectedRange(int n2, TableColumn<ObservableList<SpreadsheetCell>, ?> tableColumn, int n3) {
        if (n3 < 0 || n2 < 0) {
            return null;
        }
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)tableColumn.getCellData(n2);
        int n4 = n2;
        int n5 = n4 + this.spreadsheetView.getRowSpan(spreadsheetCell, n2);
        int n6 = this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn());
        int n7 = n6 + this.spreadsheetView.getColumnSpan(spreadsheetCell);
        ArrayList arrayList = new ArrayList();
        for (TablePosition tablePosition : this.getSelectedCells()) {
            if (tablePosition.getRow() < n4 || tablePosition.getRow() >= n5 || tablePosition.getColumn() < n6 || tablePosition.getColumn() >= n7) continue;
            arrayList.add(tablePosition);
        }
        return arrayList.isEmpty() ? null : arrayList;
    }

    private void addSelectedRowsAndColumns(TablePosition<?, ?> tablePosition) {
        GridViewSkin gridViewSkin = this.getSpreadsheetViewSkin();
        if (gridViewSkin == null) {
            return;
        }
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)tablePosition.getTableColumn().getCellData(tablePosition.getRow());
        int n2 = this.spreadsheetView.getRowSpan(spreadsheetCell, tablePosition.getRow());
        for (int i2 = tablePosition.getRow(); i2 < n2 + tablePosition.getRow(); ++i2) {
            gridViewSkin.getSelectedRows().add((Object)i2);
            for (int i3 = this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()); i3 < this.spreadsheetView.getColumnSpan(spreadsheetCell) + this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()); ++i3) {
                gridViewSkin.getSelectedColumns().add((Object)i3);
            }
        }
    }

    private void removeSelectedRowsAndColumns(TablePosition<?, ?> tablePosition) {
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)tablePosition.getTableColumn().getCellData(tablePosition.getRow());
        int n2 = this.spreadsheetView.getRowSpan(spreadsheetCell, tablePosition.getRow());
        for (int i2 = tablePosition.getRow(); i2 < n2 + tablePosition.getRow(); ++i2) {
            this.getSpreadsheetViewSkin().getSelectedRows().remove((Object)i2);
            for (int i3 = this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()); i3 < this.spreadsheetView.getColumnSpan(spreadsheetCell) + this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()); ++i3) {
                this.getSpreadsheetViewSkin().getSelectedColumns().remove((Object)i3);
            }
        }
    }

    public void clearAndSelect(int n2, TableColumn<ObservableList<SpreadsheetCell>, ?> tableColumn) {
        this.makeAtomic = true;
        ArrayList arrayList = new ArrayList((Collection<TablePosition<ObservableList<SpreadsheetCell>, ?>>)this.selectedCellsMap.getSelectedCells());
        this.clearSelection();
        this.select(n2, tableColumn);
        this.makeAtomic = false;
        if (this.old != null && this.old.getColumn() >= 0) {
            TableColumn tableColumn2 = this.getTableView().getVisibleLeafColumn(this.old.getColumn());
            int n3 = this.selectedCellsSeq.indexOf(new TablePosition(this.getTableView(), this.old.getRow(), tableColumn2));
            NonIterableChange.GenericAddRemoveChange genericAddRemoveChange = new NonIterableChange.GenericAddRemoveChange(n3, n3 + 1, arrayList, (ObservableList<TablePosition<ObservableList<SpreadsheetCell>, ?>>)this.selectedCellsSeq);
            this.handleSelectedCellsListChangeEvent(genericAddRemoveChange);
        }
    }

    public ObservableList<TablePosition> getSelectedCells() {
        return (ObservableList)this.selectedCellsSeq;
    }

    public void selectAboveCell() {
        TablePosition<ObservableList<SpreadsheetCell>, ?> tablePosition = this.getFocusedCell();
        if (tablePosition.getRow() == -1) {
            this.select(this.getItemCount() - 1);
        } else if (tablePosition.getRow() > 0) {
            this.select(tablePosition.getRow() - 1, tablePosition.getTableColumn());
        }
    }

    public void selectBelowCell() {
        TablePosition<ObservableList<SpreadsheetCell>, ?> tablePosition = this.getFocusedCell();
        if (tablePosition.getRow() == -1) {
            this.select(0);
        } else if (tablePosition.getRow() < this.getItemCount() - 1) {
            this.select(tablePosition.getRow() + 1, tablePosition.getTableColumn());
        }
    }

    public void selectLeftCell() {
        if (!this.isCellSelectionEnabled()) {
            return;
        }
        TablePosition<ObservableList<SpreadsheetCell>, ?> tablePosition = this.getFocusedCell();
        if (tablePosition.getColumn() - 1 >= 0) {
            this.select(tablePosition.getRow(), this.getTableColumn(tablePosition.getTableColumn(), -1));
        }
    }

    public void selectRightCell() {
        if (!this.isCellSelectionEnabled()) {
            return;
        }
        TablePosition<ObservableList<SpreadsheetCell>, ?> tablePosition = this.getFocusedCell();
        if (tablePosition.getColumn() + 1 < this.getTableView().getVisibleLeafColumns().size()) {
            this.select(tablePosition.getRow(), this.getTableColumn(tablePosition.getTableColumn(), 1));
        }
    }

    public void clearSelection() {
        if (!this.makeAtomic) {
            this.setSelectedIndex(-1);
            this.setSelectedItem((ObservableList)this.getModelItem(-1));
            this.focus(-1);
        }
        this.quietClearSelection();
    }

    private void quietClearSelection() {
        this.selectedCellsMap.clear();
        GridViewSkin gridViewSkin = this.getSpreadsheetViewSkin();
        if (gridViewSkin != null) {
            gridViewSkin.getSelectedRows().clear();
            gridViewSkin.getSelectedColumns().clear();
        }
    }

    private TablePosition<ObservableList<SpreadsheetCell>, ?> getFocusedCell() {
        if (this.getTableView().getFocusModel() == null) {
            return new TablePosition(this.getTableView(), -1, null);
        }
        return this.cellsView.getFocusModel().getFocusedCell();
    }

    private TableColumn<ObservableList<SpreadsheetCell>, ?> getTableColumn(TableColumn<ObservableList<SpreadsheetCell>, ?> tableColumn, int n2) {
        int n3 = this.getTableView().getVisibleLeafIndex(tableColumn);
        int n4 = n3 + n2;
        return this.getTableView().getVisibleLeafColumn(n4);
    }

    private GridViewSkin getSpreadsheetViewSkin() {
        return this.getCellsViewSkin();
    }

    private TablePosition<ObservableList<SpreadsheetCell>, ?> getVisibleCell(int n2, TableColumn<ObservableList<SpreadsheetCell>, ?> tableColumn) {
        int n3;
        int n4 = this.cellsView.getColumns().indexOf(tableColumn);
        SpreadsheetView.SpanType spanType = this.spreadsheetView.getSpanType(n2, n4);
        switch (spanType) {
            case NORMAL_CELL: 
            case ROW_VISIBLE: {
                return new TablePosition((TableView)this.cellsView, n2, tableColumn);
            }
        }
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)((ObservableList)this.cellsView.getItems().get(n2)).get(n4);
        int n5 = n3 = this.getCellsViewSkin() == null ? -1 : this.getCellsViewSkin().getFirstRow(spreadsheetCell, n2);
        if (this.getCellsViewSkin() == null || this.getCellsViewSkin().getCellsSize() != 0 && this.getNonFixedRow(0).getIndex() <= n3) {
            return new TablePosition((TableView)this.cellsView, n3, this.cellsView.getVisibleLeafColumn(this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn())));
        }
        GridRow gridRow = this.getNonFixedRow(0);
        return new TablePosition((TableView)this.cellsView, gridRow == null ? n2 : gridRow.getIndex(), this.cellsView.getVisibleLeafColumn(this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn())));
    }

    final GridViewSkin getCellsViewSkin() {
        return (GridViewSkin)this.cellsView.getSkin();
    }

    private GridRow getNonFixedRow(int n2) {
        return this.getCellsViewSkin().getRow(n2);
    }
}

