/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.VerticalHeader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.binding.When;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableRow;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Scale;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

final class GridVirtualFlow<T extends IndexedCell<?>>
extends VirtualFlow<T> {
    private static final Comparator<GridRow> ROWCMP = new Comparator<GridRow>(){

        @Override
        public int compare(GridRow gridRow, GridRow gridRow2) {
            return gridRow2.getIndex() - gridRow.getIndex();
        }
    };
    private SpreadsheetView spreadSheetView;
    private final GridViewSkin gridViewSkin;
    private final ArrayList<T> myFixedCells = new ArrayList();
    public final List<Node> sheetChildren;
    private StackPane corner;
    private Scale scale;
    private final ChangeListener<Number> hBarValueChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            GridVirtualFlow.this.gridViewSkin.hBarValue.clear();
        }
    };

    public GridVirtualFlow(GridViewSkin gridViewSkin) {
        this.gridViewSkin = gridViewSkin;
        ChangeListener<Number> changeListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                GridVirtualFlow.this.layoutTotal();
            }
        };
        this.getVbar().valueProperty().addListener((ChangeListener)changeListener);
        this.getHbar().valueProperty().addListener(this.hBarValueChangeListener);
        this.widthProperty().addListener(this.hBarValueChangeListener);
        this.sheetChildren = this.findSheetChildren();
        this.findCorner();
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            if (mouseEvent.getTarget().getClass() == GridRow.class) {
                this.spreadSheetView.getSelectionModel().clearSelection();
            }
        });
    }

    public void init(SpreadsheetView spreadsheetView) {
        this.getHbar().maxProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                GridVirtualFlow.this.getHbar().setBlockIncrement(GridVirtualFlow.this.getWidth());
                GridVirtualFlow.this.getHbar().setUnitIncrement(number2.doubleValue() / 20.0);
            }
        });
        this.scale = new Scale(1.0 / spreadsheetView.getZoomFactor(), 1.0 / spreadsheetView.getZoomFactor());
        this.scale.setPivotX(this.getHbar().getWidth() / 2.0);
        this.getHbar().getTransforms().add((Object)this.scale);
        this.getVbar().getTransforms().add((Object)this.scale);
        this.corner.getTransforms().add((Object)this.scale);
        this.spreadSheetView = spreadsheetView;
        this.spreadSheetView.zoomFactorProperty().addListener((observableValue, number, number2) -> {
            this.scale.setX(1.0 / number2.doubleValue());
            this.scale.setY(1.0 / number2.doubleValue());
        });
        Rectangle rectangle = new Rectangle();
        rectangle.widthProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)new When((ObservableBooleanValue)this.getVbar().visibleProperty()).then((ObservableNumberValue)this.getVbar().widthProperty()).otherwise(0)));
        rectangle.heightProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)new When((ObservableBooleanValue)this.getHbar().visibleProperty()).then((ObservableNumberValue)this.getHbar().heightProperty()).otherwise(0)));
        this.gridViewSkin.rectangleSelection.setClip((Node)rectangle);
        this.getChildren().add((Object)this.gridViewSkin.rectangleSelection);
        spreadsheetView.getFixedRows().addListener(observable -> {
            ArrayList<IndexedCell> arrayList = new ArrayList<IndexedCell>();
            for (IndexedCell indexedCell : this.myFixedCells) {
                if (spreadsheetView.getFixedRows().contains((Object)this.spreadSheetView.getFilteredSourceIndex(indexedCell.getIndex()))) continue;
                indexedCell.setManaged(false);
                indexedCell.setVisible(false);
                arrayList.add(indexedCell);
            }
            this.myFixedCells.removeAll(arrayList);
        });
    }

    public void scrollTo(int n2) {
        if (!this.getCells().isEmpty() && !VerticalHeader.isFixedRowEmpty(this.spreadSheetView)) {
            for (double d2 = this.gridViewSkin.getFixedRowHeight(); d2 >= 0.0 && n2 > 0; d2 -= this.gridViewSkin.getRowHeight(--n2)) {
            }
        }
        super.scrollTo(n2);
        this.layoutTotal();
        this.layoutFixedRows();
    }

    public double scrollPixels(double d2) {
        double d3 = super.scrollPixels(d2);
        this.layoutTotal();
        this.layoutFixedRows();
        return d3;
    }

    List<T> getFixedCells() {
        return this.myFixedCells;
    }

    GridRow getTopRow() {
        if (!this.sheetChildren.isEmpty()) {
            try {
                int n2;
                for (n2 = this.sheetChildren.size() - 1; n2 >= this.sheetChildren.size() || ((GridRow)this.sheetChildren.get(n2)).getChildrenUnmodifiable().isEmpty() && n2 > 0; --n2) {
                }
                return (GridRow)this.sheetChildren.get(n2);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    protected void layoutChildren() {
        if (this.spreadSheetView != null) {
            this.sortRows();
            super.layoutChildren();
            this.layoutTotal();
            this.layoutFixedRows();
            if (this.getVbar().getVisibleAmount() == 0.0 && this.getVbar().isVisible() && this.getCells().size() != this.getCellCount()) {
                this.getVbar().setMax(1.0);
                this.getVbar().setVisibleAmount((double)((float)this.getCells().size() / (float)this.getCellCount()));
            }
        }
        Pos pos = Pos.TOP_LEFT;
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        double d4 = this.getInsets().getTop();
        double d5 = this.getInsets().getRight();
        double d6 = this.getInsets().getLeft();
        double d7 = this.getInsets().getBottom();
        double d8 = this.scale.getX();
        double d9 = 1.0 - d8;
        double d10 = d2 / d8 - d6 - d5 - this.getVbar().getWidth();
        double d11 = d3 / d8 - d4 - d7 - this.getHbar().getHeight();
        this.layoutInArea((Node)this.getHbar(), 0.0 - d9 * 10.0, d3 - this.getHbar().getHeight() * d8, d10, d11, 0.0, null, pos.getHpos(), pos.getVpos());
        this.layoutInArea((Node)this.getVbar(), d2 - this.getVbar().getWidth() + d9, 0.0, d10, d11, 0.0, null, pos.getHpos(), pos.getVpos());
        if (this.corner != null) {
            this.layoutInArea((Node)this.corner, d2 - this.getVbar().getWidth() + d9, this.getHeight() - this.getHbar().getHeight() * d8, this.corner.getWidth(), this.corner.getHeight(), 0.0, null, pos.getHpos(), pos.getVpos());
        }
    }

    protected void layoutTotal() {
        this.sortRows();
        this.removeDeportedCells();
        if (this.getCells().isEmpty()) {
            this.reconfigureCells();
        }
        for (GridRow gridRow : this.getCells()) {
            if (gridRow == null || gridRow.getIndex() < 0 || this.gridViewSkin.hBarValue.get(gridRow.getIndex()) && !this.gridViewSkin.rowToLayout.get(gridRow.getIndex())) continue;
            gridRow.requestLayout();
        }
    }

    private void removeDeportedCells() {
        ArrayList<GridRow> arrayList = new ArrayList<GridRow>();
        for (Map.Entry<GridRow, Set<CellView>> object : this.gridViewSkin.deportedCells.entrySet()) {
            ArrayList<CellView> arrayList2 = new ArrayList<CellView>();
            for (CellView cellView : object.getValue()) {
                if (cellView.isEditing() || this.getCells().contains(cellView.getTableRow())) continue;
                object.getKey().removeCell(cellView);
                arrayList2.add(cellView);
            }
            object.getValue().removeAll(arrayList2);
            if (!object.getValue().isEmpty()) continue;
            arrayList.add(object.getKey());
        }
        for (GridRow gridRow : arrayList) {
            this.gridViewSkin.deportedCells.remove((Object)gridRow);
        }
    }

    protected ScrollBar getVerticalBar() {
        return this.getVbar();
    }

    protected ScrollBar getHorizontalBar() {
        return this.getHbar();
    }

    protected List<T> getCells() {
        return super.getCells();
    }

    private List<Node> findSheetChildren() {
        Region region;
        if (!this.getChildren().isEmpty() && this.getChildren().get(0) instanceof Region && !(region = (Region)this.getChildren().get(0)).getChildrenUnmodifiable().isEmpty() && region.getChildrenUnmodifiable().get(0) instanceof Group) {
            return ((Group)region.getChildrenUnmodifiable().get(0)).getChildren();
        }
        return new ArrayList<Node>();
    }

    private void findCorner() {
        if (!this.getChildren().isEmpty()) {
            for (Node node : this.getChildren()) {
                if (!(node instanceof StackPane)) continue;
                this.corner = (StackPane)node;
            }
        }
    }

    private void layoutFixedRows() {
        if (!VerticalHeader.isFixedRowEmpty(this.spreadSheetView) && this.getFirstVisibleCellWithinViewport() != null) {
            this.sortRows();
            Object object = null;
            block0: for (int i2 = this.spreadSheetView.getFixedRows().size() - 1; i2 >= 0; --i2) {
                IndexedCell indexedCell;
                Integer n2 = (Integer)this.spreadSheetView.getFixedRows().get(i2);
                if (this.spreadSheetView.isRowHidden(i2)) continue;
                n2 = this.spreadSheetView.getFilteredRow(n2);
                IndexedCell indexedCell2 = this.getLastVisibleCellWithinViewport();
                if (indexedCell2 != null && n2 > indexedCell2.getIndex()) {
                    if (object == null) continue;
                    object.setVisible(false);
                    object.setManaged(false);
                    this.sheetChildren.remove(object);
                    continue;
                }
                Iterator<T> iterator = this.getCells().iterator();
                while (iterator.hasNext() && (indexedCell = (IndexedCell)iterator.next()).getIndex() <= n2) {
                    if (indexedCell.getIndex() != n2.intValue()) continue;
                    object = this.containsRows(n2);
                    if (object != null) {
                        object.setVisible(false);
                        object.setManaged(false);
                        this.sheetChildren.remove(object);
                    }
                    indexedCell.toFront();
                    continue block0;
                }
                object = this.containsRows(n2);
                if (object == null) {
                    object = (IndexedCell)this.getCellFactory().call((Object)this);
                    object.getProperties().put((Object)"newcell", null);
                    this.setCellIndex((IndexedCell)object, n2);
                    this.resizeCell((IndexedCell)object);
                    this.myFixedCells.add(object);
                }
                if (!this.sheetChildren.contains(object)) {
                    this.sheetChildren.add((Node)object);
                }
                object.setManaged(true);
                object.setVisible(true);
                object.toFront();
                object.requestLayout();
            }
        }
    }

    private T containsRows(int n2) {
        for (IndexedCell indexedCell : this.myFixedCells) {
            if (indexedCell.getIndex() != n2) continue;
            return (T)indexedCell;
        }
        return null;
    }

    private void sortRows() {
        List<T> list = this.getCells();
        ArrayList<T> arrayList = new ArrayList<T>(list);
        Collections.sort(arrayList, ROWCMP);
        for (TableRow tableRow : arrayList) {
            tableRow.toFront();
        }
    }
}

