/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.behavior.TableViewBehavior;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.TableViewSpanSelectionModel;
import javafx.collections.ObservableList;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;
import javafx.util.Pair;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;

public class GridViewBehavior
extends TableViewBehavior<ObservableList<SpreadsheetCell>> {
    private GridViewSkin skin;

    public GridViewBehavior(TableView<ObservableList<SpreadsheetCell>> tableView) {
        super(tableView);
    }

    void setGridViewSkin(GridViewSkin gridViewSkin) {
        this.skin = gridViewSkin;
    }

    protected void updateCellVerticalSelection(int n2, Runnable runnable) {
        TableViewSpanSelectionModel tableViewSpanSelectionModel = (TableViewSpanSelectionModel)this.getSelectionModel();
        if (tableViewSpanSelectionModel == null || tableViewSpanSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        TablePositionBase tablePositionBase = this.getFocusedCell();
        if (this.isShiftDown && this.getAnchor() != null) {
            SpreadsheetCell spreadsheetCell = (SpreadsheetCell)tablePositionBase.getTableColumn().getCellData(tablePositionBase.getRow());
            tableViewSpanSelectionModel.direction = new Pair((Object)n2, (Object)0);
            int n3 = n2 < 0 ? this.skin.getFirstRow(spreadsheetCell, tablePositionBase.getRow()) + n2 : tablePositionBase.getRow() + this.skin.spreadsheetView.getRowSpan(spreadsheetCell, tablePositionBase.getRow()) - 1 + n2;
            n3 = Math.max(Math.min(this.getItemCount() - 1, n3), 0);
            TablePositionBase tablePositionBase2 = this.getAnchor();
            int n4 = Math.min(tablePositionBase2.getRow(), n3);
            int n5 = Math.max(tablePositionBase2.getRow(), n3);
            int n6 = Math.min(tablePositionBase2.getColumn(), tablePositionBase.getColumn());
            int n7 = Math.max(tablePositionBase2.getColumn(), tablePositionBase.getColumn());
            tableViewSpanSelectionModel.clearSelection();
            if (n6 != -1 && n7 != -1) {
                tableViewSpanSelectionModel.selectRange(n4, (TableColumnBase<ObservableList<SpreadsheetCell>, ?>)((TableView)this.getNode()).getVisibleLeafColumn(n6), n5, (TableColumnBase<ObservableList<SpreadsheetCell>, ?>)((TableView)this.getNode()).getVisibleLeafColumn(n7));
            }
            tableFocusModel.focus(n3, tablePositionBase.getTableColumn());
        } else {
            int n8 = tableFocusModel.getFocusedIndex();
            if (!tableViewSpanSelectionModel.isSelected(n8, tablePositionBase.getTableColumn())) {
                tableViewSpanSelectionModel.select(n8, tablePositionBase.getTableColumn());
            }
            runnable.run();
        }
    }

    protected void updateCellHorizontalSelection(int n2, Runnable runnable) {
        TableViewSpanSelectionModel tableViewSpanSelectionModel = (TableViewSpanSelectionModel)this.getSelectionModel();
        if (tableViewSpanSelectionModel == null || tableViewSpanSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        TablePositionBase tablePositionBase = this.getFocusedCell();
        if (tablePositionBase == null || tablePositionBase.getTableColumn() == null) {
            return;
        }
        TableColumnBase tableColumnBase = this.getColumn(tablePositionBase.getTableColumn(), n2);
        if (tableColumnBase == null) {
            return;
        }
        int n3 = tablePositionBase.getRow();
        if (this.isShiftDown && this.getAnchor() != null) {
            SpreadsheetCell spreadsheetCell = (SpreadsheetCell)tablePositionBase.getTableColumn().getCellData(tablePositionBase.getRow());
            tableViewSpanSelectionModel.direction = new Pair((Object)0, (Object)n2);
            int n4 = n2 < 0 ? this.skin.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()) + n2 : this.skin.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()) + this.skin.spreadsheetView.getColumnSpan(spreadsheetCell) - 1 + n2;
            TablePositionBase tablePositionBase2 = this.getAnchor();
            int n5 = Math.min(tablePositionBase2.getRow(), n3);
            int n6 = Math.max(tablePositionBase2.getRow(), n3);
            int n7 = Math.min(tablePositionBase2.getColumn(), n4);
            int n8 = Math.max(tablePositionBase2.getColumn(), n4);
            tableViewSpanSelectionModel.clearSelection();
            if (n7 != -1 && n8 != -1) {
                tableViewSpanSelectionModel.selectRange(n5, (TableColumnBase<ObservableList<SpreadsheetCell>, ?>)((TableView)this.getNode()).getVisibleLeafColumn(n7), n6, (TableColumnBase<ObservableList<SpreadsheetCell>, ?>)((TableView)this.getNode()).getVisibleLeafColumn(n8));
            }
            tableFocusModel.focus(tablePositionBase.getRow(), this.getColumn(n4));
        } else {
            runnable.run();
        }
    }

    protected void focusPreviousRow() {
        this.focusVertical(true);
    }

    protected void focusNextRow() {
        this.focusVertical(false);
    }

    protected void focusLeftCell() {
        this.focusHorizontal(true);
    }

    protected void focusRightCell() {
        this.focusHorizontal(false);
    }

    protected void discontinuousSelectPreviousRow() {
        this.discontinuousSelectVertical(true);
    }

    protected void discontinuousSelectNextRow() {
        this.discontinuousSelectVertical(false);
    }

    protected void discontinuousSelectPreviousColumn() {
        this.discontinuousSelectHorizontal(true);
    }

    protected void discontinuousSelectNextColumn() {
        this.discontinuousSelectHorizontal(false);
    }

    private void focusVertical(boolean bl2) {
        TableSelectionModel tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null || tableSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        TablePositionBase tablePositionBase = this.getFocusedCell();
        if (tablePositionBase == null || tablePositionBase.getTableColumn() == null) {
            return;
        }
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)tablePositionBase.getTableColumn().getCellData(tablePositionBase.getRow());
        tableSelectionModel.clearAndSelect(bl2 ? this.findPreviousRow(tablePositionBase, spreadsheetCell) : this.findNextRow(tablePositionBase, spreadsheetCell), tablePositionBase.getTableColumn());
        this.skin.focusScroll();
    }

    private void focusHorizontal(boolean bl2) {
        TableSelectionModel tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        TablePositionBase tablePositionBase = this.getFocusedCell();
        if (tablePositionBase == null || tablePositionBase.getTableColumn() == null) {
            return;
        }
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)tablePositionBase.getTableColumn().getCellData(tablePositionBase.getRow());
        tableSelectionModel.clearAndSelect(tablePositionBase.getRow(), (TableColumnBase)((TableView)this.getNode()).getVisibleLeafColumn(bl2 ? this.findPreviousColumn(tablePositionBase, spreadsheetCell) : this.findNextColumn(tablePositionBase, spreadsheetCell)));
        this.skin.focusScroll();
    }

    private int findPreviousRow(TablePositionBase tablePositionBase, SpreadsheetCell spreadsheetCell) {
        ObservableList observableList = ((TableView)this.getNode()).getItems();
        if (this.isEmpty(spreadsheetCell)) {
            for (int i2 = tablePositionBase.getRow() - 1; i2 >= 0; --i2) {
                SpreadsheetCell spreadsheetCell2 = (SpreadsheetCell)((ObservableList)observableList.get(i2)).get(tablePositionBase.getColumn());
                if (this.isEmpty(spreadsheetCell2)) continue;
                return i2;
            }
        } else if (tablePositionBase.getRow() - 1 >= 0 && !this.isEmpty((SpreadsheetCell)((ObservableList)observableList.get(tablePositionBase.getRow() - 1)).get(tablePositionBase.getColumn()))) {
            for (int i3 = tablePositionBase.getRow() - 2; i3 >= 0; --i3) {
                SpreadsheetCell spreadsheetCell3 = (SpreadsheetCell)((ObservableList)observableList.get(i3)).get(tablePositionBase.getColumn());
                if (!this.isEmpty(spreadsheetCell3)) continue;
                return i3 + 1;
            }
        } else {
            for (int i4 = tablePositionBase.getRow() - 2; i4 >= 0; --i4) {
                SpreadsheetCell spreadsheetCell4 = (SpreadsheetCell)((ObservableList)observableList.get(i4)).get(tablePositionBase.getColumn());
                if (this.isEmpty(spreadsheetCell4)) continue;
                return i4;
            }
        }
        return 0;
    }

    public void selectCell(int n2, int n3) {
        TableViewSpanSelectionModel tableViewSpanSelectionModel = (TableViewSpanSelectionModel)this.getSelectionModel();
        if (tableViewSpanSelectionModel == null) {
            return;
        }
        tableViewSpanSelectionModel.direction = new Pair((Object)n2, (Object)n3);
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        TablePositionBase tablePositionBase = this.getFocusedCell();
        int n4 = tablePositionBase.getRow();
        int n5 = this.getVisibleLeafIndex(tablePositionBase.getTableColumn());
        if (n2 < 0 && n4 <= 0) {
            return;
        }
        if (n2 > 0 && n4 >= this.getItemCount() - 1) {
            return;
        }
        if (n3 < 0 && n5 <= 0) {
            return;
        }
        if (n3 > 0 && n5 >= this.getVisibleLeafColumns().size() - 1) {
            return;
        }
        if (n3 > 0 && n5 == -1) {
            return;
        }
        TableColumnBase tableColumnBase = tablePositionBase.getTableColumn();
        tableColumnBase = this.getColumn(tableColumnBase, n3);
        int n6 = tablePositionBase.getRow() + n2;
        tableViewSpanSelectionModel.clearAndSelect(n6, tableColumnBase);
        this.setAnchor(n6, tableColumnBase);
    }

    private int findNextRow(TablePositionBase tablePositionBase, SpreadsheetCell spreadsheetCell) {
        ObservableList observableList = ((TableView)this.getNode()).getItems();
        int n2 = this.getItemCount();
        if (this.isEmpty(spreadsheetCell)) {
            for (int i2 = tablePositionBase.getRow() + 1; i2 < n2; ++i2) {
                SpreadsheetCell spreadsheetCell2 = (SpreadsheetCell)((ObservableList)observableList.get(i2)).get(tablePositionBase.getColumn());
                if (this.isEmpty(spreadsheetCell2)) continue;
                return i2;
            }
        } else if (tablePositionBase.getRow() + 1 < n2 && !this.isEmpty((SpreadsheetCell)((ObservableList)observableList.get(tablePositionBase.getRow() + 1)).get(tablePositionBase.getColumn()))) {
            for (int i3 = tablePositionBase.getRow() + 2; i3 < this.getItemCount(); ++i3) {
                SpreadsheetCell spreadsheetCell3 = (SpreadsheetCell)((ObservableList)observableList.get(i3)).get(tablePositionBase.getColumn());
                if (!this.isEmpty(spreadsheetCell3)) continue;
                return i3 - 1;
            }
        } else {
            for (int i4 = tablePositionBase.getRow() + 2; i4 < n2; ++i4) {
                SpreadsheetCell spreadsheetCell4 = (SpreadsheetCell)((ObservableList)observableList.get(i4)).get(tablePositionBase.getColumn());
                if (this.isEmpty(spreadsheetCell4)) continue;
                return i4;
            }
        }
        return n2 - 1;
    }

    private void discontinuousSelectVertical(boolean bl2) {
        TableSelectionModel tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        TablePositionBase tablePositionBase = this.getFocusedCell();
        if (tablePositionBase == null || tablePositionBase.getTableColumn() == null) {
            return;
        }
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)tablePositionBase.getTableColumn().getCellData(tablePositionBase.getRow());
        int n2 = bl2 ? this.findPreviousRow(tablePositionBase, spreadsheetCell) : this.findNextRow(tablePositionBase, spreadsheetCell);
        n2 = Math.max(Math.min(this.getItemCount() - 1, n2), 0);
        TablePositionBase tablePositionBase2 = this.getAnchor();
        int n3 = Math.min(tablePositionBase2.getRow(), n2);
        int n4 = Math.max(tablePositionBase2.getRow(), n2);
        int n5 = Math.min(tablePositionBase2.getColumn(), tablePositionBase.getColumn());
        int n6 = Math.max(tablePositionBase2.getColumn(), tablePositionBase.getColumn());
        tableSelectionModel.clearSelection();
        if (n5 != -1 && n6 != -1) {
            tableSelectionModel.selectRange(n3, (TableColumnBase)((TableView)this.getNode()).getVisibleLeafColumn(n5), n4, (TableColumnBase)((TableView)this.getNode()).getVisibleLeafColumn(n6));
        }
        tableFocusModel.focus(n2, tablePositionBase.getTableColumn());
        this.skin.focusScroll();
    }

    private void discontinuousSelectHorizontal(boolean bl2) {
        TableSelectionModel tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        TablePositionBase tablePositionBase = this.getFocusedCell();
        if (tablePositionBase == null || tablePositionBase.getTableColumn() == null) {
            return;
        }
        int n2 = this.getVisibleLeafIndex(tablePositionBase.getTableColumn());
        int n3 = tablePositionBase.getRow();
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)tablePositionBase.getTableColumn().getCellData(tablePositionBase.getRow());
        int n4 = bl2 ? this.findPreviousColumn(tablePositionBase, spreadsheetCell) : this.findNextColumn(tablePositionBase, spreadsheetCell);
        TablePositionBase tablePositionBase2 = this.getAnchor();
        int n5 = Math.min(tablePositionBase2.getRow(), n3);
        int n6 = Math.max(tablePositionBase2.getRow(), n3);
        int n7 = Math.min(tablePositionBase2.getColumn(), n4);
        int n8 = Math.max(tablePositionBase2.getColumn(), n4);
        tableSelectionModel.clearSelection();
        if (n7 != -1 && n8 != -1) {
            tableSelectionModel.selectRange(n5, (TableColumnBase)((TableView)this.getNode()).getVisibleLeafColumn(n7), n6, (TableColumnBase)((TableView)this.getNode()).getVisibleLeafColumn(n8));
        }
        tableFocusModel.focus(tablePositionBase.getRow(), this.getColumn(n4));
        this.skin.focusScroll();
    }

    private int findNextColumn(TablePositionBase tablePositionBase, SpreadsheetCell spreadsheetCell) {
        ObservableList observableList = ((TableView)this.getNode()).getItems();
        int n2 = ((TableView)this.getNode()).getColumns().size();
        if (this.isEmpty(spreadsheetCell)) {
            for (int i2 = tablePositionBase.getColumn() + 1; i2 < n2; ++i2) {
                SpreadsheetCell spreadsheetCell2 = (SpreadsheetCell)((ObservableList)observableList.get(tablePositionBase.getRow())).get(i2);
                if (this.isEmpty(spreadsheetCell2)) continue;
                return i2;
            }
        } else if (tablePositionBase.getColumn() + 1 < n2 && !this.isEmpty((SpreadsheetCell)((ObservableList)observableList.get(tablePositionBase.getRow())).get(tablePositionBase.getColumn() + 1))) {
            for (int i3 = tablePositionBase.getColumn() + 2; i3 < n2; ++i3) {
                SpreadsheetCell spreadsheetCell3 = (SpreadsheetCell)((ObservableList)observableList.get(tablePositionBase.getRow())).get(i3);
                if (!this.isEmpty(spreadsheetCell3)) continue;
                return i3 - 1;
            }
        } else {
            for (int i4 = tablePositionBase.getColumn() + 2; i4 < n2; ++i4) {
                SpreadsheetCell spreadsheetCell4 = (SpreadsheetCell)((ObservableList)observableList.get(tablePositionBase.getRow())).get(i4);
                if (this.isEmpty(spreadsheetCell4)) continue;
                return i4;
            }
        }
        return n2 - 1;
    }

    private int findPreviousColumn(TablePositionBase tablePositionBase, SpreadsheetCell spreadsheetCell) {
        ObservableList observableList = ((TableView)this.getNode()).getItems();
        if (this.isEmpty(spreadsheetCell)) {
            for (int i2 = tablePositionBase.getColumn() - 1; i2 >= 0; --i2) {
                SpreadsheetCell spreadsheetCell2 = (SpreadsheetCell)((ObservableList)observableList.get(tablePositionBase.getRow())).get(i2);
                if (this.isEmpty(spreadsheetCell2)) continue;
                return i2;
            }
        } else if (tablePositionBase.getColumn() - 1 >= 0 && !this.isEmpty((SpreadsheetCell)((ObservableList)observableList.get(tablePositionBase.getRow())).get(tablePositionBase.getColumn() - 1))) {
            for (int i3 = tablePositionBase.getColumn() - 2; i3 >= 0; --i3) {
                SpreadsheetCell spreadsheetCell3 = (SpreadsheetCell)((ObservableList)observableList.get(tablePositionBase.getRow())).get(i3);
                if (!this.isEmpty(spreadsheetCell3)) continue;
                return i3 + 1;
            }
        } else {
            for (int i4 = tablePositionBase.getColumn() - 2; i4 >= 0; --i4) {
                SpreadsheetCell spreadsheetCell4 = (SpreadsheetCell)((ObservableList)observableList.get(tablePositionBase.getRow())).get(i4);
                if (this.isEmpty(spreadsheetCell4)) continue;
                return i4;
            }
        }
        return 0;
    }

    private boolean isEmpty(SpreadsheetCell spreadsheetCell) {
        return spreadsheetCell.getGraphic() == null && (spreadsheetCell.getItem() == null || spreadsheetCell.getItem() instanceof Double && ((Double)spreadsheetCell.getItem()).isNaN());
    }
}

