/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellView;
import java.util.UUID;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.MenuButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.skin.TableCellSkin;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import org.controlsfx.control.spreadsheet.Filter;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;

public class CellViewSkin
extends TableCellSkin<ObservableList<SpreadsheetCell>, SpreadsheetCell> {
    public static final EventType<Event> FILTER_EVENT_TYPE = new EventType("FilterEventType" + UUID.randomUUID().toString());
    private static final String TOP_LEFT_CLASS = "top-left";
    private static final String TOP_RIGHT_CLASS = "top-right";
    private static final String BOTTOM_RIGHT_CLASS = "bottom-right";
    private static final String BOTTOM_LEFT_CLASS = "bottom-left";
    private static final int TRIANGLE_SIZE = 8;
    private Region topLeftRegion = null;
    private Region topRightRegion = null;
    private Region bottomRightRegion = null;
    private Region bottomLeftRegion = null;
    private MenuButton filterButton = null;
    private final EventHandler<Event> triangleEventHandler = new EventHandler<Event>(){

        public void handle(Event event) {
            ((TableCell)CellViewSkin.this.getSkinnable()).requestLayout();
        }
    };
    private final WeakEventHandler weakTriangleEventHandler = new WeakEventHandler(this.triangleEventHandler);
    private final ChangeListener<SpreadsheetCell> itemChangeListener = new ChangeListener<SpreadsheetCell>(){

        public void changed(ObservableValue<? extends SpreadsheetCell> observableValue, SpreadsheetCell spreadsheetCell, SpreadsheetCell spreadsheetCell2) {
            if (spreadsheetCell != null) {
                spreadsheetCell.removeEventHandler(SpreadsheetCell.CORNER_EVENT_TYPE, (EventHandler<Event>)CellViewSkin.this.weakTriangleEventHandler);
            }
            if (spreadsheetCell2 != null) {
                spreadsheetCell2.addEventHandler(SpreadsheetCell.CORNER_EVENT_TYPE, (EventHandler<Event>)CellViewSkin.this.weakTriangleEventHandler);
            }
            if (((TableCell)CellViewSkin.this.getSkinnable()).getItem() != null) {
                CellViewSkin.this.layoutTriangle();
            }
        }
    };
    private final WeakChangeListener<SpreadsheetCell> weakItemChangeListener = new WeakChangeListener(this.itemChangeListener);
    private final ChangeListener<TableColumn> columnChangeListener = new ChangeListener<TableColumn>(){

        public void changed(ObservableValue<? extends TableColumn> observableValue, TableColumn tableColumn, TableColumn tableColumn2) {
            if (tableColumn != null) {
                tableColumn.removeEventHandler(FILTER_EVENT_TYPE, (EventHandler)CellViewSkin.this.weakTriangleEventHandler);
            }
            if (tableColumn2 != null) {
                tableColumn2.addEventHandler(FILTER_EVENT_TYPE, (EventHandler)CellViewSkin.this.weakTriangleEventHandler);
            }
        }
    };
    private final WeakChangeListener<TableColumn> weakColumnChangeListener = new WeakChangeListener(this.columnChangeListener);

    public CellViewSkin(CellView cellView) {
        super((TableCell)cellView);
        cellView.itemProperty().addListener(this.weakItemChangeListener);
        cellView.tableColumnProperty().addListener(this.weakColumnChangeListener);
        cellView.getTableColumn().addEventHandler(FILTER_EVENT_TYPE, (EventHandler)this.weakTriangleEventHandler);
        if (cellView.getItem() != null) {
            ((SpreadsheetCell)cellView.getItem()).addEventHandler(SpreadsheetCell.CORNER_EVENT_TYPE, (EventHandler<Event>)this.weakTriangleEventHandler);
        }
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        Node node = ((TableCell)this.getSkinnable()).getGraphic();
        if (node != null && node instanceof ImageView) {
            ImageView imageView = (ImageView)node;
            if (!((CellView)this.getSkinnable()).isOriginalCell()) {
                imageView.setManaged(false);
                double d7 = super.computePrefHeight(d2, d3, d4, d5, d6);
                imageView.setManaged(true);
                return d7;
            }
            if (imageView.getImage() != null) {
                return imageView.getImage().getHeight();
            }
        }
        return super.computePrefHeight(d2, d3, d4, d5, d6);
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        Filter filter = ((CellView)this.getSkinnable()).getFilter();
        double d7 = super.computePrefWidth(d2, d3, d4, d5, d6);
        if (filter != null) {
            double d8 = filter.getMenuButton().getWidth();
            d8 = d8 == 0.0 ? 23.0 : d8;
            Pos pos = ((TableCell)this.getSkinnable()).getAlignment();
            switch (pos) {
                case BASELINE_LEFT: 
                case BOTTOM_LEFT: 
                case CENTER_LEFT: 
                case TOP_LEFT: {
                    return d7 + d8;
                }
                case BASELINE_CENTER: 
                case BOTTOM_CENTER: 
                case TOP_CENTER: 
                case CENTER: {
                    return d7 + 2.0 * d8;
                }
            }
            return d7 + 10.0;
        }
        return d7;
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        super.layoutChildren(d2, d3, d4, d5);
        if (((TableCell)this.getSkinnable()).getItem() != null) {
            this.layoutTriangle();
            this.handleFilter(d2, d3, d4, d5);
        }
    }

    private void layoutTriangle() {
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)((TableCell)this.getSkinnable()).getItem();
        this.handleTopLeft(spreadsheetCell);
        this.handleTopRight(spreadsheetCell);
        this.handleBottomLeft(spreadsheetCell);
        this.handleBottomRight(spreadsheetCell);
        ((TableCell)this.getSkinnable()).requestLayout();
    }

    private void handleFilter(double d2, double d3, double d4, double d5) {
        Filter filter = ((CellView)this.getSkinnable()).getFilter();
        if (filter != null) {
            if (filter.getMenuButton().isShowing()) {
                return;
            }
            this.removeMenuButton();
            this.filterButton = filter.getMenuButton();
            if (!this.getChildren().contains((Object)this.filterButton)) {
                this.getChildren().add((Object)this.filterButton);
            }
            this.layoutInArea((Node)this.filterButton, d2 + this.snappedRightInset(), d3 + this.snappedBottomInset(), d4, d5, 0.0, new Insets(0.0), HPos.RIGHT, VPos.BOTTOM);
        } else if (this.filterButton != null) {
            this.removeMenuButton();
        }
    }

    private void removeMenuButton() {
        if (this.filterButton != null && this.getChildren().contains((Object)this.filterButton)) {
            this.getChildren().remove((Object)this.filterButton);
            this.filterButton = null;
        }
    }

    private void handleTopLeft(SpreadsheetCell spreadsheetCell) {
        if (spreadsheetCell.isCornerActivated(SpreadsheetCell.CornerPosition.TOP_LEFT)) {
            if (this.topLeftRegion == null) {
                this.topLeftRegion = CellViewSkin.getRegion(SpreadsheetCell.CornerPosition.TOP_LEFT);
            }
            this.getChildren().remove((Object)this.topLeftRegion);
            this.getChildren().add((Object)this.topLeftRegion);
            this.topLeftRegion.relocate(0.0, 0.0);
        } else if (this.topLeftRegion != null) {
            this.getChildren().remove((Object)this.topLeftRegion);
            this.topLeftRegion = null;
        }
    }

    private void handleTopRight(SpreadsheetCell spreadsheetCell) {
        if (spreadsheetCell.isCornerActivated(SpreadsheetCell.CornerPosition.TOP_RIGHT)) {
            if (this.topRightRegion == null) {
                this.topRightRegion = CellViewSkin.getRegion(SpreadsheetCell.CornerPosition.TOP_RIGHT);
            }
            this.getChildren().remove((Object)this.topRightRegion);
            this.getChildren().add((Object)this.topRightRegion);
            this.topRightRegion.relocate(((TableCell)this.getSkinnable()).getWidth() - 8.0, 0.0);
        } else if (this.topRightRegion != null) {
            this.getChildren().remove((Object)this.topRightRegion);
            this.topRightRegion = null;
        }
    }

    private void handleBottomRight(SpreadsheetCell spreadsheetCell) {
        if (spreadsheetCell.isCornerActivated(SpreadsheetCell.CornerPosition.BOTTOM_RIGHT)) {
            if (this.bottomRightRegion == null) {
                this.bottomRightRegion = CellViewSkin.getRegion(SpreadsheetCell.CornerPosition.BOTTOM_RIGHT);
            }
            this.getChildren().remove((Object)this.bottomRightRegion);
            this.getChildren().add((Object)this.bottomRightRegion);
            this.bottomRightRegion.relocate(((TableCell)this.getSkinnable()).getWidth() - 8.0, ((TableCell)this.getSkinnable()).getHeight() - 8.0);
        } else if (this.bottomRightRegion != null) {
            this.getChildren().remove((Object)this.bottomRightRegion);
            this.bottomRightRegion = null;
        }
    }

    private void handleBottomLeft(SpreadsheetCell spreadsheetCell) {
        if (spreadsheetCell.isCornerActivated(SpreadsheetCell.CornerPosition.BOTTOM_LEFT)) {
            if (this.bottomLeftRegion == null) {
                this.bottomLeftRegion = CellViewSkin.getRegion(SpreadsheetCell.CornerPosition.BOTTOM_LEFT);
            }
            this.getChildren().remove((Object)this.bottomLeftRegion);
            this.getChildren().add((Object)this.bottomLeftRegion);
            this.bottomLeftRegion.relocate(0.0, ((TableCell)this.getSkinnable()).getHeight() - 8.0);
        } else if (this.bottomLeftRegion != null) {
            this.getChildren().remove((Object)this.bottomLeftRegion);
            this.bottomLeftRegion = null;
        }
    }

    private static Region getRegion(SpreadsheetCell.CornerPosition cornerPosition) {
        Region region = new Region();
        region.resize(8.0, 8.0);
        region.getStyleClass().add((Object)"cell-corner");
        switch (cornerPosition) {
            case TOP_LEFT: {
                region.getStyleClass().add((Object)TOP_LEFT_CLASS);
                break;
            }
            case TOP_RIGHT: {
                region.getStyleClass().add((Object)TOP_RIGHT_CLASS);
                break;
            }
            case BOTTOM_RIGHT: {
                region.getStyleClass().add((Object)BOTTOM_RIGHT_CLASS);
                break;
            }
            case BOTTOM_LEFT: {
                region.getStyleClass().add((Object)BOTTOM_LEFT_CLASS);
            }
        }
        return region;
    }
}

