/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellViewSkin;
import impl.org.controlsfx.spreadsheet.GridCellEditor;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.beans.binding.When;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.SetChangeListener;
import javafx.collections.WeakSetChangeListener;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Side;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;
import javafx.util.Duration;
import org.controlsfx.control.spreadsheet.CellGraphicFactory;
import org.controlsfx.control.spreadsheet.Filter;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellEditor;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class CellView
extends TableCell<ObservableList<SpreadsheetCell>, SpreadsheetCell> {
    final SpreadsheetHandle handle;
    private Tooltip tooltip;
    private EventHandler<DragEvent> dragOverHandler;
    private EventHandler<DragEvent> dragDropHandler;
    private boolean dirtyStyle = false;
    private static final String ANCHOR_PROPERTY_KEY = "table.anchor";
    private static final int TOOLTIP_MAX_WIDTH = 400;
    private static final Duration FADE_DURATION = Duration.millis((double)200.0);
    private final ChangeListener<Node> graphicListener = new ChangeListener<Node>(){

        public void changed(ObservableValue<? extends Node> observableValue, Node node, Node node2) {
            CellView.this.setCellGraphic((SpreadsheetCell)CellView.this.getItem());
        }
    };
    private final WeakChangeListener<Node> weakGraphicListener = new WeakChangeListener(this.graphicListener);
    private final SetChangeListener<String> styleClassListener = new SetChangeListener<String>(){

        public void onChanged(SetChangeListener.Change<? extends String> change) {
            if (change.wasAdded()) {
                CellView.this.getStyleClass().add((Object)((String)change.getElementAdded()));
            } else if (change.wasRemoved()) {
                CellView.this.getStyleClass().remove(change.getElementRemoved());
            }
            if (CellView.this.getItem() != null && ((SpreadsheetCell)CellView.this.getItem()).isCellGraphic()) {
                CellView.this.dirtyStyle = true;
            }
        }
    };
    private final WeakSetChangeListener<String> weakStyleClassListener = new WeakSetChangeListener(this.styleClassListener);
    private ChangeListener<String> styleListener;
    private WeakChangeListener<String> weakStyleListener;
    private final EventHandler<MouseEvent> startFullDragEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            if (CellView.this.handle.getGridView().getSelectionModel().getSelectionMode().equals((Object)SelectionMode.MULTIPLE)) {
                CellView.setAnchor((Control)CellView.this.getTableView(), (TablePositionBase)CellView.this.getTableView().getFocusModel().getFocusedCell());
                CellView.this.startFullDrag();
            }
        }
    };
    private final EventHandler<MouseEvent> dragMouseEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            CellView.this.dragSelect(mouseEvent);
        }
    };
    private final ChangeListener<SpreadsheetCell> itemChangeListener = new ChangeListener<SpreadsheetCell>(){

        public void changed(ObservableValue<? extends SpreadsheetCell> observableValue, SpreadsheetCell spreadsheetCell, SpreadsheetCell spreadsheetCell2) {
            if (spreadsheetCell != null) {
                spreadsheetCell.getStyleClass().removeListener(CellView.this.weakStyleClassListener);
                spreadsheetCell.graphicProperty().removeListener(CellView.this.weakGraphicListener);
                if (spreadsheetCell.styleProperty() != null) {
                    spreadsheetCell.styleProperty().removeListener(CellView.this.weakStyleListener);
                }
            }
            if (spreadsheetCell2 != null) {
                CellView.this.getStyleClass().clear();
                CellView.this.getStyleClass().setAll(spreadsheetCell2.getStyleClass());
                spreadsheetCell2.getStyleClass().addListener(CellView.this.weakStyleClassListener);
                CellView.this.setCellGraphic(spreadsheetCell2);
                spreadsheetCell2.graphicProperty().addListener(CellView.this.weakGraphicListener);
                if (spreadsheetCell2.styleProperty() != null) {
                    CellView.this.initStyleListener();
                    spreadsheetCell2.styleProperty().addListener(CellView.this.weakStyleListener);
                    CellView.this.setStyle(spreadsheetCell2.getStyle());
                } else {
                    CellView.this.setStyle(null);
                }
                if (CellView.this.getItem() != null && ((SpreadsheetCell)CellView.this.getItem()).isCellGraphic()) {
                    CellView.this.dirtyStyle = true;
                }
            }
        }
    };
    private final EventHandler<MouseEvent> actionEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            if (CellView.this.getItem() != null && ((SpreadsheetCell)CellView.this.getItem()).hasPopup() && MouseButton.PRIMARY.equals((Object)mouseEvent.getButton()) && (CellView.this.getFilter() == null || !CellView.this.getFilter().getMenuButton().isShowing())) {
                ContextMenu contextMenu = new ContextMenu();
                contextMenu.getScene().getStylesheets().add((Object)SpreadsheetView.class.getResource("spreadsheet.css").toExternalForm());
                contextMenu.getStyleClass().add((Object)"popup-button");
                contextMenu.getItems().setAll(((SpreadsheetCell)CellView.this.getItem()).getPopupItems());
                contextMenu.show((Node)CellView.this, Side.BOTTOM, 0.0, 0.0);
            }
        }
    };
    private final WeakEventHandler weakActionhandler = new WeakEventHandler(this.actionEventHandler);
    private ChangeListener<Parent> parentListener = new ChangeListener<Parent>(){

        public void changed(ObservableValue<? extends Parent> observableValue, Parent parent, Parent parent2) {
            if (parent2 == null && CellView.this.getGraphic() != null) {
                CellView.this.releaseCellGraphic();
            }
        }
    };

    static TablePositionBase<?> getAnchor(Control control, TablePositionBase<?> tablePositionBase) {
        return CellView.hasAnchor(control) ? (TablePositionBase)control.getProperties().get((Object)ANCHOR_PROPERTY_KEY) : tablePositionBase;
    }

    static boolean hasAnchor(Control control) {
        return control.getProperties().get((Object)ANCHOR_PROPERTY_KEY) != null;
    }

    static void setAnchor(Control control, TablePositionBase tablePositionBase) {
        if (control != null && tablePositionBase == null) {
            CellView.removeAnchor(control);
        } else {
            control.getProperties().put((Object)ANCHOR_PROPERTY_KEY, (Object)tablePositionBase);
        }
    }

    static void removeAnchor(Control control) {
        control.getProperties().remove((Object)ANCHOR_PROPERTY_KEY);
    }

    public CellView(SpreadsheetHandle spreadsheetHandle) {
        this.handle = spreadsheetHandle;
        this.addEventHandler(MouseEvent.DRAG_DETECTED, (EventHandler)new WeakEventHandler(this.startFullDragEventHandler));
        this.setOnMouseDragEntered((EventHandler)new WeakEventHandler(this.dragMouseEventHandler));
        this.itemProperty().addListener(this.itemChangeListener);
    }

    public void startEdit() {
        if (this.getParent() == null) {
            this.updateTableView(null);
            this.updateTableRow(null);
            this.updateTableColumn(null);
            return;
        }
        if (!this.isEditable()) {
            this.getTableView().edit(-1, null);
            return;
        }
        int n2 = this.getTableView().getColumns().indexOf((Object)this.getTableColumn());
        int n3 = this.getIndex();
        SpreadsheetView spreadsheetView = this.handle.getView();
        SpreadsheetView.SpanType spanType = spreadsheetView.getSpanType(n3, n2);
        if (spanType == SpreadsheetView.SpanType.NORMAL_CELL || spanType == SpreadsheetView.SpanType.ROW_VISIBLE) {
            if (!this.getTableRow().isManaged()) {
                return;
            }
            GridCellEditor gridCellEditor = this.getEditor((SpreadsheetCell)this.getItem(), spreadsheetView);
            if (gridCellEditor != null) {
                super.startEdit();
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                gridCellEditor.startEdit();
            } else {
                this.getTableView().edit(-1, null);
            }
        }
    }

    Filter getFilter() {
        Filter filter;
        Filter filter2 = filter = this.getItem() != null && ((SpreadsheetCell)this.getItem()).getColumn() < this.handle.getView().getColumns().size() ? ((SpreadsheetColumn)this.handle.getView().getColumns().get(((SpreadsheetCell)this.getItem()).getColumn())).getFilter() : null;
        if (filter != null && ((SpreadsheetCell)this.getItem()).getRowSpan() > 1) {
            int n2;
            int n3 = this.handle.getView().getRowSpan((SpreadsheetCell)this.getItem(), this.getIndex());
            for (int i2 = n2 = ((SpreadsheetCell)this.getItem()).getRow(); i2 < n2 + n3; ++i2) {
                if (this.handle.getView().getFilteredRow() != this.handle.getView().getModelRow(i2)) continue;
                return filter;
            }
            return null;
        }
        return filter != null && this.handle.getView().getFilteredRow() == this.handle.getView().getModelRow(this.getIndex()) ? filter : null;
    }

    public void commitEdit(SpreadsheetCell spreadsheetCell) {
        FadeTransition fadeTransition = new FadeTransition(FADE_DURATION, (Node)this);
        fadeTransition.setFromValue(0.0);
        fadeTransition.setToValue(1.0);
        fadeTransition.play();
        if (!this.isEditing()) {
            return;
        }
        super.commitEdit((Object)spreadsheetCell);
        this.setContentDisplay(ContentDisplay.LEFT);
        this.updateItem(spreadsheetCell, false);
        if (this.getTableView() != null) {
            this.getTableView().requestFocus();
        }
    }

    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        super.cancelEdit();
        this.setContentDisplay(ContentDisplay.LEFT);
        this.updateItem((SpreadsheetCell)this.getItem(), false);
        GridCellEditor gridCellEditor = this.handle.getCellsViewSkin().getSpreadsheetCellEditorImpl();
        if (gridCellEditor.isEditing()) {
            gridCellEditor.endEdit(false);
        }
        if (this.getTableView() != null) {
            this.getTableView().requestFocus();
        }
    }

    public void updateItem(SpreadsheetCell spreadsheetCell, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.getTableView().getItems().size() < this.getIndex() + 1;
        if (!this.isEditing()) {
            super.updateItem((Object)spreadsheetCell, bl2 && bl3);
        }
        if (bl2 && this.isSelected()) {
            this.updateSelected(false);
        }
        if (bl2 && bl3) {
            this.textProperty().unbind();
            this.setText(null);
            this.releaseCellGraphic();
        } else if (!this.isEditing() && spreadsheetCell != null) {
            this.show(spreadsheetCell);
            if (spreadsheetCell.getGraphic() == null && !spreadsheetCell.isCellGraphic()) {
                this.setGraphic(null);
            }
        }
    }

    public void releaseCellGraphic() {
        CellGraphicFactory cellGraphicFactory = this.handle.getView().getCellGraphicFactory();
        if (cellGraphicFactory != null && this.getGraphic() != null && cellGraphicFactory.getType().isAssignableFrom(this.getGraphic().getClass())) {
            cellGraphicFactory.setUnusedNode(this.getGraphic());
            this.setGraphic(null);
            this.parentProperty().removeListener(this.parentListener);
        }
    }

    protected void layoutChildren() {
        CellGraphicFactory cellGraphicFactory;
        super.layoutChildren();
        if (this.dirtyStyle && ((SpreadsheetCell)this.getItem()).isCellGraphic() && (cellGraphicFactory = this.handle.getView().getCellGraphicFactory()) != null) {
            Node node = this.getGraphic() != null && cellGraphicFactory.getType().isAssignableFrom(this.getGraphic().getClass()) ? this.getGraphic() : null;
            cellGraphicFactory.loadStyle(node, (SpreadsheetCell)this.getItem(), this.getFont(), this.getTextFill(), this.getAlignment(), this.getBackground());
            this.dirtyStyle = false;
        }
    }

    public void show(SpreadsheetCell spreadsheetCell) {
        String string;
        this.textProperty().bind((ObservableValue)spreadsheetCell.textProperty());
        this.setCellGraphic(spreadsheetCell);
        Optional<String> optional = spreadsheetCell.getTooltip();
        String string2 = string = optional.isPresent() ? optional.get().trim() : null;
        if (string != null && !string.isEmpty()) {
            Tooltip tooltip = this.getAvailableTooltip();
            if (tooltip != null) {
                if (!Objects.equals(tooltip.getText(), string)) {
                    this.getTooltip().setText(string);
                }
            } else {
                CellView.getValue(() -> {
                    Tooltip tooltip = new Tooltip((String)optional.get());
                    tooltip.setWrapText(true);
                    tooltip.setMaxWidth(400.0);
                    this.setTooltip(tooltip);
                });
            }
        } else {
            if (this.getTooltip() != null) {
                this.tooltip = this.getTooltip();
            }
            this.setTooltip(null);
        }
        this.setWrapText(spreadsheetCell.isWrapText());
        this.setEditable(spreadsheetCell.hasPopup() ? false : spreadsheetCell.isEditable());
        if (spreadsheetCell.hasPopup()) {
            this.setOnMouseClicked((EventHandler)this.weakActionhandler);
            this.setCursor(Cursor.HAND);
        } else {
            this.setOnMouseClicked(null);
            this.setCursor(Cursor.DEFAULT);
        }
        if (spreadsheetCell.getCellType().acceptDrop()) {
            this.setOnDragOver(this.getDragOverHandler());
            this.setOnDragDropped(this.getDragDropHandler());
        } else {
            this.setOnDragOver(null);
            this.setOnDragDropped(null);
        }
    }

    private Tooltip getAvailableTooltip() {
        if (this.getTooltip() != null) {
            return this.getTooltip();
        }
        if (this.tooltip != null) {
            this.setTooltip(this.tooltip);
            return this.tooltip;
        }
        return null;
    }

    public boolean isOriginalCell() {
        return this.handle.getView().getReverseRowSpan((SpreadsheetCell)this.getItem(), this.getIndex()) <= 1;
    }

    private void setBrowserGraphic(SpreadsheetCell spreadsheetCell) {
        CellGraphicFactory cellGraphicFactory = this.handle.getView().getCellGraphicFactory();
        if (cellGraphicFactory == null) {
            return;
        }
        this.textProperty().unbind();
        this.setText(null);
        if (this.getGraphic() != null && cellGraphicFactory.getType().isAssignableFrom(this.getGraphic().getClass())) {
            cellGraphicFactory.load(this.getGraphic(), spreadsheetCell);
        } else {
            this.dirtyStyle = true;
            this.setGraphic(cellGraphicFactory.getNode(spreadsheetCell));
            if (!this.handle.getView().getFixedRows().contains((Object)this.getIndex()) && !this.handle.getView().getFixedColumns().contains((Object)spreadsheetCell.getColumn())) {
                this.parentProperty().addListener(this.parentListener);
            }
        }
    }

    private void setCellGraphic(SpreadsheetCell spreadsheetCell) {
        Node node;
        if (this.isEditing()) {
            return;
        }
        if (spreadsheetCell.isCellGraphic() && spreadsheetCell.getItem() != null) {
            this.setBrowserGraphic(spreadsheetCell);
            return;
        }
        if (this.getGraphic() != null) {
            this.releaseCellGraphic();
        }
        if ((node = spreadsheetCell.getGraphic()) != null) {
            if (node instanceof ImageView) {
                ImageView imageView = (ImageView)node;
                imageView.setCache(true);
                imageView.setPreserveRatio(true);
                imageView.setSmooth(true);
                if (imageView.getImage() != null) {
                    imageView.fitHeightProperty().bind((ObservableValue)new When((ObservableBooleanValue)this.heightProperty().greaterThan(imageView.getImage().getHeight())).then(imageView.getImage().getHeight()).otherwise((ObservableNumberValue)this.heightProperty()));
                    imageView.fitWidthProperty().bind((ObservableValue)new When((ObservableBooleanValue)this.widthProperty().greaterThan(imageView.getImage().getWidth())).then(imageView.getImage().getWidth()).otherwise((ObservableNumberValue)this.widthProperty()));
                }
            } else if (node instanceof Region && spreadsheetCell.getItem() == null) {
                Region region = (Region)node;
                region.minHeightProperty().bind((ObservableValue)this.heightProperty());
                region.minWidthProperty().bind((ObservableValue)this.widthProperty());
            }
            this.setGraphic(node);
            if (!this.getChildren().contains((Object)node)) {
                this.getChildren().add((Object)node);
            }
        } else {
            this.setGraphic(null);
        }
    }

    private GridCellEditor getEditor(SpreadsheetCell spreadsheetCell, SpreadsheetView spreadsheetView) {
        SpreadsheetCellType spreadsheetCellType = spreadsheetCell.getCellType();
        Optional<SpreadsheetCellEditor> optional = spreadsheetView.getEditor(spreadsheetCellType);
        if (optional.isPresent()) {
            GridCellEditor gridCellEditor = this.handle.getCellsViewSkin().getSpreadsheetCellEditorImpl();
            if (gridCellEditor.isEditing()) {
                if (gridCellEditor.getModelCell() != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("The cell at row ").append(gridCellEditor.getModelCell().getRow()).append(" and column ").append(gridCellEditor.getModelCell().getColumn()).append(" was in edition and cell at row ").append(spreadsheetCell.getRow()).append(" and column ").append(spreadsheetCell.getColumn()).append(" requested edition. This situation should not happen as the previous cell should not be in edition.");
                    Logger.getLogger("root").warning(stringBuilder.toString());
                }
                gridCellEditor.endEdit(false);
            }
            gridCellEditor.updateSpreadsheetCell(this);
            gridCellEditor.updateDataCell(spreadsheetCell);
            gridCellEditor.updateSpreadsheetCellEditor(optional.get());
            return gridCellEditor;
        }
        return null;
    }

    private EventHandler<DragEvent> getDragOverHandler() {
        if (this.dragOverHandler == null) {
            this.dragOverHandler = new EventHandler<DragEvent>(){

                public void handle(DragEvent dragEvent) {
                    Dragboard dragboard = dragEvent.getDragboard();
                    if (dragboard.hasFiles()) {
                        dragEvent.acceptTransferModes(TransferMode.ANY);
                    } else {
                        dragEvent.consume();
                    }
                }
            };
        }
        return this.dragOverHandler;
    }

    private EventHandler<DragEvent> getDragDropHandler() {
        if (this.dragDropHandler == null) {
            this.dragDropHandler = new EventHandler<DragEvent>(){

                public void handle(DragEvent dragEvent) {
                    Dragboard dragboard = dragEvent.getDragboard();
                    boolean bl2 = false;
                    if (dragboard.hasFiles() && dragboard.getFiles().size() == 1 && ((SpreadsheetCell)CellView.this.getItem()).getCellType().match(dragboard.getFiles().get(0), ((SpreadsheetCell)CellView.this.getItem()).getOptionsForEditor())) {
                        CellView.this.handle.getView().getGrid().setCellValue(((SpreadsheetCell)CellView.this.getItem()).getRow(), ((SpreadsheetCell)CellView.this.getItem()).getColumn(), ((SpreadsheetCell)CellView.this.getItem()).getCellType().convertValue(dragboard.getFiles().get(0)));
                        bl2 = true;
                    }
                    dragEvent.setDropCompleted(bl2);
                    dragEvent.consume();
                }
            };
        }
        return this.dragDropHandler;
    }

    private void dragSelect(MouseEvent mouseEvent) {
        if (!this.contains(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        TableView tableView = this.getTableView();
        if (tableView == null) {
            return;
        }
        int n2 = tableView.getItems().size();
        if (this.getIndex() >= n2) {
            return;
        }
        TableView.TableViewSelectionModel tableViewSelectionModel = tableView.getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        int n3 = this.getIndex();
        int n4 = tableView.getVisibleLeafIndex(this.getTableColumn());
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)this.getItem();
        int n5 = this.getIndex() + this.handle.getView().getRowSpan(spreadsheetCell, this.getIndex()) - 1;
        int n6 = this.handle.getView().getViewColumn(spreadsheetCell.getColumn()) + this.handle.getView().getColumnSpan(spreadsheetCell) - 1;
        TableView.TableViewFocusModel tableViewFocusModel = tableView.getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        TablePosition tablePosition = tableViewFocusModel.getFocusedCell();
        MouseButton mouseButton = mouseEvent.getButton();
        if (mouseButton == MouseButton.PRIMARY) {
            TablePositionBase<?> tablePositionBase = CellView.getAnchor((Control)tableView, tablePosition);
            int n7 = Math.min(tablePositionBase.getRow(), n3);
            n7 = Math.min(n7, n5);
            int n8 = Math.max(tablePositionBase.getRow(), n3);
            n8 = Math.max(n8, n5);
            int n9 = Math.min(tablePositionBase.getColumn(), n4);
            n9 = Math.min(n9, n6);
            int n10 = Math.max(tablePositionBase.getColumn(), n4);
            n10 = Math.max(n10, n6);
            if (!mouseEvent.isShortcutDown()) {
                tableViewSelectionModel.clearSelection();
            }
            if (n9 != -1 && n10 != -1) {
                tableViewSelectionModel.selectRange(n7, (TableColumnBase)tableView.getVisibleLeafColumn(n9), n8, (TableColumnBase)tableView.getVisibleLeafColumn(n10));
            }
            CellView.setAnchor((Control)tableView, tablePositionBase);
        }
    }

    public static void getValue(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new CellViewSkin(this);
    }

    private void initStyleListener() {
        if (this.styleListener == null) {
            this.styleListener = (observableValue, string, string2) -> {
                this.styleProperty().set(string2);
                if (this.getItem() != null && ((SpreadsheetCell)this.getItem()).isCellGraphic()) {
                    this.dirtyStyle = true;
                }
            };
        }
        this.weakStyleListener = new WeakChangeListener(this.styleListener);
    }
}

