/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.i18n.Localization;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.scene.control.SkinBase;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import org.controlsfx.control.textfield.CustomTextField;
import org.controlsfx.control.textfield.TextFields;

public class SearchableComboBoxSkin<T>
extends SkinBase<ComboBox<T>> {
    private static final Image filterIcon = new Image(SearchableComboBoxSkin.class.getResource("/impl/org/controlsfx/table/filter.png").toExternalForm());
    private final ComboBox<T> filteredComboBox = this.createFilteredComboBox();
    private final CustomTextField searchField;
    private T previousValue;

    public SearchableComboBoxSkin(ComboBox<T> comboBox) {
        super(comboBox);
        this.getChildren().add(this.filteredComboBox);
        this.searchField = this.createSearchField();
        this.getChildren().add((Object)this.searchField);
        this.bindSearchFieldAndFilteredComboBox();
        this.preventDefaultComboBoxKeyListener();
        comboBox.addEventHandler(KeyEvent.KEY_PRESSED, this::checkOpenPopup);
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        this.filteredComboBox.resizeRelocate(d2, d3, d4, d5);
        this.searchField.resizeRelocate(d2, d3, d4, d5);
    }

    private CustomTextField createSearchField() {
        CustomTextField customTextField = (CustomTextField)TextFields.createClearableTextField();
        customTextField.setPromptText(Localization.getString("filterpanel.search.field"));
        customTextField.setId("search");
        customTextField.getStyleClass().add((Object)"combo-box-search");
        ImageView imageView = new ImageView(filterIcon);
        imageView.setFitHeight(15.0);
        imageView.setPreserveRatio(true);
        customTextField.setLeft((Node)imageView);
        return customTextField;
    }

    private ComboBox<T> createFilteredComboBox() {
        ComboBox comboBox = new ComboBox();
        comboBox.setId("filtered");
        comboBox.getStyleClass().add((Object)"combo-box-filtered");
        comboBox.setFocusTraversable(false);
        Bindings.bindContent((List)comboBox.getStyleClass(), (ObservableList)((ComboBox)this.getSkinnable()).getStyleClass());
        comboBox.buttonCellProperty().bind((ObservableValue)((ComboBox)this.getSkinnable()).buttonCellProperty());
        comboBox.cellFactoryProperty().bind((ObservableValue)((ComboBox)this.getSkinnable()).cellFactoryProperty());
        comboBox.converterProperty().bind((ObservableValue)((ComboBox)this.getSkinnable()).converterProperty());
        comboBox.placeholderProperty().bind((ObservableValue)((ComboBox)this.getSkinnable()).placeholderProperty());
        comboBox.disableProperty().bind((ObservableValue)((ComboBox)this.getSkinnable()).disableProperty());
        comboBox.visibleRowCountProperty().bind((ObservableValue)((ComboBox)this.getSkinnable()).visibleRowCountProperty());
        comboBox.promptTextProperty().bind((ObservableValue)((ComboBox)this.getSkinnable()).promptTextProperty());
        ((ComboBox)this.getSkinnable()).showingProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                comboBox.show();
            } else {
                comboBox.hide();
            }
        });
        comboBox.valueProperty().bindBidirectional((Property)((ComboBox)this.getSkinnable()).valueProperty());
        return comboBox;
    }

    private void bindSearchFieldAndFilteredComboBox() {
        this.filteredComboBox.setItems(this.createFilteredList());
        ((ComboBox)this.getSkinnable()).itemsProperty().addListener((observableValue, observableList, observableList2) -> this.filteredComboBox.setItems(this.createFilteredList()));
        this.searchField.textProperty().addListener(observable -> this.updateFilter());
        this.searchField.visibleProperty().bind((ObservableValue)this.filteredComboBox.showingProperty());
        this.filteredComboBox.showingProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                ((ComboBox)this.getSkinnable()).show();
                this.previousValue = ((ComboBox)this.getSkinnable()).getValue();
                this.searchField.requestFocus();
            } else {
                ((ComboBox)this.getSkinnable()).hide();
                this.searchField.setText("");
            }
        });
        this.searchField.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                this.filteredComboBox.show();
            } else {
                this.filteredComboBox.hide();
            }
        });
    }

    private FilteredList<T> createFilteredList() {
        return new FilteredList(((ComboBox)this.getSkinnable()).getItems(), this.predicate());
    }

    private void updateFilter() {
        this.filteredComboBox.setItems(this.createFilteredList());
    }

    private Predicate<T> predicate() {
        String string = this.searchField.getText().trim();
        if (string.isEmpty()) {
            return null;
        }
        return this.predicate(string);
    }

    private Predicate<T> predicate(String string) {
        String[] stringArray = string.toLowerCase().split(" ");
        return object -> {
            String string = this.getDisplayText(object).toLowerCase();
            return Arrays.stream(stringArray).allMatch(string2 -> string.contains((CharSequence)string2));
        };
    }

    private String getDisplayText(T t2) {
        StringConverter stringConverter = this.filteredComboBox.getConverter();
        return t2 == null ? "" : (stringConverter != null ? stringConverter.toString(t2) : t2.toString());
    }

    private void preventDefaultComboBoxKeyListener() {
        this.filteredComboBox.skinProperty().addListener((observableValue, skin, skin2) -> {
            ListView listView;
            ComboBoxListViewSkin comboBoxListViewSkin;
            if (skin2 instanceof ComboBoxListViewSkin && (comboBoxListViewSkin = (ComboBoxListViewSkin)skin2).getPopupContent() instanceof ListView && (listView = (ListView)comboBoxListViewSkin.getPopupContent()) != null) {
                listView.setOnKeyPressed(this::checkApplyAndCancel);
            }
        });
    }

    private void checkApplyAndCancel(KeyEvent keyEvent) {
        KeyCode keyCode = keyEvent.getCode();
        if (keyCode == KeyCode.ENTER || keyCode == KeyCode.TAB) {
            if (this.filteredComboBox.getSelectionModel().isEmpty()) {
                this.filteredComboBox.getSelectionModel().selectFirst();
            }
            ((ComboBox)this.getSkinnable()).hide();
            if (keyCode == KeyCode.ENTER) {
                ((ComboBox)this.getSkinnable()).requestFocus();
            }
        } else if (keyCode == KeyCode.ESCAPE) {
            ((ComboBox)this.getSkinnable()).setValue(this.previousValue);
            ((ComboBox)this.getSkinnable()).hide();
            ((ComboBox)this.getSkinnable()).requestFocus();
        }
    }

    private void checkOpenPopup(KeyEvent keyEvent) {
        KeyCode keyCode = keyEvent.getCode();
        if (keyCode == KeyCode.UP || keyCode == KeyCode.DOWN) {
            this.filteredComboBox.show();
            keyEvent.consume();
        } else if (keyCode.isLetterKey() || keyCode.isDigitKey() || keyCode == KeyCode.SPACE) {
            this.filteredComboBox.show();
        }
    }
}

