/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.ImplUtils;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import org.controlsfx.control.RangeSlider;
import org.controlsfx.tools.Utils;

public class RangeSliderSkin
extends SkinBase<RangeSlider> {
    private NumberAxis tickLine = null;
    private double trackToTickGap = 2.0;
    private boolean showTickMarks;
    private double thumbWidth;
    private double thumbHeight;
    private Orientation orientation;
    private StackPane track;
    private double trackStart;
    private double trackLength;
    private double lowThumbPos;
    private double rangeEnd;
    private double rangeStart;
    private ThumbPane lowThumb;
    private ThumbPane highThumb;
    private StackPane rangeBar;
    private double preDragPos;
    private Point2D preDragThumbPoint;
    private FocusedChild currentFocus = FocusedChild.LOW_THUMB;
    private Callback<Void, FocusedChild> selectedValue;

    public RangeSliderSkin(RangeSlider rangeSlider) {
        super((Control)rangeSlider);
        this.orientation = ((RangeSlider)this.getSkinnable()).getOrientation();
        this.initFirstThumb();
        this.initSecondThumb();
        this.initRangeBar();
        this.registerChangeListener((ObservableValue)rangeSlider.lowValueProperty(), observableValue -> {
            this.positionLowThumb();
            this.rangeBar.resizeRelocate(this.rangeStart, this.rangeBar.getLayoutY(), this.rangeEnd - this.rangeStart, this.rangeBar.getHeight());
        });
        this.registerChangeListener((ObservableValue)rangeSlider.highValueProperty(), observableValue -> {
            this.positionHighThumb();
            this.rangeBar.resize(this.rangeEnd - this.rangeStart, this.rangeBar.getHeight());
        });
        this.registerChangeListener((ObservableValue)rangeSlider.minProperty(), observableValue -> {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setLowerBound(((RangeSlider)this.getSkinnable()).getMin());
            }
            ((RangeSlider)this.getSkinnable()).requestLayout();
        });
        this.registerChangeListener((ObservableValue)rangeSlider.maxProperty(), observableValue -> {
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setUpperBound(((RangeSlider)this.getSkinnable()).getMax());
            }
            ((RangeSlider)this.getSkinnable()).requestLayout();
        });
        this.registerChangeListener((ObservableValue)rangeSlider.orientationProperty(), observableValue -> {
            this.orientation = ((RangeSlider)this.getSkinnable()).getOrientation();
            if (this.showTickMarks && this.tickLine != null) {
                this.tickLine.setSide(this.isHorizontal() ? Side.BOTTOM : Side.RIGHT);
            }
            ((RangeSlider)this.getSkinnable()).requestLayout();
        });
        this.registerChangeListener((ObservableValue)rangeSlider.showTickMarksProperty(), observableValue -> this.setShowTickMarks(((RangeSlider)this.getSkinnable()).isShowTickMarks(), ((RangeSlider)this.getSkinnable()).isShowTickLabels()));
        this.registerChangeListener((ObservableValue)rangeSlider.showTickLabelsProperty(), observableValue -> this.setShowTickMarks(((RangeSlider)this.getSkinnable()).isShowTickMarks(), ((RangeSlider)this.getSkinnable()).isShowTickLabels()));
        this.registerChangeListener((ObservableValue)rangeSlider.majorTickUnitProperty(), observableValue -> {
            if (this.tickLine != null) {
                this.tickLine.setTickUnit(((RangeSlider)this.getSkinnable()).getMajorTickUnit());
                ((RangeSlider)this.getSkinnable()).requestLayout();
            }
        });
        this.registerChangeListener((ObservableValue)rangeSlider.minorTickCountProperty(), observableValue -> {
            if (this.tickLine != null) {
                this.tickLine.setMinorTickCount(Math.max(((RangeSlider)this.getSkinnable()).getMinorTickCount(), 0) + 1);
                ((RangeSlider)this.getSkinnable()).requestLayout();
            }
        });
        this.lowThumb.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                this.currentFocus = FocusedChild.LOW_THUMB;
            }
        });
        this.highThumb.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                this.currentFocus = FocusedChild.HIGH_THUMB;
            }
        });
        this.rangeBar.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                this.currentFocus = FocusedChild.RANGE_BAR;
            }
        });
        rangeSlider.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                this.lowThumb.setFocus(true);
            } else {
                this.lowThumb.setFocus(false);
                this.highThumb.setFocus(false);
                this.currentFocus = FocusedChild.NONE;
            }
        });
        EventHandler eventHandler = keyEvent -> {
            if (KeyCode.TAB.equals((Object)keyEvent.getCode())) {
                if (this.lowThumb.isFocused()) {
                    if (keyEvent.isShiftDown()) {
                        ImplUtils.focusPreviousSibling((Node)this.getSkinnable());
                    } else {
                        this.lowThumb.setFocus(false);
                        this.highThumb.setFocus(true);
                    }
                    keyEvent.consume();
                } else if (this.highThumb.isFocused()) {
                    if (keyEvent.isShiftDown()) {
                        this.highThumb.setFocus(false);
                        this.lowThumb.setFocus(true);
                    } else {
                        ImplUtils.focusNextSibling((Node)this.getSkinnable());
                    }
                    keyEvent.consume();
                }
            } else if (KeyCode.LEFT.equals((Object)keyEvent.getCode()) || KeyCode.KP_LEFT.equals((Object)keyEvent.getCode())) {
                if (((RangeSlider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
                    this.rtl((RangeSlider)this.getSkinnable(), this::incrementValue, this::decrementValue);
                }
            } else if (KeyCode.RIGHT.equals((Object)keyEvent.getCode()) || KeyCode.KP_RIGHT.equals((Object)keyEvent.getCode())) {
                if (((RangeSlider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
                    this.rtl((RangeSlider)this.getSkinnable(), this::decrementValue, this::incrementValue);
                }
            } else if (KeyCode.DOWN.equals((Object)keyEvent.getCode()) || KeyCode.KP_DOWN.equals((Object)keyEvent.getCode())) {
                if (((RangeSlider)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                    this.decrementValue();
                }
            } else if ((KeyCode.UP.equals((Object)keyEvent.getCode()) || KeyCode.KP_UP.equals((Object)keyEvent.getCode())) && ((RangeSlider)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                this.incrementValue();
            }
            keyEvent.consume();
        };
        EventHandler eventHandler2 = keyEvent -> {
            if (KeyCode.HOME.equals((Object)keyEvent.getCode())) {
                this.home();
            } else if (KeyCode.END.equals((Object)keyEvent.getCode())) {
                this.end();
            }
            keyEvent.consume();
        };
        ((RangeSlider)this.getSkinnable()).addEventHandler(KeyEvent.KEY_PRESSED, eventHandler);
        ((RangeSlider)this.getSkinnable()).addEventHandler(KeyEvent.KEY_RELEASED, eventHandler2);
        this.setSelectedValue((Callback<Void, FocusedChild>)((Callback)void_ -> this.currentFocus));
    }

    private void initFirstThumb() {
        this.lowThumb = new ThumbPane();
        this.lowThumb.getStyleClass().setAll((Object[])new String[]{"low-thumb"});
        this.lowThumb.setFocusTraversable(true);
        this.track = new StackPane();
        this.track.setFocusTraversable(false);
        this.track.getStyleClass().setAll((Object[])new String[]{"track"});
        this.getChildren().clear();
        this.getChildren().addAll((Object[])new Node[]{this.track, this.lowThumb});
        this.setShowTickMarks(((RangeSlider)this.getSkinnable()).isShowTickMarks(), ((RangeSlider)this.getSkinnable()).isShowTickLabels());
        this.track.setOnMousePressed(mouseEvent -> {
            if (!this.lowThumb.isPressed() && !this.highThumb.isPressed()) {
                if (this.isHorizontal()) {
                    this.trackPress((MouseEvent)mouseEvent, mouseEvent.getX() / this.trackLength);
                } else {
                    this.trackPress((MouseEvent)mouseEvent, mouseEvent.getY() / this.trackLength);
                }
            }
        });
        this.track.setOnMouseReleased(mouseEvent -> this.trackRelease((MouseEvent)mouseEvent, 0.0));
        this.lowThumb.setOnMousePressed(mouseEvent -> {
            this.highThumb.setFocus(false);
            this.lowThumb.setFocus(true);
            this.lowThumbPressed((MouseEvent)mouseEvent, 0.0);
            this.preDragThumbPoint = this.lowThumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
            this.preDragPos = (((RangeSlider)this.getSkinnable()).getLowValue() - ((RangeSlider)this.getSkinnable()).getMin()) / this.getMaxMinusMinNoZero();
        });
        this.lowThumb.setOnMouseReleased(mouseEvent -> this.lowThumbReleased((MouseEvent)mouseEvent));
        this.lowThumb.setOnMouseDragged(mouseEvent -> {
            Point2D point2D = this.lowThumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
            double d2 = this.isHorizontal() ? point2D.getX() - this.preDragThumbPoint.getX() : -(point2D.getY() - this.preDragThumbPoint.getY());
            this.lowThumbDragged((MouseEvent)mouseEvent, this.preDragPos + d2 / this.trackLength);
        });
    }

    private void initSecondThumb() {
        this.highThumb = new ThumbPane();
        this.highThumb.getStyleClass().setAll((Object[])new String[]{"high-thumb"});
        if (!this.getChildren().contains((Object)this.highThumb)) {
            this.getChildren().add((Object)this.highThumb);
        }
        this.highThumb.setOnMousePressed(mouseEvent -> {
            this.lowThumb.setFocus(false);
            this.highThumb.setFocus(true);
            this.highThumbPressed((MouseEvent)mouseEvent, 0.0);
            this.preDragThumbPoint = this.highThumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
            this.preDragPos = (((RangeSlider)this.getSkinnable()).getHighValue() - ((RangeSlider)this.getSkinnable()).getMin()) / this.getMaxMinusMinNoZero();
        });
        this.highThumb.setOnMouseReleased(mouseEvent -> this.highThumbReleased((MouseEvent)mouseEvent));
        this.highThumb.setOnMouseDragged(mouseEvent -> {
            boolean bl2 = ((RangeSlider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
            double d2 = bl2 ? this.track.getWidth() : this.track.getHeight();
            Point2D point2D = this.highThumb.localToParent(mouseEvent.getX(), mouseEvent.getY());
            double d3 = ((RangeSlider)this.getSkinnable()).getOrientation() != Orientation.HORIZONTAL ? -(point2D.getY() - this.preDragThumbPoint.getY()) : point2D.getX() - this.preDragThumbPoint.getX();
            this.highThumbDragged((MouseEvent)mouseEvent, this.preDragPos + d3 / d2);
        });
    }

    private void initRangeBar() {
        this.rangeBar = new StackPane();
        this.rangeBar.setFocusTraversable(false);
        this.rangeBar.cursorProperty().bind((ObservableValue)new ObjectBinding<Cursor>(){
            {
                this.bind(new Observable[]{RangeSliderSkin.this.rangeBar.hoverProperty()});
            }

            protected Cursor computeValue() {
                return RangeSliderSkin.this.rangeBar.isHover() ? Cursor.HAND : Cursor.DEFAULT;
            }
        });
        this.rangeBar.getStyleClass().setAll((Object[])new String[]{"range-bar"});
        this.rangeBar.setOnMousePressed(mouseEvent -> {
            this.rangeBar.requestFocus();
            this.preDragPos = this.isHorizontal() ? mouseEvent.getX() : -mouseEvent.getY();
        });
        this.rangeBar.setOnMouseDragged(mouseEvent -> {
            double d2 = (this.isHorizontal() ? mouseEvent.getX() : -mouseEvent.getY()) - this.preDragPos;
            this.moveRange(d2);
        });
        this.rangeBar.setOnMouseReleased(mouseEvent -> this.confirmRange());
        this.getChildren().add((Object)this.rangeBar);
    }

    private void setShowTickMarks(boolean bl2, boolean bl3) {
        this.showTickMarks = bl2 || bl3;
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        if (this.showTickMarks) {
            if (this.tickLine == null) {
                this.tickLine = new NumberAxis();
                this.tickLine.setFocusTraversable(false);
                this.tickLine.tickLabelFormatterProperty().bind(((RangeSlider)this.getSkinnable()).labelFormatterProperty());
                this.tickLine.setAnimated(false);
                this.tickLine.setAutoRanging(false);
                this.tickLine.setSide(this.isHorizontal() ? Side.BOTTOM : Side.RIGHT);
                this.tickLine.setUpperBound(rangeSlider.getMax());
                this.tickLine.setLowerBound(rangeSlider.getMin());
                this.tickLine.setTickUnit(rangeSlider.getMajorTickUnit());
                this.tickLine.setTickMarkVisible(bl2);
                this.tickLine.setTickLabelsVisible(bl3);
                this.tickLine.setMinorTickVisible(bl2);
                this.tickLine.setMinorTickCount(Math.max(rangeSlider.getMinorTickCount(), 0) + 1);
                this.getChildren().clear();
                this.getChildren().addAll((Object[])new Node[]{this.tickLine, this.track, this.lowThumb});
            } else {
                this.tickLine.setTickLabelsVisible(bl3);
                this.tickLine.setTickMarkVisible(bl2);
                this.tickLine.setMinorTickVisible(bl2);
            }
        } else {
            this.getChildren().clear();
            this.getChildren().addAll((Object[])new Node[]{this.track, this.lowThumb});
        }
        ((RangeSlider)this.getSkinnable()).requestLayout();
    }

    private double getMaxMinusMinNoZero() {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        return rangeSlider.getMax() - rangeSlider.getMin() == 0.0 ? 1.0 : rangeSlider.getMax() - rangeSlider.getMin();
    }

    private void positionLowThumb() {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        boolean bl2 = this.isHorizontal();
        double d2 = bl2 ? this.trackStart + (this.trackLength * ((rangeSlider.getLowValue() - rangeSlider.getMin()) / this.getMaxMinusMinNoZero()) - this.thumbWidth / 2.0) : this.lowThumbPos;
        double d3 = bl2 ? this.lowThumbPos : ((RangeSlider)this.getSkinnable()).getInsets().getTop() + this.trackLength - this.trackLength * ((rangeSlider.getLowValue() - rangeSlider.getMin()) / this.getMaxMinusMinNoZero());
        this.lowThumb.setLayoutX(d2);
        this.lowThumb.setLayoutY(d3);
        if (bl2) {
            this.rangeStart = d2 + this.thumbWidth;
        } else {
            this.rangeEnd = d3;
        }
    }

    private void positionHighThumb() {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        boolean bl2 = ((RangeSlider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
        double d2 = this.lowThumb.getWidth();
        double d3 = this.lowThumb.getHeight();
        this.highThumb.resize(d2, d3);
        double d4 = 0.0;
        double d5 = bl2 ? this.track.getLayoutX() : this.track.getLayoutY();
        double d6 = bl2 ? this.track.getWidth() : this.track.getHeight();
        double d7 = bl2 ? (d5 += d4) + ((d6 -= 2.0 * d4) * ((rangeSlider.getHighValue() - rangeSlider.getMin()) / this.getMaxMinusMinNoZero()) - d2 / 2.0) : this.lowThumb.getLayoutX();
        double d8 = bl2 ? this.lowThumb.getLayoutY() : ((RangeSlider)this.getSkinnable()).getInsets().getTop() + d6 - d6 * ((rangeSlider.getHighValue() - rangeSlider.getMin()) / this.getMaxMinusMinNoZero());
        this.highThumb.setLayoutX(d7);
        this.highThumb.setLayoutY(d8);
        if (bl2) {
            this.rangeEnd = d7;
        } else {
            this.rangeStart = d8 + d2;
        }
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6;
        this.thumbWidth = this.lowThumb.prefWidth(-1.0);
        this.thumbHeight = this.lowThumb.prefHeight(-1.0);
        this.lowThumb.resize(this.thumbWidth, this.thumbHeight);
        double d7 = this.track.getBackground() == null ? 0.0 : (d6 = this.track.getBackground().getFills().size() > 0 ? ((BackgroundFill)this.track.getBackground().getFills().get(0)).getRadii().getTopLeftHorizontalRadius() : 0.0);
        if (this.isHorizontal()) {
            double d8 = this.showTickMarks ? this.tickLine.prefHeight(-1.0) : 0.0;
            double d9 = this.track.prefHeight(-1.0);
            double d10 = Math.max(d9, this.thumbHeight);
            double d11 = d10 + (this.showTickMarks ? this.trackToTickGap + d8 : 0.0);
            double d12 = d3 + (d5 - d11) / 2.0;
            this.trackLength = d4 - this.thumbWidth;
            this.trackStart = d2 + this.thumbWidth / 2.0;
            double d13 = (int)(d12 + (d10 - d9) / 2.0);
            this.lowThumbPos = (int)(d12 + (d10 - this.thumbHeight) / 2.0);
            this.positionLowThumb();
            this.track.resizeRelocate(this.trackStart - d6, d13, this.trackLength + d6 + d6, d9);
            this.positionHighThumb();
            this.rangeBar.resizeRelocate(this.rangeStart, d13, this.rangeEnd - this.rangeStart, d9);
            if (this.showTickMarks) {
                this.tickLine.setLayoutX(this.trackStart);
                this.tickLine.setLayoutY(d13 + d9 + this.trackToTickGap);
                this.tickLine.resize(this.trackLength, d8);
                this.tickLine.requestAxisLayout();
            } else {
                if (this.tickLine != null) {
                    this.tickLine.resize(0.0, 0.0);
                    this.tickLine.requestAxisLayout();
                }
                this.tickLine = null;
            }
        } else {
            double d14 = this.showTickMarks ? this.tickLine.prefWidth(-1.0) : 0.0;
            double d15 = this.track.prefWidth(-1.0);
            double d16 = Math.max(d15, this.thumbWidth);
            double d17 = d16 + (this.showTickMarks ? this.trackToTickGap + d14 : 0.0);
            double d18 = d2 + (d4 - d17) / 2.0;
            this.trackLength = d5 - this.thumbHeight;
            this.trackStart = d3 + this.thumbHeight / 2.0;
            double d19 = (int)(d18 + (d16 - d15) / 2.0);
            this.lowThumbPos = (int)(d18 + (d16 - this.thumbWidth) / 2.0);
            this.positionLowThumb();
            this.track.resizeRelocate(d19, this.trackStart - d6, d15, this.trackLength + d6 + d6);
            this.positionHighThumb();
            this.rangeBar.resizeRelocate(d19, this.rangeStart, d15, this.rangeEnd - this.rangeStart);
            if (this.showTickMarks) {
                this.tickLine.setLayoutX(d19 + d15 + this.trackToTickGap);
                this.tickLine.setLayoutY(this.trackStart);
                this.tickLine.resize(d14, this.trackLength);
                this.tickLine.requestAxisLayout();
            } else {
                if (this.tickLine != null) {
                    this.tickLine.resize(0.0, 0.0);
                    this.tickLine.requestAxisLayout();
                }
                this.tickLine = null;
            }
        }
    }

    private double minTrackLength() {
        return 2.0 * this.lowThumb.prefWidth(-1.0);
    }

    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        if (this.isHorizontal()) {
            return d6 + this.minTrackLength() + this.lowThumb.minWidth(-1.0) + d4;
        }
        return d6 + this.lowThumb.prefWidth(-1.0) + d4;
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        if (this.isHorizontal()) {
            return d3 + this.lowThumb.prefHeight(-1.0) + d5;
        }
        return d3 + this.minTrackLength() + this.lowThumb.prefHeight(-1.0) + d5;
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        if (this.isHorizontal()) {
            if (this.showTickMarks) {
                return Math.max(140.0, this.tickLine.prefWidth(-1.0));
            }
            return 140.0;
        }
        return d6 + Math.max(this.lowThumb.prefWidth(-1.0), this.track.prefWidth(-1.0)) + (this.showTickMarks ? this.trackToTickGap + this.tickLine.prefWidth(-1.0) : 0.0) + d4;
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        if (this.isHorizontal()) {
            return ((RangeSlider)this.getSkinnable()).getInsets().getTop() + Math.max(this.lowThumb.prefHeight(-1.0), this.track.prefHeight(-1.0)) + (this.showTickMarks ? this.trackToTickGap + this.tickLine.prefHeight(-1.0) : 0.0) + d5;
        }
        if (this.showTickMarks) {
            return Math.max(140.0, this.tickLine.prefHeight(-1.0));
        }
        return 140.0;
    }

    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        if (this.isHorizontal()) {
            return Double.MAX_VALUE;
        }
        return ((RangeSlider)this.getSkinnable()).prefWidth(-1.0);
    }

    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        if (this.isHorizontal()) {
            return ((RangeSlider)this.getSkinnable()).prefHeight(d2);
        }
        return Double.MAX_VALUE;
    }

    private boolean isHorizontal() {
        return this.orientation == null || this.orientation == Orientation.HORIZONTAL;
    }

    public void setSelectedValue(Callback<Void, FocusedChild> callback) {
        this.selectedValue = callback;
    }

    private void highThumbReleased(MouseEvent mouseEvent) {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        rangeSlider.setHighValueChanging(false);
        if (rangeSlider.isSnapToTicks()) {
            rangeSlider.setHighValue(this.snapValueToTicks(rangeSlider.getHighValue()));
        }
    }

    private void highThumbPressed(MouseEvent mouseEvent, double d2) {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        if (!rangeSlider.isFocused()) {
            rangeSlider.requestFocus();
        }
        rangeSlider.setHighValueChanging(true);
    }

    private void highThumbDragged(MouseEvent mouseEvent, double d2) {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        rangeSlider.setHighValue(Utils.clamp(rangeSlider.getMin(), d2 * (rangeSlider.getMax() - rangeSlider.getMin()) + rangeSlider.getMin(), rangeSlider.getMax()));
    }

    private void moveRange(double d2) {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        double d3 = rangeSlider.getMin();
        double d4 = rangeSlider.getMax();
        double d5 = rangeSlider.getLowValue();
        double d6 = Utils.clamp(d3, d5 + d2 * (d4 - d3) / (rangeSlider.getOrientation() == Orientation.HORIZONTAL ? rangeSlider.getWidth() : rangeSlider.getHeight()), d4);
        double d7 = rangeSlider.getHighValue();
        double d8 = Utils.clamp(d3, d7 + d2 * (d4 - d3) / (rangeSlider.getOrientation() == Orientation.HORIZONTAL ? rangeSlider.getWidth() : rangeSlider.getHeight()), d4);
        if (d6 <= d3 || d8 >= d4) {
            return;
        }
        rangeSlider.setLowValueChanging(true);
        rangeSlider.setHighValueChanging(true);
        rangeSlider.setLowValue(d6);
        rangeSlider.setHighValue(d8);
    }

    private void confirmRange() {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        rangeSlider.setLowValueChanging(false);
        if (rangeSlider.isSnapToTicks()) {
            rangeSlider.setLowValue(this.snapValueToTicks(rangeSlider.getLowValue()));
        }
        rangeSlider.setHighValueChanging(false);
        if (rangeSlider.isSnapToTicks()) {
            rangeSlider.setHighValue(this.snapValueToTicks(rangeSlider.getHighValue()));
        }
    }

    private void trackPress(MouseEvent mouseEvent, double d2) {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        if (!rangeSlider.isFocused()) {
            rangeSlider.requestFocus();
        }
        if (this.selectedValue != null) {
            double d3 = rangeSlider.getOrientation().equals((Object)Orientation.HORIZONTAL) ? d2 * (rangeSlider.getMax() - rangeSlider.getMin()) + rangeSlider.getMin() : (1.0 - d2) * (rangeSlider.getMax() - rangeSlider.getMin()) + rangeSlider.getMin();
            if (d3 < rangeSlider.getLowValue()) {
                rangeSlider.adjustLowValue(d3);
            } else {
                rangeSlider.adjustHighValue(d3);
            }
        }
    }

    public void trackRelease(MouseEvent mouseEvent, double d2) {
    }

    public void lowThumbPressed(MouseEvent mouseEvent, double d2) {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        if (!rangeSlider.isFocused()) {
            rangeSlider.requestFocus();
        }
        rangeSlider.setLowValueChanging(true);
    }

    public void lowThumbDragged(MouseEvent mouseEvent, double d2) {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        double d3 = Utils.clamp(rangeSlider.getMin(), d2 * (rangeSlider.getMax() - rangeSlider.getMin()) + rangeSlider.getMin(), rangeSlider.getMax());
        rangeSlider.setLowValue(d3);
    }

    public void lowThumbReleased(MouseEvent mouseEvent) {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        rangeSlider.setLowValueChanging(false);
        if (rangeSlider.isSnapToTicks()) {
            rangeSlider.setLowValue(this.snapValueToTicks(rangeSlider.getLowValue()));
        }
    }

    void home() {
        RangeSlider rangeSlider = (RangeSlider)this.getNode();
        rangeSlider.adjustHighValue(rangeSlider.getMin());
    }

    private void decrementValue() {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        if (this.selectedValue != null) {
            if (this.selectedValue.call(null) == FocusedChild.HIGH_THUMB) {
                if (rangeSlider.isSnapToTicks()) {
                    rangeSlider.adjustHighValue(rangeSlider.getHighValue() - this.computeIncrement());
                } else {
                    rangeSlider.decrementHighValue();
                }
            } else if (rangeSlider.isSnapToTicks()) {
                rangeSlider.adjustLowValue(rangeSlider.getLowValue() - this.computeIncrement());
            } else {
                rangeSlider.decrementLowValue();
            }
        }
    }

    private void end() {
        RangeSlider rangeSlider = (RangeSlider)this.getNode();
        rangeSlider.adjustHighValue(rangeSlider.getMax());
    }

    private void incrementValue() {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        if (this.selectedValue != null) {
            if (this.selectedValue.call(null) == FocusedChild.HIGH_THUMB) {
                if (rangeSlider.isSnapToTicks()) {
                    rangeSlider.adjustHighValue(rangeSlider.getHighValue() + this.computeIncrement());
                } else {
                    rangeSlider.incrementHighValue();
                }
            } else if (rangeSlider.isSnapToTicks()) {
                rangeSlider.adjustLowValue(rangeSlider.getLowValue() + this.computeIncrement());
            } else {
                rangeSlider.incrementLowValue();
            }
        }
    }

    private double computeIncrement() {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        double d2 = rangeSlider.getMinorTickCount() != 0 ? rangeSlider.getMajorTickUnit() / (double)(Math.max(rangeSlider.getMinorTickCount(), 0) + 1) : rangeSlider.getMajorTickUnit();
        if (rangeSlider.getBlockIncrement() > 0.0 && rangeSlider.getBlockIncrement() < d2) {
            return d2;
        }
        return rangeSlider.getBlockIncrement();
    }

    private void rtl(RangeSlider rangeSlider, Runnable runnable, Runnable runnable2) {
        if (rangeSlider.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
            runnable.run();
        } else {
            runnable2.run();
        }
    }

    private double snapValueToTicks(double d2) {
        RangeSlider rangeSlider = (RangeSlider)this.getSkinnable();
        double d3 = d2;
        double d4 = rangeSlider.getMinorTickCount() != 0 ? rangeSlider.getMajorTickUnit() / (double)(Math.max(rangeSlider.getMinorTickCount(), 0) + 1) : rangeSlider.getMajorTickUnit();
        int n2 = (int)((d3 - rangeSlider.getMin()) / d4);
        double d5 = (double)n2 * d4 + rangeSlider.getMin();
        double d6 = (double)(n2 + 1) * d4 + rangeSlider.getMin();
        d3 = Utils.nearest(d5, d3, d6);
        return Utils.clamp(rangeSlider.getMin(), d3, rangeSlider.getMax());
    }

    public static enum FocusedChild {
        LOW_THUMB,
        HIGH_THUMB,
        RANGE_BAR,
        NONE;

    }

    private static class ThumbPane
    extends StackPane {
        private ThumbPane() {
        }

        public void setFocus(boolean bl2) {
            this.setFocused(bl2);
        }
    }
}

