/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.skin.ListActionViewSkin;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.controlsfx.control.ListActionView;
import org.controlsfx.control.ListSelectionView;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;

public class ListSelectionViewSkin<T>
extends SkinBase<ListSelectionView<T>> {
    private GridPane gridPane;
    private ListView<T> sourceListView = Objects.requireNonNull(this.createSourceListView(), "source list view can not be null");
    private ListView<T> targetListView;
    private ListActionView<T> sourceListActionView;
    private ListActionView<T> targetListActionView;

    public ListSelectionViewSkin(ListSelectionView<T> listSelectionView) {
        super(listSelectionView);
        this.sourceListView.setId("source-list-view");
        this.sourceListActionView = this.createListActionView(this.sourceListView);
        Bindings.bindContent(this.sourceListActionView.getActions(), listSelectionView.getSourceActions());
        Bindings.bindContentBidirectional(this.sourceListActionView.getItems(), listSelectionView.getSourceItems());
        this.targetListView = Objects.requireNonNull(this.createTargetListView(), "target list view can not be null");
        this.targetListView.setId("target-list-view");
        this.targetListActionView = this.createListActionView(this.targetListView);
        Bindings.bindContent(this.targetListActionView.getActions(), listSelectionView.getTargetActions());
        Bindings.bindContentBidirectional(this.targetListActionView.getItems(), listSelectionView.getTargetItems());
        this.sourceListActionView.cellFactoryProperty().bind(listSelectionView.cellFactoryProperty());
        this.targetListActionView.cellFactoryProperty().bind(listSelectionView.cellFactoryProperty());
        this.gridPane = this.createGridPane();
        this.getChildren().add((Object)this.gridPane);
        InvalidationListener invalidationListener = observable -> this.updateView();
        listSelectionView.sourceHeaderProperty().addListener(invalidationListener);
        listSelectionView.sourceFooterProperty().addListener(invalidationListener);
        listSelectionView.targetHeaderProperty().addListener(invalidationListener);
        listSelectionView.targetFooterProperty().addListener(invalidationListener);
        listSelectionView.getActions().addListener(invalidationListener);
        this.updateView();
        this.getSourceListView().addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 2) {
                this.moveToTarget();
            }
        });
        this.getTargetListView().addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 2) {
                this.moveToSource();
            }
        });
        listSelectionView.orientationProperty().addListener(observable -> this.updateView());
    }

    private GridPane createGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add((Object)"grid-pane");
        return gridPane;
    }

    private void setHorizontalViewConstraints() {
        this.gridPane.getColumnConstraints().clear();
        this.gridPane.getRowConstraints().clear();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setFillWidth(true);
        columnConstraints.setHgrow(Priority.ALWAYS);
        columnConstraints.setMaxWidth(Double.MAX_VALUE);
        columnConstraints.setPrefWidth(200.0);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setFillWidth(true);
        columnConstraints2.setHgrow(Priority.NEVER);
        ColumnConstraints columnConstraints3 = new ColumnConstraints();
        columnConstraints3.setFillWidth(true);
        columnConstraints3.setHgrow(Priority.ALWAYS);
        columnConstraints3.setMaxWidth(Double.MAX_VALUE);
        columnConstraints3.setPrefWidth(200.0);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints, columnConstraints2, columnConstraints3});
        RowConstraints rowConstraints = new RowConstraints();
        rowConstraints.setFillHeight(true);
        rowConstraints.setVgrow(Priority.NEVER);
        RowConstraints rowConstraints2 = new RowConstraints();
        rowConstraints2.setMaxHeight(Double.MAX_VALUE);
        rowConstraints2.setPrefHeight(200.0);
        rowConstraints2.setVgrow(Priority.ALWAYS);
        RowConstraints rowConstraints3 = new RowConstraints();
        rowConstraints3.setFillHeight(true);
        rowConstraints3.setVgrow(Priority.NEVER);
        this.gridPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraints, rowConstraints2, rowConstraints3});
    }

    private void setVerticalViewConstraints() {
        this.gridPane.getColumnConstraints().clear();
        this.gridPane.getRowConstraints().clear();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setFillWidth(true);
        columnConstraints.setHgrow(Priority.ALWAYS);
        columnConstraints.setMaxWidth(Double.MAX_VALUE);
        columnConstraints.setPrefWidth(200.0);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        RowConstraints rowConstraints = new RowConstraints();
        rowConstraints.setFillHeight(true);
        rowConstraints.setVgrow(Priority.NEVER);
        RowConstraints rowConstraints2 = new RowConstraints();
        rowConstraints2.setMaxHeight(Double.MAX_VALUE);
        rowConstraints2.setPrefHeight(200.0);
        rowConstraints2.setVgrow(Priority.ALWAYS);
        RowConstraints rowConstraints3 = new RowConstraints();
        rowConstraints3.setFillHeight(true);
        rowConstraints3.setVgrow(Priority.NEVER);
        RowConstraints rowConstraints4 = new RowConstraints();
        rowConstraints4.setFillHeight(true);
        rowConstraints4.setVgrow(Priority.NEVER);
        RowConstraints rowConstraints5 = new RowConstraints();
        rowConstraints5.setFillHeight(true);
        rowConstraints5.setVgrow(Priority.NEVER);
        RowConstraints rowConstraints6 = new RowConstraints();
        rowConstraints6.setMaxHeight(Double.MAX_VALUE);
        rowConstraints6.setPrefHeight(200.0);
        rowConstraints6.setVgrow(Priority.ALWAYS);
        RowConstraints rowConstraints7 = new RowConstraints();
        rowConstraints7.setFillHeight(true);
        rowConstraints7.setVgrow(Priority.NEVER);
        this.gridPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraints, rowConstraints2, rowConstraints3, rowConstraints4, rowConstraints5, rowConstraints6, rowConstraints7});
    }

    private VBox createVerticalButtonBox() {
        VBox vBox = new VBox(5.0);
        vBox.setFillWidth(true);
        vBox.getChildren().addAll(this.createButtonsFromActions());
        return vBox;
    }

    private HBox createHorizontalButtonBox() {
        HBox hBox = new HBox(5.0);
        hBox.setFillHeight(true);
        hBox.getChildren().addAll(this.createButtonsFromActions());
        return hBox;
    }

    private void updateView() {
        this.gridPane.getChildren().clear();
        Node node = ((ListSelectionView)this.getSkinnable()).getSourceHeader();
        Node node2 = ((ListSelectionView)this.getSkinnable()).getTargetHeader();
        Node node3 = ((ListSelectionView)this.getSkinnable()).getSourceFooter();
        Node node4 = ((ListSelectionView)this.getSkinnable()).getTargetFooter();
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER);
        Orientation orientation = ((ListSelectionView)this.getSkinnable()).getOrientation();
        if (orientation == Orientation.HORIZONTAL) {
            this.setHorizontalViewConstraints();
            if (node != null) {
                this.gridPane.add(node, 0, 0);
            }
            if (node2 != null) {
                this.gridPane.add(node2, 2, 0);
            }
            if (this.sourceListActionView != null) {
                this.sourceListActionView.setSide(Side.LEFT);
                this.gridPane.add(this.sourceListActionView, 0, 1);
            }
            if (this.targetListActionView != null) {
                this.targetListActionView.setSide(Side.RIGHT);
                this.gridPane.add(this.targetListActionView, 2, 1);
            }
            if (node3 != null) {
                this.gridPane.add(node3, 0, 2);
            }
            if (node4 != null) {
                this.gridPane.add(node4, 2, 2);
            }
            stackPane.getChildren().add((Object)this.createVerticalButtonBox());
            this.gridPane.add((Node)stackPane, 1, 1);
        } else {
            this.setVerticalViewConstraints();
            if (node != null) {
                this.gridPane.add(node, 0, 0);
            }
            if (node2 != null) {
                this.gridPane.add(node2, 0, 4);
            }
            if (this.sourceListActionView != null) {
                this.sourceListActionView.setSide(Side.RIGHT);
                this.gridPane.add(this.sourceListActionView, 0, 1);
            }
            if (this.targetListActionView != null) {
                this.targetListActionView.setSide(Side.RIGHT);
                this.gridPane.add(this.targetListActionView, 0, 5);
            }
            if (node3 != null) {
                this.gridPane.add(node3, 0, 2);
            }
            if (node4 != null) {
                this.gridPane.add(node4, 0, 6);
            }
            stackPane.getChildren().add((Object)this.createHorizontalButtonBox());
            this.gridPane.add((Node)stackPane, 0, 3);
        }
    }

    private void moveToTarget() {
        this.move(this.getSourceListView(), this.getTargetListView());
        this.getSourceListView().getSelectionModel().clearSelection();
    }

    private void moveToSource() {
        this.move(this.getTargetListView(), this.getSourceListView());
        this.getTargetListView().getSelectionModel().clearSelection();
    }

    private void move(ListView<T> listView, ListView<T> listView2) {
        ArrayList arrayList = new ArrayList(listView.getSelectionModel().getSelectedItems());
        this.move(listView, listView2, arrayList);
    }

    private void move(ListView<T> listView, ListView<T> listView2, List<T> list) {
        listView.getItems().removeAll(list);
        listView2.getItems().addAll(list);
    }

    private ObservableList<Node> createButtonsFromActions() {
        return ((ListSelectionView)this.getSkinnable()).getActions().stream().peek(this::initializeListSelectionAction).map(this::createActionNode).collect(Collectors.toCollection(FXCollections::observableArrayList));
    }

    private void initializeListSelectionAction(Action action) {
        if (action instanceof ListSelectionView.ListSelectionAction) {
            ((ListSelectionView.ListSelectionAction)action).initialize(this.sourceListView, this.targetListView);
        }
    }

    private Node createActionNode(Action action) {
        if (action == ActionUtils.ACTION_SEPARATOR) {
            return new Separator();
        }
        if (action == ActionUtils.ACTION_SPAN) {
            Pane pane = new Pane();
            HBox.setHgrow((Node)pane, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)pane, (Priority)Priority.ALWAYS);
            return pane;
        }
        return this.createActionButton(action);
    }

    private Button createActionButton(Action action) {
        Button button = ActionUtils.createButton(action);
        button.setMaxWidth(Double.MAX_VALUE);
        if (action.getAccelerator() != null) {
            ((ListSelectionView)this.getSkinnable()).getScene().getAccelerators().put((Object)action.getAccelerator(), () -> ((Button)button).fire());
        }
        return button;
    }

    public final ListView<T> getSourceListView() {
        return this.sourceListView;
    }

    public final ListView<T> getTargetListView() {
        return this.targetListView;
    }

    protected ListView<T> createSourceListView() {
        return this.createListView();
    }

    protected ListView<T> createTargetListView() {
        return this.createListView();
    }

    private ListView<T> createListView() {
        ListView listView = new ListView();
        listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        return listView;
    }

    private ListActionView<T> createListActionView(final ListView<T> listView) {
        ListActionView listActionView = new ListActionView();
        listActionView.setSkin((Skin)new ListActionViewSkin<T>(listActionView){

            @Override
            public ListView<T> createListView() {
                return listView;
            }
        });
        return listActionView;
    }
}

