/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import java.util.ArrayList;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.text.TextFlow;
import org.controlsfx.control.HyperlinkLabel;

public class HyperlinkLabelSkin
extends SkinBase<HyperlinkLabel> {
    private static final String HYPERLINK_START = "[";
    private static final String HYPERLINK_END = "]";
    private final TextFlow textFlow;
    private final EventHandler<ActionEvent> eventHandler = actionEvent -> {
        EventHandler<ActionEvent> eventHandler = ((HyperlinkLabel)this.getSkinnable()).getOnAction();
        if (eventHandler != null) {
            eventHandler.handle(actionEvent);
        }
    };

    public HyperlinkLabelSkin(HyperlinkLabel hyperlinkLabel) {
        super((Control)hyperlinkLabel);
        this.textFlow = new TextFlow();
        this.getChildren().add((Object)this.textFlow);
        this.updateText();
        this.updateFocusTraversable(((HyperlinkLabel)this.getSkinnable()).isFocusTraversable());
        this.registerChangeListener((ObservableValue)hyperlinkLabel.focusedProperty(), observableValue -> {
            if (((HyperlinkLabel)this.getSkinnable()).isFocused()) {
                this.textFlow.getChildren().stream().filter(Node::isFocusTraversable).findFirst().ifPresent(Node::requestFocus);
            }
        });
        this.registerChangeListener((ObservableValue)hyperlinkLabel.focusTraversableProperty(), observableValue -> this.updateFocusTraversable(((HyperlinkLabel)this.getSkinnable()).isFocusTraversable()));
        this.registerChangeListener((ObservableValue)hyperlinkLabel.textProperty(), observableValue -> this.updateText());
    }

    private void updateFocusTraversable(Boolean bl2) {
        this.textFlow.getChildren().stream().filter(node -> node instanceof Hyperlink).forEach(node -> node.setFocusTraversable(bl2.booleanValue()));
    }

    private void updateText() {
        String string = ((HyperlinkLabel)this.getSkinnable()).getText();
        if (string == null || string.isEmpty()) {
            this.textFlow.getChildren().clear();
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        int n3 = string.length();
        while (n2 != -1 && n2 < n3) {
            Label label;
            int n4 = string.indexOf(HYPERLINK_START, n2);
            int n5 = string.indexOf(HYPERLINK_END, n4);
            if ((n4 == -1 || n5 == -1) && n3 > n2) {
                label = new Label(string.substring(n2));
                arrayList.add(label);
                break;
            }
            label = new Label(string.substring(n2, n4));
            arrayList.add(label);
            Hyperlink hyperlink = new Hyperlink(string.substring(n4 + 1, n5));
            hyperlink.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
            hyperlink.setOnAction(this.eventHandler);
            arrayList.add(hyperlink);
            n2 = n5 + 1;
        }
        this.textFlow.getChildren().setAll(arrayList);
    }
}

