/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.skin.GridRow;
import impl.org.controlsfx.skin.GridViewSkin;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.skin.CellSkinBase;
import org.controlsfx.control.GridCell;
import org.controlsfx.control.GridView;

public class GridRowSkin<T>
extends CellSkinBase<GridRow<T>> {
    public GridRowSkin(GridRow<T> gridRow) {
        super(gridRow);
        this.getChildren().clear();
        this.updateCells();
        this.registerChangeListener((ObservableValue)((GridRow)this.getSkinnable()).widthProperty(), observableValue -> this.updateCells());
        this.registerChangeListener((ObservableValue)((GridRow)this.getSkinnable()).heightProperty(), observableValue -> this.updateCells());
    }

    public GridCell<T> getCellAtIndex(int n2) {
        if (n2 < this.getChildren().size()) {
            return (GridCell)((Object)this.getChildren().get(n2));
        }
        return null;
    }

    public void updateCells() {
        int n2 = ((GridRow)this.getSkinnable()).getIndex();
        if (n2 >= 0) {
            GridView gridView = ((GridRow)this.getSkinnable()).getGridView();
            GridViewSkin gridViewSkin = (GridViewSkin)gridView.getSkin();
            if (gridViewSkin == null) {
                return;
            }
            int n3 = gridViewSkin.computeMaxCellsInRow();
            int n4 = gridView.getItems().size();
            int n5 = n2 * n3;
            int n6 = n5 + n3 - 1;
            int n7 = 0;
            int n8 = n5;
            while (n8 <= n6 && n8 < n4) {
                GridCell<T> gridCell = this.getCellAtIndex(n7);
                if (gridCell == null) {
                    gridCell = this.createCell();
                    this.getChildren().add(gridCell);
                }
                gridCell.updateIndex(-1);
                gridCell.updateIndex(n8);
                ++n8;
                ++n7;
            }
            this.getChildren().remove(n7, this.getChildren().size());
        }
    }

    private GridCell<T> createCell() {
        GridView gridView = (GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get());
        GridCell gridCell = gridView.getCellFactory() != null ? (GridCell)((Object)gridView.getCellFactory().call((Object)gridView)) : this.createDefaultCellImpl();
        gridCell.updateGridView(gridView);
        return gridCell;
    }

    private GridCell<T> createDefaultCellImpl() {
        return new GridCell<T>(){

            protected void updateItem(T t2, boolean bl2) {
                super.updateItem(t2, bl2);
                if (bl2) {
                    this.setText("");
                } else {
                    this.setText(t2.toString());
                }
            }
        };
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return super.computePrefHeight(d2, d3, d4, d5, d6);
    }

    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return Double.MAX_VALUE;
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        GridView gridView = (GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get());
        return gridView.getCellHeight() + gridView.getVerticalCellSpacing() * 2.0;
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6 = ((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())).getCellWidth();
        double d7 = ((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())).getCellHeight();
        double d8 = ((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())).getHorizontalCellSpacing();
        double d9 = ((GridView)((Object)((GridRow)this.getSkinnable()).gridViewProperty().get())).getVerticalCellSpacing();
        double d10 = 0.0;
        double d11 = 0.0;
        for (Node node : this.getChildren()) {
            node.relocate(d10 + d8, d11 + d9);
            node.resize(d6, d7);
            d10 = d10 + d8 + d6 + d8;
        }
    }
}

