/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.TableRow;
import javafx.scene.control.skin.TableRowSkin;
import org.controlsfx.control.table.TableRowExpanderColumn;

public class ExpandableTableRowSkin<S>
extends TableRowSkin<S> {
    private final TableRow<S> tableRow;
    private TableRowExpanderColumn<S> expander;
    private Double tableRowPrefHeight = -1.0;

    public ExpandableTableRowSkin(TableRow<S> tableRow, TableRowExpanderColumn<S> tableRowExpanderColumn) {
        super(tableRow);
        this.tableRow = tableRow;
        this.expander = tableRowExpanderColumn;
        tableRow.itemProperty().addListener((observableValue, object, object2) -> {
            Node node;
            if (object != null && (node = this.expander.getExpandedNode(object)) != null) {
                this.getChildren().remove((Object)node);
            }
        });
    }

    private Node getContent() {
        Node node = this.expander.getOrCreateExpandedNode(this.tableRow);
        if (!this.getChildren().contains((Object)node)) {
            this.getChildren().add((Object)node);
        }
        return node;
    }

    private Boolean isExpanded() {
        return ((TableRow)this.getSkinnable()).getItem() != null && Objects.requireNonNullElse((Boolean)this.expander.getCellData(((TableRow)this.getSkinnable()).getIndex()), false) != false;
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        this.tableRowPrefHeight = super.computePrefHeight(d2, d3, d4, d5, d6);
        return this.isExpanded() != false ? this.tableRowPrefHeight + this.getContent().prefHeight(d2) : this.tableRowPrefHeight;
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        super.layoutChildren(d2, d3, d4, d5);
        if (this.isExpanded().booleanValue()) {
            this.getContent().resizeRelocate(0.0, this.tableRowPrefHeight.doubleValue(), d4, d5 - this.tableRowPrefHeight);
        }
    }
}

