/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.skin.AutoCompletePopup;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.input.MouseButton;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.controlsfx.control.textfield.AutoCompletionBinding;

public class AutoCompletePopupSkin<T>
implements Skin<AutoCompletePopup<T>> {
    private final AutoCompletePopup<T> control;
    private final ListView<T> suggestionList;
    final int LIST_CELL_HEIGHT = 24;

    public AutoCompletePopupSkin(AutoCompletePopup<T> autoCompletePopup) {
        this(autoCompletePopup, autoCompletePopup.getConverter());
    }

    public AutoCompletePopupSkin(AutoCompletePopup<T> autoCompletePopup, StringConverter<T> stringConverter) {
        this(autoCompletePopup, TextFieldListCell.forListView(stringConverter));
    }

    public AutoCompletePopupSkin(AutoCompletePopup<T> autoCompletePopup, Callback<ListView<T>, ListCell<T>> callback) {
        this.control = autoCompletePopup;
        this.suggestionList = new ListView(autoCompletePopup.getSuggestions());
        this.suggestionList.getStyleClass().add((Object)"auto-complete-popup");
        this.suggestionList.getStylesheets().add((Object)AutoCompletionBinding.class.getResource("autocompletion.css").toExternalForm());
        this.suggestionList.prefHeightProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)autoCompletePopup.visibleRowCountProperty(), (ObservableNumberValue)Bindings.size((ObservableList)this.suggestionList.getItems())).multiply(24).add(18));
        this.suggestionList.setCellFactory(callback);
        this.suggestionList.prefWidthProperty().bind((ObservableValue)autoCompletePopup.prefWidthProperty());
        this.suggestionList.maxWidthProperty().bind((ObservableValue)autoCompletePopup.maxWidthProperty());
        this.suggestionList.minWidthProperty().bind((ObservableValue)autoCompletePopup.minWidthProperty());
        this.registerEventListener();
    }

    private void registerEventListener() {
        this.suggestionList.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                this.onSuggestionChoosen(this.suggestionList.getSelectionModel().getSelectedItem());
            }
        });
        this.suggestionList.setOnKeyPressed(keyEvent -> {
            switch (keyEvent.getCode()) {
                case TAB: 
                case ENTER: {
                    this.onSuggestionChoosen(this.suggestionList.getSelectionModel().getSelectedItem());
                    break;
                }
                case ESCAPE: {
                    if (!this.control.isHideOnEscape()) break;
                    this.control.hide();
                    break;
                }
            }
        });
    }

    private void onSuggestionChoosen(T t2) {
        if (t2 != null) {
            Event.fireEvent(this.control, new AutoCompletePopup.SuggestionEvent<T>(t2));
        }
    }

    public Node getNode() {
        return this.suggestionList;
    }

    public AutoCompletePopup<T> getSkinnable() {
        return this.control;
    }

    public void dispose() {
    }
}

