/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.i18n;

import impl.org.controlsfx.i18n.Translation;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public class Translations {
    private static final List<Translation> translations;

    private static void loadFrom(Path path) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                String string = path2.getFileName().toString();
                if (!string.startsWith("controlsfx") && !string.endsWith(".properties")) continue;
                if ("controlsfx.properties".equals(string)) {
                    translations.add(new Translation("en", path2));
                    continue;
                }
                if (string.contains("_")) {
                    String string2 = string.substring(11, string.indexOf(".properties"));
                    translations.add(new Translation(string2, path2));
                    continue;
                }
                throw new IllegalStateException("Unknown translation file '" + path2 + "'.");
            }
        }
        catch (IOException | DirectoryIteratorException exception) {
            // empty catch block
        }
    }

    private Translations() {
    }

    public static Optional<Translation> getTranslation(String string) {
        for (Translation translation : translations) {
            if (!string.equals(translation.getLocaleString())) continue;
            return Optional.of(translation);
        }
        return Optional.empty();
    }

    public static List<Translation> getAllTranslations() {
        return translations;
    }

    public static List<Locale> getAllTranslationLocales() {
        return translations.stream().map(translation -> translation.getLocale()).collect(Collectors.toList());
    }

    static {
        Path path2;
        translations = new ArrayList<Translation>();
        File file = new File(Translations.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        if (file.getName().endsWith(".jar")) {
            path2 = file.toPath();
            try (FileSystem fileSystem = FileSystems.newFileSystem(path2, (ClassLoader)null);){
                fileSystem.getRootDirectories().forEach(path -> Translations.loadFrom(path));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (translations.isEmpty()) {
            path2 = new File("src/main/resources").toPath();
            Translations.loadFrom(path2);
        }
        if (translations.isEmpty()) {
            path2 = new File("bin").toPath();
            Translations.loadFrom(path2);
        }
        if (translations.isEmpty() && file.getAbsolutePath().endsWith("controlsfx" + File.separator + "bin")) {
            Translations.loadFrom(file.toPath());
        }
        Collections.sort(translations);
    }
}

