/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.txw2;

import com.sun.xml.txw2.Attribute;
import com.sun.xml.txw2.ContainerElement;
import com.sun.xml.txw2.Content;
import com.sun.xml.txw2.ContentVisitor;
import com.sun.xml.txw2.Document;
import com.sun.xml.txw2.NamespaceDecl;
import com.sun.xml.txw2.NamespaceResolver;

class StartTag
extends Content
implements NamespaceResolver {
    private String uri;
    private final String localName;
    private Attribute firstAtt;
    private Attribute lastAtt;
    private ContainerElement owner;
    private NamespaceDecl firstNs;
    private NamespaceDecl lastNs;
    final Document document;

    public StartTag(ContainerElement containerElement, String string, String string2) {
        this(containerElement.document, string, string2);
        this.owner = containerElement;
    }

    public StartTag(Document document, String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        this.uri = string;
        this.localName = string2;
        this.document = document;
        this.addNamespaceDecl(string, null, false);
    }

    public void addAttribute(String string, String string2, Object object) {
        this.checkWritable();
        Attribute attribute = this.firstAtt;
        while (attribute != null && !attribute.hasName(string, string2)) {
            attribute = attribute.next;
        }
        if (attribute == null) {
            attribute = new Attribute(string, string2);
            if (this.lastAtt == null) {
                assert (this.firstAtt == null);
                this.firstAtt = this.lastAtt = attribute;
            } else {
                assert (this.firstAtt != null);
                this.lastAtt.next = attribute;
                this.lastAtt = attribute;
            }
            if (string.length() > 0) {
                this.addNamespaceDecl(string, null, true);
            }
        }
        this.document.writeValue(object, this, attribute.value);
    }

    public NamespaceDecl addNamespaceDecl(String string, String string2, boolean bl2) {
        this.checkWritable();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.length() == 0) {
            if (bl2) {
                throw new IllegalArgumentException("The empty namespace cannot have a non-empty prefix");
            }
            if (string2 != null && string2.length() > 0) {
                throw new IllegalArgumentException("The empty namespace can be only bound to the empty prefix");
            }
            string2 = "";
        }
        NamespaceDecl namespaceDecl = this.firstNs;
        while (namespaceDecl != null) {
            if (string.equals(namespaceDecl.uri)) {
                if (string2 == null) {
                    namespaceDecl.requirePrefix |= bl2;
                    return namespaceDecl;
                }
                if (namespaceDecl.prefix == null) {
                    namespaceDecl.prefix = string2;
                    namespaceDecl.requirePrefix |= bl2;
                    return namespaceDecl;
                }
                if (string2.equals(namespaceDecl.prefix)) {
                    namespaceDecl.requirePrefix |= bl2;
                    return namespaceDecl;
                }
            }
            if (string2 != null && namespaceDecl.prefix != null && namespaceDecl.prefix.equals(string2)) {
                throw new IllegalArgumentException("Prefix '" + string2 + "' is already bound to '" + namespaceDecl.uri + '\'');
            }
            namespaceDecl = namespaceDecl.next;
        }
        namespaceDecl = new NamespaceDecl(this.document.assignNewId(), string, string2, bl2);
        if (this.lastNs == null) {
            assert (this.firstNs == null);
            this.firstNs = this.lastNs = namespaceDecl;
        } else {
            assert (this.firstNs != null);
            this.lastNs.next = namespaceDecl;
            this.lastNs = namespaceDecl;
        }
        return namespaceDecl;
    }

    private void checkWritable() {
        if (this.isWritten()) {
            throw new IllegalStateException("The start tag of " + this.localName + " has already been written. If you need out of order writing, see the TypedXmlWriter.block method");
        }
    }

    boolean isWritten() {
        return this.uri == null;
    }

    @Override
    boolean isReadyToCommit() {
        if (this.owner != null && this.owner.isBlocked()) {
            return false;
        }
        for (Content content = this.getNext(); content != null; content = content.getNext()) {
            if (!content.concludesPendingStartTag()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void written() {
        this.lastAtt = null;
        this.firstAtt = null;
        this.uri = null;
        if (this.owner != null) {
            assert (this.owner.startTag == this);
            this.owner.startTag = null;
        }
    }

    @Override
    boolean concludesPendingStartTag() {
        return true;
    }

    @Override
    void accept(ContentVisitor contentVisitor) {
        contentVisitor.onStartTag(this.uri, this.localName, this.firstAtt, this.firstNs);
    }

    @Override
    public String getPrefix(String string) {
        NamespaceDecl namespaceDecl = this.addNamespaceDecl(string, null, false);
        if (namespaceDecl.prefix != null) {
            return namespaceDecl.prefix;
        }
        return namespaceDecl.dummyPrefix;
    }
}

