/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.txw2;

import com.sun.xml.txw2.Attribute;
import com.sun.xml.txw2.Content;
import com.sun.xml.txw2.ContentVisitor;
import com.sun.xml.txw2.DatatypeWriter;
import com.sun.xml.txw2.NamespaceDecl;
import com.sun.xml.txw2.NamespaceResolver;
import com.sun.xml.txw2.NamespaceSupport;
import com.sun.xml.txw2.StartDocument;
import com.sun.xml.txw2.output.XmlSerializer;
import java.util.HashMap;
import java.util.Map;

public final class Document {
    private final XmlSerializer out;
    private boolean started = false;
    private Content current = null;
    private final Map<Class, DatatypeWriter> datatypeWriters = new HashMap<Class, DatatypeWriter>();
    private int iota = 1;
    private final NamespaceSupport inscopeNamespace = new NamespaceSupport();
    private NamespaceDecl activeNamespaces;
    private final ContentVisitor visitor = new ContentVisitor(){

        @Override
        public void onStartDocument() {
            throw new IllegalStateException();
        }

        @Override
        public void onEndDocument() {
            Document.this.out.endDocument();
        }

        @Override
        public void onEndTag() {
            Document.this.out.endTag();
            Document.this.inscopeNamespace.popContext();
            Document.this.activeNamespaces = null;
        }

        @Override
        public void onPcdata(StringBuilder stringBuilder) {
            if (Document.this.activeNamespaces != null) {
                stringBuilder = Document.this.fixPrefix(stringBuilder);
            }
            Document.this.out.text(stringBuilder);
        }

        @Override
        public void onCdata(StringBuilder stringBuilder) {
            if (Document.this.activeNamespaces != null) {
                stringBuilder = Document.this.fixPrefix(stringBuilder);
            }
            Document.this.out.cdata(stringBuilder);
        }

        @Override
        public void onComment(StringBuilder stringBuilder) {
            if (Document.this.activeNamespaces != null) {
                stringBuilder = Document.this.fixPrefix(stringBuilder);
            }
            Document.this.out.comment(stringBuilder);
        }

        @Override
        public void onStartTag(String string, String string2, Attribute attribute, NamespaceDecl namespaceDecl) {
            String string3;
            assert (string != null);
            assert (string2 != null);
            Document.this.activeNamespaces = namespaceDecl;
            if (!Document.this.started) {
                Document.this.started = true;
                Document.this.out.startDocument();
            }
            Document.this.inscopeNamespace.pushContext();
            Object object = namespaceDecl;
            while (object != null) {
                ((NamespaceDecl)object).declared = false;
                if (!(((NamespaceDecl)object).prefix == null || (string3 = Document.this.inscopeNamespace.getURI(((NamespaceDecl)object).prefix)) != null && string3.equals(((NamespaceDecl)object).uri))) {
                    Document.this.inscopeNamespace.declarePrefix(((NamespaceDecl)object).prefix, ((NamespaceDecl)object).uri);
                    ((NamespaceDecl)object).declared = true;
                }
                object = ((NamespaceDecl)object).next;
            }
            object = namespaceDecl;
            while (object != null) {
                if (((NamespaceDecl)object).prefix == null) {
                    if (Document.this.inscopeNamespace.getURI("").equals(((NamespaceDecl)object).uri)) {
                        ((NamespaceDecl)object).prefix = "";
                    } else {
                        string3 = Document.this.inscopeNamespace.getPrefix(((NamespaceDecl)object).uri);
                        if (string3 == null) {
                            do {
                                string3 = Document.this.newPrefix();
                            } while (Document.this.inscopeNamespace.getURI(string3) != null);
                            ((NamespaceDecl)object).declared = true;
                            Document.this.inscopeNamespace.declarePrefix(string3, ((NamespaceDecl)object).uri);
                        }
                        ((NamespaceDecl)object).prefix = string3;
                    }
                }
                object = ((NamespaceDecl)object).next;
            }
            assert (namespaceDecl.uri.equals(string));
            assert (namespaceDecl.prefix != null) : "a prefix must have been all allocated";
            Document.this.out.beginStartTag(string, string2, namespaceDecl.prefix);
            object = namespaceDecl;
            while (object != null) {
                if (((NamespaceDecl)object).declared) {
                    Document.this.out.writeXmlns(((NamespaceDecl)object).prefix, ((NamespaceDecl)object).uri);
                }
                object = ((NamespaceDecl)object).next;
            }
            object = attribute;
            while (object != null) {
                string3 = ((Attribute)object).nsUri.length() == 0 ? "" : Document.this.inscopeNamespace.getPrefix(((Attribute)object).nsUri);
                Document.this.out.writeAttribute(((Attribute)object).nsUri, ((Attribute)object).localName, string3, Document.this.fixPrefix(((Attribute)object).value));
                object = ((Attribute)object).next;
            }
            Document.this.out.endStartTag(string, string2, namespaceDecl.prefix);
        }
    };
    private final StringBuilder prefixSeed = new StringBuilder("ns");
    private int prefixIota = 0;
    static final char MAGIC = '\u0000';

    Document(XmlSerializer xmlSerializer) {
        this.out = xmlSerializer;
        for (DatatypeWriter<?> datatypeWriter : DatatypeWriter.BUILTIN) {
            this.datatypeWriters.put(datatypeWriter.getType(), datatypeWriter);
        }
    }

    void flush() {
        this.out.flush();
    }

    void setFirstContent(Content content) {
        assert (this.current == null);
        this.current = new StartDocument();
        this.current.setNext(this, content);
    }

    public void addDatatypeWriter(DatatypeWriter<?> datatypeWriter) {
        this.datatypeWriters.put(datatypeWriter.getType(), datatypeWriter);
    }

    void run() {
        Content content;
        while ((content = this.current.getNext()) != null && content.isReadyToCommit()) {
            content.accept(this.visitor);
            content.written();
            this.current = content;
        }
        return;
    }

    void writeValue(Object object, NamespaceResolver namespaceResolver, StringBuilder stringBuilder) {
        if (object == null) {
            throw new IllegalArgumentException("argument contains null");
        }
        if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                this.writeValue(object2, namespaceResolver, stringBuilder);
            }
            return;
        }
        if (object instanceof Iterable) {
            for (Object t2 : (Iterable)object) {
                this.writeValue(t2, namespaceResolver, stringBuilder);
            }
            return;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(' ');
        }
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            DatatypeWriter datatypeWriter = this.datatypeWriters.get(clazz);
            if (datatypeWriter == null) continue;
            datatypeWriter.print(object, namespaceResolver, stringBuilder);
            return;
        }
        stringBuilder.append(object);
    }

    private String newPrefix() {
        this.prefixSeed.setLength(2);
        this.prefixSeed.append(++this.prefixIota);
        return this.prefixSeed.toString();
    }

    private StringBuilder fixPrefix(StringBuilder stringBuilder) {
        int n2;
        assert (this.activeNamespaces != null);
        int n3 = stringBuilder.length();
        for (n2 = 0; n2 < n3 && stringBuilder.charAt(n2) != '\u0000'; ++n2) {
        }
        if (n2 == n3) {
            return stringBuilder;
        }
        while (n2 < n3) {
            char c2 = stringBuilder.charAt(n2 + 1);
            NamespaceDecl namespaceDecl = this.activeNamespaces;
            while (namespaceDecl != null && namespaceDecl.uniqueId != c2) {
                namespaceDecl = namespaceDecl.next;
            }
            if (namespaceDecl == null) {
                throw new IllegalStateException("Unexpected use of prefixes " + stringBuilder);
            }
            int n4 = 2;
            String string = namespaceDecl.prefix;
            if (string.length() == 0) {
                if (stringBuilder.length() <= n2 + 2 || stringBuilder.charAt(n2 + 2) != ':') {
                    throw new IllegalStateException("Unexpected use of prefixes " + stringBuilder);
                }
                n4 = 3;
            }
            stringBuilder.replace(n2, n2 + n4, string);
            n3 += string.length() - n4;
            while (n2 < n3 && stringBuilder.charAt(n2) != '\u0000') {
                ++n2;
            }
        }
        return stringBuilder;
    }

    char assignNewId() {
        return (char)this.iota++;
    }
}

