/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.WeakHashMap;

public class EditDistance {
    private static final WeakHashMap<AbstractMap.SimpleEntry<String, String>, Integer> CACHE = new WeakHashMap();
    private int[] cost;
    private int[] back;
    private final String a;
    private final String b;

    public static int editDistance(String string, String string2) {
        AbstractMap.SimpleEntry<String, String> simpleEntry = new AbstractMap.SimpleEntry<String, String>(string, string2);
        Integer n2 = null;
        if (CACHE.containsKey(simpleEntry)) {
            n2 = CACHE.get(simpleEntry);
        }
        if (n2 == null) {
            n2 = new EditDistance(string, string2).calc();
            CACHE.put(simpleEntry, n2);
        }
        return n2;
    }

    public static String findNearest(String string, String[] stringArray) {
        return EditDistance.findNearest(string, Arrays.asList(stringArray));
    }

    public static String findNearest(String string, Collection<String> collection) {
        int n2 = Integer.MAX_VALUE;
        String string2 = null;
        for (String string3 : collection) {
            int n3 = EditDistance.editDistance(string, string3);
            if (n2 <= n3) continue;
            n2 = n3;
            string2 = string3;
        }
        return string2;
    }

    private EditDistance(String string, String string2) {
        this.a = string;
        this.b = string2;
        this.cost = new int[string.length() + 1];
        this.back = new int[string.length() + 1];
        for (int i2 = 0; i2 <= string.length(); ++i2) {
            this.cost[i2] = i2;
        }
    }

    private void flip() {
        int[] nArray = this.cost;
        this.cost = this.back;
        this.back = nArray;
    }

    private int min(int n2, int n3, int n4) {
        return Math.min(n2, Math.min(n3, n4));
    }

    private int calc() {
        for (int i2 = 0; i2 < this.b.length(); ++i2) {
            this.flip();
            this.cost[0] = i2 + 1;
            for (int i3 = 0; i3 < this.a.length(); ++i3) {
                int n2 = this.a.charAt(i3) == this.b.charAt(i2) ? 0 : 1;
                this.cost[i3 + 1] = this.min(this.back[i3] + n2, this.cost[i3] + 1, this.back[i3 + 1] + 1);
            }
        }
        return this.cost[this.a.length()];
    }
}

