/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.schemagen;

import com.sun.xml.bind.v2.schemagen.GroupKind;
import com.sun.xml.bind.v2.schemagen.xmlschema.ContentModelContainer;
import com.sun.xml.bind.v2.schemagen.xmlschema.Occurs;
import com.sun.xml.bind.v2.schemagen.xmlschema.Particle;
import com.sun.xml.bind.v2.schemagen.xmlschema.TypeDefParticle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

abstract class Tree {
    Tree() {
    }

    Tree makeOptional(boolean bl2) {
        return bl2 ? new Optional(this) : this;
    }

    Tree makeRepeated(boolean bl2) {
        return bl2 ? new Repeated(this) : this;
    }

    static Tree makeGroup(GroupKind groupKind, List<Tree> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>(list.size());
        for (Tree tree : list) {
            Group group;
            if (tree instanceof Group && (group = (Group)tree).kind == groupKind) {
                arrayList.addAll(Arrays.asList(group.children));
                continue;
            }
            arrayList.add(tree);
        }
        return new Group(groupKind, arrayList.toArray(new Tree[arrayList.size()]));
    }

    abstract boolean isNullable();

    boolean canBeTopLevel() {
        return false;
    }

    protected abstract void write(ContentModelContainer var1, boolean var2, boolean var3);

    protected void write(TypeDefParticle typeDefParticle) {
        if (this.canBeTopLevel()) {
            this.write(typeDefParticle._cast(ContentModelContainer.class), false, false);
        } else {
            new Group(GroupKind.SEQUENCE, new Tree[]{this}).write(typeDefParticle);
        }
    }

    protected final void writeOccurs(Occurs occurs, boolean bl2, boolean bl3) {
        if (bl2) {
            occurs.minOccurs(0);
        }
        if (bl3) {
            occurs.maxOccurs("unbounded");
        }
    }

    private static final class Group
    extends Tree {
        private final GroupKind kind;
        private final Tree[] children;

        private Group(GroupKind groupKind, Tree ... treeArray) {
            this.kind = groupKind;
            this.children = treeArray;
        }

        @Override
        boolean canBeTopLevel() {
            return true;
        }

        @Override
        boolean isNullable() {
            if (this.kind == GroupKind.CHOICE) {
                for (Tree tree : this.children) {
                    if (!tree.isNullable()) continue;
                    return true;
                }
                return false;
            }
            for (Tree tree : this.children) {
                if (tree.isNullable()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected void write(ContentModelContainer contentModelContainer, boolean bl2, boolean bl3) {
            Particle particle = this.kind.write(contentModelContainer);
            this.writeOccurs(particle, bl2, bl3);
            for (Tree tree : this.children) {
                tree.write(particle, false, false);
            }
        }
    }

    private static final class Repeated
    extends Tree {
        private final Tree body;

        private Repeated(Tree tree) {
            this.body = tree;
        }

        @Override
        boolean isNullable() {
            return this.body.isNullable();
        }

        @Override
        Tree makeRepeated(boolean bl2) {
            return this;
        }

        @Override
        protected void write(ContentModelContainer contentModelContainer, boolean bl2, boolean bl3) {
            this.body.write(contentModelContainer, bl2, true);
        }
    }

    private static final class Optional
    extends Tree {
        private final Tree body;

        private Optional(Tree tree) {
            this.body = tree;
        }

        @Override
        boolean isNullable() {
            return true;
        }

        @Override
        Tree makeOptional(boolean bl2) {
            return this;
        }

        @Override
        protected void write(ContentModelContainer contentModelContainer, boolean bl2, boolean bl3) {
            this.body.write(contentModelContainer, true, bl3);
        }
    }

    static abstract class Term
    extends Tree {
        Term() {
        }

        @Override
        boolean isNullable() {
            return false;
        }
    }
}

