/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.unmarshaller;

import com.sun.istack.Nullable;
import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.v2.runtime.output.Pcdata;
import com.sun.xml.bind.v2.runtime.output.UTF8XmlOutput;
import com.sun.xml.bind.v2.util.ByteArrayOutputStreamEx;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class Base64Data
extends Pcdata {
    private DataHandler dataHandler;
    private byte[] data;
    private int dataLen;
    @Nullable
    private String mimeType;

    public void set(byte[] byArray, int n2, @Nullable String string) {
        this.data = byArray;
        this.dataLen = n2;
        this.dataHandler = null;
        this.mimeType = string;
    }

    public void set(byte[] byArray, @Nullable String string) {
        this.set(byArray, byArray.length, string);
    }

    public void set(DataHandler dataHandler) {
        assert (dataHandler != null);
        this.dataHandler = dataHandler;
        this.data = null;
    }

    public DataHandler getDataHandler() {
        if (this.dataHandler == null) {
            this.dataHandler = new DataHandler(new DataSource(){

                @Override
                public String getContentType() {
                    return Base64Data.this.getMimeType();
                }

                @Override
                public InputStream getInputStream() {
                    return new ByteArrayInputStream(Base64Data.this.data, 0, Base64Data.this.dataLen);
                }

                @Override
                public String getName() {
                    return null;
                }

                @Override
                public OutputStream getOutputStream() {
                    throw new UnsupportedOperationException();
                }
            });
        }
        return this.dataHandler;
    }

    public byte[] getExact() {
        this.get();
        if (this.dataLen != this.data.length) {
            byte[] byArray = new byte[this.dataLen];
            System.arraycopy(this.data, 0, byArray, 0, this.dataLen);
            this.data = byArray;
        }
        return this.data;
    }

    public InputStream getInputStream() throws IOException {
        if (this.dataHandler != null) {
            return this.dataHandler.getInputStream();
        }
        return new ByteArrayInputStream(this.data, 0, this.dataLen);
    }

    public boolean hasData() {
        return this.data != null;
    }

    public byte[] get() {
        if (this.data == null) {
            try {
                ByteArrayOutputStreamEx byteArrayOutputStreamEx = new ByteArrayOutputStreamEx(1024);
                InputStream inputStream = this.dataHandler.getDataSource().getInputStream();
                byteArrayOutputStreamEx.readFrom(inputStream);
                inputStream.close();
                this.data = byteArrayOutputStreamEx.getBuffer();
                this.dataLen = byteArrayOutputStreamEx.size();
            }
            catch (IOException iOException) {
                this.dataLen = 0;
            }
        }
        return this.data;
    }

    public int getDataLen() {
        return this.dataLen;
    }

    public String getMimeType() {
        if (this.mimeType == null) {
            return "application/octet-stream";
        }
        return this.mimeType;
    }

    @Override
    public int length() {
        this.get();
        return (this.dataLen + 2) / 3 * 4;
    }

    @Override
    public char charAt(int n2) {
        int n3 = n2 % 4;
        int n4 = n2 / 4 * 3;
        switch (n3) {
            case 0: {
                return DatatypeConverterImpl.encode(this.data[n4] >> 2);
            }
            case 1: {
                byte by2 = n4 + 1 < this.dataLen ? this.data[n4 + 1] : (byte)0;
                return DatatypeConverterImpl.encode((this.data[n4] & 3) << 4 | by2 >> 4 & 0xF);
            }
            case 2: {
                if (n4 + 1 < this.dataLen) {
                    byte by3 = this.data[n4 + 1];
                    byte by4 = n4 + 2 < this.dataLen ? this.data[n4 + 2] : (byte)0;
                    return DatatypeConverterImpl.encode((by3 & 0xF) << 2 | by4 >> 6 & 3);
                }
                return '=';
            }
            case 3: {
                if (n4 + 2 < this.dataLen) {
                    return DatatypeConverterImpl.encode(this.data[n4 + 2] & 0x3F);
                }
                return '=';
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public CharSequence subSequence(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        this.get();
        for (int i2 = n2; i2 < n3; ++i2) {
            stringBuilder.append(this.charAt(i2));
        }
        return stringBuilder;
    }

    @Override
    public String toString() {
        this.get();
        return DatatypeConverterImpl._printBase64Binary(this.data, 0, this.dataLen);
    }

    @Override
    public void writeTo(char[] cArray, int n2) {
        this.get();
        DatatypeConverterImpl._printBase64Binary(this.data, 0, this.dataLen, cArray, n2);
    }

    @Override
    public void writeTo(UTF8XmlOutput uTF8XmlOutput) throws IOException {
        this.get();
        uTF8XmlOutput.text(this.data, this.dataLen);
    }

    public void writeTo(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        this.get();
        DatatypeConverterImpl._printBase64Binary(this.data, 0, this.dataLen, xMLStreamWriter);
    }
}

