/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.property;

import com.sun.xml.bind.v2.model.core.ID;
import com.sun.xml.bind.v2.model.core.PropertyKind;
import com.sun.xml.bind.v2.model.runtime.RuntimeAttributePropertyInfo;
import com.sun.xml.bind.v2.model.runtime.RuntimeElementPropertyInfo;
import com.sun.xml.bind.v2.model.runtime.RuntimeNonElement;
import com.sun.xml.bind.v2.model.runtime.RuntimePropertyInfo;
import com.sun.xml.bind.v2.model.runtime.RuntimeTypeInfo;
import com.sun.xml.bind.v2.model.runtime.RuntimeValuePropertyInfo;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.property.ArrayElementLeafProperty;
import com.sun.xml.bind.v2.runtime.property.ArrayElementNodeProperty;
import com.sun.xml.bind.v2.runtime.property.ArrayReferenceNodeProperty;
import com.sun.xml.bind.v2.runtime.property.AttributeProperty;
import com.sun.xml.bind.v2.runtime.property.ListElementProperty;
import com.sun.xml.bind.v2.runtime.property.Property;
import com.sun.xml.bind.v2.runtime.property.SingleElementLeafProperty;
import com.sun.xml.bind.v2.runtime.property.SingleElementNodeProperty;
import com.sun.xml.bind.v2.runtime.property.SingleMapNodeProperty;
import com.sun.xml.bind.v2.runtime.property.SingleReferenceNodeProperty;
import com.sun.xml.bind.v2.runtime.property.ValueProperty;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;

public abstract class PropertyFactory {
    private static final Constructor<? extends Property>[] propImpls;

    private PropertyFactory() {
    }

    public static Property create(JAXBContextImpl jAXBContextImpl, RuntimePropertyInfo runtimePropertyInfo) {
        PropertyKind propertyKind = runtimePropertyInfo.kind();
        switch (propertyKind) {
            case ATTRIBUTE: {
                return new AttributeProperty(jAXBContextImpl, (RuntimeAttributePropertyInfo)runtimePropertyInfo);
            }
            case VALUE: {
                return new ValueProperty(jAXBContextImpl, (RuntimeValuePropertyInfo)runtimePropertyInfo);
            }
            case ELEMENT: {
                if (!((RuntimeElementPropertyInfo)runtimePropertyInfo).isValueList()) break;
                return new ListElementProperty(jAXBContextImpl, (RuntimeElementPropertyInfo)runtimePropertyInfo);
            }
            case REFERENCE: 
            case MAP: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        boolean bl2 = runtimePropertyInfo.isCollection();
        boolean bl3 = PropertyFactory.isLeaf(runtimePropertyInfo);
        Constructor<? extends Property> constructor = propImpls[(bl3 ? 0 : 6) + (bl2 ? 3 : 0) + propertyKind.propertyIndex];
        try {
            return constructor.newInstance(jAXBContextImpl, runtimePropertyInfo);
        }
        catch (InstantiationException instantiationException) {
            throw new InstantiationError(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
    }

    static boolean isLeaf(RuntimePropertyInfo runtimePropertyInfo) {
        Collection<? extends RuntimeTypeInfo> collection = runtimePropertyInfo.ref();
        if (collection.size() != 1) {
            return false;
        }
        RuntimeTypeInfo runtimeTypeInfo = collection.iterator().next();
        if (!(runtimeTypeInfo instanceof RuntimeNonElement)) {
            return false;
        }
        if (runtimePropertyInfo.id() == ID.IDREF) {
            return true;
        }
        if (((RuntimeNonElement)runtimeTypeInfo).getTransducer() == null) {
            return false;
        }
        return runtimePropertyInfo.getIndividualType().equals(runtimeTypeInfo.getType());
    }

    static {
        Class[] classArray = new Class[]{SingleElementLeafProperty.class, null, null, ArrayElementLeafProperty.class, null, null, SingleElementNodeProperty.class, SingleReferenceNodeProperty.class, SingleMapNodeProperty.class, ArrayElementNodeProperty.class, ArrayReferenceNodeProperty.class, null};
        propImpls = new Constructor[classArray.length];
        for (int i2 = 0; i2 < propImpls.length; ++i2) {
            if (classArray[i2] == null) continue;
            PropertyFactory.propImpls[i2] = classArray[i2].getConstructors()[0];
        }
    }
}

