/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.output;

import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.output.Encoded;
import com.sun.xml.bind.v2.runtime.output.NamespaceContextImpl;
import com.sun.xml.bind.v2.runtime.output.Pcdata;
import com.sun.xml.bind.v2.runtime.output.XmlOutputAbstractImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public class UTF8XmlOutput
extends XmlOutputAbstractImpl {
    protected final OutputStream out;
    private Encoded[] prefixes = new Encoded[8];
    private int prefixCount;
    private final Encoded[] localNames;
    private final Encoded textBuffer = new Encoded();
    protected final byte[] octetBuffer = new byte[1024];
    protected int octetBufferIndex;
    protected boolean closeStartTagPending = false;
    private String header;
    private CharacterEscapeHandler escapeHandler = null;
    private final byte[] XMLNS_EQUALS = (byte[])_XMLNS_EQUALS.clone();
    private final byte[] XMLNS_COLON = (byte[])_XMLNS_COLON.clone();
    private final byte[] EQUALS = (byte[])_EQUALS.clone();
    private final byte[] CLOSE_TAG = (byte[])_CLOSE_TAG.clone();
    private final byte[] EMPTY_TAG = (byte[])_EMPTY_TAG.clone();
    private final byte[] XML_DECL = (byte[])_XML_DECL.clone();
    private static final byte[] _XMLNS_EQUALS = UTF8XmlOutput.toBytes(" xmlns=\"");
    private static final byte[] _XMLNS_COLON = UTF8XmlOutput.toBytes(" xmlns:");
    private static final byte[] _EQUALS = UTF8XmlOutput.toBytes("=\"");
    private static final byte[] _CLOSE_TAG = UTF8XmlOutput.toBytes("</");
    private static final byte[] _EMPTY_TAG = UTF8XmlOutput.toBytes("/>");
    private static final byte[] _XML_DECL = UTF8XmlOutput.toBytes("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public UTF8XmlOutput(OutputStream outputStream, Encoded[] encodedArray, CharacterEscapeHandler characterEscapeHandler) {
        this.out = outputStream;
        this.localNames = encodedArray;
        for (int i2 = 0; i2 < this.prefixes.length; ++i2) {
            this.prefixes[i2] = new Encoded();
        }
        this.escapeHandler = characterEscapeHandler;
    }

    public void setHeader(String string) {
        this.header = string;
    }

    @Override
    public void startDocument(XMLSerializer xMLSerializer, boolean bl2, int[] nArray, NamespaceContextImpl namespaceContextImpl) throws IOException, SAXException, XMLStreamException {
        super.startDocument(xMLSerializer, bl2, nArray, namespaceContextImpl);
        this.octetBufferIndex = 0;
        if (!bl2) {
            this.write(this.XML_DECL);
        }
        if (this.header != null) {
            this.textBuffer.set(this.header);
            this.textBuffer.write(this);
        }
    }

    @Override
    public void endDocument(boolean bl2) throws IOException, SAXException, XMLStreamException {
        this.flushBuffer();
        super.endDocument(bl2);
    }

    protected final void closeStartTag() throws IOException {
        if (this.closeStartTagPending) {
            this.write(62);
            this.closeStartTagPending = false;
        }
    }

    @Override
    public void beginStartTag(int n2, String string) throws IOException {
        this.closeStartTag();
        int n3 = this.pushNsDecls();
        this.write(60);
        this.writeName(n2, string);
        this.writeNsDecls(n3);
    }

    @Override
    public void beginStartTag(Name name) throws IOException {
        this.closeStartTag();
        int n2 = this.pushNsDecls();
        this.write(60);
        this.writeName(name);
        this.writeNsDecls(n2);
    }

    private int pushNsDecls() {
        int n2;
        int n3;
        int n4 = this.nsContext.count();
        NamespaceContextImpl.Element element = this.nsContext.getCurrent();
        if (n4 > this.prefixes.length) {
            n3 = Math.max(n4, this.prefixes.length * 2);
            Encoded[] encodedArray = new Encoded[n3];
            System.arraycopy(this.prefixes, 0, encodedArray, 0, this.prefixes.length);
            for (n2 = this.prefixes.length; n2 < encodedArray.length; ++n2) {
                encodedArray[n2] = new Encoded();
            }
            this.prefixes = encodedArray;
        }
        n3 = Math.min(this.prefixCount, element.getBase());
        int n5 = this.nsContext.count();
        for (n2 = n3; n2 < n5; ++n2) {
            String string = this.nsContext.getPrefix(n2);
            Encoded encoded = this.prefixes[n2];
            if (string.length() == 0) {
                encoded.buf = EMPTY_BYTE_ARRAY;
                encoded.len = 0;
                continue;
            }
            encoded.set(string);
            encoded.append(':');
        }
        this.prefixCount = n5;
        return n3;
    }

    protected void writeNsDecls(int n2) throws IOException {
        NamespaceContextImpl.Element element = this.nsContext.getCurrent();
        int n3 = this.nsContext.count();
        for (int i2 = element.getBase(); i2 < n3; ++i2) {
            this.writeNsDecl(i2);
        }
    }

    protected final void writeNsDecl(int n2) throws IOException {
        String string = this.nsContext.getPrefix(n2);
        if (string.length() == 0) {
            if (this.nsContext.getCurrent().isRootElement() && this.nsContext.getNamespaceURI(n2).length() == 0) {
                return;
            }
            this.write(this.XMLNS_EQUALS);
        } else {
            Encoded encoded = this.prefixes[n2];
            this.write(this.XMLNS_COLON);
            this.write(encoded.buf, 0, encoded.len - 1);
            this.write(this.EQUALS);
        }
        this.doText(this.nsContext.getNamespaceURI(n2), true);
        this.write(34);
    }

    private void writePrefix(int n2) throws IOException {
        this.prefixes[n2].write(this);
    }

    private void writeName(Name name) throws IOException {
        this.writePrefix(this.nsUriIndex2prefixIndex[name.nsUriIndex]);
        this.localNames[name.localNameIndex].write(this);
    }

    private void writeName(int n2, String string) throws IOException {
        this.writePrefix(n2);
        this.textBuffer.set(string);
        this.textBuffer.write(this);
    }

    @Override
    public void attribute(Name name, String string) throws IOException {
        this.write(32);
        if (name.nsUriIndex == -1) {
            this.localNames[name.localNameIndex].write(this);
        } else {
            this.writeName(name);
        }
        this.write(this.EQUALS);
        this.doText(string, true);
        this.write(34);
    }

    @Override
    public void attribute(int n2, String string, String string2) throws IOException {
        this.write(32);
        if (n2 == -1) {
            this.textBuffer.set(string);
            this.textBuffer.write(this);
        } else {
            this.writeName(n2, string);
        }
        this.write(this.EQUALS);
        this.doText(string2, true);
        this.write(34);
    }

    @Override
    public void endStartTag() throws IOException {
        this.closeStartTagPending = true;
    }

    @Override
    public void endTag(Name name) throws IOException {
        if (this.closeStartTagPending) {
            this.write(this.EMPTY_TAG);
            this.closeStartTagPending = false;
        } else {
            this.write(this.CLOSE_TAG);
            this.writeName(name);
            this.write(62);
        }
    }

    @Override
    public void endTag(int n2, String string) throws IOException {
        if (this.closeStartTagPending) {
            this.write(this.EMPTY_TAG);
            this.closeStartTagPending = false;
        } else {
            this.write(this.CLOSE_TAG);
            this.writeName(n2, string);
            this.write(62);
        }
    }

    @Override
    public void text(String string, boolean bl2) throws IOException {
        this.closeStartTag();
        if (bl2) {
            this.write(32);
        }
        this.doText(string, false);
    }

    @Override
    public void text(Pcdata pcdata, boolean bl2) throws IOException {
        this.closeStartTag();
        if (bl2) {
            this.write(32);
        }
        pcdata.writeTo(this);
    }

    private void doText(String string, boolean bl2) throws IOException {
        if (this.escapeHandler != null) {
            StringWriter stringWriter = new StringWriter();
            this.escapeHandler.escape(string.toCharArray(), 0, string.length(), bl2, stringWriter);
            this.textBuffer.set(stringWriter.toString());
        } else {
            this.textBuffer.setEscape(string, bl2);
        }
        this.textBuffer.write(this);
    }

    public final void text(int n2) throws IOException {
        this.closeStartTag();
        boolean bl2 = n2 < 0;
        this.textBuffer.ensureSize(11);
        byte[] byArray = this.textBuffer.buf;
        int n3 = 11;
        do {
            int n4;
            if ((n4 = n2 % 10) < 0) {
                n4 = -n4;
            }
            byArray[--n3] = (byte)(0x30 | n4);
        } while ((n2 /= 10) != 0);
        if (bl2) {
            byArray[--n3] = 45;
        }
        this.write(byArray, n3, 11 - n3);
    }

    public void text(byte[] byArray, int n2) throws IOException {
        this.closeStartTag();
        int n3 = 0;
        while (n2 > 0) {
            int n4 = Math.min((this.octetBuffer.length - this.octetBufferIndex) / 4 * 3, n2);
            this.octetBufferIndex = DatatypeConverterImpl._printBase64Binary(byArray, n3, n4, this.octetBuffer, this.octetBufferIndex);
            if (n4 < n2) {
                this.flushBuffer();
            }
            n3 += n4;
            n2 -= n4;
        }
    }

    public final void write(int n2) throws IOException {
        if (this.octetBufferIndex < this.octetBuffer.length) {
            this.octetBuffer[this.octetBufferIndex++] = (byte)n2;
        } else {
            this.out.write(this.octetBuffer);
            this.octetBufferIndex = 1;
            this.octetBuffer[0] = (byte)n2;
        }
    }

    protected final void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    protected final void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.octetBufferIndex + n3 < this.octetBuffer.length) {
            System.arraycopy(byArray, n2, this.octetBuffer, this.octetBufferIndex, n3);
            this.octetBufferIndex += n3;
        } else {
            this.out.write(this.octetBuffer, 0, this.octetBufferIndex);
            this.out.write(byArray, n2, n3);
            this.octetBufferIndex = 0;
        }
    }

    protected final void flushBuffer() throws IOException {
        this.out.write(this.octetBuffer, 0, this.octetBufferIndex);
        this.octetBufferIndex = 0;
    }

    static byte[] toBytes(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        return byArray;
    }
}

