/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.utils;

import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import javafx.application.Platform;

public class JFXUtilities {
    public static void runInFX(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
            return;
        }
        Platform.runLater((Runnable)runnable);
    }

    public static void runInFXAndWait(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                runnable.run();
            }
            finally {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static <T> T[] concat(T[] TArray, T[] TArray2, Function<Integer, T[]> function) {
        int n2 = TArray.length;
        int n3 = TArray2.length;
        T[] TArray3 = function.apply(n2 + n3);
        System.arraycopy(TArray, 0, TArray3, 0, n2);
        System.arraycopy(TArray2, 0, TArray3, n2, n3);
        return TArray3;
    }
}

