/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.transitions;

import com.jfoenix.transitions.JFXKeyValue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Supplier;
import javafx.util.Duration;

public class JFXKeyFrame {
    private Duration duration;
    private Set<JFXKeyValue<?>> keyValues = new CopyOnWriteArraySet();
    private Supplier<Boolean> animateCondition = null;

    public JFXKeyFrame(Duration duration, JFXKeyValue ... jFXKeyValueArray) {
        this.duration = duration;
        for (JFXKeyValue jFXKeyValue : jFXKeyValueArray) {
            if (jFXKeyValue == null) continue;
            this.keyValues.add(jFXKeyValue);
        }
    }

    private JFXKeyFrame() {
    }

    public final Duration getDuration() {
        return this.duration;
    }

    public final Set<JFXKeyValue<?>> getValues() {
        return this.keyValues;
    }

    public Supplier<Boolean> getAnimateCondition() {
        return this.animateCondition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Duration duration;
        private Set<JFXKeyValue<?>> keyValues = new CopyOnWriteArraySet();
        private Supplier<Boolean> animateCondition = null;

        private Builder() {
        }

        public Builder setDuration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public Builder setKeyValues(JFXKeyValue ... jFXKeyValueArray) {
            for (JFXKeyValue jFXKeyValue : jFXKeyValueArray) {
                if (jFXKeyValue == null) continue;
                this.keyValues.add(jFXKeyValue);
            }
            return this;
        }

        public Builder setAnimateCondition(Supplier<Boolean> supplier) {
            this.animateCondition = supplier;
            return this;
        }

        public JFXKeyFrame build() {
            JFXKeyFrame jFXKeyFrame = new JFXKeyFrame();
            jFXKeyFrame.duration = this.duration;
            jFXKeyFrame.keyValues = this.keyValues;
            jFXKeyFrame.animateCondition = this.animateCondition;
            return jFXKeyFrame;
        }
    }
}

