/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.svg;

import com.jfoenix.svg.SVGGlyph;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Translate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SVGGlyphLoader {
    private static final HashMap<String, SVGGlyphBuilder> glyphsMap = new HashMap();

    public static SVGGlyph getGlyph(String string) {
        return glyphsMap.get(string).build();
    }

    public static SVGGlyph getIcoMoonGlyph(String string) throws Exception {
        SVGGlyphBuilder sVGGlyphBuilder = glyphsMap.get(string);
        if (sVGGlyphBuilder == null) {
            throw new Exception("Glyph '" + string + "' not found!");
        }
        SVGGlyph sVGGlyph = sVGGlyphBuilder.build();
        sVGGlyph.getTransforms().add((Object)new Scale(1.0, -1.0));
        Translate translate = new Translate();
        translate.yProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> -sVGGlyph.getHeight(), (Observable[])new Observable[]{sVGGlyph.heightProperty()}));
        sVGGlyph.getTransforms().add((Object)translate);
        return sVGGlyph;
    }

    public static Set<String> getAllGlyphsIDs() {
        return glyphsMap.keySet();
    }

    public static void loadGlyphsFont(URL uRL) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver((string, string2) -> new InputSource(new StringReader("")));
            File file = new File(uRL.toURI());
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("glyph");
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Node node = nodeList.item(i2);
                Node node2 = node.getAttributes().getNamedItem("glyph-name");
                if (node2 == null) continue;
                String string3 = node2.getNodeValue();
                SVGGlyphBuilder sVGGlyphBuilder = new SVGGlyphBuilder(i2, string3, node.getAttributes().getNamedItem("d").getNodeValue());
                glyphsMap.put(file.getName() + "." + string3, sVGGlyphBuilder);
            }
        }
        catch (URISyntaxException | ParserConfigurationException | SAXException exception) {
            exception.printStackTrace();
        }
    }

    public static void loadGlyphsFont(InputStream inputStream, String string3) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver((string, string2) -> new InputSource(new StringReader("")));
            Document document = documentBuilder.parse(inputStream);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("glyph");
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Node node = nodeList.item(i2);
                Node node2 = node.getAttributes().getNamedItem("glyph-name");
                if (node2 == null) continue;
                String string4 = node2.getNodeValue();
                SVGGlyphBuilder sVGGlyphBuilder = new SVGGlyphBuilder(i2, string4, node.getAttributes().getNamedItem("d").getNodeValue());
                glyphsMap.put(string3 + "." + string4, sVGGlyphBuilder);
            }
            inputStream.close();
        }
        catch (ParserConfigurationException | SAXException exception) {
            exception.printStackTrace();
        }
    }

    public static SVGGlyph loadGlyph(URL uRL) throws IOException {
        int n2;
        String string = uRL.toString();
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        int n3 = 0;
        for (n2 = 0; n2 < string2.length() && string2.charAt(n2) != '-'; ++n2) {
        }
        int n4 = Integer.parseInt(string2.substring(n3, n2));
        n3 = n2 + 1;
        while (n2 < string2.length() && string2.charAt(n2) != '.') {
            ++n2;
        }
        String string3 = string2.substring(n3, n2);
        return new SVGGlyph(n4, string3, SVGGlyphLoader.extractSvgPath(SVGGlyphLoader.getStringFromInputStream(uRL.openStream())), (Paint)Color.BLACK);
    }

    public static void clear() {
        glyphsMap.clear();
    }

    private static String extractSvgPath(String string) {
        return string.replaceFirst(".*d=\"", "").replaceFirst("\".*", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFromInputStream(InputStream inputStream) {
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return stringBuilder.toString();
    }

    private static final class SVGGlyphBuilder {
        private int glyphId;
        private String name;
        private String svgPathContent;

        SVGGlyphBuilder(int n2, String string, String string2) {
            this.glyphId = n2;
            this.name = string;
            this.svgPathContent = string2;
        }

        SVGGlyph build() {
            return new SVGGlyph(this.glyphId, this.name, this.svgPathContent, (Paint)Color.BLACK);
        }
    }
}

