/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.JFXTimePicker;
import com.jfoenix.skins.JFXGenericPickerSkin;
import com.jfoenix.skins.JFXTimePickerContent;
import java.time.LocalTime;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class JFXTimePickerSkin
extends JFXGenericPickerSkin<LocalTime> {
    private JFXTimePicker jfxTimePicker;
    private TextField displayNode;
    private JFXTimePickerContent content;
    private JFXDialog dialog;

    public JFXTimePickerSkin(JFXTimePicker jFXTimePicker) {
        super(jFXTimePicker);
        this.jfxTimePicker = jFXTimePicker;
        jFXTimePicker.focusedProperty().addListener(observable -> {
            if (this.getEditor() != null && !jFXTimePicker.isFocused()) {
                this.reflectSetTextFromTextFieldIntoComboBoxValue();
            }
        });
        this.updateArrow(jFXTimePicker);
        ((JFXTextField)this.getEditor()).setFocusColor(jFXTimePicker.getDefaultColor());
        this.registerChangeListener((ObservableValue)jFXTimePicker.defaultColorProperty(), observableValue -> this.updateArrow(jFXTimePicker));
        this.registerChangeListener((ObservableValue)jFXTimePicker.converterProperty(), observableValue -> this.reflectUpdateDisplayNode());
        this.registerChangeListener((ObservableValue)jFXTimePicker.editorProperty(), observableValue -> this.reflectUpdateDisplayNode());
        this.registerChangeListener((ObservableValue)jFXTimePicker.showingProperty(), observableValue -> {
            if (this.jfxTimePicker.isShowing()) {
                this.show();
            } else {
                this.hide();
            }
        });
        this.registerChangeListener((ObservableValue)jFXTimePicker.valueProperty(), observableValue -> {
            this.reflectUpdateDisplayNode();
            this.jfxTimePicker.fireEvent((Event)new ActionEvent());
        });
    }

    private void updateArrow(JFXTimePicker jFXTimePicker) {
        ((Region)this.arrowButton.getChildren().get(0)).setBackground(new Background(new BackgroundFill[]{new BackgroundFill(jFXTimePicker.getDefaultColor(), null, null)}));
        ((JFXTextField)this.getEditor()).setFocusColor(this.jfxTimePicker.getDefaultColor());
    }

    protected Node getPopupContent() {
        if (this.content == null) {
            this.content = new JFXTimePickerContent((JFXTimePicker)this.getSkinnable());
        }
        return this.content;
    }

    public void show() {
        if (!this.jfxTimePicker.isOverLay()) {
            super.show();
        }
        if (this.content != null) {
            this.content.init();
            this.content.clearFocus();
        }
        if (this.dialog == null && this.jfxTimePicker.isOverLay()) {
            StackPane stackPane = this.jfxTimePicker.getDialogParent();
            if (stackPane == null) {
                stackPane = (StackPane)this.jfxTimePicker.getScene().getRoot();
            }
            this.dialog = new JFXDialog(stackPane, (Region)this.getPopupContent(), JFXDialog.DialogTransition.CENTER, true);
            this.arrowButton.setOnMouseClicked(mouseEvent -> {
                if (this.jfxTimePicker.isOverLay()) {
                    StackPane stackPane = this.jfxTimePicker.getDialogParent();
                    if (stackPane == null) {
                        stackPane = (StackPane)this.jfxTimePicker.getScene().getRoot();
                    }
                    this.dialog.show(stackPane);
                }
            });
        }
    }

    protected TextField getEditor() {
        return ((JFXTimePicker)this.getSkinnable()).getEditor();
    }

    protected StringConverter<LocalTime> getConverter() {
        return ((JFXTimePicker)this.getSkinnable()).getConverter();
    }

    public Node getDisplayNode() {
        if (this.displayNode == null) {
            this.displayNode = this.reflectGetEditableInputNode();
            this.displayNode.getStyleClass().add((Object)"time-picker-display-node");
            this.reflectUpdateDisplayNode();
        }
        this.displayNode.setEditable(this.jfxTimePicker.isEditable());
        return this.displayNode;
    }
}

