/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.controls.JFXTabPane;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.svg.SVGGlyph;
import com.jfoenix.transitions.CachedTransition;
import com.sun.javafx.scene.control.LambdaMultiplePropertyChangeListenerHandler;
import com.sun.javafx.scene.control.behavior.TabPaneBehavior;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class JFXTabPaneSkin
extends SkinBase<JFXTabPane> {
    private HeaderContainer header;
    private ObservableList<TabContentHolder> tabContentHolders;
    private Rectangle clip;
    private Rectangle tabsClip;
    private Tab selectedTab;
    private boolean isSelectingTab = false;
    private double dragStart;
    private double offsetStart;
    private AnchorPane tabsContainer;
    private AnchorPane tabsContainerHolder;
    private static final int SPACER = 10;
    private double maxWidth = 0.0;
    private double maxHeight = 0.0;
    private final TabPaneBehavior behavior;
    private boolean removedTabs = false;
    private int diffTabsIndices = 0;
    private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"selected");
    private static final PseudoClass DISABLED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"disabled");
    private static final PseudoClass TOP_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"top");
    private static final PseudoClass BOTTOM_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"bottom");
    private static final PseudoClass LEFT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"left");
    private static final PseudoClass RIGHT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"right");
    private static final PseudoClass CLOSABLE = PseudoClass.getPseudoClass((String)"closable");

    public JFXTabPaneSkin(JFXTabPane jFXTabPane) {
        super((Control)jFXTabPane);
        this.behavior = new TabPaneBehavior((TabPane)jFXTabPane);
        this.tabContentHolders = FXCollections.observableArrayList();
        this.header = new HeaderContainer();
        this.getChildren().add((Object)JFXDepthManager.createMaterialNode((Node)this.header, 1));
        this.tabsContainer = new AnchorPane();
        this.tabsContainerHolder = new AnchorPane();
        this.tabsContainerHolder.getChildren().add((Object)this.tabsContainer);
        this.tabsClip = new Rectangle();
        this.tabsContainerHolder.setClip((Node)this.tabsClip);
        this.getChildren().add(0, (Object)this.tabsContainerHolder);
        for (Tab tab : ((JFXTabPane)this.getSkinnable()).getTabs()) {
            this.addTabContentHolder(tab);
        }
        this.clip = new Rectangle(jFXTabPane.getWidth(), jFXTabPane.getHeight());
        ((JFXTabPane)this.getSkinnable()).setClip((Node)this.clip);
        if (((JFXTabPane)this.getSkinnable()).getTabs().size() == 0) {
            this.header.setVisible(false);
        }
        this.selectedTab = (Tab)((JFXTabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        if (this.selectedTab == null && ((JFXTabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex() != -1) {
            ((JFXTabPane)this.getSkinnable()).getSelectionModel().select(((JFXTabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex());
            this.selectedTab = (Tab)((JFXTabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        }
        if (this.selectedTab == null) {
            ((JFXTabPane)this.getSkinnable()).getSelectionModel().selectFirst();
        }
        this.selectedTab = (Tab)((JFXTabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        this.header.headersRegion.setOnMouseDragged(mouseEvent -> {
            this.header.updateScrollOffset(this.offsetStart + (this.isHorizontal() ? mouseEvent.getSceneX() : mouseEvent.getSceneY()) - this.dragStart);
            mouseEvent.consume();
        });
        ((JFXTabPane)this.getSkinnable()).addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            this.dragStart = this.isHorizontal() ? mouseEvent.getSceneX() : mouseEvent.getSceneY();
            this.offsetStart = this.header.scrollOffset;
        });
        ((JFXTabPane)this.getSkinnable()).getTabs().addListener(change -> {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            int n2 = -1;
            while (change.next()) {
                if (change.wasPermutated()) {
                    Tab tab = (Tab)((JFXTabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
                    Object object = new ArrayList(change.getTo() - change.getFrom());
                    ((JFXTabPane)this.getSkinnable()).getSelectionModel().clearSelection();
                    for (int i2 = change.getFrom(); i2 < change.getTo(); ++i2) {
                        object.add((Tab)((JFXTabPane)this.getSkinnable()).getTabs().get(i2));
                    }
                    this.removeTabs((List<? extends Tab>)object);
                    this.addTabs((List<? extends Tab>)object, change.getFrom());
                    ((JFXTabPane)this.getSkinnable()).getSelectionModel().select((Object)tab);
                }
                if (change.wasRemoved()) {
                    arrayList.addAll(change.getRemoved());
                }
                if (!change.wasAdded()) continue;
                arrayList2.addAll(change.getAddedSubList());
                n2 = change.getFrom();
            }
            arrayList.removeAll(arrayList2);
            this.removeTabs(arrayList);
            if (!arrayList2.isEmpty()) {
                for (Object object : this.tabContentHolders) {
                    TabHeaderContainer tabHeaderContainer = this.header.getTabHeaderContainer(((TabContentHolder)object).tab);
                    if (tabHeaderContainer.isClosing || !arrayList2.contains(((TabContentHolder)object).tab)) continue;
                    arrayList2.remove(((TabContentHolder)object).tab);
                }
                this.addTabs(arrayList2, n2 == -1 ? this.tabContentHolders.size() : n2);
            }
            ((JFXTabPane)this.getSkinnable()).requestLayout();
        });
        this.registerChangeListener((ObservableValue)jFXTabPane.getSelectionModel().selectedItemProperty(), observableValue -> {
            this.isSelectingTab = true;
            this.selectedTab = (Tab)((JFXTabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
            ((JFXTabPane)this.getSkinnable()).requestLayout();
        });
        this.registerChangeListener((ObservableValue)jFXTabPane.widthProperty(), observableValue -> this.clip.setWidth(((JFXTabPane)this.getSkinnable()).getWidth()));
        this.registerChangeListener((ObservableValue)jFXTabPane.heightProperty(), observableValue -> this.clip.setHeight(((JFXTabPane)this.getSkinnable()).getHeight()));
    }

    private void removeTabs(List<? extends Tab> list) {
        for (Tab tab : list) {
            TabHeaderContainer tabHeaderContainer = this.header.getTabHeaderContainer(tab);
            if (tabHeaderContainer == null) continue;
            tabHeaderContainer.isClosing = true;
            this.removeTab(tab);
            if (!((JFXTabPane)this.getSkinnable()).getTabs().isEmpty()) continue;
            this.header.setVisible(false);
        }
        this.removedTabs = !list.isEmpty();
    }

    private void addTabs(List<? extends Tab> list, int n2) {
        int n3 = 0;
        for (Tab tab : list) {
            if (!this.header.isVisible()) {
                this.header.setVisible(true);
            }
            this.header.addTab(tab, n2 + n3++, false);
            this.addTabContentHolder(tab);
            TabHeaderContainer tabHeaderContainer = this.header.getTabHeaderContainer(tab);
            if (tabHeaderContainer == null) continue;
            tabHeaderContainer.setVisible(true);
            tabHeaderContainer.inner.requestLayout();
        }
    }

    private void addTabContentHolder(Tab tab) {
        TabContentHolder tabContentHolder = new TabContentHolder(tab);
        tabContentHolder.setClip((Node)new Rectangle());
        this.tabContentHolders.add((Object)tabContentHolder);
        this.tabsContainer.getChildren().add(0, (Object)tabContentHolder);
    }

    private void removeTabContentHolder(Tab tab) {
        for (TabContentHolder tabContentHolder : this.tabContentHolders) {
            if (!tabContentHolder.tab.equals(tab)) continue;
            tabContentHolder.removeListeners(tab);
            this.getChildren().remove((Object)tabContentHolder);
            this.tabContentHolders.remove((Object)tabContentHolder);
            this.tabsContainer.getChildren().remove((Object)tabContentHolder);
            break;
        }
    }

    private void removeTab(Tab tab) {
        TabHeaderContainer tabHeaderContainer = this.header.getTabHeaderContainer(tab);
        if (tabHeaderContainer != null) {
            tabHeaderContainer.removeListeners();
        }
        this.header.removeTab(tab);
        this.removeTabContentHolder(tab);
        this.header.requestLayout();
    }

    private boolean isHorizontal() {
        Side side = ((JFXTabPane)this.getSkinnable()).getSide();
        return Side.TOP.equals((Object)side) || Side.BOTTOM.equals((Object)side);
    }

    private static int getRotation(Side side) {
        switch (side) {
            case TOP: {
                return 0;
            }
            case BOTTOM: {
                return 180;
            }
            case LEFT: {
                return -90;
            }
            case RIGHT: {
                return 90;
            }
        }
        return 0;
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        for (TabContentHolder tabContentHolder : this.tabContentHolders) {
            this.maxWidth = Math.max(this.maxWidth, this.snapSize(tabContentHolder.prefWidth(-1.0)));
        }
        double d7 = this.snapSize(this.header.prefWidth(-1.0));
        double d8 = Math.max(this.maxWidth, d7);
        return this.snapSize(d8) + d4 + d6;
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        for (TabContentHolder tabContentHolder : this.tabContentHolders) {
            this.maxHeight = Math.max(this.maxHeight, this.snapSize(tabContentHolder.prefHeight(-1.0)));
        }
        double d7 = this.snapSize(this.header.prefHeight(-1.0));
        double d8 = this.maxHeight + this.snapSize(d7);
        return this.snapSize(d8) + d3 + d5;
    }

    public double computeBaselineOffset(double d2, double d3, double d4, double d5) {
        return this.header.getBaselineOffset() + d2;
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6 = this.snapSize(this.header.prefHeight(-1.0));
        Side side = ((JFXTabPane)this.getSkinnable()).getSide();
        double d7 = side == Side.RIGHT ? d2 + d4 - d6 : d2;
        double d8 = side == Side.BOTTOM ? d3 + d5 - d6 : d3;
        int n2 = JFXTabPaneSkin.getRotation(side);
        switch (side) {
            case TOP: {
                this.header.resize(d4, d6);
                this.header.relocate(d7, d8);
                break;
            }
            case LEFT: {
                this.header.resize(d5, d6);
                this.header.relocate(d7 + d6, d5 - d6);
                break;
            }
            case RIGHT: {
                this.header.resize(d5, d6);
                this.header.relocate(d7, d3 - d6);
                break;
            }
            case BOTTOM: {
                this.header.resize(d4, d6);
                this.header.relocate(d4, d8 - d6);
            }
        }
        this.header.getTransforms().setAll((Object[])new Transform[]{new Rotate((double)n2, 0.0, d6, 1.0)});
        double d9 = d2 + (side == Side.LEFT ? d6 : 0.0);
        double d10 = d3 + (side == Side.TOP ? d6 : 0.0);
        double d11 = d4 - (this.isHorizontal() ? 0.0 : d6);
        double d12 = d5 - (this.isHorizontal() ? d6 : 0.0);
        this.tabsClip.setWidth(d11);
        this.tabsClip.setHeight(d12);
        this.tabsContainerHolder.resize(d11, d12);
        this.tabsContainerHolder.relocate(d9, d10);
        this.tabsContainer.resize(d11 * (double)this.tabContentHolders.size(), d12);
        int n3 = this.tabContentHolders.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            TabContentHolder tabContentHolder = (TabContentHolder)((Object)this.tabContentHolders.get(i2));
            tabContentHolder.setVisible(true);
            tabContentHolder.setTranslateX(d11 * (double)i2);
            if (tabContentHolder.getClip() != null) {
                ((Rectangle)tabContentHolder.getClip()).setWidth(d11);
                ((Rectangle)tabContentHolder.getClip()).setHeight(d12);
            }
            if (tabContentHolder.tab == this.selectedTab) {
                int n4 = ((JFXTabPane)this.getSkinnable()).getTabs().indexOf((Object)this.selectedTab);
                if (n4 != i2) {
                    this.tabsContainer.setTranslateX(-d11 * (double)i2);
                    this.diffTabsIndices = i2 - n4;
                } else {
                    if (this.diffTabsIndices != 0) {
                        this.tabsContainer.setTranslateX(this.tabsContainer.getTranslateX() + d11 * (double)this.diffTabsIndices);
                        this.diffTabsIndices = 0;
                    }
                    if (this.isSelectingTab && !((JFXTabPane)this.getSkinnable()).isDisableAnimation().booleanValue()) {
                        new CachedTransition((Node)this.tabsContainer, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.tabsContainer.translateXProperty(), (Object)(-d11 * (double)n4), Interpolator.EASE_BOTH)})})){
                            {
                                this.setCycleDuration(Duration.seconds((double)0.32));
                                this.setDelay(Duration.seconds((double)0.0));
                            }
                        }.play();
                    } else {
                        this.tabsContainer.setTranslateX(-d11 * (double)n4);
                    }
                }
            }
            tabContentHolder.resize(d11, d12);
        }
    }

    protected class HeaderControl
    extends StackPane {
        private StackPane inner;
        private boolean showControlButtons;
        private boolean isLeftArrow;
        private Timeline arrowAnimation;
        private SVGGlyph arrowButton;
        private StackPane container;
        private PseudoClass left = PseudoClass.getPseudoClass((String)"left");
        private PseudoClass right = PseudoClass.getPseudoClass((String)"right");
        private boolean showTabsHeaderControls = false;

        public HeaderControl(ArrowPosition arrowPosition) {
            this.getStyleClass().setAll((Object[])new String[]{"control-buttons-tab"});
            this.isLeftArrow = arrowPosition == ArrowPosition.LEFT;
            this.arrowButton = new SVGGlyph();
            this.arrowButton.pseudoClassStateChanged(this.isLeftArrow ? this.left : this.right, true);
            this.arrowButton.getStyleClass().setAll((Object[])new String[]{"tab-down-button"});
            this.arrowButton.setVisible(this.isControlButtonShown());
            StackPane.setMargin((Node)this.arrowButton, (Insets)new Insets(0.0, 0.0, 0.0, this.isLeftArrow ? -4.0 : 4.0));
            SimpleDoubleProperty simpleDoubleProperty = new SimpleDoubleProperty(0.0);
            simpleDoubleProperty.addListener((observableValue, number, number2) -> JFXTabPaneSkin.this.header.updateScrollOffset(number2.doubleValue()));
            this.container = new StackPane(new Node[]{this.arrowButton});
            this.container.getStyleClass().add((Object)"container");
            this.container.setPadding(new Insets(7.0));
            this.container.setCursor(Cursor.HAND);
            this.container.setOnMousePressed(arg_0 -> this.lambda$new$1((DoubleProperty)simpleDoubleProperty, arg_0));
            this.container.setOnMouseReleased(mouseEvent -> this.arrowAnimation.stop());
            final JFXRippler jFXRippler = new JFXRippler((Node)this.container, JFXRippler.RipplerMask.CIRCLE, JFXRippler.RipplerPos.BACK);
            jFXRippler.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
            this.inner = new StackPane(){

                protected double computePrefWidth(double d2) {
                    double d3 = 0.0;
                    double d4 = !HeaderControl.this.isControlButtonShown() ? 0.0 : this.snapSize(jFXRippler.prefWidth(this.getHeight()));
                    return d3 += (d3 += HeaderControl.this.isControlButtonShown() ? d4 : 0.0) > 0.0 ? this.snappedLeftInset() + this.snappedRightInset() : 0.0;
                }

                protected double computePrefHeight(double d2) {
                    double d3 = 0.0;
                    d3 = HeaderControl.this.isControlButtonShown() ? Math.max(d3, this.snapSize(jFXRippler.prefHeight(d2))) : 0.0;
                    return d3 += d3 > 0.0 ? this.snappedTopInset() + this.snappedBottomInset() : 0.0;
                }

                protected void layoutChildren() {
                    if (HeaderControl.this.isControlButtonShown()) {
                        double d2 = 0.0;
                        double d3 = this.snappedTopInset();
                        double d4 = this.snapSize(this.getWidth()) - d2 + this.snappedLeftInset();
                        double d5 = this.snapSize(this.getHeight()) - d3 + this.snappedBottomInset();
                        this.positionArrow(jFXRippler, d2, d3, d4, d5);
                    }
                }

                private void positionArrow(JFXRippler jFXRippler2, double d2, double d3, double d4, double d5) {
                    jFXRippler2.resize(d4, d5);
                    this.positionInArea((Node)jFXRippler2, d2, d3, d4, d5, 0.0, HPos.CENTER, VPos.CENTER);
                }
            };
            this.inner.getChildren().add((Object)jFXRippler);
            this.getChildren().add((Object)this.inner);
            this.showControlButtons = false;
            if (this.isControlButtonShown()) {
                this.showControlButtons = true;
                this.requestLayout();
            }
        }

        private void showTabsMenu(boolean bl2) {
            boolean bl3 = this.isControlButtonShown();
            this.showTabsHeaderControls = bl2;
            if (this.showTabsHeaderControls && !bl3) {
                this.arrowButton.setVisible(true);
                this.showControlButtons = true;
                this.inner.requestLayout();
                JFXTabPaneSkin.this.header.layoutChildren();
            } else if (!this.showTabsHeaderControls && bl3) {
                this.container.setPrefWidth(0.0);
                if (this.isControlButtonShown()) {
                    this.showControlButtons = true;
                } else {
                    this.setVisible(false);
                }
                this.requestLayout();
            }
        }

        private boolean isControlButtonShown() {
            return this.showTabsHeaderControls;
        }

        protected double computePrefWidth(double d2) {
            double d3 = this.snapSize(this.inner.prefWidth(d2));
            if (d3 > 0.0) {
                d3 += this.snappedLeftInset() + this.snappedRightInset();
            }
            return d3;
        }

        protected double computePrefHeight(double d2) {
            return Math.max(((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMinHeight(), this.snapSize(this.inner.prefHeight(d2))) + this.snappedTopInset() + this.snappedBottomInset();
        }

        protected void layoutChildren() {
            double d2 = this.snappedLeftInset();
            double d3 = this.snappedTopInset();
            double d4 = this.snapSize(this.getWidth()) - d2 + this.snappedRightInset();
            double d5 = this.snapSize(this.getHeight()) - d3 + this.snappedBottomInset();
            if (this.showControlButtons) {
                this.setVisible(true);
                this.showControlButtons = false;
            }
            this.inner.resize(d4, d5);
            this.positionInArea((Node)this.inner, d2, d3, d4, d5, 0.0, HPos.CENTER, VPos.BOTTOM);
        }

        private /* synthetic */ void lambda$new$1(DoubleProperty doubleProperty, MouseEvent mouseEvent) {
            doubleProperty.set(JFXTabPaneSkin.this.header.scrollOffset);
            double d2 = this.isLeftArrow ? JFXTabPaneSkin.this.header.scrollOffset + JFXTabPaneSkin.this.header.headersRegion.getWidth() : JFXTabPaneSkin.this.header.scrollOffset - JFXTabPaneSkin.this.header.headersRegion.getWidth();
            this.arrowAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), new KeyValue[]{new KeyValue((WritableValue)doubleProperty, (Object)d2, Interpolator.LINEAR)})});
            this.arrowAnimation.play();
        }
    }

    private static enum ArrowPosition {
        RIGHT,
        LEFT;

    }

    protected class TabContentHolder
    extends StackPane {
        private Tab tab;
        private InvalidationListener tabContentListener = observable -> this.updateContent();
        private InvalidationListener tabSelectedListener = observable -> this.setVisible(this.tab.isSelected());
        private WeakInvalidationListener weakTabContentListener = new WeakInvalidationListener(this.tabContentListener);
        private WeakInvalidationListener weakTabSelectedListener = new WeakInvalidationListener(this.tabSelectedListener);

        public TabContentHolder(Tab tab) {
            this.tab = tab;
            this.getStyleClass().setAll((Object[])new String[]{"tab-content-area"});
            this.setManaged(false);
            this.updateContent();
            this.setVisible(tab.isSelected());
            tab.selectedProperty().addListener((InvalidationListener)this.weakTabSelectedListener);
            tab.contentProperty().addListener((InvalidationListener)this.weakTabContentListener);
        }

        private void updateContent() {
            Node node = this.tab.getContent();
            if (node == null) {
                this.getChildren().clear();
            } else {
                this.getChildren().setAll((Object[])new Node[]{node});
            }
        }

        private void removeListeners(Tab tab) {
            tab.selectedProperty().removeListener((InvalidationListener)this.weakTabSelectedListener);
            tab.contentProperty().removeListener((InvalidationListener)this.weakTabContentListener);
        }
    }

    protected class TabHeaderContainer
    extends StackPane {
        private Tab tab = null;
        private Label tabLabel;
        private Tooltip oldTooltip;
        private Tooltip tooltip;
        private HBox inner;
        private Button closeButton;
        private JFXRippler rippler;
        private boolean isClosing = false;
        private final LambdaMultiplePropertyChangeListenerHandler listener = new LambdaMultiplePropertyChangeListenerHandler();
        private final ListChangeListener<String> styleClassListener = change -> this.getStyleClass().setAll((Collection)this.tab.getStyleClass());
        private final WeakListChangeListener<String> weakStyleClassListener = new WeakListChangeListener(this.styleClassListener);

        public TabHeaderContainer(Tab tab) {
            this.tab = tab;
            this.getStyleClass().setAll((Collection)tab.getStyleClass());
            this.setId(tab.getId());
            this.setStyle(tab.getStyle());
            this.tabLabel = new Label(tab.getText(), tab.getGraphic());
            this.tabLabel.getStyleClass().setAll((Object[])new String[]{"tab-label"});
            this.closeButton = new JFXButton(null, (Node)new SVGGlyph());
            this.closeButton.getStyleClass().add((Object)"tab-close-button");
            this.closeButton.setOnAction(actionEvent -> {
                if (JFXTabPaneSkin.this.behavior.canCloseTab(tab)) {
                    JFXTabPaneSkin.this.behavior.closeTab(tab);
                    this.setOnMouseClicked(null);
                }
            });
            this.inner = new HBox();
            this.inner.getChildren().setAll((Object[])new Node[]{this.tabLabel, this.closeButton});
            this.inner.setAlignment(Pos.CENTER);
            this.inner.getStyleClass().add((Object)"tab-container");
            this.inner.setRotate(((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getSide().equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
            this.rippler = new JFXRippler((Node)this.inner);
            this.getChildren().addAll((Object[])new Node[]{this.rippler});
            this.tooltip = tab.getTooltip();
            if (this.tooltip != null) {
                Tooltip.install((Node)this, (Tooltip)this.tooltip);
                this.oldTooltip = this.tooltip;
            }
            this.listener.registerChangeListener((ObservableValue)tab.selectedProperty(), observableValue -> {
                this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, tab.isSelected());
                this.updateInnerUI();
            });
            this.listener.registerChangeListener((ObservableValue)tab.textProperty(), observableValue -> this.tabLabel.setText(tab.getText()));
            this.listener.registerChangeListener((ObservableValue)tab.graphicProperty(), observableValue -> this.tabLabel.setGraphic(tab.getGraphic()));
            this.listener.registerChangeListener((ObservableValue)this.widthProperty(), observableValue -> JFXTabPaneSkin.this.header.updateSelectionLine(true));
            this.listener.registerChangeListener((ObservableValue)tab.tooltipProperty(), observableValue -> {
                if (this.oldTooltip != null) {
                    Tooltip.uninstall((Node)this, (Tooltip)this.oldTooltip);
                }
                this.tooltip = tab.getTooltip();
                if (this.tooltip != null) {
                    Tooltip.install((Node)this, (Tooltip)this.tooltip);
                    this.oldTooltip = this.tooltip;
                }
            });
            this.listener.registerChangeListener((ObservableValue)tab.disableProperty(), observableValue -> {
                this.pseudoClassStateChanged(DISABLED_PSEUDOCLASS_STATE, tab.isDisable());
                this.updateInnerUI();
            });
            this.listener.registerChangeListener((ObservableValue)tab.styleProperty(), observableValue -> this.setStyle(tab.getStyle()));
            this.listener.registerChangeListener((ObservableValue)((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).tabMinWidthProperty(), observableValue -> this.updateSkinnableUI());
            this.listener.registerChangeListener((ObservableValue)((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).tabMaxWidthProperty(), observableValue -> this.updateSkinnableUI());
            this.listener.registerChangeListener((ObservableValue)((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).tabMinHeightProperty(), observableValue -> this.updateSkinnableUI());
            this.listener.registerChangeListener((ObservableValue)((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).tabMaxHeightProperty(), observableValue -> this.updateSkinnableUI());
            this.listener.registerChangeListener((ObservableValue)((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).sideProperty(), observableValue -> {
                Side side = ((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getSide();
                this.pseudoClassStateChanged(TOP_PSEUDOCLASS_STATE, side == Side.TOP);
                this.pseudoClassStateChanged(RIGHT_PSEUDOCLASS_STATE, side == Side.RIGHT);
                this.pseudoClassStateChanged(BOTTOM_PSEUDOCLASS_STATE, side == Side.BOTTOM);
                this.pseudoClassStateChanged(LEFT_PSEUDOCLASS_STATE, side == Side.LEFT);
                this.inner.setRotate(side == Side.BOTTOM ? 180.0 : 0.0);
            });
            this.listener.registerChangeListener((ObservableValue)((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).tabClosingPolicyProperty(), observableValue -> this.updateInnerUI());
            tab.getStyleClass().addListener(this.weakStyleClassListener);
            this.getProperties().put(Tab.class, (Object)tab);
            this.setOnMouseClicked(mouseEvent -> {
                if (tab.isDisable() || !mouseEvent.isStillSincePress()) {
                    return;
                }
                if (mouseEvent.getButton() == MouseButton.MIDDLE) {
                    if (this.showCloseButton() && JFXTabPaneSkin.this.behavior.canCloseTab(tab)) {
                        this.removeListeners();
                        JFXTabPaneSkin.this.behavior.closeTab(tab);
                    }
                } else if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                    this.setOpacity(1.0);
                    JFXTabPaneSkin.this.behavior.selectTab(tab);
                }
            });
            this.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, contextMenuEvent -> {
                ContextMenu contextMenu = tab.getContextMenu();
                if (contextMenu != null) {
                    contextMenu.show((Node)this.tabLabel, contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY());
                    contextMenuEvent.consume();
                }
            });
            this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, tab.isSelected());
            this.pseudoClassStateChanged(DISABLED_PSEUDOCLASS_STATE, tab.isDisable());
            Side side = ((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getSide();
            this.pseudoClassStateChanged(TOP_PSEUDOCLASS_STATE, side == Side.TOP);
            this.pseudoClassStateChanged(RIGHT_PSEUDOCLASS_STATE, side == Side.RIGHT);
            this.pseudoClassStateChanged(BOTTOM_PSEUDOCLASS_STATE, side == Side.BOTTOM);
            this.pseudoClassStateChanged(LEFT_PSEUDOCLASS_STATE, side == Side.LEFT);
            this.pseudoClassStateChanged(CLOSABLE, this.showCloseButton());
        }

        private void updateInnerUI() {
            this.inner.requestLayout();
            this.requestLayout();
        }

        private void updateSkinnableUI() {
            this.requestLayout();
            ((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).requestLayout();
        }

        private boolean showCloseButton() {
            return this.tab.isClosable() && ((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getTabClosingPolicy().equals((Object)TabPane.TabClosingPolicy.ALL_TABS);
        }

        private void removeListeners() {
            this.listener.dispose();
            this.inner.getChildren().clear();
            this.getChildren().clear();
        }

        protected double computePrefWidth(double d2) {
            double d3 = this.snapSize(((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMinWidth());
            double d4 = this.snapSize(((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMaxWidth());
            double d5 = this.snappedRightInset();
            double d6 = this.snappedLeftInset();
            double d7 = this.snapSize(this.tabLabel.prefWidth(-1.0));
            if (this.showCloseButton()) {
                d7 += this.snapSize(this.closeButton.prefWidth(-1.0));
            }
            if (d7 > d4) {
                d7 = d4;
            } else if (d7 < d3) {
                d7 = d3;
            }
            return d7 += d5 + d6;
        }

        protected double computePrefHeight(double d2) {
            double d3 = this.snapSize(((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMinHeight());
            double d4 = this.snapSize(((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getTabMaxHeight());
            double d5 = this.snappedTopInset();
            double d6 = this.snappedBottomInset();
            double d7 = this.snapSize(this.tabLabel.prefHeight(d2));
            if (d7 > d4) {
                d7 = d4;
            } else if (d7 < d3) {
                d7 = d3;
            }
            return d7 += d5 + d6;
        }

        protected void layoutChildren() {
            boolean bl2 = this.showCloseButton();
            this.closeButton.setManaged(bl2);
            this.closeButton.setVisible(bl2);
            this.pseudoClassStateChanged(CLOSABLE, bl2);
            this.rippler.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    protected class HeaderContainer
    extends StackPane {
        private Rectangle clip;
        private StackPane headersRegion;
        private StackPane headerBackground;
        private HeaderControl rightControlButton;
        private HeaderControl leftControlButton;
        private StackPane selectedTabLine;
        private boolean initialized = false;
        private boolean measureClosingTabs = false;
        private double scrollOffset;
        private double selectedTabLineOffset;
        private final Scale scale;
        private final Rotate rotate;
        private int direction;
        private Timeline timeline;
        private final double translateScaleFactor = 1.3;
        private List<TabHeaderContainer> removedTabsHeaders = new ArrayList<TabHeaderContainer>();

        public HeaderContainer() {
            ((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).sideProperty().addListener(observable -> this.updateDirection());
            this.updateDirection();
            this.getStyleClass().setAll((Object[])new String[]{"tab-header-area"});
            this.setManaged(false);
            this.clip = new Rectangle();
            this.headersRegion = new StackPane(){

                protected double computePrefWidth(double d2) {
                    double d3 = 0.0;
                    for (Node node : this.getChildren()) {
                        if (!(node instanceof TabHeaderContainer) || !node.isVisible() || !HeaderContainer.this.measureClosingTabs && ((TabHeaderContainer)node).isClosing) continue;
                        d3 += node.prefWidth(d2);
                    }
                    return this.snapSize(d3) + this.snappedLeftInset() + this.snappedRightInset();
                }

                protected double computePrefHeight(double d2) {
                    double d3 = 0.0;
                    for (Node node : this.getChildren()) {
                        if (!(node instanceof TabHeaderContainer)) continue;
                        d3 = Math.max(d3, node.prefHeight(d2));
                    }
                    return this.snapSize(d3) + this.snappedTopInset() + this.snappedBottomInset();
                }

                protected void layoutChildren() {
                    double d2;
                    if (HeaderContainer.this.isTabsFitHeaderWidth()) {
                        HeaderContainer.this.updateScrollOffset(0.0);
                    } else if (!HeaderContainer.this.removedTabsHeaders.isEmpty()) {
                        d2 = 0.0;
                        double d3 = JFXTabPaneSkin.this.header.getWidth() - this.snapSize(HeaderContainer.this.rightControlButton.prefWidth(-1.0)) - this.snapSize(HeaderContainer.this.leftControlButton.prefWidth(-1.0)) - this.snappedLeftInset() - 10.0;
                        Iterator iterator = this.getChildren().iterator();
                        while (iterator.hasNext()) {
                            Node node = (Node)iterator.next();
                            if (!(node instanceof TabHeaderContainer)) continue;
                            TabHeaderContainer tabHeaderContainer = (TabHeaderContainer)node;
                            double d4 = this.snapSize(tabHeaderContainer.prefWidth(-1.0));
                            if (HeaderContainer.this.removedTabsHeaders.contains((Object)tabHeaderContainer)) {
                                if (d2 < d3) {
                                    JFXTabPaneSkin.this.isSelectingTab = true;
                                }
                                iterator.remove();
                                HeaderContainer.this.removedTabsHeaders.remove((Object)tabHeaderContainer);
                                if (HeaderContainer.this.removedTabsHeaders.isEmpty()) break;
                            }
                            d2 += d4;
                        }
                    }
                    if (JFXTabPaneSkin.this.removedTabs) {
                        HeaderContainer.this.updateSelectionLine(false);
                        JFXTabPaneSkin.this.removedTabs = false;
                    }
                    if (JFXTabPaneSkin.this.isSelectingTab) {
                        HeaderContainer.this.updateSelectionLine(true);
                        JFXTabPaneSkin.this.isSelectingTab = false;
                    } else {
                        HeaderContainer.this.updateScrollOffset(HeaderContainer.this.scrollOffset);
                    }
                    d2 = this.snapSize(this.prefHeight(-1.0));
                    Side side = ((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getSide();
                    double d5 = side == Side.LEFT || side == Side.BOTTOM ? this.snapSize(this.getWidth()) - HeaderContainer.this.scrollOffset : HeaderContainer.this.scrollOffset;
                    HeaderContainer.this.updateHeaderContainerClip();
                    for (TabHeaderContainer tabHeaderContainer : this.getChildren()) {
                        double d6;
                        if (!(tabHeaderContainer instanceof TabHeaderContainer)) continue;
                        TabHeaderContainer tabHeaderContainer2 = tabHeaderContainer;
                        double d7 = this.snapSize(tabHeaderContainer2.prefWidth(-1.0));
                        double d8 = this.snapSize(tabHeaderContainer2.prefHeight(-1.0));
                        tabHeaderContainer2.resize(d7, d8);
                        double d9 = d6 = side == Side.BOTTOM ? 0.0 : d2 - d8 - this.snappedBottomInset();
                        if (side == Side.LEFT || side == Side.BOTTOM) {
                            tabHeaderContainer2.relocate(d5 -= d7, d6);
                            continue;
                        }
                        tabHeaderContainer2.relocate(d5, d6);
                        d5 += d7;
                    }
                    HeaderContainer.this.selectedTabLine.resizeRelocate(side == Side.LEFT || side == Side.BOTTOM ? this.snapSize(HeaderContainer.this.headersRegion.getWidth()) : 0.0, d2 - HeaderContainer.this.selectedTabLine.prefHeight(-1.0), this.snapSize(HeaderContainer.this.selectedTabLine.prefWidth(-1.0)), this.snapSize(HeaderContainer.this.selectedTabLine.prefHeight(-1.0)));
                }
            };
            this.headersRegion.getStyleClass().setAll((Object[])new String[]{"headers-region"});
            this.headersRegion.setCache(true);
            this.headersRegion.setClip((Node)this.clip);
            this.headerBackground = new StackPane();
            this.headerBackground.getStyleClass().setAll((Object[])new String[]{"tab-header-background"});
            this.selectedTabLine = new StackPane();
            this.selectedTabLine.setManaged(false);
            this.scale = new Scale(1.0, 1.0, 0.0, 0.0);
            this.rotate = new Rotate(0.0, 0.0, 1.0);
            this.rotate.pivotYProperty().bind((ObservableValue)this.selectedTabLine.heightProperty().divide(2));
            this.selectedTabLine.getTransforms().addAll((Object[])new Transform[]{this.scale, this.rotate});
            this.selectedTabLine.setCache(true);
            this.selectedTabLine.getStyleClass().add((Object)"tab-selected-line");
            this.headersRegion.getChildren().add((Object)this.selectedTabLine);
            this.rightControlButton = new HeaderControl(ArrowPosition.RIGHT);
            this.leftControlButton = new HeaderControl(ArrowPosition.LEFT);
            this.rightControlButton.setVisible(false);
            this.leftControlButton.setVisible(false);
            this.rightControlButton.inner.prefHeightProperty().bind((ObservableValue)this.headersRegion.heightProperty());
            this.leftControlButton.inner.prefHeightProperty().bind((ObservableValue)this.headersRegion.heightProperty());
            this.getChildren().addAll((Object[])new Node[]{this.headerBackground, this.headersRegion, this.leftControlButton, this.rightControlButton});
            int n2 = 0;
            for (Tab tab : ((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getTabs()) {
                this.addTab(tab, n2++, true);
            }
            this.addEventHandler(ScrollEvent.SCROLL, scrollEvent -> this.updateScrollOffset(this.scrollOffset + scrollEvent.getDeltaY() * (double)(JFXTabPaneSkin.this.isHorizontal() ? -1 : 1)));
        }

        private void updateDirection() {
            Side side = ((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getSide();
            this.direction = side == Side.BOTTOM || side == Side.LEFT ? -1 : 1;
        }

        private void updateHeaderContainerClip() {
            double d2 = this.getClipOffset();
            Side side = ((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getSide();
            double d3 = 2.0 * this.snapSize(this.rightControlButton.prefWidth(-1.0));
            this.measureClosingTabs = true;
            double d4 = this.snapSize(this.headersRegion.prefWidth(-1.0));
            double d5 = this.snapSize(this.headersRegion.prefHeight(-1.0));
            this.measureClosingTabs = false;
            double d6 = this.snapSize(this.getWidth()) - d3 - d2;
            double d7 = d4 < d6 ? d4 : d6;
            double d8 = d5;
            this.clip.setX((side == Side.LEFT || side == Side.BOTTOM) && d4 >= d6 ? d4 - d6 : 0.0);
            this.clip.setY(0.0);
            this.clip.setWidth(d7);
            this.clip.setHeight(d8);
        }

        private double getClipOffset() {
            return JFXTabPaneSkin.this.isHorizontal() ? this.snappedLeftInset() : this.snappedRightInset();
        }

        private void addTab(Tab tab, int n2, boolean bl2) {
            TabHeaderContainer tabHeaderContainer = new TabHeaderContainer(tab);
            tabHeaderContainer.setVisible(bl2);
            this.headersRegion.getChildren().add(n2, (Object)tabHeaderContainer);
        }

        private void removeTab(Tab tab) {
            TabHeaderContainer tabHeaderContainer = this.getTabHeaderContainer(tab);
            if (tabHeaderContainer != null) {
                if (this.isTabsFitHeaderWidth()) {
                    this.headersRegion.getChildren().remove((Object)tabHeaderContainer);
                } else {
                    this.removedTabsHeaders.add(tabHeaderContainer);
                    tabHeaderContainer.removeListeners();
                }
            }
        }

        private TabHeaderContainer getTabHeaderContainer(Tab tab) {
            for (Node node : this.headersRegion.getChildren()) {
                if (!(node instanceof TabHeaderContainer) || !((TabHeaderContainer)node).tab.equals(tab)) continue;
                return (TabHeaderContainer)node;
            }
            return null;
        }

        private boolean isTabsFitHeaderWidth() {
            double d2;
            double d3 = this.snapSize(this.headersRegion.prefWidth(-1.0));
            double d4 = d3 + (d2 = 2.0 * this.snapSize(this.rightControlButton.prefWidth(-1.0))) + this.snappedLeftInset() + 10.0;
            return d4 <= this.getWidth();
        }

        private void runTimeline(double d2, double d3) {
            double d4;
            if (this.selectedTabLine.getTranslateX() == d2 && this.scale.getX() == d3) {
                return;
            }
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = this.selectedTabLine.prefWidth(-1.0);
            if (this.isAnimating()) {
                this.timeline.stop();
                d5 = this.scale.getX();
                if (this.rotate.getAngle() != 0.0) {
                    this.rotate.setAngle(0.0);
                    d6 = d5 * d7;
                    this.selectedTabLine.setTranslateX(this.selectedTabLine.getTranslateX() - d6);
                }
            }
            double d8 = this.scale.getX();
            double d9 = d7 * d8;
            double d10 = this.selectedTabLine.getTranslateX();
            double d11 = d3 * d8 / d9;
            this.selectedTabLineOffset = d2;
            double d12 = (d2 += JFXTabPaneSkin.this.offsetStart * (double)this.direction) - d10;
            double d13 = d4 = d5 != 0.0 ? d5 : (Math.abs(d12) / 1.3 + d9) * d8 / d9;
            if (d4 > Math.abs(d12) + d3) {
                d4 = Math.abs(d12) + d3;
            }
            if (d12 < 0.0) {
                this.selectedTabLine.setTranslateX(this.selectedTabLine.getTranslateX() + d9);
                d2 += d3;
                this.rotate.setAngle(180.0);
            }
            this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)this.selectedTabLine.getTranslateX(), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.12), new KeyValue[]{new KeyValue((WritableValue)this.scale.xProperty(), (Object)d4, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)this.selectedTabLine.getTranslateX(), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.24), new KeyValue[]{new KeyValue((WritableValue)this.scale.xProperty(), (Object)d11, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedTabLine.translateXProperty(), (Object)d2, Interpolator.EASE_BOTH)})});
            this.timeline.setOnFinished(actionEvent -> {
                if (this.rotate.getAngle() != 0.0) {
                    this.rotate.setAngle(0.0);
                    this.selectedTabLine.setTranslateX(this.selectedTabLine.getTranslateX() - d3);
                }
            });
            this.timeline.play();
        }

        private boolean isAnimating() {
            return this.timeline != null && this.timeline.getStatus() == Animation.Status.RUNNING;
        }

        private void updateScrollOffset(double d2) {
            double d3 = this.snapSize(JFXTabPaneSkin.this.isHorizontal() ? ((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getWidth() : ((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getHeight());
            double d4 = 2.0 * this.snapSize(this.rightControlButton.getWidth());
            double d5 = d3 - d4 - this.snappedLeftInset() - 10.0;
            double d6 = 0.0;
            for (Node node : this.headersRegion.getChildren()) {
                if (!(node instanceof TabHeaderContainer)) continue;
                double d7 = this.snapSize(node.prefWidth(-1.0));
                d6 += d7;
            }
            double d8 = d2;
            if (d5 - d2 > d6 && d2 < 0.0) {
                d8 = d5 - d6;
            } else if (d2 > 0.0) {
                d8 = 0.0;
            }
            if (d8 != this.scrollOffset) {
                this.scrollOffset = d8;
                this.headersRegion.requestLayout();
                if (!this.isAnimating()) {
                    this.selectedTabLine.setTranslateX(this.selectedTabLineOffset + this.scrollOffset * (double)this.direction);
                }
            }
        }

        protected double computePrefWidth(double d2) {
            double d3 = JFXTabPaneSkin.this.isHorizontal() ? 2.0 * this.snappedLeftInset() + this.snappedRightInset() : 2.0 * this.snappedTopInset() + this.snappedBottomInset();
            return this.snapSize(this.headersRegion.prefWidth(d2)) + 2.0 * this.rightControlButton.prefWidth(d2) + d3 + 10.0;
        }

        protected double computePrefHeight(double d2) {
            double d3 = JFXTabPaneSkin.this.isHorizontal() ? this.snappedTopInset() + this.snappedBottomInset() : this.snappedLeftInset() + this.snappedRightInset();
            return this.snapSize(this.headersRegion.prefHeight(-1.0)) + d3;
        }

        public double getBaselineOffset() {
            return ((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getSide() == Side.TOP ? this.headersRegion.getBaselineOffset() + this.snappedTopInset() : 0.0;
        }

        protected void layoutChildren() {
            double d2 = this.snappedLeftInset();
            double d3 = this.snappedRightInset();
            double d4 = this.snappedTopInset();
            double d5 = this.snappedBottomInset();
            double d6 = JFXTabPaneSkin.this.isHorizontal() ? d2 + d3 : d4 + d5;
            double d7 = this.snapSize(this.getWidth()) - d6;
            double d8 = this.snapSize(this.getHeight()) - d6;
            double d9 = this.snapSize(this.prefHeight(-1.0));
            double d10 = this.snapSize(this.headersRegion.prefWidth(-1.0));
            double d11 = this.snapSize(this.headersRegion.prefHeight(-1.0));
            this.rightControlButton.showTabsMenu(!this.isTabsFitHeaderWidth());
            this.leftControlButton.showTabsMenu(!this.isTabsFitHeaderWidth());
            this.updateHeaderContainerClip();
            this.headersRegion.requestLayout();
            double d12 = this.snapSize(this.rightControlButton.prefWidth(-1.0));
            double d13 = this.rightControlButton.prefHeight(d12);
            this.rightControlButton.resize(d12, d13);
            this.leftControlButton.resize(d12, d13);
            this.headersRegion.resize(d10, d11);
            this.headerBackground.resize(this.snapSize(this.getWidth()), this.snapSize(this.getHeight()));
            Side side = ((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getSide();
            double d14 = 0.0;
            double d15 = 0.0;
            double d16 = 0.0;
            double d17 = 0.0;
            switch (side) {
                case TOP: {
                    d14 = d2;
                    d15 = d9 - d11 - d5;
                    d16 = d7 - d12 + d2;
                    d17 = this.snapSize(this.getHeight()) - d13 - d5;
                    break;
                }
                case BOTTOM: {
                    d14 = this.snapSize(this.getWidth()) - d10 - d2;
                    d15 = d9 - d11 - d4;
                    d16 = d3;
                    d17 = this.snapSize(this.getHeight()) - d13 - d4;
                    break;
                }
                case LEFT: {
                    d14 = this.snapSize(this.getWidth()) - d10 - d4;
                    d15 = d9 - d11 - d3;
                    d16 = d2;
                    d17 = this.snapSize(this.getHeight()) - d13 - d3;
                    break;
                }
                case RIGHT: {
                    d14 = d4;
                    d15 = d9 - d11 - d2;
                    d16 = d7 - d12 + d4;
                    d17 = this.snapSize(this.getHeight()) - d13 - d2;
                }
            }
            if (this.headerBackground.isVisible()) {
                this.positionInArea((Node)this.headerBackground, 0.0, 0.0, this.snapSize(this.getWidth()), this.snapSize(this.getHeight()), 0.0, HPos.CENTER, VPos.CENTER);
            }
            this.positionInArea((Node)this.headersRegion, d14 + d12 * (double)(side == Side.LEFT || side == Side.BOTTOM ? -1 : 1), d15, d7, d8, 0.0, HPos.LEFT, VPos.CENTER);
            this.positionInArea((Node)this.rightControlButton, d16, d17, d12, d13, 0.0, HPos.CENTER, VPos.CENTER);
            this.positionInArea((Node)this.leftControlButton, side == Side.LEFT || side == Side.BOTTOM ? d7 - d12 : 0.0, d17, d12, d13, 0.0, HPos.CENTER, VPos.CENTER);
            this.rightControlButton.setRotate(side == Side.LEFT || side == Side.BOTTOM ? 180.0 : 0.0);
            this.leftControlButton.setRotate(side == Side.LEFT || side == Side.BOTTOM ? 180.0 : 0.0);
            if (!this.initialized) {
                this.updateSelectionLine(true);
                this.initialized = true;
            }
        }

        private void updateSelectionLine(boolean bl2) {
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            Side side = ((JFXTabPane)JFXTabPaneSkin.this.getSkinnable()).getSide();
            for (Node node : this.headersRegion.getChildren()) {
                if (!(node instanceof TabHeaderContainer)) continue;
                TabHeaderContainer tabHeaderContainer = (TabHeaderContainer)node;
                double d5 = this.snapSize(tabHeaderContainer.prefWidth(-1.0));
                if (JFXTabPaneSkin.this.selectedTab != null && JFXTabPaneSkin.this.selectedTab.equals(tabHeaderContainer.tab)) {
                    d3 = side == Side.LEFT || side == Side.BOTTOM ? -d2 - d5 : d2;
                    d4 = d5;
                    break;
                }
                d2 += d5;
            }
            if (d4 > 0.0) {
                if (bl2) {
                    this.runTimeline(d3, d4);
                } else {
                    this.selectedTabLine.setTranslateX(d3 + this.scrollOffset * (double)this.direction);
                    this.scale.setX(d4);
                    this.selectedTabLineOffset = d3;
                }
            }
        }
    }
}

