/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXSpinner;
import com.sun.javafx.scene.NodeHelper;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class JFXSpinnerSkin
extends SkinBase<JFXSpinner> {
    private JFXSpinner control;
    private boolean isValid = false;
    private Color greenColor;
    private Color redColor;
    private Color yellowColor;
    private Color blueColor;
    private Timeline timeline;
    private Arc arc;
    private Arc track;
    private final StackPane arcPane;
    private final Rectangle fillRect;
    private double arcLength = -1.0;
    private Text text;
    boolean wasIndeterminate = false;

    public JFXSpinnerSkin(JFXSpinner jFXSpinner) {
        super((Control)jFXSpinner);
        this.control = jFXSpinner;
        this.blueColor = Color.valueOf((String)"#4285f4");
        this.redColor = Color.valueOf((String)"#db4437");
        this.yellowColor = Color.valueOf((String)"#f4b400");
        this.greenColor = Color.valueOf((String)"#0F9D58");
        this.arc = new Arc();
        this.arc.setManaged(false);
        this.arc.setStartAngle(0.0);
        this.arc.setLength(180.0);
        this.arc.getStyleClass().setAll((Object[])new String[]{"arc"});
        this.arc.setFill((Paint)Color.TRANSPARENT);
        this.arc.setStrokeWidth(3.0);
        this.track = new Arc();
        this.track.setManaged(false);
        this.track.setStartAngle(0.0);
        this.track.setLength(360.0);
        this.track.setStrokeWidth(3.0);
        this.track.getStyleClass().setAll((Object[])new String[]{"track"});
        this.track.setFill((Paint)Color.TRANSPARENT);
        this.fillRect = new Rectangle();
        this.fillRect.setFill((Paint)Color.TRANSPARENT);
        this.text = new Text();
        this.text.getStyleClass().setAll((Object[])new String[]{"text", "percentage"});
        Group group = new Group(new Node[]{this.fillRect, this.track, this.arc, this.text});
        group.setManaged(false);
        this.arcPane = new StackPane(new Node[]{group});
        this.arcPane.setPrefSize(50.0, 50.0);
        this.getChildren().setAll((Object[])new Node[]{this.arcPane});
        this.registerChangeListener((ObservableValue)jFXSpinner.indeterminateProperty(), observableValue -> this.initialize());
        this.registerChangeListener((ObservableValue)jFXSpinner.progressProperty(), observableValue -> this.updateProgress());
        this.registerChangeListener((ObservableValue)jFXSpinner.visibleProperty(), observableValue -> this.updateAnimation());
        this.registerChangeListener((ObservableValue)jFXSpinner.parentProperty(), observableValue -> this.updateAnimation());
        this.registerChangeListener((ObservableValue)jFXSpinner.sceneProperty(), observableValue -> this.updateAnimation());
    }

    private void initialize() {
        if (((JFXSpinner)this.getSkinnable()).isIndeterminate()) {
            if (this.timeline == null) {
                this.createTransition();
                if (NodeHelper.isTreeShowing((Node)this.getSkinnable())) {
                    this.timeline.play();
                }
            }
        } else {
            this.clearAnimation();
            this.arc.setStartAngle(90.0);
            this.updateProgress();
        }
    }

    private KeyFrame[] getKeyFrames(double d2, double d3, Paint paint) {
        KeyFrame[] keyFrameArray = new KeyFrame[]{new KeyFrame(Duration.seconds((double)d3), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)5, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(d2 + 45.0 + this.control.getStartingAngle()), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(d3 + 0.4)), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)250, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(d2 + 90.0 + this.control.getStartingAngle()), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(d3 + 0.7)), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)250, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(d2 + 135.0 + this.control.getStartingAngle()), Interpolator.LINEAR)}), new KeyFrame(Duration.seconds((double)(d3 + 1.1)), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)5, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(d2 + 435.0 + this.control.getStartingAngle()), Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.strokeProperty(), (Object)paint, Interpolator.EASE_BOTH)})};
        return keyFrameArray;
    }

    private void pauseTimeline(boolean bl2) {
        if (((JFXSpinner)this.getSkinnable()).isIndeterminate()) {
            if (this.timeline == null) {
                this.createTransition();
            }
            if (bl2) {
                this.timeline.pause();
            } else {
                this.timeline.play();
            }
        }
    }

    private void updateAnimation() {
        boolean bl2;
        ProgressIndicator progressIndicator = (ProgressIndicator)this.getSkinnable();
        boolean bl3 = bl2 = progressIndicator.isVisible() && progressIndicator.getParent() != null && progressIndicator.getScene() != null;
        if (this.timeline != null) {
            this.pauseTimeline(!bl2);
        } else if (bl2) {
            this.createTransition();
        }
    }

    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        if (-1.0 == this.control.getRadius()) {
            return super.computeMaxHeight(d2, d3, d4, d5, d6);
        }
        return this.control.getRadius() * 2.0 + this.arc.getStrokeWidth() * 2.0;
    }

    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        if (-1.0 == this.control.getRadius()) {
            return super.computeMaxHeight(d2, d3, d4, d5, d6);
        }
        return this.control.getRadius() * 2.0 + this.arc.getStrokeWidth() * 2.0;
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return this.arcPane.prefWidth(-1.0);
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return this.arcPane.prefHeight(-1.0);
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6 = this.arc.getStrokeWidth();
        double d7 = Math.min(d4, d5) / 2.0 - d6 / 2.0;
        double d8 = this.snapSize(d7 * 2.0 + d6);
        this.arcPane.resizeRelocate((d4 - d8) / 2.0 + 1.0, (d5 - d8) / 2.0 + 1.0, d8, d8);
        this.updateArcLayout(d7, d8);
        this.fillRect.setWidth(d8);
        this.fillRect.setHeight(d8);
        if (!this.isValid) {
            this.initialize();
            this.isValid = true;
        }
        if (!((JFXSpinner)this.getSkinnable()).isIndeterminate()) {
            this.arc.setLength(this.arcLength);
            if (this.text.isVisible()) {
                double d9 = this.control.getProgress();
                int n2 = (int)Math.round(d9 * 100.0);
                Font font = this.text.getFont();
                this.text.setFont(Font.font((String)font.getFamily(), (double)(d7 / 1.7)));
                this.text.setText((d9 > 1.0 ? 100 : n2) + "%");
                this.text.relocate((d8 - this.text.getLayoutBounds().getWidth()) / 2.0, (d8 - this.text.getLayoutBounds().getHeight()) / 2.0);
            }
        }
    }

    private void updateArcLayout(double d2, double d3) {
        this.arc.setRadiusX(d2);
        this.arc.setRadiusY(d2);
        this.arc.setCenterX(d3 / 2.0);
        this.arc.setCenterY(d3 / 2.0);
        this.track.setRadiusX(d2);
        this.track.setRadiusY(d2);
        this.track.setCenterX(d3 / 2.0);
        this.track.setCenterY(d3 / 2.0);
        this.track.setStrokeWidth(this.arc.getStrokeWidth());
    }

    protected void updateProgress() {
        ProgressIndicator progressIndicator = (ProgressIndicator)this.getSkinnable();
        boolean bl2 = progressIndicator.isIndeterminate();
        if (!bl2 || !this.wasIndeterminate) {
            this.arcLength = -360.0 * progressIndicator.getProgress();
            progressIndicator.requestLayout();
        }
        this.wasIndeterminate = bl2;
    }

    private void createTransition() {
        if (!((JFXSpinner)this.getSkinnable()).isIndeterminate()) {
            return;
        }
        Paint paint = this.arc.getStroke();
        if (paint == null) {
            this.arc.setStroke((Paint)this.blueColor);
        }
        KeyFrame[] keyFrameArray = this.getKeyFrames(0.0, 0.0, (Paint)(paint == null ? this.blueColor : paint));
        KeyFrame[] keyFrameArray2 = this.getKeyFrames(450.0, 1.4, (Paint)(paint == null ? this.redColor : paint));
        KeyFrame[] keyFrameArray3 = this.getKeyFrames(900.0, 2.8, (Paint)(paint == null ? this.yellowColor : paint));
        KeyFrame[] keyFrameArray4 = this.getKeyFrames(1350.0, 4.2, (Paint)(paint == null ? this.greenColor : paint));
        KeyFrame keyFrame = new KeyFrame(Duration.seconds((double)5.6), new KeyValue[]{new KeyValue((WritableValue)this.arc.lengthProperty(), (Object)5, Interpolator.LINEAR), new KeyValue((WritableValue)this.arc.startAngleProperty(), (Object)(1845.0 + this.control.getStartingAngle()), Interpolator.LINEAR)});
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline.getKeyFrames().clear();
        }
        this.timeline = new Timeline(new KeyFrame[]{keyFrameArray[0], keyFrameArray[1], keyFrameArray[2], keyFrameArray[3], keyFrameArray2[0], keyFrameArray2[1], keyFrameArray2[2], keyFrameArray2[3], keyFrameArray3[0], keyFrameArray3[1], keyFrameArray3[2], keyFrameArray3[3], keyFrameArray4[0], keyFrameArray4[1], keyFrameArray4[2], keyFrameArray4[3], keyFrame});
        this.timeline.setCycleCount(-1);
        this.timeline.setDelay(Duration.ZERO);
        this.timeline.playFromStart();
    }

    private void clearAnimation() {
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline.getKeyFrames().clear();
            this.timeline = null;
        }
    }

    public void dispose() {
        super.dispose();
        this.clearAnimation();
        this.arc = null;
        this.track = null;
        this.control = null;
    }
}

