/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXSlider;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.geometry.Orientation;
import javafx.scene.control.Slider;
import javafx.scene.control.skin.SliderSkin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class JFXSliderSkin
extends SliderSkin {
    private final Pane mouseHandlerPane = new Pane();
    private static final PseudoClass MIN_VALUE = PseudoClass.getPseudoClass((String)"min");
    private static final PseudoClass MAX_VALUE = PseudoClass.getPseudoClass((String)"max");
    private Text sliderValue;
    private StackPane coloredTrack;
    private StackPane thumb;
    private StackPane track = (StackPane)((Slider)this.getSkinnable()).lookup(".track");
    private StackPane animatedThumb;
    private Timeline timeline;
    private double indicatorRotation;
    private double horizontalRotation;
    private double shifting;
    private boolean isValid = false;

    public JFXSliderSkin(JFXSlider jFXSlider) {
        super((Slider)jFXSlider);
        this.thumb = (StackPane)((Slider)this.getSkinnable()).lookup(".thumb");
        this.coloredTrack = new StackPane();
        this.coloredTrack.getStyleClass().add((Object)"colored-track");
        this.coloredTrack.setMouseTransparent(true);
        this.sliderValue = new Text();
        this.sliderValue.getStyleClass().setAll((Object[])new String[]{"slider-value"});
        this.animatedThumb = new StackPane();
        this.animatedThumb.getStyleClass().add((Object)"animated-thumb");
        this.animatedThumb.getChildren().add((Object)this.sliderValue);
        this.animatedThumb.setMouseTransparent(true);
        this.animatedThumb.setScaleX(0.0);
        this.animatedThumb.setScaleY(0.0);
        this.getChildren().add(this.getChildren().indexOf((Object)this.thumb), (Object)this.coloredTrack);
        this.getChildren().add(this.getChildren().indexOf((Object)this.thumb), (Object)this.animatedThumb);
        this.getChildren().add(0, (Object)this.mouseHandlerPane);
        this.registerChangeListener((ObservableValue)jFXSlider.valueFactoryProperty(), observableValue -> this.refreshSliderValueBinding());
        this.initListeners();
    }

    private void refreshSliderValueBinding() {
        this.sliderValue.textProperty().unbind();
        if (((JFXSlider)this.getSkinnable()).getValueFactory() != null) {
            this.sliderValue.textProperty().bind((ObservableValue)((JFXSlider)this.getSkinnable()).getValueFactory().call((Object)((JFXSlider)this.getSkinnable())));
        } else {
            this.sliderValue.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (((Slider)this.getSkinnable()).getLabelFormatter() != null) {
                    return ((Slider)this.getSkinnable()).getLabelFormatter().toString((Object)((Slider)this.getSkinnable()).getValue());
                }
                return String.valueOf(Math.round(((Slider)this.getSkinnable()).getValue()));
            }, (Observable[])new Observable[]{((Slider)this.getSkinnable()).valueProperty()}));
        }
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        double d8;
        double d9;
        boolean bl2;
        super.layoutChildren(d2, d3, d4, d5);
        if (!this.isValid) {
            this.initializeVariables();
            this.initAnimation(((Slider)this.getSkinnable()).getOrientation());
            this.isValid = true;
        }
        double d10 = this.animatedThumb.prefWidth(-1.0);
        this.animatedThumb.resize(d10, this.animatedThumb.prefHeight(d10));
        boolean bl3 = bl2 = ((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
        if (bl2) {
            d9 = this.thumb.getLayoutX() - this.snappedLeftInset();
            d8 = this.track.getHeight();
            d7 = this.track.getLayoutX();
            d6 = this.track.getLayoutY();
            this.animatedThumb.setLayoutX(this.thumb.getLayoutX() + this.thumb.getWidth() / 2.0 - this.animatedThumb.getWidth() / 2.0);
        } else {
            d8 = this.track.getLayoutBounds().getMaxY() + this.track.getLayoutY() - this.thumb.getLayoutY() - this.snappedBottomInset();
            d9 = this.track.getWidth();
            d7 = this.track.getLayoutX();
            d6 = this.thumb.getLayoutY();
            this.animatedThumb.setLayoutY(this.thumb.getLayoutY() + this.thumb.getHeight() / 2.0 - this.animatedThumb.getHeight() / 2.0);
        }
        this.coloredTrack.resizeRelocate(d7, d6, d9, d8);
        this.mouseHandlerPane.resizeRelocate(d2, d3, d4, d5);
    }

    private void initializeVariables() {
        this.shifting = 30.0 + this.thumb.getWidth();
        if (((Slider)this.getSkinnable()).getOrientation() != Orientation.HORIZONTAL) {
            this.horizontalRotation = -90.0;
        }
        if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() != JFXSlider.IndicatorPosition.LEFT) {
            this.indicatorRotation = 180.0;
            this.shifting = -this.shifting;
        }
        double d2 = 45.0;
        this.sliderValue.setRotate(45.0 + this.indicatorRotation + 3.0 * this.horizontalRotation);
        this.animatedThumb.setRotate(-45.0 + this.indicatorRotation + this.horizontalRotation);
    }

    private void initListeners() {
        this.mouseHandlerPane.setOnMousePressed(this::delegateToTrack);
        this.mouseHandlerPane.setOnMouseReleased(this::delegateToTrack);
        this.mouseHandlerPane.setOnMouseDragged(this::delegateToTrack);
        this.track.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            this.timeline.setRate(1.0);
            this.timeline.play();
        });
        this.track.addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            this.timeline.setRate(-1.0);
            this.timeline.play();
        });
        this.thumb.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            this.timeline.setRate(1.0);
            this.timeline.play();
        });
        this.thumb.addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            this.timeline.setRate(-1.0);
            this.timeline.play();
        });
        this.refreshSliderValueBinding();
        this.updateValueStyleClass();
        ((Slider)this.getSkinnable()).valueProperty().addListener(observable -> this.updateValueStyleClass());
        ((Slider)this.getSkinnable()).orientationProperty().addListener(observable -> this.initAnimation(((Slider)this.getSkinnable()).getOrientation()));
    }

    private void delegateToTrack(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            mouseEvent.consume();
            this.track.fireEvent((Event)mouseEvent);
        }
    }

    private void updateValueStyleClass() {
        ((Slider)this.getSkinnable()).pseudoClassStateChanged(MIN_VALUE, ((Slider)this.getSkinnable()).getMin() == ((Slider)this.getSkinnable()).getValue());
        ((Slider)this.getSkinnable()).pseudoClassStateChanged(MAX_VALUE, ((Slider)this.getSkinnable()).getMax() == ((Slider)this.getSkinnable()).getValue());
    }

    private void initAnimation(Orientation orientation) {
        DoubleProperty doubleProperty;
        double d2;
        double d3;
        if (orientation == Orientation.HORIZONTAL) {
            if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() == JFXSlider.IndicatorPosition.RIGHT) {
                d3 = this.thumb.getLayoutY() - this.thumb.getHeight();
                d2 = d3 - this.shifting;
            } else {
                double d4 = this.animatedThumb.prefHeight(this.animatedThumb.prefWidth(-1.0));
                d3 = this.thumb.getLayoutY() - d4 / 2.0;
                d2 = this.thumb.getLayoutY() - d4 - this.thumb.getHeight();
            }
            doubleProperty = this.animatedThumb.translateYProperty();
        } else {
            if (((JFXSlider)this.getSkinnable()).getIndicatorPosition() == JFXSlider.IndicatorPosition.RIGHT) {
                d3 = this.thumb.getLayoutX() - this.thumb.getWidth();
                d2 = d3 - this.shifting;
            } else {
                double d5 = this.animatedThumb.prefWidth(-1.0);
                d3 = this.thumb.getLayoutX() - d5 / 2.0;
                d2 = this.thumb.getLayoutX() - d5 - this.thumb.getWidth();
            }
            doubleProperty = this.animatedThumb.translateXProperty();
        }
        this.clearAnimation();
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.animatedThumb.scaleXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.scaleYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)doubleProperty, (Object)d3, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.2), new KeyValue[]{new KeyValue((WritableValue)this.animatedThumb.scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.animatedThumb.scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)doubleProperty, (Object)d2, Interpolator.EASE_BOTH)})});
    }

    public void dispose() {
        super.dispose();
        this.clearAnimation();
    }

    private void clearAnimation() {
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline.getKeyFrames().clear();
            this.timeline = null;
        }
    }
}

