/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXListCell;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.svg.SVGGlyph;
import com.jfoenix.transitions.CachedTransition;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.animation.TranslateTransition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.DateCell;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.Duration;

public class JFXDatePickerContent
extends VBox {
    private static final String SPINNER_LABEL = "spinner-label";
    private static final String ROBOTO = "Roboto";
    private static final Color DEFAULT_CELL_COLOR = Color.valueOf((String)"#9C9C9C");
    private static final Color DEFAULT_COLOR = Color.valueOf((String)"#313131");
    private static final PseudoClass selectedYear = PseudoClass.getPseudoClass((String)"selected-year");
    protected JFXDatePicker datePicker;
    private JFXButton backMonthButton;
    private JFXButton forwardMonthButton;
    private ObjectProperty<JFXListCell> selectedYearCell = new SimpleObjectProperty(null);
    private Label selectedDateLabel;
    private Label selectedYearLabel;
    private Label monthYearLabel;
    protected GridPane contentGrid;
    private StackPane calendarPlaceHolder = new StackPane();
    private CachedTransition showTransition;
    private CachedTransition hideTransition;
    private ParallelTransition tempImageTransition;
    private int daysPerWeek = 7;
    private List<DateCell> weekDaysCells = new ArrayList<DateCell>();
    private List<DateCell> weekNumberCells = new ArrayList<DateCell>();
    protected List<DateCell> dayCells = new ArrayList<DateCell>();
    private LocalDate[] dayCellDates;
    private DateCell currentFocusedDayCell = null;
    private ListView<String> yearsListView = new JFXListView<String>(){
        {
            this.getStyleClass().setAll((Object[])new String[]{"date-picker-list-view"});
            this.setCellFactory(listView -> new JFXListCell<String>(){
                boolean mousePressed = false;
                {
                    this.getStyleClass().setAll((Object[])new String[]{"data-picker-list-cell"});
                    this.setOnMousePressed(mouseEvent -> {
                        this.mousePressed = true;
                    });
                    this.setOnMouseReleased(mouseEvent -> {
                        this.mousePressed = false;
                    });
                    this.setOnMouseClicked(mouseEvent -> {
                        String string = (String)JFXDatePickerContent.this.yearsListView.getSelectionModel().getSelectedItem();
                        if (string != null && string.equals(this.getText())) {
                            int n2 = Integer.parseInt(this.getText()) - Integer.parseInt(JFXDatePickerContent.this.selectedYearLabel.getText());
                            JFXDatePickerContent.this.forward(n2, ChronoUnit.YEARS, false, false);
                            JFXDatePickerContent.this.hideTransition.setOnFinished(actionEvent -> {
                                JFXDatePickerContent.this.selectedYearCell.set((Object)this);
                                this.pseudoClassStateChanged(selectedYear, true);
                                this.setTextFill(JFXDatePickerContent.this.datePicker.getDefaultColor());
                                JFXDatePickerContent.this.yearsListView.scrollTo(this.getIndex() - 2 >= 0 ? this.getIndex() - 2 : this.getIndex());
                                JFXDatePickerContent.this.hideTransition.setOnFinished(null);
                            });
                            JFXDatePickerContent.this.hideTransition.play();
                        }
                    });
                    JFXDatePickerContent.this.selectedYearLabel.textProperty().addListener((observableValue, string, string2) -> {
                        if (!JFXDatePickerContent.this.yearsListView.isVisible() && string2.equals(this.getText())) {
                            JFXDatePickerContent.this.selectedYearCell.set((Object)this);
                        }
                    });
                }

                @Override
                public void updateItem(String string, boolean bl2) {
                    super.updateItem(string, bl2);
                    if (!bl2) {
                        boolean bl3 = string.equals(JFXDatePickerContent.this.selectedYearLabel.getText());
                        if (bl3) {
                            JFXDatePickerContent.this.selectedYearCell.set((Object)this);
                        }
                        this.pseudoClassStateChanged(selectedYear, bl3);
                        this.setTextFill((Paint)(bl3 ? JFXDatePickerContent.this.datePicker.getDefaultColor() : DEFAULT_COLOR));
                    } else {
                        this.pseudoClassStateChanged(selectedYear, false);
                        this.setTextFill((Paint)DEFAULT_COLOR);
                    }
                }
            });
        }
    };
    final DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("MMMM");
    final DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("y");
    final DateTimeFormatter weekNumberFormatter = DateTimeFormatter.ofPattern("w");
    final DateTimeFormatter weekDayNameFormatter = DateTimeFormatter.ofPattern("ccc");
    final DateTimeFormatter dayCellFormatter = DateTimeFormatter.ofPattern("d");
    private ObjectProperty<YearMonth> selectedYearMonth = new SimpleObjectProperty((Object)this, "selectedYearMonth");

    JFXDatePickerContent(final JFXDatePicker jFXDatePicker) {
        this.datePicker = jFXDatePicker;
        this.getStyleClass().add((Object)"date-picker-popup");
        LocalDate localDate = (LocalDate)jFXDatePicker.getValue();
        this.selectedYearMonth.set((Object)(localDate != null ? YearMonth.from(localDate) : YearMonth.now()));
        this.selectedYearMonth.addListener((observableValue, yearMonth, yearMonth2) -> this.updateValues());
        this.selectedYearCell.addListener((observableValue, jFXListCell, jFXListCell2) -> {
            if (jFXListCell != null) {
                jFXListCell.pseudoClassStateChanged(selectedYear, false);
                jFXListCell.setTextFill((Paint)DEFAULT_COLOR);
            }
            if (jFXListCell2 != null) {
                jFXListCell2.pseudoClassStateChanged(selectedYear, true);
                jFXListCell2.setTextFill(jFXDatePicker.getDefaultColor());
            }
        });
        this.getChildren().add((Object)this.createHeaderPane());
        this.contentGrid = new GridPane(){

            protected double computePrefWidth(double d2) {
                int n2 = JFXDatePickerContent.this.daysPerWeek + (jFXDatePicker.isShowWeekNumbers() ? 1 : 0);
                double d3 = this.snapSpace(this.getInsets().getLeft());
                double d4 = this.snapSpace(this.getInsets().getRight());
                double d5 = this.snapSpace(this.getHgap()) * (double)(n2 - 1);
                double d6 = super.computePrefWidth(d2) - d3 - d4 - d5;
                return this.snapSize(d6 / (double)n2) * (double)n2 + d3 + d4 + d5;
            }

            protected void layoutChildren() {
                if (this.getWidth() > 0.0 && this.getHeight() > 0.0) {
                    super.layoutChildren();
                }
            }
        };
        this.contentGrid.setFocusTraversable(true);
        this.contentGrid.getStyleClass().add((Object)"calendar-grid");
        this.contentGrid.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.contentGrid.setPadding(new Insets(0.0, 12.0, 12.0, 12.0));
        this.contentGrid.setVgap(0.0);
        this.contentGrid.setHgap(0.0);
        this.createWeekDaysCells();
        this.createDayCells();
        VBox vBox = new VBox();
        vBox.getChildren().setAll((Object[])new Node[]{this.createCalendarMonthLabelPane(), this.contentGrid});
        this.calendarPlaceHolder.getChildren().setAll((Object[])new Node[]{vBox, this.createCalendarArrowsPane()});
        Rectangle rectangle = new Rectangle();
        rectangle.widthProperty().bind((ObservableValue)this.calendarPlaceHolder.widthProperty());
        rectangle.heightProperty().bind((ObservableValue)this.calendarPlaceHolder.heightProperty());
        this.calendarPlaceHolder.setClip((Node)rectangle);
        for (int i2 = 0; i2 <= 200; ++i2) {
            this.yearsListView.getItems().add((Object)Integer.toString(1900 + i2));
        }
        this.yearsListView.setVisible(false);
        this.yearsListView.setOpacity(0.0);
        this.yearsListView.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        StackPane stackPane = new StackPane();
        this.yearsListView.maxWidthProperty().bind((ObservableValue)stackPane.widthProperty());
        this.yearsListView.maxHeightProperty().bind((ObservableValue)stackPane.heightProperty());
        stackPane.getChildren().setAll((Object[])new Node[]{this.calendarPlaceHolder, this.yearsListView});
        this.getChildren().add((Object)stackPane);
        this.refresh();
        this.scrollToYear();
        this.addEventHandler(KeyEvent.ANY, keyEvent -> {
            Node node = this.getScene().getFocusOwner();
            if (node instanceof DateCell) {
                this.currentFocusedDayCell = (DateCell)node;
            }
            switch (keyEvent.getCode()) {
                case HOME: {
                    this.init();
                    this.goToDate(LocalDate.now(), true);
                    keyEvent.consume();
                    break;
                }
                case PAGE_UP: {
                    if (!this.backMonthButton.isDisabled()) {
                        this.forward(-1, ChronoUnit.MONTHS, true, true);
                    }
                    keyEvent.consume();
                    break;
                }
                case PAGE_DOWN: {
                    if (!this.forwardMonthButton.isDisabled()) {
                        this.forward(1, ChronoUnit.MONTHS, true, true);
                    }
                    keyEvent.consume();
                    break;
                }
                case ESCAPE: {
                    jFXDatePicker.hide();
                    keyEvent.consume();
                    break;
                }
                case F4: 
                case F10: 
                case UP: 
                case DOWN: 
                case LEFT: 
                case RIGHT: 
                case TAB: {
                    break;
                }
                default: {
                    keyEvent.consume();
                }
            }
        });
        this.showTransition = new CachedTransition((Node)this.yearsListView, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.yearsListView.opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.calendarPlaceHolder.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)this.yearsListView.opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.calendarPlaceHolder.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.yearsListView.opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.calendarPlaceHolder.opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedYearLabel.textFillProperty(), (Object)Color.WHITE, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedDateLabel.textFillProperty(), (Object)Color.rgb((int)255, (int)255, (int)255, (double)0.67), Interpolator.EASE_BOTH)})})){
            {
                this.setCycleDuration(Duration.millis((double)320.0));
                this.setDelay(Duration.seconds((double)0.0));
            }

            @Override
            protected void starting() {
                super.starting();
                JFXDatePickerContent.this.yearsListView.setVisible(true);
            }
        };
        this.hideTransition = new CachedTransition((Node)this.yearsListView, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.yearsListView.opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.calendarPlaceHolder.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)this.yearsListView.opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.calendarPlaceHolder.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.yearsListView.opacityProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.calendarPlaceHolder.opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedDateLabel.textFillProperty(), (Object)Color.WHITE, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selectedYearLabel.textFillProperty(), (Object)Color.rgb((int)255, (int)255, (int)255, (double)0.67), Interpolator.EASE_BOTH)})})){
            {
                this.setCycleDuration(Duration.millis((double)320.0));
                this.setDelay(Duration.seconds((double)0.0));
            }

            @Override
            protected void stopping() {
                super.stopping();
                JFXDatePickerContent.this.yearsListView.setVisible(false);
            }
        };
    }

    private final void scrollToYear() {
        int n2 = Integer.parseInt(this.selectedYearLabel.getText()) - 1900 - 2;
        this.yearsListView.scrollTo(n2 >= 0 ? n2 : n2 + 2);
    }

    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/jfx-date-picker.css").toExternalForm();
    }

    ObjectProperty<YearMonth> displayedYearMonthProperty() {
        return this.selectedYearMonth;
    }

    private void createWeekDaysCells() {
        DateCell dateCell;
        int n2;
        for (n2 = 0; n2 < this.daysPerWeek; ++n2) {
            dateCell = new DateCell();
            dateCell.getStyleClass().add((Object)"day-name-cell");
            dateCell.setTextFill((Paint)DEFAULT_CELL_COLOR);
            dateCell.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            dateCell.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)12.0));
            dateCell.setAlignment(Pos.BASELINE_CENTER);
            this.weekDaysCells.add(dateCell);
        }
        for (n2 = 0; n2 < 6; ++n2) {
            dateCell = new DateCell();
            dateCell.getStyleClass().add((Object)"week-number-cell");
            dateCell.setTextFill((Paint)DEFAULT_CELL_COLOR);
            dateCell.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            dateCell.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)12.0));
            this.weekNumberCells.add(dateCell);
        }
    }

    protected VBox createHeaderPane() {
        this.selectedYearLabel = new Label();
        this.selectedYearLabel.getStyleClass().add((Object)SPINNER_LABEL);
        this.selectedYearLabel.setTextFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.67));
        this.selectedYearLabel.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)14.0));
        HBox hBox = new HBox();
        hBox.getStyleClass().add((Object)"spinner");
        hBox.getChildren().addAll((Object[])new Node[]{this.selectedYearLabel});
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.setFillHeight(false);
        hBox.setOnMouseClicked(mouseEvent -> {
            if (!this.yearsListView.isVisible()) {
                this.scrollToYear();
                this.hideTransition.stop();
                this.showTransition.play();
            }
        });
        this.selectedDateLabel = new Label();
        this.selectedDateLabel.getStyleClass().add((Object)SPINNER_LABEL);
        this.selectedDateLabel.setTextFill((Paint)Color.WHITE);
        this.selectedDateLabel.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)32.0));
        HBox hBox2 = new HBox(new Node[]{this.selectedDateLabel});
        hBox2.getStyleClass().add((Object)"spinner");
        hBox2.setAlignment(Pos.CENTER_LEFT);
        hBox2.setOnMouseClicked(mouseEvent -> {
            if (this.yearsListView.isVisible()) {
                this.showTransition.stop();
                this.hideTransition.play();
            }
        });
        VBox vBox = new VBox();
        vBox.getStyleClass().add((Object)"month-year-pane");
        vBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.datePicker.getDefaultColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        vBox.setPadding(new Insets(12.0, 24.0, 12.0, 24.0));
        vBox.getChildren().add((Object)hBox);
        vBox.getChildren().add((Object)hBox2);
        return vBox;
    }

    protected BorderPane createCalendarArrowsPane() {
        SVGGlyph sVGGlyph = new SVGGlyph(0, "CHEVRON_LEFT", "M 742,-37 90,614 Q 53,651 53,704.5 53,758 90,795 l 652,651 q 37,37 90.5,37 53.5,0 90.5,-37 l 75,-75 q 37,-37 37,-90.5 0,-53.5 -37,-90.5 L 512,704 998,219 q 37,-38 37,-91 0,-53 -37,-90 L 923,-37 Q 886,-74 832.5,-74 779,-74 742,-37 z", (Paint)Color.GRAY);
        SVGGlyph sVGGlyph2 = new SVGGlyph(0, "CHEVRON_RIGHT", "m 1099,704 q 0,-52 -37,-91 L 410,-38 q -37,-37 -90,-37 -53,0 -90,37 l -76,75 q -37,39 -37,91 0,53 37,90 l 486,486 -486,485 q -37,39 -37,91 0,53 37,90 l 76,75 q 36,38 90,38 54,0 90,-38 l 652,-651 q 37,-37 37,-90 z", (Paint)Color.GRAY);
        sVGGlyph.setFill((Paint)DEFAULT_COLOR);
        sVGGlyph.setSize(6.0, 11.0);
        sVGGlyph2.setFill((Paint)DEFAULT_COLOR);
        sVGGlyph2.setSize(6.0, 11.0);
        this.backMonthButton = new JFXButton();
        this.backMonthButton.setMinSize(40.0, 40.0);
        this.backMonthButton.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, new CornerRadii(40.0), Insets.EMPTY)}));
        this.backMonthButton.getStyleClass().add((Object)"left-button");
        this.backMonthButton.setGraphic((Node)sVGGlyph);
        this.backMonthButton.setRipplerFill(this.datePicker.getDefaultColor());
        this.backMonthButton.setOnAction(actionEvent -> this.forward(-1, ChronoUnit.MONTHS, false, true));
        this.forwardMonthButton = new JFXButton();
        this.forwardMonthButton.setMinSize(40.0, 40.0);
        this.forwardMonthButton.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, new CornerRadii(40.0), Insets.EMPTY)}));
        this.forwardMonthButton.getStyleClass().add((Object)"right-button");
        this.forwardMonthButton.setGraphic((Node)sVGGlyph2);
        this.forwardMonthButton.setRipplerFill(this.datePicker.getDefaultColor());
        this.forwardMonthButton.setOnAction(actionEvent -> this.forward(1, ChronoUnit.MONTHS, false, true));
        BorderPane borderPane = new BorderPane();
        borderPane.setLeft((Node)this.backMonthButton);
        borderPane.setRight((Node)this.forwardMonthButton);
        borderPane.setPadding(new Insets(4.0, 12.0, 2.0, 12.0));
        borderPane.setPickOnBounds(false);
        return borderPane;
    }

    protected BorderPane createCalendarMonthLabelPane() {
        this.monthYearLabel = new Label();
        this.monthYearLabel.getStyleClass().add((Object)SPINNER_LABEL);
        this.monthYearLabel.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)13.0));
        this.monthYearLabel.setTextFill((Paint)DEFAULT_COLOR);
        BorderPane borderPane = new BorderPane();
        borderPane.setMinHeight(50.0);
        borderPane.setCenter((Node)this.monthYearLabel);
        borderPane.setPadding(new Insets(2.0, 12.0, 2.0, 12.0));
        return borderPane;
    }

    void updateContentGrid() {
        int n2;
        this.contentGrid.getColumnConstraints().clear();
        this.contentGrid.getChildren().clear();
        int n3 = this.daysPerWeek + (this.datePicker.isShowWeekNumbers() ? 1 : 0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(100.0);
        for (n2 = 0; n2 < n3; ++n2) {
            this.contentGrid.getColumnConstraints().add((Object)columnConstraints);
        }
        for (n2 = 0; n2 < this.daysPerWeek; ++n2) {
            this.contentGrid.add((Node)this.weekDaysCells.get(n2), n2 + n3 - this.daysPerWeek, 1);
        }
        if (this.datePicker.isShowWeekNumbers()) {
            for (n2 = 0; n2 < 6; ++n2) {
                this.contentGrid.add((Node)this.weekNumberCells.get(n2), 0, n2 + 2);
            }
        }
        for (n2 = 0; n2 < 6; ++n2) {
            for (int i2 = 0; i2 < this.daysPerWeek; ++i2) {
                this.contentGrid.add((Node)this.dayCells.get(n2 * this.daysPerWeek + i2), i2 + n3 - this.daysPerWeek, n2 + 2);
            }
        }
    }

    private void refresh() {
        this.updateDayNameCells();
        this.updateValues();
    }

    private void updateDayNameCells() {
        int n2 = WeekFields.of(this.getLocale()).getFirstDayOfWeek().getValue();
        LocalDate localDate = LocalDate.of(2009, 7, 12 + n2);
        for (int i2 = 0; i2 < this.daysPerWeek; ++i2) {
            String string = this.weekDayNameFormatter.withLocale(this.getLocale()).format(localDate.plus(i2, ChronoUnit.DAYS));
            string = this.weekDayNameFormatter.getLocale() == Locale.CHINA ? string.substring(string.length() - 1).toUpperCase() : string.substring(0, 1).toUpperCase();
            this.weekDaysCells.get(i2).setText(string);
        }
    }

    void updateValues() {
        this.updateWeekNumberDateCells();
        this.updateDayCells();
        this.updateMonthYearPane();
    }

    void updateWeekNumberDateCells() {
        if (this.datePicker.isShowWeekNumbers()) {
            Locale locale = this.getLocale();
            LocalDate localDate = ((YearMonth)this.selectedYearMonth.get()).atDay(1);
            for (int i2 = 0; i2 < 6; ++i2) {
                LocalDate localDate2 = localDate.plus(i2, ChronoUnit.WEEKS);
                String string = this.weekNumberFormatter.withLocale(locale).withDecimalStyle(DecimalStyle.of(locale)).format(localDate2);
                this.weekNumberCells.get(i2).setText(string);
            }
        }
    }

    private void updateDayCells() {
        int n2;
        Locale locale = this.getLocale();
        Chronology chronology = this.getPrimaryChronology();
        int n3 = WeekFields.of(this.getLocale()).getFirstDayOfWeek().getValue();
        n2 += (n2 = ((YearMonth)this.selectedYearMonth.get()).atDay(1).getDayOfWeek().getValue() - n3) < 0 ? this.daysPerWeek : 0;
        YearMonth yearMonth = (YearMonth)this.selectedYearMonth.get();
        int n4 = -1;
        for (int i2 = 0; i2 < 6 * this.daysPerWeek; ++i2) {
            DateCell dateCell = this.dayCells.get(i2);
            dateCell.getStyleClass().setAll((Object[])new String[]{"cell", "date-cell", "day-cell"});
            dateCell.setPrefSize(40.0, 42.0);
            dateCell.setDisable(false);
            dateCell.setStyle(null);
            dateCell.setGraphic(null);
            dateCell.setTooltip(null);
            dateCell.setTextFill((Paint)DEFAULT_COLOR);
            dateCell.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            try {
                LocalDate localDate;
                if (n4 == -1) {
                    n4 = yearMonth.lengthOfMonth();
                }
                int n5 = i2 - n2 + 1;
                this.dayCellDates[i2] = localDate = yearMonth.atDay(n5);
                if (localDate.equals(LocalDate.now())) {
                    dateCell.setTextFill(this.datePicker.getDefaultColor());
                    dateCell.getStyleClass().add((Object)"today");
                }
                if (localDate.equals(this.datePicker.getValue())) {
                    dateCell.getStyleClass().add((Object)"selected");
                    dateCell.setTextFill((Paint)Color.WHITE);
                    dateCell.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.datePicker.getDefaultColor(), new CornerRadii(40.0), Insets.EMPTY)}));
                }
                ChronoLocalDate chronoLocalDate = chronology.date(localDate);
                String string = this.dayCellFormatter.withLocale(locale).withChronology(chronology).withDecimalStyle(DecimalStyle.of(locale)).format(chronoLocalDate);
                dateCell.setText(string);
                if (i2 < n2) {
                    dateCell.getStyleClass().add((Object)"previous-month");
                    dateCell.setText("");
                } else if (i2 >= n2 + n4) {
                    dateCell.getStyleClass().add((Object)"next-month");
                    dateCell.setText("");
                }
                dateCell.updateItem(localDate, false);
                continue;
            }
            catch (DateTimeException dateTimeException) {
                dateCell.setText("");
                dateCell.setDisable(true);
            }
        }
    }

    protected void updateMonthYearPane() {
        YearMonth yearMonth = (YearMonth)this.selectedYearMonth.get();
        LocalDate localDate = (LocalDate)this.datePicker.getValue();
        localDate = localDate == null ? LocalDate.now() : localDate;
        this.selectedDateLabel.setText(DateTimeFormatter.ofPattern("EEE, MMM dd").format(localDate));
        this.selectedYearLabel.setText(this.formatYear(yearMonth));
        this.monthYearLabel.setText(this.formatMonth(yearMonth) + " " + this.formatYear(yearMonth));
        Chronology chronology = this.datePicker.getChronology();
        LocalDate localDate2 = yearMonth.atDay(1);
        this.backMonthButton.setDisable(!this.isValidDate(chronology, localDate2, -1, ChronoUnit.DAYS));
        this.forwardMonthButton.setDisable(!this.isValidDate(chronology, localDate2, 1, ChronoUnit.MONTHS));
    }

    private String formatMonth(YearMonth yearMonth) {
        try {
            Chronology chronology = this.getPrimaryChronology();
            ChronoLocalDate chronoLocalDate = chronology.date(yearMonth.atDay(1));
            return this.monthFormatter.withLocale(this.getLocale()).withChronology(chronology).format(chronoLocalDate);
        }
        catch (DateTimeException dateTimeException) {
            return "";
        }
    }

    private String formatYear(YearMonth yearMonth) {
        try {
            Chronology chronology = this.getPrimaryChronology();
            ChronoLocalDate chronoLocalDate = chronology.date(yearMonth.atDay(1));
            return this.yearFormatter.withLocale(this.getLocale()).withChronology(chronology).withDecimalStyle(DecimalStyle.of(this.getLocale())).format(chronoLocalDate);
        }
        catch (DateTimeException dateTimeException) {
            return "";
        }
    }

    protected LocalDate dayCellDate(DateCell dateCell) {
        assert (this.dayCellDates != null);
        return this.dayCellDates[this.dayCells.indexOf(dateCell)];
    }

    protected void forward(int n2, ChronoUnit chronoUnit, boolean bl2, boolean bl3) {
        DateCell dateCell;
        YearMonth yearMonth;
        if (bl3 && (this.tempImageTransition == null || this.tempImageTransition.getStatus() == Animation.Status.STOPPED)) {
            yearMonth = (Pane)this.calendarPlaceHolder.getChildren().get(0);
            this.getParent().setManaged(false);
            dateCell = new SnapshotParameters();
            dateCell.setFill((Paint)Color.TRANSPARENT);
            WritableImage writableImage = yearMonth.snapshot((SnapshotParameters)dateCell, new WritableImage((int)yearMonth.getWidth(), (int)yearMonth.getHeight()));
            ImageView imageView = new ImageView((Image)writableImage);
            this.calendarPlaceHolder.getChildren().add(this.calendarPlaceHolder.getChildren().size() - 2, (Object)imageView);
            TranslateTransition translateTransition = new TranslateTransition(Duration.millis((double)160.0), (Node)imageView);
            translateTransition.setToX((double)(-n2) * this.calendarPlaceHolder.getWidth());
            translateTransition.setOnFinished(actionEvent -> this.calendarPlaceHolder.getChildren().remove((Object)imageView));
            yearMonth.setTranslateX((double)n2 * this.calendarPlaceHolder.getWidth());
            TranslateTransition translateTransition2 = new TranslateTransition(Duration.millis((double)160.0), (Node)yearMonth);
            translateTransition2.setToX(0.0);
            this.tempImageTransition = new ParallelTransition(new Animation[]{translateTransition, translateTransition2});
            this.tempImageTransition.setOnFinished(actionEvent -> {
                this.calendarPlaceHolder.getChildren().remove((Object)imageView);
                this.getParent().setManaged(true);
            });
            this.tempImageTransition.play();
        }
        yearMonth = (YearMonth)this.selectedYearMonth.get();
        dateCell = this.currentFocusedDayCell;
        if (dateCell == null || this.dayCellDate(dateCell).getMonth() != yearMonth.getMonth()) {
            dateCell = this.findDayCellOfDate(yearMonth.atDay(1));
        }
        this.goToDayCell(dateCell, n2, chronoUnit, bl2);
    }

    private void goToDayCell(DateCell dateCell, int n2, ChronoUnit chronoUnit, boolean bl2) {
        YearMonth yearMonth = ((YearMonth)this.selectedYearMonth.get()).plus(n2, chronoUnit);
        this.goToDate(this.dayCellDate(dateCell).plus(n2, chronoUnit).withYear(yearMonth.getYear()), bl2);
    }

    private void goToDate(LocalDate localDate, boolean bl2) {
        if (this.isValidDate(this.datePicker.getChronology(), localDate)) {
            this.selectedYearMonth.set((Object)YearMonth.from(localDate));
            if (bl2) {
                this.findDayCellOfDate(localDate).requestFocus();
            }
        }
    }

    private void selectDayCell(DateCell dateCell) {
        this.datePicker.setValue(this.dayCellDate(dateCell));
        this.datePicker.hide();
    }

    private DateCell findDayCellOfDate(LocalDate localDate) {
        for (int i2 = 0; i2 < this.dayCellDates.length; ++i2) {
            if (!localDate.equals(this.dayCellDates[i2])) continue;
            return this.dayCells.get(i2);
        }
        return this.dayCells.get(this.dayCells.size() / 2 + 1);
    }

    void init() {
        this.calendarPlaceHolder.setOpacity(1.0);
        this.selectedDateLabel.setTextFill((Paint)Color.WHITE);
        this.selectedYearLabel.setTextFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.67));
        this.yearsListView.setOpacity(0.0);
        this.yearsListView.setVisible(false);
    }

    void clearFocus() {
        LocalDate localDate = (LocalDate)this.datePicker.getValue();
        if (localDate == null) {
            localDate = LocalDate.now();
        }
        if (YearMonth.from(localDate).equals(this.selectedYearMonth.get())) {
            this.goToDate(localDate, true);
        }
    }

    protected void createDayCells() {
        for (int i2 = 0; i2 < 6; ++i2) {
            for (int i3 = 0; i3 < this.daysPerWeek; ++i3) {
                DateCell dateCell = this.createDayCell();
                dateCell.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                    if (mouseEvent.getButton() != MouseButton.PRIMARY) {
                        return;
                    }
                    DateCell dateCell = (DateCell)mouseEvent.getSource();
                    this.selectDayCell(dateCell);
                    this.currentFocusedDayCell = dateCell;
                });
                dateCell.setOnMouseEntered(mouseEvent -> {
                    if (!dateCell.getStyleClass().contains((Object)"selected")) {
                        dateCell.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.valueOf((String)"#EDEDED"), new CornerRadii(40.0), Insets.EMPTY)}));
                    }
                });
                dateCell.setOnMouseExited(mouseEvent -> {
                    if (!dateCell.getStyleClass().contains((Object)"selected")) {
                        dateCell.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
                    }
                });
                dateCell.setAlignment(Pos.BASELINE_CENTER);
                dateCell.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.TRANSPARENT, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(5.0))}));
                dateCell.setFont(Font.font((String)ROBOTO, (FontWeight)FontWeight.BOLD, (double)12.0));
                this.dayCells.add(dateCell);
            }
        }
        this.dayCellDates = new LocalDate[6 * this.daysPerWeek];
        this.updateContentGrid();
    }

    private DateCell createDayCell() {
        DateCell dateCell = null;
        if (this.datePicker.getDayCellFactory() != null) {
            dateCell = (DateCell)this.datePicker.getDayCellFactory().call((Object)this.datePicker);
        }
        if (dateCell == null) {
            dateCell = new DateCell();
        }
        return dateCell;
    }

    protected Chronology getPrimaryChronology() {
        return this.datePicker.getChronology();
    }

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    protected boolean isValidDate(Chronology chronology, LocalDate localDate, int n2, ChronoUnit chronoUnit) {
        return localDate != null && this.isValidDate(chronology, localDate.plus(n2, chronoUnit));
    }

    protected boolean isValidDate(Chronology chronology, LocalDate localDate) {
        try {
            if (localDate != null) {
                chronology.date(localDate);
            }
            return true;
        }
        catch (DateTimeException dateTimeException) {
            return false;
        }
    }
}

