/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXColorPicker;
import com.jfoenix.skins.JFXCustomColorPickerDialog;
import com.jfoenix.utils.JFXNodeUtils;
import java.util.Iterator;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

class JFXColorPalette
extends Region {
    private static final int SQUARE_SIZE = 15;
    JFXColorGrid colorPickerGrid;
    final JFXButton customColorLink = new JFXButton("Custom Color");
    JFXCustomColorPickerDialog customColorDialog = null;
    private JFXColorPicker colorPicker;
    private final GridPane customColorGrid = new GridPane();
    private final Label customColorLabel = new Label("Recent Colors");
    private PopupControl popupControl;
    private ColorSquare focusedSquare;
    private Color mouseDragColor = null;
    private boolean dragDetected = false;
    private final ColorSquare hoverSquare = new ColorSquare();
    private static final int NUM_OF_COLUMNS = 10;
    private static double[] RAW_VALUES = new double[]{250.0, 250.0, 250.0, 245.0, 245.0, 245.0, 238.0, 238.0, 238.0, 224.0, 224.0, 224.0, 189.0, 189.0, 189.0, 158.0, 158.0, 158.0, 117.0, 117.0, 117.0, 97.0, 97.0, 97.0, 66.0, 66.0, 66.0, 33.0, 33.0, 33.0, 236.0, 239.0, 241.0, 207.0, 216.0, 220.0, 176.0, 190.0, 197.0, 144.0, 164.0, 174.0, 120.0, 144.0, 156.0, 96.0, 125.0, 139.0, 84.0, 110.0, 122.0, 69.0, 90.0, 100.0, 55.0, 71.0, 79.0, 38.0, 50.0, 56.0, 255.0, 235.0, 238.0, 255.0, 205.0, 210.0, 239.0, 154.0, 154.0, 229.0, 115.0, 115.0, 239.0, 83.0, 80.0, 244.0, 67.0, 54.0, 229.0, 57.0, 53.0, 211.0, 47.0, 47.0, 198.0, 40.0, 40.0, 183.0, 28.0, 28.0, 252.0, 228.0, 236.0, 248.0, 187.0, 208.0, 244.0, 143.0, 177.0, 240.0, 98.0, 146.0, 236.0, 64.0, 122.0, 233.0, 30.0, 99.0, 216.0, 27.0, 96.0, 194.0, 24.0, 91.0, 173.0, 20.0, 87.0, 136.0, 14.0, 79.0, 243.0, 229.0, 245.0, 225.0, 190.0, 231.0, 206.0, 147.0, 216.0, 186.0, 104.0, 200.0, 171.0, 71.0, 188.0, 156.0, 39.0, 176.0, 142.0, 36.0, 170.0, 123.0, 31.0, 162.0, 106.0, 27.0, 154.0, 74.0, 20.0, 140.0, 237.0, 231.0, 246.0, 209.0, 196.0, 233.0, 179.0, 157.0, 219.0, 149.0, 117.0, 205.0, 126.0, 87.0, 194.0, 103.0, 58.0, 183.0, 94.0, 53.0, 177.0, 81.0, 45.0, 168.0, 69.0, 39.0, 160.0, 49.0, 27.0, 146.0, 232.0, 234.0, 246.0, 197.0, 202.0, 233.0, 159.0, 168.0, 218.0, 121.0, 134.0, 203.0, 92.0, 107.0, 192.0, 63.0, 81.0, 181.0, 57.0, 73.0, 171.0, 48.0, 63.0, 159.0, 40.0, 53.0, 147.0, 26.0, 35.0, 126.0, 227.0, 242.0, 253.0, 187.0, 222.0, 251.0, 144.0, 202.0, 249.0, 100.0, 181.0, 246.0, 66.0, 165.0, 245.0, 33.0, 150.0, 243.0, 30.0, 136.0, 229.0, 25.0, 118.0, 210.0, 21.0, 101.0, 192.0, 13.0, 71.0, 161.0, 225.0, 245.0, 254.0, 179.0, 229.0, 252.0, 129.0, 212.0, 250.0, 79.0, 195.0, 247.0, 41.0, 182.0, 246.0, 3.0, 169.0, 244.0, 3.0, 155.0, 229.0, 2.0, 136.0, 209.0, 2.0, 119.0, 189.0, 1.0, 87.0, 155.0, 224.0, 247.0, 250.0, 178.0, 235.0, 242.0, 128.0, 222.0, 234.0, 77.0, 208.0, 225.0, 38.0, 198.0, 218.0, 0.0, 188.0, 212.0, 0.0, 172.0, 193.0, 0.0, 151.0, 167.0, 0.0, 131.0, 143.0, 0.0, 96.0, 100.0, 224.0, 242.0, 241.0, 178.0, 223.0, 219.0, 128.0, 203.0, 196.0, 77.0, 182.0, 172.0, 38.0, 166.0, 154.0, 0.0, 150.0, 136.0, 0.0, 137.0, 123.0, 0.0, 121.0, 107.0, 0.0, 105.0, 92.0, 0.0, 77.0, 64.0, 232.0, 245.0, 233.0, 200.0, 230.0, 201.0, 165.0, 214.0, 167.0, 129.0, 199.0, 132.0, 102.0, 187.0, 106.0, 76.0, 175.0, 80.0, 67.0, 160.0, 71.0, 56.0, 142.0, 60.0, 46.0, 125.0, 50.0, 27.0, 94.0, 32.0, 241.0, 248.0, 233.0, 220.0, 237.0, 200.0, 197.0, 225.0, 165.0, 174.0, 213.0, 129.0, 156.0, 204.0, 101.0, 139.0, 195.0, 74.0, 124.0, 179.0, 66.0, 104.0, 159.0, 56.0, 85.0, 139.0, 47.0, 51.0, 105.0, 30.0, 249.0, 251.0, 231.0, 240.0, 244.0, 195.0, 230.0, 238.0, 156.0, 220.0, 231.0, 117.0, 212.0, 225.0, 87.0, 205.0, 220.0, 57.0, 192.0, 202.0, 51.0, 175.0, 180.0, 43.0, 158.0, 157.0, 36.0, 130.0, 119.0, 23.0, 255.0, 253.0, 231.0, 255.0, 249.0, 196.0, 255.0, 245.0, 157.0, 255.0, 241.0, 118.0, 255.0, 238.0, 88.0, 255.0, 235.0, 59.0, 253.0, 216.0, 53.0, 251.0, 192.0, 45.0, 249.0, 168.0, 37.0, 245.0, 127.0, 23.0, 255.0, 248.0, 225.0, 255.0, 236.0, 179.0, 255.0, 224.0, 130.0, 255.0, 213.0, 79.0, 255.0, 202.0, 40.0, 255.0, 193.0, 7.0, 255.0, 179.0, 0.0, 255.0, 160.0, 0.0, 255.0, 143.0, 0.0, 255.0, 111.0, 0.0, 255.0, 243.0, 224.0, 255.0, 224.0, 178.0, 255.0, 204.0, 128.0, 255.0, 183.0, 77.0, 255.0, 167.0, 38.0, 255.0, 152.0, 0.0, 251.0, 140.0, 0.0, 245.0, 124.0, 0.0, 239.0, 108.0, 0.0, 230.0, 81.0, 0.0, 251.0, 233.0, 231.0, 255.0, 204.0, 188.0, 255.0, 171.0, 145.0, 255.0, 138.0, 101.0, 255.0, 112.0, 67.0, 255.0, 87.0, 34.0, 244.0, 81.0, 30.0, 230.0, 74.0, 25.0, 216.0, 67.0, 21.0, 191.0, 54.0, 12.0, 239.0, 235.0, 233.0, 215.0, 204.0, 200.0, 188.0, 170.0, 164.0, 161.0, 136.0, 127.0, 141.0, 110.0, 99.0, 121.0, 85.0, 72.0, 109.0, 76.0, 65.0, 93.0, 64.0, 55.0, 78.0, 52.0, 46.0, 62.0, 39.0, 35.0};

    public JFXColorPalette(JFXColorPicker jFXColorPicker) {
        this.getStyleClass().add((Object)"color-palette-region");
        this.colorPicker = jFXColorPicker;
        this.colorPickerGrid = new JFXColorGrid();
        ((Node)this.colorPickerGrid.getChildren().get(0)).requestFocus();
        this.customColorLabel.setAlignment(Pos.CENTER_LEFT);
        this.customColorLink.setPrefWidth(this.colorPickerGrid.prefWidth(-1.0));
        this.customColorLink.setAlignment(Pos.CENTER);
        this.customColorLink.setFocusTraversable(true);
        this.customColorLink.setOnAction(actionEvent -> {
            if (this.customColorDialog == null) {
                this.customColorDialog = new JFXCustomColorPickerDialog((Window)this.popupControl);
                this.customColorDialog.customColorProperty().addListener((observableValue, color, color2) -> jFXColorPicker.setValue((Color)this.customColorDialog.customColorProperty().get()));
                this.customColorDialog.setOnSave(() -> {
                    Color color = (Color)this.customColorDialog.customColorProperty().get();
                    this.buildCustomColors();
                    jFXColorPicker.getCustomColors().add((Object)color);
                    this.updateSelection(color);
                    Event.fireEvent((EventTarget)jFXColorPicker, (Event)new ActionEvent());
                    jFXColorPicker.hide();
                });
            }
            this.customColorDialog.setCurrentColor((Color)jFXColorPicker.valueProperty().get());
            if (this.popupControl != null) {
                this.popupControl.setAutoHide(false);
            }
            this.customColorDialog.show();
            this.customColorDialog.setOnHidden((EventHandler<WindowEvent>)((EventHandler)windowEvent -> {
                if (this.popupControl != null) {
                    this.popupControl.setAutoHide(true);
                }
            }));
        });
        this.initNavigation();
        this.customColorGrid.getStyleClass().add((Object)"color-picker-grid");
        this.customColorGrid.setVisible(false);
        this.buildCustomColors();
        jFXColorPicker.getCustomColors().addListener(change -> this.buildCustomColors());
        VBox vBox = new VBox();
        vBox.getStyleClass().add((Object)"color-palette");
        vBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
        vBox.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.valueOf((String)"#9E9E9E"), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
        vBox.getChildren().addAll((Object[])new Node[]{this.colorPickerGrid});
        if (jFXColorPicker.getPreDefinedColors() == null) {
            vBox.getChildren().addAll((Object[])new Node[]{this.customColorLabel, this.customColorGrid, this.customColorLink});
        }
        this.hoverSquare.setMouseTransparent(true);
        this.hoverSquare.getStyleClass().addAll((Object[])new String[]{"hover-square"});
        this.setFocusedSquare(null);
        this.getChildren().addAll((Object[])new Node[]{vBox, this.hoverSquare});
    }

    private void setFocusedSquare(ColorSquare colorSquare) {
        double d2;
        double d3;
        this.hoverSquare.setVisible(colorSquare != null);
        if (colorSquare == this.focusedSquare) {
            return;
        }
        this.focusedSquare = colorSquare;
        this.hoverSquare.setVisible(this.focusedSquare != null);
        if (this.focusedSquare == null) {
            return;
        }
        if (!this.focusedSquare.isFocused()) {
            this.focusedSquare.requestFocus();
        }
        this.hoverSquare.rectangle.setFill(this.focusedSquare.rectangle.getFill());
        Bounds bounds = colorSquare.localToScene(colorSquare.getLayoutBounds());
        double d4 = bounds.getMinX();
        double d5 = bounds.getMinY();
        double d6 = d3 = this.hoverSquare.getScaleX() == 1.0 ? 0.0 : this.hoverSquare.getWidth() / 4.0;
        if (this.colorPicker.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
            d4 = this.focusedSquare.getLayoutX();
            d2 = -this.focusedSquare.getWidth() + d3;
        } else {
            d2 = this.focusedSquare.getWidth() / 2.0 + d3;
        }
        this.hoverSquare.setLayoutX(this.snapPosition(d4) - d2);
        this.hoverSquare.setLayoutY(this.snapPosition(d5) - this.focusedSquare.getHeight() / 2.0 + (this.hoverSquare.getScaleY() == 1.0 ? 0.0 : this.focusedSquare.getHeight() / 4.0));
    }

    private void buildCustomColors() {
        Object object;
        int n2;
        ObservableList observableList = this.colorPicker.getCustomColors();
        this.customColorGrid.getChildren().clear();
        if (observableList.isEmpty()) {
            this.customColorLabel.setVisible(false);
            this.customColorLabel.setManaged(false);
            this.customColorGrid.setVisible(false);
            this.customColorGrid.setManaged(false);
            return;
        }
        this.customColorLabel.setVisible(true);
        this.customColorLabel.setManaged(true);
        this.customColorGrid.setVisible(true);
        this.customColorGrid.setManaged(true);
        int n3 = 0;
        int n4 = 0;
        int n5 = observableList.size() % 10;
        int n6 = n5 == 0 ? 0 : 10 - n5;
        for (n2 = 0; n2 < observableList.size(); ++n2) {
            object = (Color)observableList.get(n2);
            ColorSquare colorSquare = new ColorSquare((Color)object, n2, true);
            this.customColorGrid.add((Node)colorSquare, n3, n4);
            if (++n3 != 10) continue;
            n3 = 0;
            ++n4;
        }
        for (n2 = 0; n2 < n6; ++n2) {
            object = new ColorSquare();
            this.customColorGrid.add((Node)object, n3, n4);
            ++n3;
        }
        this.requestLayout();
    }

    private void initNavigation() {
        this.setOnKeyPressed(keyEvent -> {
            switch (keyEvent.getCode()) {
                case SPACE: 
                case ENTER: {
                    if (this.focusedSquare != null) {
                        this.focusedSquare.selectColor((KeyEvent)keyEvent);
                    }
                    keyEvent.consume();
                    break;
                }
            }
        });
    }

    public void setPopupControl(PopupControl popupControl) {
        this.popupControl = popupControl;
    }

    public JFXColorGrid getColorGrid() {
        return this.colorPickerGrid;
    }

    public boolean isCustomColorDialogShowing() {
        return this.customColorDialog != null && this.customColorDialog.isVisible();
    }

    public void updateSelection(Color color) {
        this.setFocusedSquare(null);
        for (ColorSquare colorSquare : this.colorPickerGrid.getSquares()) {
            if (!colorSquare.rectangle.getFill().equals(color)) continue;
            this.setFocusedSquare(colorSquare);
            return;
        }
        Iterator iterator = this.customColorGrid.getChildren().iterator();
        while (iterator.hasNext()) {
            ColorSquare colorSquare;
            ColorSquare colorSquare2 = colorSquare = (Node)iterator.next();
            if (!colorSquare2.rectangle.getFill().equals(color)) continue;
            this.setFocusedSquare(colorSquare2);
            return;
        }
    }

    private static int clamp(int n2, int n3, int n4) {
        if (n3 < n2) {
            return n2;
        }
        if (n3 > n4) {
            return n4;
        }
        return n3;
    }

    class JFXColorGrid
    extends GridPane {
        private final List<ColorSquare> squares;
        final int NUM_OF_COLORS;
        final int NUM_OF_ROWS;

        public JFXColorGrid() {
            this.getStyleClass().add((Object)"color-picker-grid");
            this.setId("ColorCustomizerColorGrid");
            int n2 = 0;
            int n3 = 0;
            this.squares = FXCollections.observableArrayList();
            double[] dArray = JFXColorPalette.this.colorPicker.getPreDefinedColors();
            dArray = dArray == null ? RAW_VALUES : dArray;
            this.NUM_OF_COLORS = dArray.length / 3;
            this.NUM_OF_ROWS = (int)Math.ceil((double)this.NUM_OF_COLORS / 10.0);
            int n4 = dArray.length / 3;
            Color[] colorArray = new Color[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                colorArray[i2] = new Color(dArray[i2 * 3] / 255.0, dArray[i2 * 3 + 1] / 255.0, dArray[i2 * 3 + 2] / 255.0, 1.0);
                ColorSquare colorSquare = new ColorSquare(colorArray[i2], i2);
                this.squares.add(colorSquare);
            }
            for (ColorSquare colorSquare : this.squares) {
                this.add((Node)colorSquare, n2, n3);
                if (++n2 != 10) continue;
                n2 = 0;
                ++n3;
            }
            this.setOnMouseDragged(mouseEvent -> {
                if (!JFXColorPalette.this.dragDetected) {
                    JFXColorPalette.this.dragDetected = true;
                    JFXColorPalette.this.mouseDragColor = (Color)JFXColorPalette.this.colorPicker.getValue();
                }
                int n2 = JFXColorPalette.clamp(0, (int)mouseEvent.getX() / 16, 9);
                int n3 = JFXColorPalette.clamp(0, (int)mouseEvent.getY() / 16, this.NUM_OF_ROWS - 1);
                int n4 = n2 + n3 * 10;
                JFXColorPalette.this.colorPicker.setValue((Color)this.squares.get((int)n4).rectangle.getFill());
                JFXColorPalette.this.updateSelection((Color)JFXColorPalette.this.colorPicker.getValue());
            });
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
                if (JFXColorPalette.this.colorPickerGrid.getBoundsInLocal().contains(mouseEvent.getX(), mouseEvent.getY())) {
                    JFXColorPalette.this.updateSelection((Color)JFXColorPalette.this.colorPicker.getValue());
                    JFXColorPalette.this.colorPicker.fireEvent((Event)new ActionEvent());
                    JFXColorPalette.this.colorPicker.hide();
                } else if (JFXColorPalette.this.mouseDragColor != null) {
                    JFXColorPalette.this.colorPicker.setValue(JFXColorPalette.this.mouseDragColor);
                    JFXColorPalette.this.updateSelection(JFXColorPalette.this.mouseDragColor);
                }
                JFXColorPalette.this.dragDetected = false;
            });
        }

        public List<ColorSquare> getSquares() {
            return this.squares;
        }

        protected double computePrefWidth(double d2) {
            return 160.0;
        }

        protected double computePrefHeight(double d2) {
            return 16 * this.NUM_OF_ROWS;
        }
    }

    class ColorSquare
    extends StackPane {
        Rectangle rectangle;
        boolean isEmpty;

        public ColorSquare() {
            this(null, -1, false);
        }

        public ColorSquare(Color color, int n2) {
            this(color, n2, false);
        }

        public ColorSquare(Color color, int n2, boolean bl4) {
            this.getStyleClass().add((Object)"color-square");
            if (color != null) {
                this.setFocusTraversable(true);
                this.focusedProperty().addListener((observableValue, bl2, bl3) -> JFXColorPalette.this.setFocusedSquare(bl3 != false ? this : null));
                this.addEventHandler(MouseEvent.MOUSE_ENTERED, mouseEvent -> JFXColorPalette.this.setFocusedSquare(this));
                this.addEventHandler(MouseEvent.MOUSE_EXITED, mouseEvent -> JFXColorPalette.this.setFocusedSquare(null));
                this.addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
                    if (!JFXColorPalette.this.dragDetected && mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 1) {
                        if (!this.isEmpty) {
                            Color color = (Color)this.rectangle.getFill();
                            JFXColorPalette.this.colorPicker.setValue(color);
                            JFXColorPalette.this.colorPicker.fireEvent((Event)new ActionEvent());
                            JFXColorPalette.this.updateSelection(color);
                            mouseEvent.consume();
                        }
                        JFXColorPalette.this.colorPicker.hide();
                    }
                });
            }
            this.rectangle = new Rectangle(15.0, 15.0);
            if (color == null) {
                this.rectangle.setFill((Paint)Color.WHITE);
                this.isEmpty = true;
            } else {
                this.rectangle.setFill((Paint)color);
            }
            this.rectangle.setStrokeType(StrokeType.INSIDE);
            String string = JFXNodeUtils.colorToHex(color);
            Tooltip.install((Node)this, (Tooltip)new Tooltip(string == null ? "" : string.toUpperCase()));
            this.rectangle.getStyleClass().add((Object)"color-rect");
            this.getChildren().add((Object)this.rectangle);
        }

        public void selectColor(KeyEvent keyEvent) {
            if (this.rectangle.getFill() != null) {
                if (this.rectangle.getFill() instanceof Color) {
                    JFXColorPalette.this.colorPicker.setValue((Color)this.rectangle.getFill());
                    JFXColorPalette.this.colorPicker.fireEvent((Event)new ActionEvent());
                }
                keyEvent.consume();
            }
            JFXColorPalette.this.colorPicker.hide();
        }
    }
}

