/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.transitions.CachedTransition;
import com.jfoenix.utils.JFXNodeUtils;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.skin.ButtonSkin;
import javafx.scene.effect.DropShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class JFXButtonSkin
extends ButtonSkin {
    private Transition clickedAnimation;
    private JFXRippler buttonRippler = new JFXRippler((Node)this.getSkinnable()){

        @Override
        protected Node getMask() {
            StackPane stackPane = new StackPane();
            stackPane.shapeProperty().bind((ObservableValue)((Button)JFXButtonSkin.this.getSkinnable()).shapeProperty());
            JFXNodeUtils.updateBackground(((Button)JFXButtonSkin.this.getSkinnable()).getBackground(), (Region)stackPane);
            stackPane.resize(this.getWidth() - this.snappedRightInset() - this.snappedLeftInset(), this.getHeight() - this.snappedBottomInset() - this.snappedTopInset());
            return stackPane;
        }

        @Override
        protected void positionControl(Node node) {
        }
    };
    private Runnable releaseManualRippler = null;
    private boolean invalid = true;
    private boolean mousePressed = false;

    public JFXButtonSkin(JFXButton jFXButton) {
        super((Button)jFXButton);
        jFXButton.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> this.playClickAnimation(1.0));
        jFXButton.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            this.mousePressed = true;
        });
        jFXButton.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            this.mousePressed = false;
        });
        jFXButton.addEventFilter(MouseEvent.MOUSE_DRAGGED, mouseEvent -> {
            this.mousePressed = false;
        });
        jFXButton.ripplerFillProperty().addListener((observableValue, paint, paint2) -> this.buttonRippler.setRipplerFill((Paint)paint2));
        jFXButton.armedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                if (!this.mousePressed) {
                    this.releaseManualRippler = this.buttonRippler.createManualRipple();
                    this.playClickAnimation(1.0);
                }
            } else {
                if (this.releaseManualRippler != null) {
                    this.releaseManualRippler.run();
                    this.releaseManualRippler = null;
                }
                this.playClickAnimation(-1.0);
            }
        });
        jFXButton.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (!jFXButton.disableVisualFocusProperty().get()) {
                if (bl3.booleanValue()) {
                    if (!((Button)this.getSkinnable()).isPressed()) {
                        this.buttonRippler.setOverlayVisible(true);
                    }
                } else {
                    this.buttonRippler.setOverlayVisible(false);
                }
            }
        });
        jFXButton.buttonTypeProperty().addListener((observableValue, buttonType, buttonType2) -> this.updateButtonType((JFXButton.ButtonType)((Object)buttonType2)));
        this.updateButtonType(jFXButton.getButtonType());
        this.updateChildren();
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.buttonRippler != null) {
            this.getChildren().add(0, (Object)this.buttonRippler);
        }
        for (int i2 = 1; i2 < this.getChildren().size(); ++i2) {
            Node node = (Node)this.getChildren().get(i2);
            if (!(node instanceof Text)) continue;
            node.setMouseTransparent(true);
        }
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        if (this.invalid) {
            if (((JFXButton)this.getSkinnable()).getRipplerFill() == null) {
                for (int i2 = this.getChildren().size() - 1; i2 >= 1; --i2) {
                    if (this.getChildren().get(i2) instanceof Text) {
                        this.buttonRippler.setRipplerFill(((Text)this.getChildren().get(i2)).getFill());
                        ((Text)this.getChildren().get(i2)).fillProperty().addListener((observableValue, paint, paint2) -> this.buttonRippler.setRipplerFill((Paint)paint2));
                    } else {
                        if (!(this.getChildren().get(i2) instanceof Label)) continue;
                        this.buttonRippler.setRipplerFill(((Label)this.getChildren().get(i2)).getTextFill());
                        ((Label)this.getChildren().get(i2)).textFillProperty().addListener((observableValue, paint, paint2) -> this.buttonRippler.setRipplerFill((Paint)paint2));
                    }
                    break;
                }
            } else {
                this.buttonRippler.setRipplerFill(((JFXButton)this.getSkinnable()).getRipplerFill());
            }
            this.invalid = false;
        }
        this.buttonRippler.resizeRelocate(((Button)this.getSkinnable()).getLayoutBounds().getMinX(), ((Button)this.getSkinnable()).getLayoutBounds().getMinY(), ((Button)this.getSkinnable()).getWidth(), ((Button)this.getSkinnable()).getHeight());
        this.layoutLabelInArea(d2, d3, d4, d5);
    }

    private void updateButtonType(JFXButton.ButtonType buttonType) {
        switch (buttonType) {
            case RAISED: {
                JFXDepthManager.setDepth((Node)this.getSkinnable(), 2);
                this.clickedAnimation = new ButtonClickTransition((Node)this.getSkinnable(), (DropShadow)((Button)this.getSkinnable()).getEffect());
                ((Button)this.getSkinnable()).setPickOnBounds(false);
                break;
            }
            default: {
                ((Button)this.getSkinnable()).setEffect(null);
                ((Button)this.getSkinnable()).setPickOnBounds(true);
            }
        }
    }

    private void playClickAnimation(double d2) {
        if (!(this.clickedAnimation == null || this.clickedAnimation.getCurrentTime().equals((Object)this.clickedAnimation.getCycleDuration()) && d2 == 1.0)) {
            this.clickedAnimation.setRate(d2);
            this.clickedAnimation.play();
        }
    }

    private static class ButtonClickTransition
    extends CachedTransition {
        ButtonClickTransition(Node node, DropShadow dropShadow) {
            super(node, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)dropShadow.radiusProperty(), (Object)JFXDepthManager.getShadowAt(2).radiusProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)dropShadow.spreadProperty(), (Object)JFXDepthManager.getShadowAt(2).spreadProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)dropShadow.offsetXProperty(), (Object)JFXDepthManager.getShadowAt(2).offsetXProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)dropShadow.offsetYProperty(), (Object)JFXDepthManager.getShadowAt(2).offsetYProperty().get(), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)dropShadow.radiusProperty(), (Object)JFXDepthManager.getShadowAt(5).radiusProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)dropShadow.spreadProperty(), (Object)JFXDepthManager.getShadowAt(5).spreadProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)dropShadow.offsetXProperty(), (Object)JFXDepthManager.getShadowAt(5).offsetXProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)dropShadow.offsetYProperty(), (Object)JFXDepthManager.getShadowAt(5).offsetYProperty().get(), Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.seconds((double)0.2));
            this.setDelay(Duration.seconds((double)0.0));
        }
    }
}

