/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.responsive;

import javafx.collections.ListChangeListener;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

public class JFXResponsiveHandler {
    public static final PseudoClass PSEUDO_CLASS_EX_SMALL = PseudoClass.getPseudoClass((String)"extreme-small-device");
    public static final PseudoClass PSEUDO_CLASS_SMALL = PseudoClass.getPseudoClass((String)"small-device");
    public static final PseudoClass PSEUDO_CLASS_MEDIUM = PseudoClass.getPseudoClass((String)"medium-device");
    public static final PseudoClass PSEUDO_CLASS_LARGE = PseudoClass.getPseudoClass((String)"large-device");

    public JFXResponsiveHandler(Stage stage, PseudoClass pseudoClass) {
        this.scanAllNodes(stage.getScene().getRoot(), pseudoClass);
    }

    private void scanAllNodes(Parent parent, final PseudoClass pseudoClass) {
        parent.getChildrenUnmodifiable().addListener((ListChangeListener)new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> change) {
                while (change.next()) {
                    if (change.wasPermutated() || change.wasUpdated()) continue;
                    for (Node node : change.getAddedSubList()) {
                        if (!(node instanceof Parent)) continue;
                        JFXResponsiveHandler.this.scanAllNodes((Parent)node, pseudoClass);
                    }
                }
            }
        });
        for (Node node3 : parent.getChildrenUnmodifiable()) {
            if (node3 instanceof Pane) {
                ((Pane)node3).getChildren().addListener((ListChangeListener)new ListChangeListener<Node>(){

                    public void onChanged(ListChangeListener.Change<? extends Node> change) {
                        while (change.next()) {
                            if (change.wasPermutated() || change.wasUpdated()) continue;
                            for (Node node : change.getAddedSubList()) {
                                if (!(node instanceof Parent)) continue;
                                JFXResponsiveHandler.this.scanAllNodes((Parent)node, pseudoClass);
                            }
                        }
                    }
                });
                this.scanAllNodes((Parent)((Pane)node3), pseudoClass);
                continue;
            }
            if (node3 instanceof ScrollPane) {
                ((ScrollPane)node3).contentProperty().addListener((observableValue, node, node2) -> this.scanAllNodes((Parent)node2, pseudoClass));
                if (!(((ScrollPane)node3).getContent() instanceof Parent)) continue;
                this.scanAllNodes((Parent)((ScrollPane)node3).getContent(), pseudoClass);
                continue;
            }
            if (!(node3 instanceof Control)) continue;
            node3.pseudoClassStateChanged(PSEUDO_CLASS_EX_SMALL, pseudoClass == PSEUDO_CLASS_EX_SMALL);
            node3.pseudoClassStateChanged(PSEUDO_CLASS_SMALL, pseudoClass == PSEUDO_CLASS_SMALL);
            node3.pseudoClassStateChanged(PSEUDO_CLASS_MEDIUM, pseudoClass == PSEUDO_CLASS_MEDIUM);
            node3.pseudoClassStateChanged(PSEUDO_CLASS_LARGE, pseudoClass == PSEUDO_CLASS_LARGE);
        }
    }
}

